/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bilateral;

import com.ibm.bilateral.ClArgs;
import com.ibm.bilateral.Holdings;
import com.ibm.bilateral.NegotiationState;
import com.ibm.bilateral.NegotiationStats;
import com.ibm.bilateral.Offer;
import com.ibm.bilateral.OfferSet;
import com.ibm.bilateral.Response;
import com.ibm.bilateral.SellerStrategy;
import com.ibm.bilateral.Session;
import com.ibm.bilateral.SessionHistory;
import com.ibm.bilateral.TradingPartner;
import com.ibm.bilateral.Utility;
import java.io.IOException;
import java.io.Serializable;

public class Seller
implements Serializable {
    private static final boolean DEBUG = true;
    private final ClArgs cl;
    private final TradingPartner agentID;
    private final SellerStrategy sparams;
    private final Utility utility;
    private final NegotiationState nstate;
    private final NegotiationStats nstats;
    private final Holdings hold;
    private final SessionHistory sh;
    private OfferSet offerSet;

    public Seller(ClArgs clArgs, TradingPartner tradingPartner, SellerStrategy sellerStrategy, Utility utility, int n) throws IOException {
        this.cl = clArgs;
        this.nstate = new NegotiationState();
        this.nstats = new NegotiationStats();
        this.hold = new Holdings();
        this.sparams = sellerStrategy;
        this.utility = utility;
        this.agentID = tradingPartner;
        this.hold.cash = 0;
        this.hold.quant = n;
        this.sh = this.sparams.createHistory();
        if (clArgs.isVerbose()) {
            System.out.print("For seller with agent ID = ");
            System.out.print(tradingPartner);
            System.out.print(": ");
            System.out.println(utility);
        }
    }

    public synchronized boolean sellerInitNegotiation(TradingPartner tradingPartner) {
        if (this.nstate.inNegotiation) {
            throw new IllegalStateException("Call to SellerInitNegotiation during existing negotiation.");
        }
        this.nstate.inNegotiation = true;
        this.nstate.reset();
        Session session = this.sh.newSession();
        session.sessionInit(tradingPartner);
        return true;
    }

    public synchronized OfferSet sellerMakeOffer() {
        if (!this.nstate.inNegotiation) {
            throw new IllegalStateException("Call to sellerMakeOffer() before negotiation sellerInitNegotiation().");
        }
        ++this.nstate.current_round;
        this.offerSet = this.sparams.makeOffer(this.nstate, this.utility);
        return new OfferSet(this.offerSet);
    }

    public synchronized void sellerReceiveResponse(Response response) {
        if (!this.nstate.inNegotiation) {
            throw new IllegalStateException("Call to sellerReceiveResponse() before negotiation sellerInitNegotiation().");
        }
        if (response.getChoice() >= 0) {
            this.nstate.currentAO = this.offerSet.getOffer(response.getChoice());
            this.nstate.currentAOvalue = this.utility.computeUtility(this.nstate.currentAO);
            if (this.nstate.nAO == 0) {
                this.nstate.initAO = this.nstate.currentAO;
                this.nstate.initAOvalue = this.nstate.currentAOvalue;
            }
            ++this.nstate.nAO;
        }
        Session session = this.sh.currentSession();
        int n = this.nstate.current_round;
        session.UpdateSessionHistory(n, this.offerSet, response);
    }

    public synchronized void sellerCompleteNegotiation(boolean bl) {
        if (!this.nstate.inNegotiation) {
            throw new IllegalStateException("Call to sellerCompleteNegotiation outside existing negotiation.");
        }
        this.nstate.inNegotiation = false;
        Session session = this.sh.currentSession();
        session.sessionUpdate(this.nstate);
        if (bl) {
            session.finalUpdate(this.nstate.currentAOvalue);
            this.UpdateInventory();
        } else {
            this.nstate.nAO = 0;
            session.finalUpdate(0.0);
        }
        this.nstats.UpdateStats(this.nstate);
    }

    public synchronized Offer sellerConfirm() {
        if (!this.nstate.inNegotiation) {
            throw new IllegalStateException("Call to sellerConfirm() outside existing negotiation.");
        }
        return this.nstate.currentAO;
    }

    void UpdateInventory() {
        if (this.nstate.nAO < 1) {
            return;
        }
        Offer offer = this.nstate.currentAO;
        int n = offer.getPrice();
        int n2 = offer.getUnits();
        this.hold.quant -= n2;
        this.hold.cash += n;
    }

    void sellerLearn() {
    }

    public double computeUtility(Offer offer) {
        return this.utility.computeUtility(offer);
    }

    public TradingPartner getId() {
        return this.agentID;
    }

    public Offer getCurrentAO() {
        return this.nstate.currentAO;
    }

    public NegotiationStats getStatistics() {
        return new NegotiationStats(this.nstats);
    }
}

