/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bilateral;

import com.ibm.bilateral.Offer;
import java.io.Serializable;

public class OfferSet
implements Serializable {
    private static final OfferSet QUIT_OSET = new OfferSet();
    private int n_offers;
    private final Offer[] offers;
    private final boolean qquit;

    private OfferSet() {
        this.n_offers = 0;
        this.offers = new Offer[0];
        this.qquit = true;
    }

    public OfferSet(int n) {
        this.qquit = false;
        this.n_offers = 0;
        this.offers = new Offer[n];
    }

    public OfferSet(OfferSet offerSet) {
        this.n_offers = offerSet.n_offers;
        this.offers = new Offer[offerSet.n_offers];
        System.arraycopy(offerSet.offers, 0, this.offers, 0, this.n_offers);
        this.qquit = offerSet.qquit;
    }

    public static OfferSet createQuitNoOffers() {
        return QUIT_OSET;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = 0;
        while (n < this.n_offers) {
            stringBuffer.append(this.offers[n]);
            stringBuffer.append(", ");
            ++n;
        }
        stringBuffer.append("] (qquit=");
        stringBuffer.append(this.qquit);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean isQuit() {
        return this.qquit;
    }

    public Offer getOffer(int n) {
        if (n >= this.n_offers) {
            throw new IllegalArgumentException("Only " + this.n_offers + " offer(s) in set");
        }
        return this.offers[n];
    }

    public void addOffer(Offer offer) {
        this.offers[this.n_offers++] = offer;
    }

    public int size() {
        return this.n_offers;
    }
}

