/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bilateral;

import com.ibm.bilateral.BuyerStrategy;
import com.ibm.bilateral.ClArgs;
import com.ibm.bilateral.NegotiationState;
import com.ibm.bilateral.OfferSet;
import com.ibm.bilateral.RandomBN;
import com.ibm.bilateral.Response;
import com.ibm.bilateral.SessionHistory;
import com.ibm.bilateral.Utility;
import com.ibm.bilateral.ZiBuyerStrategy;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;

public class LapBuyerStrategy
implements BuyerStrategy,
Serializable {
    private Lap_Buyer_SParams lb_params;
    private ZiBuyerStrategy.ZI_Buyer_SParams zib_params;
    private int max_rounds;

    public LapBuyerStrategy(String string, ClArgs clArgs) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        this.lb_params = new Lap_Buyer_SParams();
        if (this.getNonCommentLine(bufferedReader) != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            this.max_rounds = Integer.parseInt(stringTokenizer.nextToken());
            this.zib_params.patience_accept = Double.parseDouble(stringTokenizer.nextToken());
            this.zib_params.patience_reject = Double.parseDouble(stringTokenizer.nextToken());
            this.zib_params.improvement_factor = Double.parseDouble(stringTokenizer.nextToken());
            this.lb_params.u_star = Double.parseDouble(stringTokenizer.nextToken());
        }
        if (clArgs.isVerbose()) {
            System.out.print(" params: pa ");
            System.out.print(this.zib_params.patience_accept);
            System.out.print(" pr ");
            System.out.print(this.zib_params.patience_reject);
            System.out.print(" if ");
            System.out.print(this.zib_params.improvement_factor);
            System.out.print(" u* ");
            System.out.print(this.lb_params.u_star);
        }
        bufferedReader.close();
        if (this.max_rounds > clArgs.numRounds()) {
            this.max_rounds = clArgs.numRounds();
        }
        if (clArgs.isVerbose()) {
            System.out.print("max_rounds ");
            System.out.println(this.max_rounds);
        }
    }

    public Response respondToOffer(NegotiationState negotiationState, Utility utility, OfferSet offerSet) {
        double d;
        if (negotiationState.current_round >= this.maxRounds()) {
            negotiationState.quit = true;
            return Response.QUIT_RESPONSE;
        }
        Response response = null;
        int n = offerSet.size();
        if (n <= 0) {
            return new Response();
        }
        double d2 = negotiationState.nAO > 0 ? negotiationState.currentAOvalue : 0.0;
        double d3 = d2;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            d = utility.computeUtility(offerSet.getOffer(n3));
            if (d > d2) {
                d2 = d;
                n2 = n3;
            }
            ++n3;
        }
        response = new Response(n2);
        if (response.getChoice() >= 0 && RandomBN.uni() > LapBuyerStrategy.lap_accept_prob(d2, this.lb_params.u_star)) {
            response = new Response();
        }
        if (response.getChoice() < 0) {
            d = RandomBN.uni();
            if (d > this.zib_params.patience_reject) {
                response = Response.QUIT_RESPONSE;
                negotiationState.quit = true;
            }
        } else if (d3 != 0.0 && d2 / d3 < 1.0 + this.zib_params.improvement_factor && (d = RandomBN.uni()) > this.zib_params.patience_accept) {
            response = Response.QUIT_RESPONSE;
            negotiationState.quit = true;
        }
        return response;
    }

    public int maxRounds() {
        return this.max_rounds;
    }

    private static double lap_accept_prob(double d, double d2) {
        if (d >= d2) {
            return 1.0;
        }
        if (d <= 0.0) {
            return 0.0;
        }
        return d / d2;
    }

    public SessionHistory createHistory() {
        return new SessionHistory(this.maxRounds());
    }

    private int getNonCommentLine(BufferedReader bufferedReader) throws IOException {
        while (true) {
            int n = 32;
            while (Character.isWhitespace((char)n)) {
                bufferedReader.mark(1);
                n = bufferedReader.read();
                if (n != -1) continue;
                return -1;
            }
            if (n != 35) break;
            bufferedReader.readLine();
        }
        bufferedReader.reset();
        return 0;
    }

    static class Lap_Buyer_SParams
    implements Serializable {
        double u_star;

        Lap_Buyer_SParams() {
        }
    }
}

