/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bilateral;

import com.ibm.bilateral.BuyerStrategy;
import com.ibm.bilateral.ClArgs;
import com.ibm.bilateral.DoSellerStrategy;
import com.ibm.bilateral.InitParams;
import com.ibm.bilateral.LapBuyerStrategy;
import com.ibm.bilateral.SellerStrategy;
import com.ibm.bilateral.Utility;
import com.ibm.bilateral.UtilityParams;
import com.ibm.bilateral.ZiBuyerStrategy;
import com.ibm.bilateral.ZiSellerStrategy;
import java.io.IOException;
import java.io.Serializable;

public class InitParamsImp
implements InitParams,
Serializable {
    private static final int ZI_BUYER = 0;
    private static final int LAP_BUYER = 1;
    private static final int ZI_SELLER = 0;
    private static final int DO_SELLER = 1;
    public final int strategy;
    public final String sparams_file;
    public final int utype;
    public final int uparams_type;
    public final String uparams_file;
    private final UtilityParams uparams;

    public InitParamsImp(int n, String string, int n2, int n3, String string2) throws IOException {
        this.strategy = n;
        this.sparams_file = string;
        this.utype = n2;
        this.uparams_type = n3;
        this.uparams_file = string2;
        this.uparams = new UtilityParams(n2, n3, string2);
    }

    public BuyerStrategy getBuyerStrategy(ClArgs clArgs) throws IOException {
        if (this.strategy == 0) {
            return new ZiBuyerStrategy(this.sparams_file, clArgs);
        }
        return new LapBuyerStrategy(this.sparams_file, clArgs);
    }

    public SellerStrategy getSellerStrategy(ClArgs clArgs) throws IOException {
        if (this.strategy == 0) {
            return new ZiSellerStrategy(this.uparams.scaled_attributes, this.sparams_file, clArgs);
        }
        return new DoSellerStrategy(this.uparams, this.uparams.scaled_attributes, this.sparams_file, clArgs);
    }

    public Utility getBuyerUtility() {
        return this.uparams.getBuyerUtility();
    }

    public Utility getSellerUtility() {
        return this.uparams.getSellerUtility();
    }
}

