/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bilateral;

import com.ibm.bilateral.ClArgs;
import com.ibm.bilateral.NegotiationState;
import com.ibm.bilateral.Offer;
import com.ibm.bilateral.OfferIV;
import com.ibm.bilateral.OfferSet;
import com.ibm.bilateral.RandomBN;
import com.ibm.bilateral.ScaledAttributes;
import com.ibm.bilateral.Utility;
import com.ibm.bilateral.UtilityParams;
import com.ibm.bilateral.ZiSellerStrategy;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class DoSellerStrategy
extends ZiSellerStrategy {
    private static final int MAX_TRIES = 200;
    private final Utility utility;
    private final WorkArea work;

    public DoSellerStrategy(UtilityParams utilityParams, ScaledAttributes[] scaledAttributesArray, String string, ClArgs clArgs) throws IOException {
        super(scaledAttributesArray);
        this.utility = utilityParams.getSellerUtility();
        this.work = new WorkArea();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        if (this.getNonCommentLine(bufferedReader) != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            this.max_offers = Integer.parseInt(stringTokenizer.nextToken());
            this.max_rounds = Integer.parseInt(stringTokenizer.nextToken());
            this.zis_params.max_tries = Integer.parseInt(stringTokenizer.nextToken());
            this.zis_params.offer_revision_radius = Float.parseFloat(stringTokenizer.nextToken());
        }
        this.work.sorted_offers = new Offer[this.max_offers * this.max_rounds];
        this.work.sorted_values = new double[this.max_offers * this.max_rounds];
        if (clArgs.isVerbose()) {
            System.out.print(" params: mt ");
            System.out.print(this.zis_params.max_tries);
            System.out.print(" orr ");
            System.out.print(this.zis_params.offer_revision_radius);
        }
        bufferedReader.close();
        if (this.max_rounds > clArgs.numRounds()) {
            this.max_rounds = clArgs.numRounds();
        }
        if (this.max_offers > clArgs.numOffersPerRound()) {
            this.max_offers = clArgs.numOffersPerRound();
        }
        if (clArgs.isVerbose()) {
            System.out.print("max_rounds ");
            System.out.print(this.max_rounds);
            System.out.print(" max_offers ");
            System.out.println(this.max_offers);
        }
        this.DO_SellerInit();
    }

    public void initNegotiation() {
        this.work.sorted_index = 0;
    }

    public OfferSet makeOffer(NegotiationState negotiationState, Utility utility, int n) {
        if (negotiationState.current_round >= this.maxRounds()) {
            negotiationState.quit = true;
            return OfferSet.createQuitNoOffers();
        }
        boolean bl = true;
        int n2 = 0;
        if (negotiationState.nAO > 0) {
            return super.makeOffer(negotiationState, utility);
        }
        OfferSet offerSet = new OfferSet(n);
        while (bl) {
            Offer offer = this.work.sorted_offers[this.work.sorted_index];
            offerSet.addOffer(offer);
            ++this.work.sorted_index;
            if (++n2 < this.maxOffers()) continue;
            bl = false;
        }
        return offerSet;
    }

    public int maxRounds() {
        return this.max_rounds;
    }

    public int maxOffers() {
        return this.max_offers;
    }

    private void DO_SellerInit() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.maxRounds() * this.maxOffers() - 1;
        int[] nArray = new int[2];
        boolean bl = true;
        while (bl) {
            boolean bl2;
            int n5 = 0;
            while (n5 < nArray.length) {
                nArray[n5] = (int)(this.scaled_attributes[n5].min + this.scaled_attributes[n5].norm * RandomBN.uni());
                ++n5;
            }
            OfferIV offerIV = new OfferIV(nArray);
            double d = this.utility.computeUtility(offerIV);
            if (d <= 0.0) {
                ++n3;
            } else if (n2 == 0) {
                bl2 = false;
                n = 0;
                this.work.sorted_offers[n] = offerIV;
                this.work.sorted_values[n] = d;
                ++n2;
                n3 = 0;
            } else {
                n = 0;
                bl2 = false;
                int n6 = n2;
                while (n6 >= 1) {
                    if (((Object)offerIV).equals(this.work.sorted_offers[n6 - 1])) {
                        bl2 = true;
                        break;
                    }
                    if (d < this.work.sorted_values[n6 - 1]) {
                        n = n6;
                        break;
                    }
                    --n6;
                }
                if (!bl2) {
                    if (n < 0 || n > n2) {
                        throw new IllegalStateException("insert_here < 0 || insert_here > n");
                    }
                    int n7 = n2;
                    while (n7 > n) {
                        this.work.sorted_offers[n7] = this.work.sorted_offers[n7 - 1];
                        this.work.sorted_values[n7] = this.work.sorted_values[n7 - 1];
                        --n7;
                    }
                    this.work.sorted_offers[n] = offerIV;
                    this.work.sorted_values[n] = d;
                    ++n2;
                    n3 = 0;
                } else {
                    ++n3;
                }
            }
            if (n3 < 200 && n2 < n4) continue;
            bl = false;
        }
        this.work.sorted_total = n2;
        this.work.sorted_index = 0;
        System.out.print(" list of ");
        System.out.print(this.work.sorted_total);
        System.out.println(" sorted offers: ");
        n = 0;
        while (n < this.work.sorted_total) {
            System.out.print(this.work.sorted_offers[n]);
            System.out.print(" u ");
            System.out.println(this.work.sorted_values[n]);
            ++n;
        }
    }

    private int getNonCommentLine(BufferedReader bufferedReader) throws IOException {
        while (true) {
            int n = 32;
            while (Character.isWhitespace((char)n)) {
                bufferedReader.mark(1);
                n = bufferedReader.read();
                if (n != -1) continue;
                return -1;
            }
            if (n != 35) break;
            bufferedReader.readLine();
        }
        bufferedReader.reset();
        return 0;
    }

    static class WorkArea {
        Offer[] sorted_offers;
        double[] sorted_values;
        int sorted_total;
        int sorted_index;

        WorkArea() {
        }
    }
}

