/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bilateral;

import com.ibm.bilateral.ClArgs;
import java.io.Serializable;

public class ClArgsImp
implements ClArgs,
Serializable {
    private static final boolean DEBUG = false;
    private static final int DEFAULT_NUM_NEGOTIATIONS = 10000;
    private static final int DEFAULT_NUM_ROUNDS = 200;
    private static final int DEFAULT_NUM_OFFERS_PER_ROUND = 10;
    private static final int DEFAULT_RANDOM_SEED = 789;
    private static final boolean DEFAULT_VERBOSE = false;
    private int random_seed = 789;
    private boolean verbose = false;
    private int num_negotiations = 10000;
    private int num_rounds = 200;
    private int num_offers_per_round = 10;
    private double beta;

    public void setNumberOfNegotiations(int n) {
        this.num_negotiations = n;
    }

    public void setNumberOfRounds(int n) {
        this.num_rounds = n;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public int getRandomSeed() {
        return this.random_seed;
    }

    public int numNegotiations() {
        return this.num_negotiations;
    }

    public int numRounds() {
        return this.num_rounds;
    }

    public int numOffersPerRound() {
        return this.num_offers_per_round;
    }

    public int parseArgs(String[] stringArray) {
        if (stringArray.length < 2) {
            ClArgsImp.usage_error();
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = 2;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-beta")) {
                if (n2 + 1 < stringArray.length && ClArgsImp.numeric_check(stringArray[n2 + 1])) {
                    this.beta = Float.parseFloat(stringArray[n2 + 1]);
                    ++n2;
                } else {
                    ClArgsImp.usage_error();
                }
            }
            if (stringArray[n2].equals("-r")) {
                if (n2 + 1 < stringArray.length && ClArgsImp.numeric_check(stringArray[n2 + 1])) {
                    this.random_seed = Integer.parseInt(stringArray[n2 + 1]);
                    ++n2;
                } else {
                    ClArgsImp.usage_error();
                }
            } else if (stringArray[n2].equals("-v")) {
                if (n2 + 1 < stringArray.length && ClArgsImp.numeric_check(stringArray[n2 + 1])) {
                    this.verbose = Integer.parseInt(stringArray[n2 + 1]) != 0;
                    ++n2;
                } else {
                    ClArgsImp.usage_error();
                }
            } else if (stringArray[n2].equals("-nneg")) {
                if (n2 + 1 < stringArray.length && ClArgsImp.numeric_check(stringArray[n2 + 1])) {
                    this.num_negotiations = Integer.parseInt(stringArray[n2 + 1]);
                    ++n2;
                } else {
                    ClArgsImp.usage_error();
                }
            } else if (stringArray[n2].equals("-nround") || stringArray[n2].equals("-nr")) {
                if (n2 + 1 < stringArray.length && ClArgsImp.numeric_check(stringArray[n2 + 1])) {
                    this.num_rounds = Integer.parseInt(stringArray[n2 + 1]);
                    ++n2;
                } else {
                    ClArgsImp.usage_error();
                }
            } else if (stringArray[n2].equals("-noffers") || stringArray[n2].equals("-no")) {
                if (n2 + 1 < stringArray.length && ClArgsImp.numeric_check(stringArray[n2 + 1])) {
                    this.num_offers_per_round = Integer.parseInt(stringArray[n2 + 1]);
                    ++n2;
                } else {
                    ClArgsImp.usage_error();
                }
            } else {
                System.err.println("Unknown parameter: " + stringArray[n2]);
                ClArgsImp.usage_error();
            }
            ++n2;
        }
        return n;
    }

    private static void usage_error() {
        System.err.println("Usage: amab <n_exps> <inputfilename>");
        System.err.println("             [-r <(int) Random seed>]");
        System.err.println("             [-v <(int) turn on/off detailed printing>]");
        System.err.println("             [-nneg <(int) num negotiations>]");
        throw new IllegalArgumentException("usage_error");
    }

    private static boolean numeric_check(String string) {
        try {
            float f = Float.parseFloat(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

