/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bilateral;

import com.ibm.bilateral.RandomBN;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;

public class CesUtility
implements Serializable {
    private final double[] alpha;
    private double rho;
    private double offset;
    private double max_offset;
    protected static final double MAX_UTILITY_OFFSET = 2.0;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("rho = ");
        stringBuffer.append(this.rho);
        stringBuffer.append(", offset = ");
        stringBuffer.append(this.offset);
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    public double[] getAlpha() {
        double[] dArray = new double[this.alpha.length];
        System.arraycopy(this.alpha, 0, dArray, 0, this.alpha.length);
        return dArray;
    }

    public double getAlpha(int n) {
        return this.alpha[n];
    }

    public double getRho() {
        return this.rho;
    }

    public double getOffset() {
        return this.offset;
    }

    public double getMaxOffset() {
        return this.max_offset;
    }

    public static CesUtility createFixed(int n) {
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = 1.0 / (double)dArray.length;
            ++n2;
        }
        return new CesUtility(dArray, -2.0, 2.0, 2.0);
    }

    public static CesUtility createRandom(int n) {
        double d = RandomBN.uni();
        double d2 = (1.0 - 2.0 * d) / (1.0 - d);
        double d3 = 2.0 * RandomBN.uni();
        double[] dArray = new double[n];
        RandomBN.UniformRandomSimplex(dArray, dArray.length);
        return new CesUtility(dArray, d2, d3, 2.0);
    }

    public CesUtility(double[] dArray, double d, double d2, double d3) {
        this.alpha = new double[dArray.length];
        System.arraycopy(dArray, 0, this.alpha, 0, dArray.length);
        this.rho = d;
        this.offset = d2;
        this.max_offset = d3;
    }

    public static CesUtility createFromFileFixed(String string, int n) throws IOException {
        return new CesUtility(string, n, false);
    }

    public static CesUtility createFromFileRandom(String string, int n) throws IOException {
        return new CesUtility(string, n, true);
    }

    private CesUtility(String string, int n, boolean bl) throws IOException {
        this.alpha = new double[n];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        this.getNonCommentLine(bufferedReader);
        if (bl) {
            StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            this.max_offset = Double.parseDouble(stringTokenizer.nextToken());
            bufferedReader.close();
            double[] dArray = new double[n];
            RandomBN.UniformRandomSimplex(dArray, dArray.length);
            double d = RandomBN.uni();
            this.rho = (1.0 - 2.0 * d) / (1.0 - d);
            this.offset = this.max_offset * RandomBN.uni();
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            int n2 = 0;
            while (n2 < this.alpha.length) {
                this.alpha[n2] = Double.parseDouble(stringTokenizer.nextToken());
                ++n2;
            }
            stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            this.rho = Double.parseDouble(stringTokenizer.nextToken());
            stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            this.offset = Double.parseDouble(stringTokenizer.nextToken());
            bufferedReader.close();
            this.max_offset = 2.0;
        }
    }

    private int getNonCommentLine(BufferedReader bufferedReader) throws IOException {
        while (true) {
            int n = 32;
            while (Character.isWhitespace((char)n)) {
                bufferedReader.mark(1);
                n = bufferedReader.read();
                if (n != -1) continue;
                return -1;
            }
            if (n != 35) break;
            bufferedReader.readLine();
        }
        bufferedReader.reset();
        return 0;
    }
}

