/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bilateral;

import com.ibm.bilateral.CesUtility;
import com.ibm.bilateral.Offer;
import com.ibm.bilateral.OfferIV;
import com.ibm.bilateral.ScaledAttributes;
import com.ibm.bilateral.Utility;
import java.io.Serializable;

class BuyerCesUtility
implements Utility,
Serializable {
    private final CesUtility ces;
    private final ScaledAttributes[] scaled_attributes;

    public BuyerCesUtility(CesUtility cesUtility, ScaledAttributes[] scaledAttributesArray) {
        this.ces = cesUtility;
        this.scaled_attributes = scaledAttributesArray;
    }

    public double computeUtility(Offer offer) {
        if (offer == null) {
            throw new NullPointerException("Offer must not be null");
        }
        OfferIV offerIV = (OfferIV)offer;
        double d = 0.0;
        int n = 0;
        while (n < 2) {
            double d2 = ((double)offerIV.getAttributeValue(n) - this.scaled_attributes[n].min) / this.scaled_attributes[n].norm;
            d += this.ces.getAlpha(n) * Math.pow(d2, this.ces.getRho());
            ++n;
        }
        d = Math.pow(d, 1.0 / this.ces.getRho());
        return d -= this.ces.getOffset();
    }

    public String toString() {
        return this.ces.toString();
    }
}

