/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bilateral;

import com.ibm.bilateral.BuyerStrategy;
import com.ibm.bilateral.ClArgs;
import com.ibm.bilateral.Holdings;
import com.ibm.bilateral.NegotiationState;
import com.ibm.bilateral.NegotiationStats;
import com.ibm.bilateral.Offer;
import com.ibm.bilateral.OfferSet;
import com.ibm.bilateral.Response;
import com.ibm.bilateral.Session;
import com.ibm.bilateral.SessionHistory;
import com.ibm.bilateral.TradingPartner;
import com.ibm.bilateral.Utility;
import java.io.IOException;
import java.io.Serializable;

public class Buyer
implements Serializable {
    private static final boolean DEBUG = true;
    private final ClArgs cl;
    private final TradingPartner agentID;
    private TradingPartner partnerID;
    private final BuyerStrategy sparams;
    private final Utility utility;
    private final NegotiationState nstate;
    private final NegotiationStats nstats;
    private final Holdings hold;
    private final SessionHistory sh;

    public Buyer(ClArgs clArgs, TradingPartner tradingPartner, BuyerStrategy buyerStrategy, Utility utility, int n) throws IOException {
        this.cl = clArgs;
        this.sparams = buyerStrategy;
        this.nstate = new NegotiationState();
        this.nstats = new NegotiationStats();
        this.hold = new Holdings();
        this.utility = utility;
        this.agentID = tradingPartner;
        this.hold.cash = n;
        this.hold.quant = 0;
        this.sh = this.sparams.createHistory();
        if (clArgs.isVerbose()) {
            System.out.print("For buyer with agent ID = ");
            System.out.print(tradingPartner);
            System.out.print(": ");
            System.out.println(utility);
        }
    }

    public synchronized boolean buyerInitNegotiation(TradingPartner tradingPartner) {
        if (this.nstate.inNegotiation) {
            throw new IllegalStateException("Call to buyerInitNegotiation during existing negotiation.");
        }
        this.nstate.inNegotiation = true;
        this.nstate.reset();
        this.partnerID = tradingPartner;
        Session session = this.sh.newSession();
        session.sessionInit(tradingPartner);
        return true;
    }

    public synchronized Response buyerRespondToOffer(OfferSet offerSet) {
        if (!this.nstate.inNegotiation) {
            throw new IllegalStateException("Call to buyerRespondToOffer before buyerInitNegotiation().");
        }
        ++this.nstate.current_round;
        Response response = this.sparams.respondToOffer(this.nstate, this.utility, offerSet);
        if (!response.isQuit() && response.getChoice() >= 0) {
            this.nstate.currentAO = offerSet.getOffer(response.getChoice());
            this.nstate.currentAOvalue = this.utility.computeUtility(this.nstate.currentAO);
            if (this.nstate.nAO == 0) {
                this.nstate.initAO = this.nstate.currentAO;
                this.nstate.initAOvalue = this.nstate.currentAOvalue;
            }
            ++this.nstate.nAO;
        }
        Session session = this.sh.currentSession();
        int n = this.nstate.current_round;
        session.UpdateSessionHistory(n, offerSet, response);
        return response;
    }

    public synchronized void buyerCompleteNegotiation(boolean bl) {
        if (!this.nstate.inNegotiation) {
            throw new IllegalStateException("Call to buyerCompleteNegotiation() outside existing negotiation.");
        }
        this.nstate.inNegotiation = false;
        Session session = this.sh.currentSession();
        session.sessionUpdate(this.nstate);
        if (bl) {
            session.finalUpdate(this.nstate.currentAOvalue);
            this.UpdateInventory();
        } else {
            this.nstate.nAO = 0;
            session.finalUpdate(0.0);
        }
        this.nstats.UpdateStats(this.nstate);
        this.partnerID = null;
        this.nstate.reset();
    }

    public synchronized boolean buyerConfirm(Offer offer) {
        if (!this.nstate.inNegotiation) {
            throw new IllegalStateException("Call to buyerConfirm() outside existing negotiation.");
        }
        return offer.equals(this.nstate.currentAO);
    }

    void UpdateInventory() {
        if (this.nstate.nAO < 1) {
            return;
        }
        Offer offer = this.nstate.currentAO;
        int n = offer.getPrice();
        int n2 = offer.getUnits();
        this.hold.quant += n2;
        this.hold.cash -= n;
    }

    public void BuyerLearn() {
    }

    public double computeUtility(Offer offer) {
        return this.utility.computeUtility(offer);
    }

    public TradingPartner getId() {
        return this.agentID;
    }

    public TradingPartner getPartnerId() {
        return this.partnerID;
    }

    public boolean inNegotiation() {
        return this.nstate.inNegotiation;
    }

    public int getCurrentRound() {
        return this.nstate.current_round;
    }

    public Offer getCurrentAO() {
        return this.nstate.currentAO;
    }

    public int numAcceptedOffers() {
        return this.nstate.nAO;
    }

    public NegotiationStats getStatistics() {
        return this.nstats;
    }
}

