/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bilateral;

import com.ibm.bilateral.Buyer;
import com.ibm.bilateral.ClArgsImp;
import com.ibm.bilateral.Offer;
import com.ibm.bilateral.OfferSet;
import com.ibm.bilateral.Response;
import com.ibm.bilateral.RoundPrinter;
import com.ibm.bilateral.Seller;
import java.io.Serializable;

public abstract class Amab
implements Serializable {
    private static final boolean DEBUG = true;
    public static final String COPYRIGHT = "(C) Copyright IBM Corporation 2002.";
    public static final boolean COMMAND_LINE_RESET = true;
    ClArgsImp cl = new ClArgsImp();

    public static void negotiate(Buyer buyer, Seller seller, RoundPrinter roundPrinter) {
        OfferSet offerSet = null;
        Response response = null;
        if (!seller.sellerInitNegotiation(buyer.getId())) {
            return;
        }
        if (!buyer.buyerInitNegotiation(seller.getId())) {
            seller.sellerCompleteNegotiation(false);
            return;
        }
        do {
            offerSet = seller.sellerMakeOffer();
            System.out.println("Seller proposes " + offerSet);
            if (offerSet.isQuit()) continue;
            response = buyer.buyerRespondToOffer(offerSet);
            System.out.println("Buyer responds with " + response);
            seller.sellerReceiveResponse(response);
            roundPrinter.printRound(buyer, seller, offerSet);
        } while (!offerSet.isQuit() && !response.isQuit());
        Offer offer = seller.sellerConfirm();
        System.out.println("Seller confirms " + offer);
        boolean bl = buyer.buyerConfirm(offer);
        System.out.println(bl ? "Buyer agrees" : "Buyer does not agree");
        buyer.buyerCompleteNegotiation(bl);
        seller.sellerCompleteNegotiation(bl);
    }

    public static String Copyright() {
        return COPYRIGHT;
    }
}

