/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.planner4J.state;

import com.ibm.able.planner4J.planners.Options;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ActionImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ActionManager;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.PredicateImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.PredicateManager;
import com.ibm.able.planner4J.state.IState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class StripsStateImpl
implements IState,
Comparable,
Serializable {
    static final long serialVersionUID = 2004100100000000001L;
    public final int d_INFINITE_HVALUE = Options.getInfiniteValue();
    int d_hvalue;
    HashSet d_facts;
    ArrayList d_trace;
    ActionManager d_am = ActionManager.getActionManager();
    PredicateManager d_pm = PredicateManager.getPredicateManager();

    public StripsStateImpl() {
        this.d_facts = new HashSet();
        this.d_hvalue = this.d_INFINITE_HVALUE;
        this.d_trace = new ArrayList();
    }

    public StripsStateImpl(StripsStateImpl s) {
        this.d_facts = new HashSet(s.getFactsInternal());
        this.d_hvalue = this.d_INFINITE_HVALUE;
        this.d_trace = new ArrayList();
    }

    public Collection getFacts() {
        HashSet<PredicateImpl> facts = new HashSet<PredicateImpl>();
        PredicateImpl p = null;
        Iterator iter = this.d_facts.iterator();
        while (iter.hasNext()) {
            Integer id = (Integer)iter.next();
            p = this.d_pm.getFact(id);
            if (p == null) {
                System.out.println("INTERNAL ERROR: Found fact id '" + id + "'without matching object. Inside getFacts()");
                return null;
            }
            facts.add(p);
        }
        return facts;
    }

    public Collection getFactsInternal() {
        return this.d_facts;
    }

    public int getHeuristicValue() {
        return this.d_hvalue;
    }

    public void setHeuristicValue(int hvalue) {
        this.d_hvalue = hvalue;
    }

    public Integer getTrace(int pos) {
        return (Integer)this.d_trace.get(pos);
    }

    public int getTraceSize() {
        return this.d_trace.size();
    }

    public void addTrace(Integer actionId) {
        this.d_trace.add(actionId);
    }

    public int getStateSize() {
        return this.d_facts.size();
    }

    public int compareTo(Object other) {
        StripsStateImpl otherState = (StripsStateImpl)other;
        int otherHValue = otherState.getHeuristicValue();
        if (this.d_hvalue < otherHValue) {
            return -1;
        }
        if (this.d_hvalue == otherHValue) {
            return 0;
        }
        return 1;
    }

    public void addFact(int id) {
        Integer keyId = new Integer(id);
        this.d_facts.add(keyId);
    }

    public void addFact(Integer keyId) {
        this.d_facts.add(keyId);
    }

    public void delFact(int id) {
        Integer keyId = new Integer(id);
        this.d_facts.remove(keyId);
    }

    public void delFact(Integer keyId) {
        this.d_facts.remove(keyId);
    }

    public boolean isTrue(int id) {
        Integer keyId = new Integer(id);
        return this.d_facts.contains(keyId);
    }

    public boolean isTrue(Integer keyId) {
        return this.d_facts.contains(keyId);
    }

    public boolean isSubset(IState p_second) {
        StripsStateImpl second = (StripsStateImpl)p_second;
        Iterator iter = second.getFactsInternal().iterator();
        while (iter.hasNext()) {
            if (this.d_facts.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isSubset(IState p_first, IState p_second) {
        StripsStateImpl first = (StripsStateImpl)p_first;
        StripsStateImpl second = (StripsStateImpl)p_second;
        if (first == null) {
            return true;
        }
        Iterator iter = first.getFactsInternal().iterator();
        while (iter.hasNext()) {
            Integer id = (Integer)iter.next();
            if (second.isTrue(id)) continue;
            return false;
        }
        return true;
    }

    public boolean formsForwardCycle(StripsStateImpl start) {
        int id;
        StripsStateImpl tmp1State = new StripsStateImpl(start);
        StripsStateImpl tmpState = new StripsStateImpl(start);
        int i = 0;
        while (i < this.d_trace.size()) {
            id = (Integer)this.d_trace.get(i);
            tmpState = this.applyActionForward(id, tmpState);
            ++i;
        }
        i = 0;
        while (i < this.d_trace.size() - 1) {
            if (tmpState != null && this.isSubset(tmpState, tmp1State)) {
                if (Options.getDebugOption()) {
                    System.out.println("-- Result: is a subset / forms cycle !\n");
                }
                return true;
            }
            id = (Integer)this.d_trace.get(i);
            tmp1State = this.applyActionForward(id, tmp1State);
            ++i;
        }
        return false;
    }

    public boolean formsBackwardCycle(StripsStateImpl start) {
        int id;
        StripsStateImpl tmp1State = new StripsStateImpl(start);
        StripsStateImpl tmpState = new StripsStateImpl(start);
        int i = 0;
        while (i < this.d_trace.size()) {
            id = (Integer)this.d_trace.get(i);
            tmpState = this.applyActionBackward(id, tmpState);
            ++i;
        }
        i = 0;
        while (i < this.d_trace.size() - 1) {
            if (tmpState != null && this.isSubset(tmp1State, tmpState)) {
                if (Options.getDebugOption()) {
                    System.out.println("-- Result: is a subset / forms cycle !\n The newstate is " + tmpState + " and it is a subset of " + tmp1State);
                }
                return true;
            }
            id = (Integer)this.d_trace.get(i);
            tmp1State = this.applyActionBackward(id, tmp1State);
            ++i;
        }
        return false;
    }

    public StripsStateImpl createUnion(StripsStateImpl second) {
        StripsStateImpl union = new StripsStateImpl(this);
        Iterator iter = second.getFactsInternal().iterator();
        while (iter.hasNext()) {
            union.addFact((Integer)iter.next());
        }
        return union;
    }

    public StripsStateImpl createDelete(StripsStateImpl second) {
        StripsStateImpl delete = new StripsStateImpl(this);
        Iterator iter = second.getFactsInternal().iterator();
        while (iter.hasNext()) {
            delete.delFact((Integer)iter.next());
        }
        return delete;
    }

    public StripsStateImpl applyActionForward(int actionId) {
        return this.applyActionForward(actionId, this);
    }

    public StripsStateImpl applyActionForward(int actionId, StripsStateImpl start) {
        Integer id;
        if (start == null) {
            return null;
        }
        StripsStateImpl newState = new StripsStateImpl(start);
        ActionImpl action = this.d_am.getAction(actionId);
        if (action == null) {
            return null;
        }
        int i = 0;
        while (i < action.getNumPrecond()) {
            id = (Integer)action.getPrecond(i);
            if (!newState.isTrue(id)) {
                return null;
            }
            ++i;
        }
        i = 0;
        while (i < action.getNumDelete()) {
            id = (Integer)action.getDelete(i);
            newState.delFact(id);
            ++i;
        }
        i = 0;
        while (i < action.getNumAdd()) {
            id = (Integer)action.getAdd(i);
            newState.addFact(id);
            ++i;
        }
        return newState;
    }

    public StripsStateImpl applyActionBackward(int actionId) {
        return this.applyActionBackward(actionId, this);
    }

    public StripsStateImpl applyActionBackward(int actionId, StripsStateImpl start) {
        Integer id;
        if (start == null) {
            return null;
        }
        StripsStateImpl newState = new StripsStateImpl(start);
        ActionImpl action = this.d_am.getAction(actionId);
        if (action == null) {
            return null;
        }
        int i = 0;
        while (i < action.getNumDelete()) {
            id = (Integer)action.getDelete(i);
            if (newState.isTrue(id)) {
                return null;
            }
            ++i;
        }
        if (Options.getCompleteGoalFlag()) {
            i = 0;
            while (i < action.getNumAdd()) {
                id = (Integer)action.getAdd(i);
                if (!newState.isTrue(id)) break;
                ++i;
            }
            if (i < action.getNumAdd()) {
                return null;
            }
        } else {
            i = 0;
            while (i < action.getNumAdd()) {
                id = (Integer)action.getAdd(i);
                if (newState.isTrue(id)) break;
                ++i;
            }
            if (i >= action.getNumAdd()) {
                return null;
            }
        }
        i = 0;
        while (i < action.getNumAdd()) {
            id = (Integer)action.getAdd(i);
            newState.delFact(id);
            ++i;
        }
        i = 0;
        while (i < action.getNumPrecond()) {
            id = (Integer)action.getPrecond(i);
            newState.addFact(id);
            ++i;
        }
        return newState;
    }

    public String toString() {
        String s = "";
        if (Options.getDebugOption()) {
            s = String.valueOf(s) + "\n  --------------- ";
            s = String.valueOf(s) + "\nExpanded view = [";
            Iterator iter = this.d_facts.iterator();
            while (iter.hasNext()) {
                s = String.valueOf(s) + " " + this.d_pm.getFact((int)((Integer)iter.next())).getFullName() + " ";
            }
            s = String.valueOf(s) + "]";
            s = String.valueOf(s) + "\nHvalue = " + this.d_hvalue;
            s = String.valueOf(s) + "\nActions up to state = " + this.d_trace + "\n";
        }
        s = String.valueOf(s) + this.d_facts;
        if (Options.getDebugOption()) {
            s = String.valueOf(s) + "\n  --------------- \n\n";
        }
        return s;
    }
}

