/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.planner4J.search.stateSpaceSearchImpl;

import com.ibm.able.planner4J.planners.IDomain;
import com.ibm.able.planner4J.planners.IPlanSolution;
import com.ibm.able.planner4J.planners.IProblem;
import com.ibm.able.planner4J.planners.Options;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ActionManager;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.HelperUtil;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.PlanSolutionImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.PredicateManager;
import com.ibm.able.planner4J.search.ISearch;
import com.ibm.able.planner4J.search.SearchQueue;
import com.ibm.able.planner4J.search.stateSpaceSearchImpl.BiLevelPlanningGraphImpl;
import com.ibm.able.planner4J.search.stateSpaceSearchImpl.PlanningGraphHeuristicsCalculator;
import com.ibm.able.planner4J.state.IState;
import com.ibm.able.planner4J.state.StripsStateImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;

public class StateSpaceSearchImpl
implements ISearch,
Serializable {
    static final long serialVersionUID = 2004100100000000001L;
    protected String d_name = "State Space";
    protected int d_MAXSTATES_EXPLORED = Options.getMaxStateExploreLimit();
    protected int d_MAXSTATES_SEARCHED = Options.getMaxStateSearchLimit();
    IPlanSolution d_sol = null;
    HelperUtil d_helpers;
    ArrayList d_groundActions;
    SearchQueue d_queue;
    int d_stateExplored;
    int d_stateSearched;
    long d_searchTime;
    long d_startTime;
    long d_stopTime;
    ActionManager d_am = ActionManager.getActionManager();
    PredicateManager d_pm = PredicateManager.getPredicateManager();
    protected BiLevelPlanningGraphImpl d_pg;

    public String getAlgorithmName() {
        return this.d_name;
    }

    public ArrayList getGroundedActions() {
        return this.d_groundActions;
    }

    public int getHeuristicDistance(IState firstState, IState secondState) {
        if (Options.getSearchHeuristicType() > 0) {
            return this.getHeuristicDistanceUsingPlanningGraph(firstState, secondState);
        }
        return this.getHeuristicDistanceByStateDifference(firstState, secondState);
    }

    public int getHeuristicDistanceUsingPlanningGraph(IState firstState, IState secondState) {
        int heuristicType = Options.getSearchHeuristicType();
        int gval = ((StripsStateImpl)firstState).getTraceSize();
        int hval = heuristicType == 1 ? PlanningGraphHeuristicsCalculator.getMaxPGHeuristic(this.d_pg, firstState) : (heuristicType == 2 ? PlanningGraphHeuristicsCalculator.getSumPGHeuristic(this.d_pg, firstState) : (heuristicType == 3 ? PlanningGraphHeuristicsCalculator.getLevelPGHeuristic(this.d_pg, firstState) : (heuristicType == 4 ? PlanningGraphHeuristicsCalculator.getComboPGHeuristic(this.d_pg, firstState) : (heuristicType == 5 ? PlanningGraphHeuristicsCalculator.getAdjSumPGHeuristic(this.d_pg, firstState) : PlanningGraphHeuristicsCalculator.getAdjSum2PGHeuristic(this.d_pg, firstState, secondState)))));
        if (Options.getDebugOption()) {
            System.out.println("HeuristicType " + heuristicType + " - state: " + firstState + "\n   g = " + gval + "  hval = " + hval);
        }
        hval = gval + Options.getHeuristicWeight() * hval;
        if (Options.getDebugOption()) {
            System.out.println("\tTotal hval (f = g + w * h) = " + hval);
        }
        return hval;
    }

    public int getHeuristicDistanceByStateDifference(IState firstState, IState secondState) {
        StripsStateImpl tmpNode = (StripsStateImpl)firstState;
        StripsStateImpl reachNode = (StripsStateImpl)secondState;
        int gval = tmpNode.getTraceSize();
        int hval = Options.getForwardDirectionOption() ? reachNode.getStateSize() : tmpNode.getStateSize();
        Iterator iter = tmpNode.getFactsInternal().iterator();
        while (iter.hasNext()) {
            if (!reachNode.isTrue((int)((Integer)iter.next()))) continue;
            --hval;
        }
        if (Options.getDebugOption()) {
            System.out.println("HeuristicType 0 - state: " + tmpNode + "\n   g = " + gval + "  hval = " + hval);
        }
        hval = gval + Options.getHeuristicWeight() * hval;
        if (Options.getDebugOption()) {
            System.out.println("\tTotal hval (f = g + w * h) = " + hval);
        }
        return hval;
    }

    /*
     * Unable to fully structure code
     */
    public boolean solve(IDomain domain, IProblem problem, IState p_initial, IState p_goal) {
        initial = (StripsStateImpl)p_initial;
        goal = (StripsStateImpl)p_goal;
        this.d_sol = new PlanSolutionImpl();
        minHValue = Options.getInfiniteValue();
        closestState = null;
        this.d_helpers = new HelperUtil(domain, problem, initial, goal);
        this.d_stateExplored = 0;
        this.d_stateSearched = 0;
        this.d_searchTime = 0L;
        start = new Date();
        this.d_startTime = start.getTime();
        this.d_groundActions = this.d_helpers.getGroundActions();
        if (Options.getReduceOpsOption()) {
            d_relgroundActions = this.d_helpers.getGroundRelevantActions2();
            sz1 = this.d_groundActions.size();
            if (sz1 != (sz2 = d_relgroundActions.size())) {
                System.out.println("STATUS: Reduction of operators (in %) = " + (float)(sz1 - sz2) / (float)sz1 * 100.0f);
                if (Options.getDebugOption()) {
                    System.out.println("=>Input ops");
                    i = 0;
                    while (i < this.d_groundActions.size()) {
                        System.out.println(this.d_am.getAction((Integer)this.d_groundActions.get(i)));
                        ++i;
                    }
                    System.out.println("=>Relevant ops");
                    i = 0;
                    while (i < d_relgroundActions.size()) {
                        System.out.println(this.d_am.getAction((Integer)d_relgroundActions.get(i)));
                        ++i;
                    }
                }
                this.d_groundActions = d_relgroundActions;
            }
            infactid = 0;
            rfactid = 0;
            relfacts = this.d_helpers.getRelevantFacts();
            rfacts = relfacts.toArray();
            initial_facts = initial.getFactsInternal();
            infacts = initial_facts.toArray();
            j = 0;
            while (j < infacts.length) {
                infactid = (Integer)infacts[j];
                i = 0;
                while (i < rfacts.length) {
                    rfactid = (Integer)rfacts[i];
                    if (infactid == rfactid) break;
                    ++i;
                }
                if (i >= rfacts.length) {
                    initial.delFact(infactid);
                }
                ++j;
            }
        }
        if (Options.getDebugOption()) {
            System.out.println("The grounded actions for the problem are: ");
            i = 0;
            while (i < this.d_groundActions.size()) {
                System.out.println(this.d_groundActions.get(i));
                ++i;
            }
            System.out.println("The predicates are: \n" + this.d_pm);
        }
        if (Options.getReachFactsCheckOption()) {
            S1 = new StripsStateImpl(this.d_helpers.getReachablePredicates(this.d_groundActions));
            if (Options.getDebugOption()) {
                System.out.println("The initial state before: \n" + initial);
            }
            if (!initial.createUnion(S1).isSubset(goal)) {
                System.out.println("STATUS: Problem detected as unsolvable by reachability check!");
                return false;
            }
            in1 = initial.getStateSize();
            gl1 = goal.getStateSize();
            initial = initial.createDelete(initial.createDelete(S1));
            goal = goal.createDelete(goal.createDelete(S1));
            in2 = initial.getStateSize();
            gl2 = goal.getStateSize();
            if (Options.getDebugOption()) {
                System.out.println("The initial state after: \n" + initial);
            }
            p_goal = goal;
            if (in1 - in2 > 0 || gl1 - gl2 > 0) {
                System.out.println("STATUS: Predicates pruned from reachability check. Difference in Initial:" + Integer.toString(in1 - in2) + "and Goals: " + Integer.toString(gl1 - gl2));
            }
        }
        if (Options.getSearchHeuristicType() > 0) {
            this.d_pg = new BiLevelPlanningGraphImpl();
            this.d_pg.setPGGrowTillLevelOff(true);
            this.d_pg.setPGNumberingType(true);
            this.d_pg.setPGSerial(true);
            if (Options.getForwardDirectionOption()) {
                if (!this.d_pg.buildRegressPG(initial, p_goal, this.d_groundActions)) {
                    System.out.println("STATUS: The problem is unsolvable !");
                    if (Options.getDebugOption()) {
                        System.out.println("STATUS: PG built. It is :" + this.d_pg);
                    }
                    return this.terminateSearch(false);
                }
            } else if (!this.d_pg.buildPG(initial, p_goal, this.d_groundActions)) {
                System.out.println("STATUS: The problem is unsolvable !");
                if (Options.getDebugOption()) {
                    System.out.println("STATUS: PG built. It is :" + this.d_pg);
                }
                return this.terminateSearch(false);
            }
        }
        this.d_queue = new SearchQueue();
        MAX = 5 * this.d_MAXSTATES_SEARCHED / 100;
        states_cache = new HashSet<String>(MAX);
        counter_cache_hits = 0;
        counter_all_states = 0;
        lookup_for_fifo = 0;
        lru_index = 0;
        lrustate = new String[MAX];
        lrucount = new int[MAX];
        if (Options.getForwardDirectionOption()) {
            this.d_queue.add(initial);
        } else {
            this.d_queue.add(goal);
        }
        while (this.d_stateExplored < this.d_MAXSTATES_EXPLORED && this.d_stateSearched < this.d_MAXSTATES_SEARCHED && !this.d_queue.isEmpty()) {
            block57: {
                block55: {
                    block56: {
                        tmpNode = (StripsStateImpl)this.d_queue.remove();
                        tmpstring = tmpNode.toString();
                        if (!Options.getMinimalTestOption()) break block55;
                        if (states_cache.size() >= MAX) break block56;
                        states_cache.add(tmpstring);
                        lrustate[lru_index] = tmpstring;
                        lrucount[lru_index] = 0;
                        lru_index = lru_index < MAX - 1 ? ++lru_index : 0;
                        break block55;
                    }
                    if (lrucount[lookup_for_fifo] != 0) ** GOTO lbl133
                    states_cache.remove(lrustate[lookup_for_fifo]);
                    states_cache.add(tmpstring);
                    lrustate[lookup_for_fifo] = tmpstring;
                    lrucount[lookup_for_fifo] = 0;
                    lookup_for_fifo = lookup_for_fifo < MAX - 1 ? ++lookup_for_fifo : 0;
                    break block55;
lbl-1000:
                    // 1 sources

                    {
                        lrucount[lookup_for_fifo] = 0;
                        if (lookup_for_fifo < MAX - 1) {
                            ++lookup_for_fifo;
                            continue;
                        }
                        lookup_for_fifo = 0;
lbl133:
                        // 3 sources

                        ** while (lrucount[lookup_for_fifo] == 1)
                    }
lbl134:
                    // 1 sources

                    states_cache.remove(lrustate[lookup_for_fifo]);
                    states_cache.add(tmpstring);
                    lrustate[lookup_for_fifo] = tmpstring;
                    lrucount[lookup_for_fifo] = 0;
                    lookup_for_fifo = lookup_for_fifo < MAX - 1 ? ++lookup_for_fifo : 0;
                }
                if (Options.getDebugOption()) {
                    System.out.println("==================================================\nExpanding state (count = " + this.d_stateSearched + "): " + tmpNode);
                }
                ++this.d_stateSearched;
                if (!Options.getForwardDirectionOption()) break block57;
                if (tmpNode.isSubset(goal)) {
                    i = 0;
                    while (i < tmpNode.getTraceSize()) {
                        this.d_sol.addActionToSequentialSolution(tmpNode.getTrace(i));
                        ++i;
                    }
                    this.d_sol.setStatus(true);
                    break;
                }
                i = 0;
                while (i < this.d_groundActions.size()) {
                    block58: {
                        block59: {
                            block61: {
                                block60: {
                                    id = (Integer)this.d_groundActions.get(i);
                                    if (Options.getDebugOption()) {
                                        System.out.println("\tCandidate forward action: " + this.d_am.getAction(id));
                                    }
                                    if ((newNode = tmpNode.applyActionForward(id)) == null) break block58;
                                    j = 0;
                                    while (j < tmpNode.getTraceSize()) {
                                        newNode.addTrace(tmpNode.getTrace(j));
                                        ++j;
                                    }
                                    newNode.addTrace(id);
                                    if (!Options.getMinimalTestOption()) break block59;
                                    if (!states_cache.contains(newNode.toString())) break block60;
                                    ++counter_cache_hits;
                                    break block58;
                                }
                                if (Options.getDebugOption()) {
                                    System.out.println("Calling forward check!\n");
                                }
                                tmpstring = newNode.toString();
                                if (!newNode.formsForwardCycle(initial)) break block59;
                                ++counter_all_states;
                                if (states_cache.size() >= MAX) break block61;
                                states_cache.add(tmpstring);
                                lrustate[lru_index] = tmpstring;
                                lrucount[lru_index] = 0;
                                lru_index = lru_index < MAX - 1 ? ++lru_index : 0;
                                break block58;
                            }
                            if (lrucount[lookup_for_fifo] != 0) ** GOTO lbl198
                            states_cache.remove(lrustate[lookup_for_fifo]);
                            states_cache.add(tmpstring);
                            lrustate[lookup_for_fifo] = tmpstring;
                            lrucount[lookup_for_fifo] = 0;
                            lookup_for_fifo = lookup_for_fifo < MAX - 1 ? ++lookup_for_fifo : 0;
                            break block58;
lbl-1000:
                            // 1 sources

                            {
                                lrucount[lookup_for_fifo] = 0;
                                if (lookup_for_fifo < MAX - 1) {
                                    ++lookup_for_fifo;
                                    continue;
                                }
                                lookup_for_fifo = 0;
lbl198:
                                // 3 sources

                                ** while (lrucount[lookup_for_fifo] == 1)
                            }
lbl199:
                            // 1 sources

                            states_cache.remove(lrustate[lookup_for_fifo]);
                            states_cache.add(tmpstring);
                            lrustate[lookup_for_fifo] = tmpstring;
                            lrucount[lookup_for_fifo] = 0;
                            lookup_for_fifo = lookup_for_fifo < MAX - 1 ? ++lookup_for_fifo : 0;
                            break block58;
                        }
                        if ((hvalue = this.getHeuristicDistance(newNode, goal)) < Options.getInfiniteValue()) {
                            newNode.setHeuristicValue(hvalue);
                            if (Options.getCalcClosestStateOption() && minHValue > hvalue) {
                                closestState = newNode;
                            }
                            if (Options.getDebugOption()) {
                                System.out.println("\tApplying action " + this.d_am.getAction(id));
                                System.out.println("\tNew state: " + newNode + "\n");
                                System.out.println("The heuristic value is " + hvalue);
                            }
                            this.d_queue.add(newNode);
                            ++this.d_stateExplored;
                        }
                    }
                    ++i;
                }
                continue;
            }
            if (initial.isSubset(tmpNode)) {
                count = tmpNode.getTraceSize();
                i = 0;
                while (i < count) {
                    this.d_sol.addActionToSequentialSolution(tmpNode.getTrace(count - i - 1));
                    ++i;
                }
                this.d_sol.setStatus(true);
                break;
            }
            i = 0;
            while (i < this.d_groundActions.size()) {
                block62: {
                    block63: {
                        block65: {
                            block64: {
                                id = (Integer)this.d_groundActions.get(i);
                                if (Options.getDebugOption()) {
                                    System.out.println("\tCandidate backward action: " + this.d_am.getAction(id));
                                }
                                if ((newNode = tmpNode.applyActionBackward(id)) == null) break block62;
                                j = 0;
                                while (j < tmpNode.getTraceSize()) {
                                    newNode.addTrace(tmpNode.getTrace(j));
                                    ++j;
                                }
                                newNode.addTrace(id);
                                if (!Options.getMinimalTestOption()) break block63;
                                if (!states_cache.contains(newNode.toString())) break block64;
                                ++counter_cache_hits;
                                break block62;
                            }
                            tmpstring = newNode.toString();
                            if (!newNode.formsBackwardCycle(goal)) break block63;
                            ++counter_all_states;
                            if (states_cache.size() >= MAX) break block65;
                            states_cache.add(tmpstring);
                            lrustate[lru_index] = tmpstring;
                            lrucount[lru_index] = 0;
                            lru_index = lru_index < MAX - 1 ? ++lru_index : 0;
                            break block62;
                        }
                        if (lrucount[lookup_for_fifo] != 0) ** GOTO lbl274
                        states_cache.remove(lrustate[lookup_for_fifo]);
                        states_cache.add(tmpstring);
                        lrustate[lookup_for_fifo] = tmpstring;
                        lrucount[lookup_for_fifo] = 0;
                        lookup_for_fifo = lookup_for_fifo < MAX - 1 ? ++lookup_for_fifo : 0;
                        break block62;
lbl-1000:
                        // 1 sources

                        {
                            lrucount[lookup_for_fifo] = 0;
                            if (lookup_for_fifo < MAX - 1) {
                                ++lookup_for_fifo;
                                continue;
                            }
                            lookup_for_fifo = 0;
lbl274:
                            // 3 sources

                            ** while (lrucount[lookup_for_fifo] == 1)
                        }
lbl275:
                        // 1 sources

                        states_cache.remove(lrustate[lookup_for_fifo]);
                        states_cache.add(tmpstring);
                        lrustate[lookup_for_fifo] = tmpstring;
                        lrucount[lookup_for_fifo] = 0;
                        lookup_for_fifo = lookup_for_fifo < MAX - 1 ? ++lookup_for_fifo : 0;
                        break block62;
                    }
                    if ((hvalue = this.getHeuristicDistance(newNode, initial)) < Options.getInfiniteValue()) {
                        newNode.setHeuristicValue(hvalue);
                        if (Options.getCalcClosestStateOption() && minHValue > hvalue) {
                            closestState = newNode;
                        }
                        if (Options.getDebugOption()) {
                            System.out.println("\tApplying action " + this.d_am.getAction(id));
                            System.out.println("\tNew state: " + newNode + "\n");
                        }
                        this.d_queue.add(newNode);
                        ++this.d_stateExplored;
                    }
                }
                ++i;
            }
        }
        if (!(this.d_stateExplored < this.d_MAXSTATES_EXPLORED && this.d_stateSearched < this.d_MAXSTATES_SEARCHED || this.d_sol.isSolved())) {
            System.out.println("STATUS: The problem could not be solved ! \n\t*** Explore limit of " + this.d_MAXSTATES_EXPLORED + " or search limit of " + this.d_MAXSTATES_SEARCHED + " exceeded. ***");
            if (Options.getCalcClosestStateOption()) {
                i = 0;
                while (i < closestState.getTraceSize()) {
                    this.d_sol.addActionToSequentialSolution(closestState.getTrace(i));
                    ++i;
                }
                this.d_sol.setStatus(false);
            }
            return this.terminateSearch(false);
        }
        if (this.d_queue.isEmpty() && !this.d_sol.isSolved()) {
            System.out.println("STATUS: The problem could not be solved ! \n\t*** The problem is unsolvable -  the search queue is empty. ***");
            if (Options.getCalcClosestStateOption()) {
                i = 0;
                while (i < closestState.getTraceSize()) {
                    this.d_sol.addActionToSequentialSolution(closestState.getTrace(i));
                    ++i;
                }
                this.d_sol.setStatus(false);
            }
            return this.terminateSearch(false);
        }
        System.out.println("STATUS: The problem has been solved with cache hits = " + counter_cache_hits + " and all states search = " + counter_all_states + " !");
        this.d_sol.setCacheHits(counter_cache_hits);
        this.d_sol.setLoopChecks(counter_all_states);
        return this.terminateSearch(true);
    }

    public boolean terminateSearch(boolean result) {
        this.d_sol.setStateExplored(this.d_stateExplored);
        this.d_sol.setStateSearched(this.d_stateSearched);
        Date stop = new Date();
        this.d_stopTime = stop.getTime();
        this.d_searchTime = this.d_stopTime - this.d_startTime;
        this.d_sol.setSearchTime(this.d_searchTime);
        return result;
    }

    public IPlanSolution getSolution() {
        return this.d_sol;
    }

    public String sortString(String a) {
        char[] ch = new char[1000];
        char[] states = new char[1000];
        ch = a.toCharArray();
        int len = a.length();
        int i = 1;
        int sum = 0;
        int states_counter = 0;
        while (i < len - 1) {
            if (ch[i] == ' ') {
                ++i;
                continue;
            }
            if (ch[i] == ',') {
                states[states_counter++] = (char)sum;
                sum = 0;
                ++i;
                continue;
            }
            int temp = (int)Math.pow(10.0, a.indexOf(44, i) - i - 1);
            sum += ch[i++] * temp;
        }
        states[states_counter] = '\u0000';
        return this.bubble(states).toString();
    }

    public char[] bubble(char[] a) {
        int i = a.length - 1;
        while (i > 0) {
            int j = 0;
            while (j < i) {
                if (a[j] > a[j + 1]) {
                    char temp = a[j];
                    a[j] = a[j + 1];
                    a[j + 1] = temp;
                }
                ++j;
            }
            --i;
        }
        return a;
    }
}

