/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.planner4J.search.stateSpaceSearchImpl;

import com.ibm.able.planner4J.planners.Options;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ActionImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ActionManager;
import com.ibm.able.planner4J.search.IPlanningGraph;
import com.ibm.able.planner4J.search.stateSpaceSearchImpl.BiLevelPlanningGraphImpl;
import com.ibm.able.planner4J.state.IState;
import com.ibm.able.planner4J.state.StripsStateImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class PlanningGraphHeuristicsCalculator
implements Serializable {
    static final long serialVersionUID = 2004100100000000001L;
    static HashMap d_cache = new HashMap();

    public static int getMaxPGHeuristic(BiLevelPlanningGraphImpl p_pg, IState p_state) {
        StripsStateImpl tmpNode = (StripsStateImpl)p_state;
        int hval = 0;
        int val = 0;
        Iterator iter = tmpNode.getFactsInternal().iterator();
        while (iter.hasNext()) {
            val = p_pg.getFirstAppearLevel(iter.next());
            if (hval >= val) continue;
            hval = val;
        }
        if (Options.getDebugOption()) {
            System.out.println("PGMax - state: " + tmpNode + "\n   h = " + hval + "and SerialPG Value is " + p_pg.getActionsAtLevel(hval - 1).size());
        }
        if (p_pg.isPGSerialType()) {
            return p_pg.getActionsAtLevel(hval - 1).size();
        }
        return hval;
    }

    public static int getSumPGHeuristic(BiLevelPlanningGraphImpl p_pg, IState p_state) {
        StripsStateImpl tmpNode = (StripsStateImpl)p_state;
        int hval = 0;
        Iterator iter = tmpNode.getFactsInternal().iterator();
        while (iter.hasNext()) {
            Integer id = (Integer)iter.next();
            int val = p_pg.isPGSerialType() ? p_pg.getActionsAtLevel(p_pg.getFirstAppearLevel(id) - 1).size() : p_pg.getFirstAppearLevel(id);
            hval += val;
        }
        if (Options.getDebugOption()) {
            System.out.println("PGSum - state: " + tmpNode + "\n   h = " + hval);
        }
        return hval;
    }

    public static int getLevelPGHeuristic(BiLevelPlanningGraphImpl p_pg, IState p_state) {
        StripsStateImpl tmpNode = (StripsStateImpl)p_state;
        BiLevelPlanningGraphImpl pg = p_pg;
        int hval = 0;
        Object[] facts = tmpNode.getFactsInternal().toArray();
        int nextFactLevelIncrement = pg.isPGNumberingBFType() ? 1 : 2;
        int i = 0;
        while (i < facts.length - 1) {
            Integer ii = (Integer)facts[i];
            int val1 = pg.getFirstAppearLevel(ii);
            if (hval < val1) {
                hval = val1;
            }
            int j = i + 1;
            while (j < facts.length) {
                Integer jj = (Integer)facts[j];
                int val2 = pg.getFirstAppearLevel(jj);
                if (hval < val2) {
                    hval = val2;
                }
                if (pg.areFactsRecordedMutex(ii, jj, hval)) {
                    int k = hval + 1;
                    while (k <= pg.getMaxLevel()) {
                        if (!pg.areFactsRecordedMutex(ii, jj, k)) {
                            hval = k;
                            break;
                        }
                        k += nextFactLevelIncrement;
                    }
                    if (k > pg.getMaxLevel()) {
                        if (p_pg.isPGToGrowTillLevelOff()) {
                            return Options.getInfiniteValue();
                        }
                        return tmpNode.getTraceSize() + k;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (Options.getDebugOption()) {
            System.out.println("PGLevel - state: " + tmpNode + "\n   h = " + hval);
        }
        if (p_pg.isPGSerialType()) {
            return p_pg.getActionsAtLevel(hval - 1).size();
        }
        return hval;
    }

    public static int getComboPGHeuristic(BiLevelPlanningGraphImpl p_pg, IState p_state) {
        int val1 = 0;
        int val2 = 0;
        StripsStateImpl tmpNode = (StripsStateImpl)p_state;
        val1 = PlanningGraphHeuristicsCalculator.getSumPGHeuristic(p_pg, p_state);
        if (val1 < Options.getInfiniteValue()) {
            val2 = PlanningGraphHeuristicsCalculator.getLevelPGHeuristic(p_pg, p_state);
        }
        int hval = val1 + val2;
        if (Options.getDebugOption()) {
            System.out.println("PGCombo - state: " + tmpNode + "\n   h_sum = " + val1 + "  h_lev = " + val2);
        }
        return hval;
    }

    public static int getAdjSumPGHeuristic(BiLevelPlanningGraphImpl p_pg, IState p_state) {
        int val1 = 0;
        int val2 = 0;
        StripsStateImpl tmpNode = (StripsStateImpl)p_state;
        val1 = PlanningGraphHeuristicsCalculator.getSumPGHeuristic(p_pg, p_state);
        if (val1 < Options.getInfiniteValue()) {
            val2 = PlanningGraphHeuristicsCalculator.ugetInteractionDegree(p_pg, p_state);
        }
        int hval = val1 + val2;
        if (Options.getDebugOption()) {
            System.out.println("PGAdjSum - state: " + tmpNode + "\n   h_sum = " + val1 + "  h_interDegree = " + val2);
        }
        return hval;
    }

    public static int getAdjSum2PGHeuristic(BiLevelPlanningGraphImpl p_pg, IState p_state, IState p_reachState) {
        int val1 = 0;
        int val2 = 0;
        StripsStateImpl tmpNode = (StripsStateImpl)p_state;
        val1 = Options.getForwardDirectionOption() ? PlanningGraphHeuristicsCalculator.ugetforwardCost(p_pg, p_state, p_reachState) : PlanningGraphHeuristicsCalculator.ugetRegressedCost(p_pg, p_state, p_reachState);
        if (val1 < Options.getInfiniteValue()) {
            val2 = PlanningGraphHeuristicsCalculator.ugetInteractionDegree(p_pg, p_state);
        }
        int hval = val1 + val2;
        if (Options.getDebugOption()) {
            System.out.println("PGAdjSum2 - state: " + tmpNode + "\n   h_regCost = " + val1 + "  h_interDegree = " + val2);
        }
        return hval;
    }

    public static int ugetInteractionDegree(BiLevelPlanningGraphImpl p_pg, IState p_state) {
        StripsStateImpl tmpNode = (StripsStateImpl)p_state;
        int val = PlanningGraphHeuristicsCalculator.getLevelPGHeuristic(p_pg, p_state);
        int val1 = 0;
        int val2 = 0;
        Object[] facts = tmpNode.getFactsInternal().toArray();
        int i = 0;
        while (i < facts.length) {
            Integer ii = (Integer)facts[i];
            val2 = p_pg.getFirstAppearLevel(ii);
            if (val1 < val2) {
                val1 = val2;
            }
            ++i;
        }
        if (p_pg.isPGSerialType()) {
            val1 = p_pg.getActionsAtLevel(val1 - 1).size();
        }
        return val -= val1;
    }

    public static Object ugetHighestNonInitialLevelFact(IPlanningGraph p_pg, IState p_state) {
        StripsStateImpl tmpNode = (StripsStateImpl)p_state;
        int level = 0;
        int level2 = 0;
        Object[] facts = tmpNode.getFactsInternal().toArray();
        Integer maxLevelFact = null;
        int i = 0;
        while (i < facts.length) {
            Integer ii = (Integer)facts[i];
            level2 = p_pg.getFirstAppearLevel(ii);
            if (level < level2) {
                level = level2;
                maxLevelFact = ii;
            }
            ++i;
        }
        if (level == 0) {
            maxLevelFact = null;
        }
        return maxLevelFact;
    }

    public static int ugetRegressedCost(IPlanningGraph p_pg, IState p_state, IState p_reachState) {
        int cost = 0;
        StripsStateImpl tmpNode = (StripsStateImpl)p_state;
        StripsStateImpl reachNode = (StripsStateImpl)p_reachState;
        StripsStateImpl regressedState = new StripsStateImpl(tmpNode);
        StripsStateImpl regressedState2 = null;
        d_cache.clear();
        Integer maxLevelFact = null;
        int actionId = -1;
        int pgMaxLevel = p_pg.getMaxLevel();
        ActionImpl a = null;
        Object[] actions = null;
        if (Options.getDebugOption()) {
            System.out.println("\ncurrent state = " + regressedState.toString());
            System.out.println("\nreach state = " + reachNode.toString());
        }
        while (regressedState != null && !reachNode.isSubset(regressedState)) {
            maxLevelFact = (Integer)PlanningGraphHeuristicsCalculator.ugetHighestNonInitialLevelFact(p_pg, regressedState);
            if (maxLevelFact == null) break;
            if (d_cache.containsKey(maxLevelFact)) {
                regressedState2 = new StripsStateImpl(regressedState);
                while (d_cache.containsKey(maxLevelFact)) {
                    regressedState2.delFact(maxLevelFact);
                    maxLevelFact = (Integer)PlanningGraphHeuristicsCalculator.ugetHighestNonInitialLevelFact(p_pg, regressedState2);
                    if (maxLevelFact != null) continue;
                    return cost;
                }
            }
            d_cache.put(maxLevelFact, null);
            p_pg.getFirstAppearLevel(maxLevelFact);
            Collection c = p_pg.getActionsAtLevel(pgMaxLevel - 1);
            if (c == null) {
                return Options.getInfiniteValue();
            }
            actions = c.toArray();
            int i = 0;
            while (i < actions.length) {
                Integer tmpFact;
                actionId = (Integer)actions[i];
                a = ActionManager.getActionManager().getAction(actionId);
                if (a == null) {
                    return Options.getInfiniteValue();
                }
                int j = 0;
                while (j < a.getNumAdd()) {
                    tmpFact = (Integer)a.getAdd(j);
                    if (tmpFact.intValue() == maxLevelFact.intValue()) break;
                    ++j;
                }
                if (j < a.getNumAdd()) {
                    if (Options.getDebugOption()) {
                        System.out.println(" -> regressing using action: " + a.getFullName());
                    }
                    j = 0;
                    while (j < a.getNumAdd()) {
                        tmpFact = (Integer)a.getAdd(j);
                        regressedState.delFact(tmpFact);
                        ++j;
                    }
                    j = 0;
                    while (j < a.getNumPrecond()) {
                        tmpFact = (Integer)a.getPrecond(j);
                        regressedState.addFact(tmpFact);
                        ++j;
                    }
                    if (Options.getDebugOption()) {
                        System.out.println("regressed state = " + regressedState.toString());
                    }
                    ++cost;
                    break;
                }
                ++i;
            }
            if (i < actions.length) continue;
            return Options.getInfiniteValue();
        }
        return cost;
    }

    public static int ugetforwardCost(IPlanningGraph p_pg, IState p_state, IState p_reachState) {
        int cost = 0;
        StripsStateImpl tmpNode = (StripsStateImpl)p_state;
        StripsStateImpl reachNode = (StripsStateImpl)p_reachState;
        StripsStateImpl regressedState = new StripsStateImpl(tmpNode);
        StripsStateImpl regressedState2 = null;
        d_cache.clear();
        Integer maxLevelFact = null;
        int actionId = -1;
        int pgMaxLevel = p_pg.getMaxLevel();
        ActionImpl a = null;
        Object[] actions = null;
        if (Options.getDebugOption()) {
            System.out.println("\ncurrent state = " + regressedState.toString());
            System.out.println("\nreach state = " + reachNode.toString());
        }
        while (regressedState != null && !reachNode.isSubset(regressedState)) {
            maxLevelFact = (Integer)PlanningGraphHeuristicsCalculator.ugetHighestNonInitialLevelFact(p_pg, regressedState);
            if (maxLevelFact == null) break;
            if (d_cache.containsKey(maxLevelFact)) {
                regressedState2 = new StripsStateImpl(regressedState);
                while (d_cache.containsKey(maxLevelFact)) {
                    regressedState2.delFact(maxLevelFact);
                    maxLevelFact = (Integer)PlanningGraphHeuristicsCalculator.ugetHighestNonInitialLevelFact(p_pg, regressedState2);
                    if (maxLevelFact != null) continue;
                    return cost;
                }
            }
            d_cache.put(maxLevelFact, null);
            p_pg.getFirstAppearLevel(maxLevelFact);
            Collection c = p_pg.getActionsAtLevel(pgMaxLevel - 1);
            if (c == null) {
                return Options.getInfiniteValue();
            }
            actions = c.toArray();
            int i = 0;
            while (i < actions.length) {
                Integer tmpFact;
                actionId = (Integer)actions[i];
                a = ActionManager.getActionManager().getAction(actionId);
                if (a == null) {
                    return Options.getInfiniteValue();
                }
                int j = 0;
                while (j < a.getNumPrecond()) {
                    tmpFact = (Integer)a.getPrecond(j);
                    if (tmpFact.intValue() == maxLevelFact.intValue()) break;
                    ++j;
                }
                if (j < a.getNumPrecond()) {
                    if (Options.getDebugOption()) {
                        System.out.println(" -> regressing using action: " + a.getFullName());
                    }
                    j = 0;
                    while (j < a.getNumPrecond()) {
                        tmpFact = (Integer)a.getPrecond(j);
                        regressedState.delFact(tmpFact);
                        ++j;
                    }
                    j = 0;
                    while (j < a.getNumAdd()) {
                        tmpFact = (Integer)a.getAdd(j);
                        regressedState.addFact(tmpFact);
                        ++j;
                    }
                    if (Options.getDebugOption()) {
                        System.out.println("regressed state = " + regressedState.toString());
                    }
                    ++cost;
                    break;
                }
                ++i;
            }
            if (i < actions.length) continue;
            return Options.getInfiniteValue();
        }
        return cost;
    }
}

