/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.planner4J.search.stateSpaceSearchImpl;

import com.ibm.able.planner4J.planners.Options;
import java.io.Serializable;
import java.util.HashMap;

public class MutexManager
implements Serializable {
    static final long serialVersionUID = 2004100100000000001L;
    HashMap d_mutexStore;
    final String d_actionPrefix = "A:";
    final String d_factPrefix = "F:";
    int d_numFactMutexes;
    int d_numActionMutexes;

    public MutexManager() {
        this.d_mutexStore = new HashMap(Options.getInfiniteValue());
        this.d_numActionMutexes = 0;
        this.d_numFactMutexes = 0;
    }

    public MutexManager(int p_initialSize) {
        this.d_mutexStore = new HashMap(p_initialSize);
        this.d_numActionMutexes = 0;
        this.d_numFactMutexes = 0;
    }

    public String buildMutexKey(int p_dataType, int p_data1, int p_data2) {
        String key = p_dataType == 0 ? "F:" : "A:";
        int data1 = p_data1;
        int data2 = p_data2;
        if (p_data1 > p_data2) {
            data1 = p_data2;
            data2 = p_data1;
        }
        key = String.valueOf(key) + data1 + Options.getStringDelimiter() + data2;
        return key;
    }

    public void recordMutex(int p_dataType, int p_data1, int p_data2, int p_level) {
        int val = -1;
        String key = this.buildMutexKey(p_dataType, p_data1, p_data2);
        boolean alreadyExists = this.d_mutexStore.containsKey(key);
        if (!alreadyExists) {
            this.d_mutexStore.put(key, new Integer(p_level));
            if (p_dataType == 0) {
                ++this.d_numFactMutexes;
            } else {
                ++this.d_numActionMutexes;
            }
        } else {
            val = (Integer)this.d_mutexStore.get(key);
            if (val < p_level) {
                this.d_mutexStore.put(key, new Integer(p_level));
            }
        }
    }

    public boolean areMutex(int p_dataType, int p_data1, int p_data2, int p_level) {
        int val = -1;
        if (p_dataType == 0 && p_level == 0) {
            return false;
        }
        String key = this.buildMutexKey(p_dataType, p_data1, p_data2);
        boolean alreadyExists = this.d_mutexStore.containsKey(key);
        return alreadyExists && (val = ((Integer)this.d_mutexStore.get(key)).intValue()) >= p_level;
    }

    public int lastMutexLevel(int p_dataType, int p_data1, int p_data2) {
        int val = Options.getUndefinedValue();
        String key = this.buildMutexKey(p_dataType, p_data1, p_data2);
        boolean alreadyExists = this.d_mutexStore.containsKey(key);
        if (alreadyExists) {
            val = (Integer)this.d_mutexStore.get(key);
        }
        return val;
    }

    public int getNumFactMutexes() {
        return this.d_numFactMutexes;
    }

    public int getNumActionMutexes() {
        return this.d_numActionMutexes;
    }
}

