/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.planner4J.search.stateSpaceSearchImpl;

import com.ibm.able.planner4J.planners.Options;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ActionImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ActionManager;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.PredicateImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.PredicateManager;
import com.ibm.able.planner4J.search.IPlanningGraph;
import com.ibm.able.planner4J.search.stateSpaceSearchImpl.LevelDataItem;
import com.ibm.able.planner4J.search.stateSpaceSearchImpl.MutexManager;
import com.ibm.able.planner4J.state.IState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class BiLevelPlanningGraphImpl
implements IPlanningGraph,
Serializable {
    static final long serialVersionUID = 2004100100000000001L;
    public final int MAXSUBGOALS = 1000;
    Integer[] d_subgoals = null;
    ActionManager d_am = ActionManager.getActionManager();
    PredicateManager d_pm = PredicateManager.getPredicateManager();
    MutexManager d_mutexManager = new MutexManager();
    HashMap d_facts = new HashMap(100);
    HashMap d_actions = new HashMap(100);
    public static final String UNKNOWN_MARKER = "unknown";
    public static final String WILLKNOW_MARKER = "willknow";
    int d_maxLevel = 0;
    int[] d_inits;
    int[] d_goals;
    Object[] d_initObjs;
    Object[] d_goalObjs;
    ArrayList d_domainActions = null;
    boolean d_pgBFNumberingType = true;
    boolean d_pgSerialType = true;
    boolean d_pgGrowTillLevelOff = true;
    boolean d_pgConditionalPlanning = false;
    HashMap d_cache = new HashMap(100);

    public BiLevelPlanningGraphImpl() {
        this.d_subgoals = new Integer[1000];
    }

    public void setPGConditionalPlanning(boolean flag) {
        this.d_pgConditionalPlanning = flag;
    }

    public boolean isPGConditionalPlanning() {
        return this.d_pgConditionalPlanning;
    }

    public void setPGNumberingType(boolean flag) {
        this.d_pgBFNumberingType = flag;
    }

    public boolean isPGNumberingBFType() {
        return this.d_pgBFNumberingType;
    }

    public void setPGSerial(boolean flag) {
        this.d_pgSerialType = flag;
    }

    public boolean isPGSerialType() {
        return this.d_pgSerialType;
    }

    public void setPGGrowTillLevelOff(boolean flag) {
        this.d_pgGrowTillLevelOff = flag;
    }

    public boolean isPGToGrowTillLevelOff() {
        return this.d_pgGrowTillLevelOff;
    }

    public boolean buildPG(IState p_initState, IState p_goalState, ArrayList p_actions) {
        boolean PGLevelOff = false;
        int factLevelIncrement = this.d_pgBFNumberingType ? 1 : 2;
        if (p_initState == null || p_goalState == null || p_actions == null) {
            return true;
        }
        if (p_goalState.getStateSize() == 0 || p_actions.size() == 0) {
            return true;
        }
        this.d_domainActions = p_actions;
        Collection initialFacts = p_initState.getFactsInternal();
        this.d_initObjs = initialFacts.toArray();
        this.d_inits = new int[this.d_initObjs.length];
        int i = 0;
        while (i < this.d_initObjs.length) {
            this.d_inits[i] = (Integer)this.d_initObjs[i];
            ++i;
        }
        Collection goalFacts = p_goalState.getFactsInternal();
        this.d_goalObjs = goalFacts.toArray();
        this.d_goals = new int[this.d_goalObjs.length];
        i = 0;
        while (i < this.d_goalObjs.length) {
            this.d_goals[i] = (Integer)this.d_goalObjs[i];
            ++i;
        }
        i = 0;
        while (i < initialFacts.size()) {
            this.recordFactAtLevel(this.d_initObjs[i], 0);
            ++i;
        }
        i = 0;
        this.d_maxLevel = 0;
        int preGrowthMutexCount = 0;
        while (true) {
            this.growPGOneLevel(i);
            int postGrowthMutexCount = this.getNumActionMutexesAtLevel(i) + this.getNumFactMutexesAtLevel(i + factLevelIncrement);
            boolean bl = PGLevelOff = this.hasPGLeveledOff(i) && postGrowthMutexCount - preGrowthMutexCount == 0;
            if (this.d_pgGrowTillLevelOff && PGLevelOff || !this.d_pgGrowTillLevelOff && this.areAllGoalFactsPresent(i) && !this.isGoalMutexInconsistent(i)) {
                if (this.d_pgGrowTillLevelOff) {
                    if (!this.areAllGoalFactsPresent(i)) {
                        return false;
                    }
                    if (this.isGoalMutexInconsistent(i)) {
                        return false;
                    }
                }
                if (!this.d_pgGrowTillLevelOff || this.d_pgGrowTillLevelOff && this.checkForRelaxedPlan(null, this.d_maxLevel)) break;
                System.out.println("Relaxed plan does not exist at level = " + this.d_maxLevel);
            }
            this.d_maxLevel = i += factLevelIncrement;
            preGrowthMutexCount = postGrowthMutexCount;
        }
        if (Options.getDebugOption()) {
            System.out.println("STATUS: PG built. It is :" + this.toString());
        } else {
            System.out.println("STATUS: PG built for heuristics estimation.");
        }
        return true;
    }

    public boolean buildRegressPG(IState p_initState, IState p_goalState, ArrayList p_actions) {
        boolean PGLevelOff = false;
        int factLevelIncrement = this.d_pgBFNumberingType ? 1 : 2;
        if (p_initState == null || p_goalState == null || p_actions == null) {
            return true;
        }
        if (p_initState.getStateSize() == 0 || p_actions.size() == 0) {
            return true;
        }
        this.d_domainActions = p_actions;
        Collection initialFacts = p_goalState.getFactsInternal();
        this.d_initObjs = initialFacts.toArray();
        this.d_inits = new int[this.d_initObjs.length];
        int i = 0;
        while (i < this.d_initObjs.length) {
            this.d_inits[i] = (Integer)this.d_initObjs[i];
            ++i;
        }
        Collection goalFacts = p_initState.getFactsInternal();
        this.d_goalObjs = goalFacts.toArray();
        this.d_goals = new int[this.d_goalObjs.length];
        i = 0;
        while (i < this.d_goalObjs.length) {
            this.d_goals[i] = (Integer)this.d_goalObjs[i];
            ++i;
        }
        i = 0;
        while (i < initialFacts.size()) {
            this.recordFactAtLevel(this.d_initObjs[i], 0);
            ++i;
        }
        i = 0;
        this.d_maxLevel = 0;
        int preGrowthMutexCount = 0;
        while (true) {
            this.growRegressPGOneLevel(i);
            int postGrowthMutexCount = this.getNumActionMutexesAtLevel(i) + this.getNumFactMutexesAtLevel(i + factLevelIncrement);
            boolean bl = PGLevelOff = this.hasPGLeveledOff(i) && postGrowthMutexCount - preGrowthMutexCount == 0;
            if (this.d_pgGrowTillLevelOff && PGLevelOff || !this.d_pgGrowTillLevelOff && this.areAllInitialFactsPresent(i) && !this.isInitialMutexInconsistent(i)) {
                if (this.d_pgGrowTillLevelOff && this.isGoalMutexInconsistent(i)) {
                    return false;
                }
                if (!this.d_pgGrowTillLevelOff || this.d_pgGrowTillLevelOff && this.checkForOldRegressedRelaxedPlan(null, i)) break;
                System.out.println("Relaxed plan does not exist at level = " + this.d_maxLevel);
                return false;
            }
            this.d_maxLevel = i += factLevelIncrement;
            preGrowthMutexCount = postGrowthMutexCount;
        }
        if (Options.getDebugOption()) {
            System.out.println("STATUS: PG built. It is :" + this.toString());
        } else {
            System.out.println("STATUS: PG built for heuristics estimation.");
        }
        return true;
    }

    public boolean hasPGLeveledOff(int p_level) {
        Collection c = null;
        int nextFactLevel = this.d_pgBFNumberingType ? p_level + 1 : p_level + 2;
        c = this.getFactsAtLevel(nextFactLevel);
        Object[] factsAtNextLevel = c.toArray();
        int i = 0;
        while (i < factsAtNextLevel.length) {
            Integer ii = (Integer)factsAtNextLevel[i];
            if (!this.isFactAtLevel(ii, p_level)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean checkForRelaxedPlan(Integer[] p_goalFacts, int p_level) {
        Integer tmpFact;
        int i;
        int currentActionLevel;
        int numSubGoals = 0;
        int currentIndex = 0;
        int nextAddIndex = 0;
        if (p_goalFacts == null) {
            currentActionLevel = this.d_maxLevel - 1;
            i = 0;
            while (i < this.d_goalObjs.length) {
                this.d_subgoals[i] = (Integer)this.d_goalObjs[i];
                ++numSubGoals;
                ++nextAddIndex;
                ++i;
            }
        } else {
            currentActionLevel = p_level - 1;
            i = 0;
            while (i < p_goalFacts.length) {
                this.d_subgoals[i] = p_goalFacts[i];
                ++numSubGoals;
                ++nextAddIndex;
                ++i;
            }
        }
        int topActionLevel = currentActionLevel;
        this.d_cache.clear();
        i = 0;
        while (i < this.d_initObjs.length) {
            tmpFact = (Integer)this.d_initObjs[i];
            this.d_cache.put(tmpFact, null);
            ++i;
        }
        block3: while (currentIndex < nextAddIndex && currentActionLevel >= 0) {
            int j;
            ActionImpl a;
            Integer actionId;
            Integer currentGoal = this.d_subgoals[currentIndex];
            if (this.d_cache.containsKey(currentGoal)) {
                ++currentIndex;
                continue;
            }
            Collection c = this.getActionsAtLevel(topActionLevel);
            if (c == null) {
                return false;
            }
            Object[] actions = c.toArray();
            int minActionCost = Options.getInfiniteValue();
            Integer minActionId = null;
            ActionImpl minA = null;
            i = 0;
            while (i < actions.length) {
                actionId = (Integer)actions[i];
                a = ActionManager.getActionManager().getAction(actionId);
                if (a == null) {
                    return false;
                }
                j = 0;
                while (j < a.getNumAdd()) {
                    tmpFact = (Integer)a.getAdd(j);
                    if (tmpFact.intValue() == currentGoal.intValue()) break;
                    ++j;
                }
                if (j < a.getNumAdd()) {
                    int count = 0;
                    j = 0;
                    while (j < a.getNumPrecond()) {
                        tmpFact = (Integer)a.getPrecond(j);
                        if (!this.d_cache.containsKey(tmpFact)) {
                            ++count;
                        }
                        ++j;
                    }
                    if (minActionCost > count) {
                        minA = a;
                        minActionId = actionId;
                        minActionCost = count;
                    }
                }
                ++i;
            }
            if (minA == null) {
                return false;
            }
            a = minA;
            actionId = minActionId;
            this.d_cache.put(currentGoal, actionId);
            j = 0;
            while (j < a.getNumAdd()) {
                tmpFact = (Integer)a.getAdd(j);
                if (!this.d_cache.containsKey(tmpFact)) {
                    this.d_cache.put(tmpFact, actionId);
                }
                ++j;
            }
            j = 0;
            while (j < a.getNumPrecond()) {
                tmpFact = (Integer)a.getPrecond(j);
                if (!this.d_cache.containsKey(tmpFact)) {
                    this.d_subgoals[nextAddIndex] = tmpFact;
                    ++nextAddIndex;
                    ++numSubGoals;
                }
                ++j;
            }
            ++currentIndex;
            while (currentIndex < nextAddIndex) {
                currentGoal = this.d_subgoals[currentIndex];
                if (!this.d_cache.containsKey(currentGoal)) continue block3;
                ++currentIndex;
            }
        }
        return currentIndex >= nextAddIndex;
    }

    public boolean checkForOldRegressedRelaxedPlan(Integer[] p_goalFacts, int p_level) {
        Integer tmpFact;
        int i;
        int currentActionLevel;
        int numSubGoals = 0;
        Vector<Integer> action_applied = new Vector<Integer>();
        int currentIndex = 0;
        int nextAddIndex = 0;
        if (p_goalFacts == null) {
            currentActionLevel = this.d_maxLevel - 1;
            i = 0;
            while (i < this.d_initObjs.length) {
                this.d_subgoals[i] = (Integer)this.d_initObjs[i];
                ++numSubGoals;
                ++nextAddIndex;
                ++i;
            }
        } else {
            currentActionLevel = p_level - 1;
            i = 0;
            while (i < p_goalFacts.length) {
                this.d_subgoals[i] = p_goalFacts[i];
                ++numSubGoals;
                ++nextAddIndex;
                ++i;
            }
        }
        int topActionLevel = currentActionLevel;
        this.d_cache.clear();
        i = 0;
        while (i < this.d_goalObjs.length) {
            tmpFact = (Integer)this.d_goalObjs[i];
            this.d_cache.put(tmpFact, null);
            ++i;
        }
        ActionImpl minA = null;
        block3: while (currentIndex < nextAddIndex && currentActionLevel >= 0) {
            int j;
            ActionImpl a;
            Integer actionId;
            Integer currentGoal = this.d_subgoals[currentIndex];
            if (this.d_cache.containsKey(currentGoal)) {
                ++currentIndex;
                continue;
            }
            Collection c = this.getActionsAtLevel(topActionLevel);
            if (c == null) {
                return false;
            }
            Object[] actions = c.toArray();
            int minActionCost = 0;
            Integer minActionId = null;
            minA = null;
            i = 0;
            while (i < actions.length) {
                actionId = (Integer)actions[i];
                a = ActionManager.getActionManager().getAction(actionId);
                if (a == null) {
                    return false;
                }
                if (!action_applied.contains(actionId)) {
                    j = 0;
                    while (j < a.getNumPrecond()) {
                        tmpFact = (Integer)a.getPrecond(j);
                        if (!this.d_cache.containsKey(tmpFact)) break;
                        ++j;
                    }
                    if (j >= a.getNumPrecond()) {
                        int count = 0;
                        j = 0;
                        while (j < a.getNumAdd()) {
                            tmpFact = (Integer)a.getAdd(j);
                            int cnt = currentIndex;
                            while (cnt < nextAddIndex) {
                                if (this.d_subgoals[cnt].intValue() == tmpFact.intValue()) {
                                    ++count;
                                    break;
                                }
                                ++cnt;
                            }
                            ++j;
                        }
                        if (minActionCost < count || minA == null && minActionCost == count) {
                            minA = a;
                            minActionId = actionId;
                            minActionCost = count;
                        }
                    }
                }
                ++i;
            }
            if (minA == null) {
                return false;
            }
            a = minA;
            actionId = minActionId;
            action_applied.addElement(actionId);
            j = 0;
            while (j < a.getNumAdd()) {
                tmpFact = (Integer)a.getAdd(j);
                PredicateImpl temppred = this.d_pm.getFact(tmpFact);
                String tempstr = temppred.getName();
                if (tempstr.indexOf(WILLKNOW_MARKER) != -1) {
                    Integer tempInteger = new Integer(this.d_pm.getIdFromFactName(tempstr = tempstr.substring(WILLKNOW_MARKER.length() + 1, tempstr.length())));
                    if (!this.d_cache.containsKey(tempInteger)) {
                        this.d_cache.put(tempInteger, actionId);
                    }
                    if (!this.d_cache.containsKey(tempInteger = new Integer(this.d_pm.getIdFromFactName(tempstr = "not-" + tempstr)))) {
                        this.d_cache.put(tempInteger, actionId);
                    }
                }
                if (!this.d_cache.containsKey(tmpFact)) {
                    this.d_cache.put(tmpFact, actionId);
                }
                ++j;
            }
            while (currentIndex < nextAddIndex) {
                currentGoal = this.d_subgoals[currentIndex];
                if (!this.d_cache.containsKey(currentGoal)) continue block3;
                ++currentIndex;
            }
        }
        if (currentIndex >= nextAddIndex) {
            return true;
        }
        System.out.println("exiting from last condition" + currentIndex + nextAddIndex + currentActionLevel);
        return false;
    }

    public void growRegressPGOneLevel(int p_startLevel) {
        int nextFactLevel;
        int nextActionLevel;
        if (this.d_pgBFNumberingType) {
            nextActionLevel = p_startLevel;
            nextFactLevel = p_startLevel + 1;
        } else {
            nextActionLevel = p_startLevel + 1;
            nextFactLevel = p_startLevel + 2;
        }
        int i = 0;
        while (i < this.d_domainActions.size()) {
            Integer ii = (Integer)this.d_domainActions.get(i);
            int id = ii;
            ActionImpl a = this.d_am.getAction(id);
            if (!a.getType()) {
                boolean flag;
                Integer jj;
                int j;
                if (Options.getCompleteGoalFlag()) {
                    j = 0;
                    while (j < a.getNumAdd()) {
                        jj = (Integer)a.getAdd(j);
                        if (!this.isFactAtLevel(jj, p_startLevel)) break;
                        ++j;
                    }
                    flag = j >= a.getNumAdd();
                } else {
                    j = 0;
                    while (j < a.getNumAdd()) {
                        jj = (Integer)a.getAdd(j);
                        if (this.isFactAtLevel(jj, p_startLevel)) break;
                        ++j;
                    }
                    flag = j < a.getNumAdd();
                }
                if (flag) {
                    Integer kk;
                    this.recordActionAtLevel(ii, nextActionLevel);
                    int k = 0;
                    while (k < a.getNumPrecond()) {
                        kk = (Integer)a.getPrecond(k);
                        this.recordFactAtLevel(kk, nextFactLevel);
                        ++k;
                    }
                    if (!Options.getCompleteGoalFlag()) {
                        k = 0;
                        while (k < a.getNumAdd()) {
                            kk = (Integer)a.getAdd(k);
                            this.recordFactAtLevel(kk, nextFactLevel);
                            ++k;
                        }
                    }
                }
            }
            ++i;
        }
        this.recordAllActionMutexes(nextActionLevel);
        this.recordAllRegressedFactMutexes(nextFactLevel);
    }

    public void growPGOneLevel(int p_startLevel) {
        int nextFactLevel;
        int nextActionLevel;
        if (this.d_pgBFNumberingType) {
            nextActionLevel = p_startLevel;
            nextFactLevel = p_startLevel + 1;
        } else {
            nextActionLevel = p_startLevel + 1;
            nextFactLevel = p_startLevel + 2;
        }
        int i = 0;
        while (i < this.d_domainActions.size()) {
            Integer ii = (Integer)this.d_domainActions.get(i);
            int id = ii;
            ActionImpl a = this.d_am.getAction(id);
            if (!a.getType()) {
                int j = 0;
                while (j < a.getNumPrecond()) {
                    Integer jj = (Integer)a.getPrecond(j);
                    if (!this.isFactAtLevel(jj, p_startLevel)) break;
                    ++j;
                }
                if (j >= a.getNumPrecond()) {
                    this.recordActionAtLevel(ii, nextActionLevel);
                    int k = 0;
                    while (k < a.getNumAdd()) {
                        Integer kk = (Integer)a.getAdd(k);
                        this.recordFactAtLevel(kk, nextFactLevel);
                        ++k;
                    }
                }
            }
            ++i;
        }
        this.recordAllActionMutexes(nextActionLevel);
        this.recordAllFactMutexes(nextFactLevel);
    }

    public void recordAllRegressedFactMutexes(int p_level) {
        Integer[] pair = new Integer[2];
        Collection c = this.getFactsAtLevel(p_level);
        if (c == null) {
            return;
        }
        Object[] facts = c.toArray();
        int i = 0;
        while (i < facts.length) {
            int firstID = (Integer)facts[i];
            int j = 0;
            while (j < facts.length) {
                int secondID = (Integer)facts[j];
                if (i != j && firstID <= secondID) {
                    if (this.areFactsMutex(firstID, secondID, p_level)) {
                        this.d_mutexManager.recordMutex(0, firstID, secondID, p_level);
                    } else {
                        pair[0] = new Integer(firstID);
                        pair[1] = new Integer(secondID);
                        if (!this.checkForOldRegressedRelaxedPlan(pair, p_level)) {
                            this.d_mutexManager.recordMutex(0, firstID, secondID, p_level);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void recordAllFactMutexes(int p_level) {
        Integer[] pair = new Integer[2];
        Collection c = this.getFactsAtLevel(p_level);
        if (c == null) {
            return;
        }
        Object[] facts = c.toArray();
        int i = 0;
        while (i < facts.length) {
            int firstID = (Integer)facts[i];
            int j = 0;
            while (j < facts.length) {
                int secondID = (Integer)facts[j];
                if (i != j && firstID <= secondID) {
                    if (this.areFactsMutex(firstID, secondID, p_level)) {
                        this.d_mutexManager.recordMutex(0, firstID, secondID, p_level);
                    } else {
                        pair[0] = new Integer(firstID);
                        pair[1] = new Integer(secondID);
                        if (!this.checkForRelaxedPlan(pair, p_level)) {
                            this.d_mutexManager.recordMutex(0, firstID, secondID, p_level);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void recordAllActionMutexes(int p_level) {
        int corrospFactLevel = this.d_pgBFNumberingType ? p_level : p_level - 1;
        Collection c = this.getActionsAtLevel(p_level);
        if (c == null) {
            return;
        }
        Object[] actions = c.toArray();
        if (this.d_pgSerialType) {
            int i = 0;
            while (i < actions.length) {
                int firstID = (Integer)actions[i];
                int j = 0;
                while (j < actions.length) {
                    int secondID = (Integer)actions[j];
                    if (i != j && firstID <= secondID) {
                        this.d_mutexManager.recordMutex(1, firstID, secondID, p_level);
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < actions.length) {
                int firstID = (Integer)actions[i];
                int j = 0;
                while (j < actions.length) {
                    int secondID = (Integer)actions[j];
                    if (i != j && firstID <= secondID) {
                        if (this.areActionsStaticMutex(firstID, secondID, p_level)) {
                            this.d_mutexManager.recordMutex(1, firstID, secondID, p_level);
                        } else {
                            ActionImpl a1 = this.d_am.getAction(firstID);
                            ActionImpl a2 = this.d_am.getAction(secondID);
                            int m = 0;
                            while (m < a1.getNumPrecond()) {
                                int p1 = (Integer)a1.getPrecond(m);
                                int n = 0;
                                while (n < a2.getNumPrecond()) {
                                    int p2 = (Integer)a2.getPrecond(n);
                                    if (this.areFactsRecordedMutex(p1, p2, corrospFactLevel)) {
                                        this.d_mutexManager.recordMutex(1, firstID, secondID, p_level);
                                        break;
                                    }
                                    ++n;
                                }
                                if (n < a2.getNumPrecond()) break;
                                ++m;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public boolean isGoalMutexInconsistent(int p_level) {
        int i = 0;
        while (i < this.d_goals.length - 1) {
            int j = i + 1;
            while (j < this.d_goals.length) {
                if (this.areFactsRecordedMutex(this.d_goals[i], this.d_goals[j], p_level)) {
                    System.out.println("The mutex conditions are " + this.d_goals[i] + " " + this.d_goals[j]);
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean isInitialMutexInconsistent(int p_level) {
        int i = 0;
        while (i < this.d_inits.length - 1) {
            int j = i + 1;
            while (j < this.d_inits.length) {
                if (this.areFactsRecordedMutex(this.d_goals[i], this.d_goals[j], p_level)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean areAllGoalFactsPresent(int p_level) {
        int i = 0;
        while (i < this.d_goals.length) {
            if (!this.isFactAtLevel(this.d_goalObjs[i], p_level)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean areAllInitialFactsPresent(int p_level) {
        int i = 0;
        while (i < this.d_inits.length) {
            if (!this.isFactAtLevel(this.d_initObjs[i], p_level)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getMaxLevel() {
        return this.d_maxLevel;
    }

    public void setMaxLevel(int p_newMaxLevel) {
        this.d_maxLevel = p_newMaxLevel;
    }

    public Collection getFactsAtLevel(int p_level) {
        Set allfacts = this.d_facts.keySet();
        Vector<Integer> result = new Vector<Integer>();
        if (allfacts != null) {
            Iterator it = allfacts.iterator();
            if (it != null) {
                while (it.hasNext()) {
                    Integer aKey = (Integer)it.next();
                    int val = ((LevelDataItem)this.d_facts.get(aKey)).getAppearLevel();
                    if (val > p_level) continue;
                    result.add(aKey);
                }
            }
            return result;
        }
        return null;
    }

    public boolean isFactAtLevel(Object p_fact, int p_level) {
        if (!(this.d_pgBFNumberingType || p_level >= 0 && p_level % 2 != 1)) {
            return false;
        }
        LevelDataItem i = (LevelDataItem)this.d_facts.get(p_fact);
        return i != null && i.getAppearLevel() <= p_level;
    }

    public void recordFactAtLevel(Object p_fact, int p_level) {
        if (!(this.d_pgBFNumberingType || p_level >= 0 && p_level % 2 != 1)) {
            return;
        }
        LevelDataItem i = (LevelDataItem)this.d_facts.get(p_fact);
        if (i != null && i.getAppearLevel() <= p_level) {
            return;
        }
        i = new LevelDataItem((Integer)p_fact, 0, p_level);
        this.d_facts.put(p_fact, i);
    }

    public Collection getActionsAtLevel(int p_level) {
        Set allactions = this.d_actions.keySet();
        Vector<Integer> result = new Vector<Integer>();
        if (allactions != null) {
            Iterator it = allactions.iterator();
            if (it != null) {
                while (it.hasNext()) {
                    Integer aKey = (Integer)it.next();
                    int val = ((LevelDataItem)this.d_actions.get(aKey)).getAppearLevel();
                    if (val > p_level) continue;
                    result.add(aKey);
                }
            }
            return result;
        }
        return null;
    }

    public boolean isActionAtLevel(Object p_action, int p_level) {
        if (!(this.d_pgBFNumberingType || p_level >= 0 && p_level % 2 != 0)) {
            return false;
        }
        LevelDataItem i = (LevelDataItem)this.d_actions.get(p_action);
        return i != null && i.getAppearLevel() <= p_level;
    }

    public void recordActionAtLevel(Object p_fact, int p_level) {
        if (!(this.d_pgBFNumberingType || p_level >= 0 && p_level % 2 != 0)) {
            return;
        }
        LevelDataItem i = (LevelDataItem)this.d_actions.get(p_fact);
        if (i != null && i.getAppearLevel() <= p_level) {
            return;
        }
        i = new LevelDataItem((Integer)p_fact, 1, p_level);
        this.d_actions.put(p_fact, i);
    }

    public MutexManager getMutexManager() {
        return this.d_mutexManager;
    }

    public boolean areFactsRecordedMutex(int p_data1, int p_data2, int p_level) {
        return this.d_mutexManager.areMutex(0, p_data1, p_data2, p_level);
    }

    public boolean areFactsMutex(int p_data1, int p_data2, int p_level) {
        int supportersActionLevel = p_level - 1;
        boolean result = false;
        if (p_level < 0) {
            return false;
        }
        int prevFactLevel = this.d_pgBFNumberingType ? p_level - 1 : p_level - 2;
        Integer ii = new Integer(p_data1);
        Integer jj = new Integer(p_data2);
        int supporterPairFirstAppearLevel = Options.getInfiniteValue();
        if (this.isFactAtLevel(ii, prevFactLevel) && this.isFactAtLevel(jj, prevFactLevel) && !this.areFactsRecordedMutex(p_data1, p_data2, prevFactLevel)) {
            return false;
        }
        Collection c = this.getActionsAtLevel(supportersActionLevel);
        if (c == null) {
            return false;
        }
        Object[] actions = c.toArray();
        int i = 0;
        while (i < actions.length) {
            int id1 = (Integer)actions[i];
            ActionImpl a1 = this.d_am.getAction(id1);
            int m = 0;
            while (m < a1.getNumAdd()) {
                int p1 = (Integer)a1.getAdd(m);
                if (p1 == p_data1) break;
                ++m;
            }
            if (m < a1.getNumAdd()) {
                int j = 0;
                while (j < actions.length) {
                    int id2 = (Integer)actions[j];
                    if (i != j && id1 <= id2) {
                        ActionImpl a2 = this.d_am.getAction(id2);
                        int n = 0;
                        while (n < a2.getNumAdd()) {
                            int p2 = (Integer)a2.getAdd(n);
                            if (p2 == p_data2) break;
                            ++n;
                        }
                        if (n < a2.getNumAdd()) {
                            int lastMutexLevel;
                            if (!this.areActionsRecordedMutex(a1.getId(), a2.getId(), supportersActionLevel)) {
                                return false;
                            }
                            LevelDataItem data = (LevelDataItem)this.d_actions.get(actions[i]);
                            if (data != null) {
                                supporterPairFirstAppearLevel = data.getAppearLevel();
                            }
                            if ((data = (LevelDataItem)this.d_actions.get(actions[j])) != null && supporterPairFirstAppearLevel < data.getAppearLevel()) {
                                supporterPairFirstAppearLevel = data.getAppearLevel();
                            }
                            if ((lastMutexLevel = this.d_mutexManager.lastMutexLevel(1, a1.getId(), a2.getId())) == Options.getUndefinedValue() || lastMutexLevel <= supportersActionLevel && supporterPairFirstAppearLevel < supportersActionLevel) {
                                return false;
                            }
                            result = true;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public boolean areActionsRecordedMutex(int p_data1, int p_data2, int p_level) {
        return this.d_mutexManager.areMutex(1, p_data1, p_data2, p_level);
    }

    public boolean areActionsStaticMutex(int p_data1, int p_data2, int p_level) {
        int p2;
        int j;
        int p1;
        ActionImpl a1 = this.d_am.getAction(p_data1);
        ActionImpl a2 = this.d_am.getAction(p_data2);
        int i = 0;
        while (i < a1.getNumDelete()) {
            p1 = (Integer)a1.getDelete(i);
            j = 0;
            while (j < a2.getNumAdd()) {
                p2 = (Integer)a2.getAdd(j);
                if (p1 == p2) {
                    return true;
                }
                ++j;
            }
            j = 0;
            while (j < a2.getNumPrecond()) {
                p2 = (Integer)a2.getPrecond(j);
                if (p1 == p2) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < a2.getNumDelete()) {
            p1 = (Integer)a2.getDelete(i);
            j = 0;
            while (j < a1.getNumAdd()) {
                p2 = (Integer)a1.getAdd(j);
                if (p1 == p2) {
                    return true;
                }
                ++j;
            }
            j = 0;
            while (j < a1.getNumPrecond()) {
                p2 = (Integer)a1.getPrecond(j);
                if (p1 == p2) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean areActionsDynamicallyMutex(int p_data1, int p_data2, int p_level) {
        int corrospFactLevel = this.d_pgBFNumberingType ? p_level : p_level - 1;
        ActionImpl a1 = this.d_am.getAction(p_data1);
        ActionImpl a2 = this.d_am.getAction(p_data2);
        int i = 0;
        while (i < a1.getNumPrecond()) {
            int p1 = (Integer)a1.getPrecond(i);
            int j = 0;
            while (j < a2.getNumPrecond()) {
                int p2 = (Integer)a2.getPrecond(j);
                if (this.areFactsRecordedMutex(p1, p2, corrospFactLevel)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public int getFirstAppearLevel(Object p_fact) {
        LevelDataItem data = (LevelDataItem)this.d_facts.get(p_fact);
        if (data == null) {
            return Options.getInfiniteValue();
        }
        return data.getAppearLevel();
    }

    public int getNumActionMutexesAtLevel(int p_actionLevel) {
        int count = 0;
        if (p_actionLevel < 0) {
            return count;
        }
        Collection c = this.getActionsAtLevel(p_actionLevel);
        if (c == null) {
            return count;
        }
        Object[] actions = c.toArray();
        int i = 0;
        while (i < actions.length) {
            int id1 = (Integer)actions[i];
            int j = 0;
            while (j < actions.length) {
                int id2;
                if (i != j && this.areActionsRecordedMutex(id1, id2 = ((Integer)actions[j]).intValue(), p_actionLevel)) {
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        return count;
    }

    public int getNumFactMutexesAtLevel(int p_factLevel) {
        int count = 0;
        if (p_factLevel <= 0) {
            return count;
        }
        Collection c = this.getFactsAtLevel(p_factLevel);
        if (c == null) {
            return count;
        }
        Object[] facts = c.toArray();
        int i = 0;
        while (i < facts.length) {
            int id1 = (Integer)facts[i];
            int j = 0;
            while (j < facts.length) {
                int id2;
                if (i != j && this.areFactsRecordedMutex(id1, id2 = ((Integer)facts[j]).intValue(), p_factLevel)) {
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        return count;
    }

    public String printLevelActionsToString(int p_level, String s) {
        Collection c = this.getActionsAtLevel(p_level);
        s = String.valueOf(s) + "\n\n Action Level: " + p_level + "\n    ";
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                int item = (Integer)it.next();
                s = String.valueOf(s) + item + ":(" + this.d_am.getAction(item).getFullName() + ") ";
            }
        }
        Object[] actions = c.toArray();
        s = String.valueOf(s) + "\n     Mutexes are: ";
        int i = 0;
        while (i < actions.length) {
            int id1 = (Integer)actions[i];
            s = String.valueOf(s) + " [" + id1 + ": ";
            int j = 0;
            while (j < actions.length) {
                int id2;
                if (i != j && this.areActionsRecordedMutex(id1, id2 = ((Integer)actions[j]).intValue(), p_level)) {
                    s = String.valueOf(s) + " " + id2;
                }
                ++j;
            }
            s = String.valueOf(s) + "]";
            ++i;
        }
        return s;
    }

    public String printLevelFactsToString(int p_level, String s) {
        Collection c = this.getFactsAtLevel(p_level);
        s = String.valueOf(s) + "\n\n Fact Level: " + p_level + "\n    ";
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                int item = (Integer)it.next();
                s = String.valueOf(s) + item + ":(" + this.d_pm.getFact(item).getFullName() + ") ";
            }
        }
        Object[] facts = c.toArray();
        s = String.valueOf(s) + "\n     Mutexes are: ";
        int i = 0;
        while (i < facts.length) {
            int id1 = (Integer)facts[i];
            s = String.valueOf(s) + " [" + id1 + ": ";
            int j = 0;
            while (j < facts.length) {
                int id2;
                if (i != j && this.areFactsRecordedMutex(id1, id2 = ((Integer)facts[j]).intValue(), p_level)) {
                    s = String.valueOf(s) + " " + id2;
                }
                ++j;
            }
            s = String.valueOf(s) + "]";
            ++i;
        }
        return s;
    }

    public String toString() {
        String s = new String();
        int i = 0;
        while (i <= this.d_maxLevel) {
            if (this.d_pgBFNumberingType) {
                s = String.valueOf(s) + "\n\t--------------------------------------------";
                s = this.printLevelFactsToString(i, s);
                if (i < this.d_maxLevel) {
                    s = this.printLevelActionsToString(i, s);
                }
            } else if (i % 2 == 0) {
                s = String.valueOf(s) + "\n\t--------------------------------------------";
                s = this.printLevelFactsToString(i, s);
            } else {
                s = this.printLevelActionsToString(i, s);
            }
            ++i;
        }
        s = String.valueOf(s) + "\n\t--------------------------------------------\n";
        return s;
    }
}

