/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.planner4J.search;

import java.io.Serializable;
import java.util.Vector;

public class SearchQueue
implements Serializable {
    static final long serialVersionUID = 2004100100000000001L;
    protected Vector d_data;

    public SearchQueue() {
        this.d_data = new Vector();
    }

    public SearchQueue(Vector v) {
        this.d_data = new Vector(v.size());
        int i = 0;
        while (i < v.size()) {
            this.add((Comparable)v.elementAt(i));
            ++i;
        }
    }

    protected static int parentOf(int i) {
        return (i - 1) / 2;
    }

    protected static int leftChildOf(int i) {
        return 2 * i + 1;
    }

    protected static int rightChildOf(int i) {
        return 2 * (i + 1);
    }

    public Comparable peek() {
        return (Comparable)this.d_data.elementAt(0);
    }

    public Comparable remove() {
        Comparable minVal = this.peek();
        this.d_data.setElementAt(this.d_data.elementAt(this.d_data.size() - 1), 0);
        this.d_data.setSize(this.d_data.size() - 1);
        if (this.d_data.size() > 1) {
            this.pushDownRoot(0);
        }
        return minVal;
    }

    public void add(Comparable value) {
        this.d_data.addElement(value);
        this.percolateUp(this.d_data.size() - 1);
    }

    public boolean isEmpty() {
        return this.d_data.size() == 0;
    }

    protected void percolateUp(int leaf) {
        int parent = SearchQueue.parentOf(leaf);
        Comparable value = (Comparable)this.d_data.elementAt(leaf);
        while (leaf > 0 && value.compareTo((Comparable)this.d_data.elementAt(parent)) < 0) {
            this.d_data.setElementAt(this.d_data.elementAt(parent), leaf);
            leaf = parent;
            parent = SearchQueue.parentOf(leaf);
        }
        this.d_data.setElementAt(value, leaf);
    }

    protected void pushDownRoot(int root) {
        int heapSize = this.d_data.size();
        Comparable value = (Comparable)this.d_data.elementAt(root);
        while (root < heapSize) {
            int childpos = SearchQueue.leftChildOf(root);
            if (childpos < heapSize) {
                if (SearchQueue.rightChildOf(root) < heapSize && ((Comparable)this.d_data.elementAt(childpos + 1)).compareTo((Comparable)this.d_data.elementAt(childpos)) < 0) {
                    ++childpos;
                }
                if (((Comparable)this.d_data.elementAt(childpos)).compareTo(value) < 0) {
                    this.d_data.setElementAt(this.d_data.elementAt(childpos), root);
                    root = childpos;
                    continue;
                }
                this.d_data.setElementAt(value, root);
                return;
            }
            this.d_data.setElementAt(value, root);
            return;
        }
    }

    public int size() {
        return this.d_data.size();
    }

    public void clear() {
        this.d_data.clear();
    }

    public String toString() {
        return "<SearchQueue: " + this.d_data + ">";
    }
}

