/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.planner4J.planners.classicalPlannerImpl;

import com.ibm.able.planner4J.planners.Options;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.PredicateImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class PredicateManager
implements Serializable {
    static final long serialVersionUID = 2004100100000000001L;
    public int ILLEGAL_ID = Options.getUndefinedValue();
    final int INIT_PREDICATE_HASHSIZE = 1000;
    private int d_idCounter;
    private Hashtable d_predicateMap;
    private Hashtable d_predicateNameToIDMap;
    private static PredicateManager d_singleRef;

    private PredicateManager() {
        this.reset();
    }

    public static PredicateManager getPredicateManager() {
        if (d_singleRef == null) {
            d_singleRef = new PredicateManager();
        }
        return d_singleRef;
    }

    public void reset() {
        this.d_predicateMap = new Hashtable(1000);
        this.d_predicateNameToIDMap = new Hashtable(1000);
        this.d_idCounter = 0;
    }

    public int recordFact(PredicateImpl value) {
        Integer key = new Integer(this.d_idCounter);
        value.setId(this.d_idCounter);
        value.setFullName();
        this.d_predicateMap.put(key, value);
        if (value.getType()) {
            this.d_predicateNameToIDMap.put(value.getPredicateName(), key);
        } else {
            this.d_predicateNameToIDMap.put(value.getFullName(), key);
        }
        ++this.d_idCounter;
        if (Options.getDebugOption()) {
            System.out.println("Recording " + value);
            System.out.println("Recording " + value.getFullName());
        }
        return key;
    }

    public PredicateImpl getFact(Integer keyId) {
        return (PredicateImpl)this.d_predicateMap.get(keyId);
    }

    public PredicateImpl getFact(int id) {
        Integer keyId = new Integer(id);
        return (PredicateImpl)this.d_predicateMap.get(keyId);
    }

    public int getIdFromFactName(String predicateName) {
        int retval = this.ILLEGAL_ID;
        if (this.d_predicateNameToIDMap.containsKey(predicateName)) {
            retval = (Integer)this.d_predicateNameToIDMap.get(predicateName);
        }
        return retval;
    }

    public int numKey() {
        return this.d_predicateMap.size();
    }

    public String toString() {
        return this.d_predicateMap.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(d_singleRef);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        d_singleRef = (PredicateManager)in.readObject();
    }
}

