/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.planner4J.planners.classicalPlannerImpl;

import com.ibm.able.planner4J.planners.IAction;
import com.ibm.able.planner4J.planners.IPlanSolution;
import com.ibm.able.planner4J.planners.Options;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ActionManager;
import java.io.Serializable;
import java.util.ArrayList;

public class PlanSolutionImpl
implements IPlanSolution,
Serializable {
    static final long serialVersionUID = 2004100100000000001L;
    protected boolean d_solved = false;
    protected int d_length;
    protected int d_numActionsInPlan = 0;
    protected int d_stateExplored;
    protected int d_stateSearched;
    protected int d_cacheHits;
    protected int d_loopChecks;
    protected long d_searchTime;
    protected ArrayList d_sol;
    protected ActionManager d_am = ActionManager.getActionManager();

    public PlanSolutionImpl() {
        this.d_sol = new ArrayList();
        this.d_length = Options.getUndefinedValue();
    }

    public ArrayList getSequentialPlanActions() {
        IAction action = null;
        ArrayList<IAction> actionList = new ArrayList<IAction>();
        int i = 0;
        while (i < this.d_sol.size()) {
            ArrayList currentStep = (ArrayList)this.d_sol.get(i);
            Object o = currentStep.get(0);
            action = o instanceof Integer ? this.d_am.getActionInExternalFormat((Integer)o) : (IAction)o;
            actionList.add(action);
            ++i;
        }
        return actionList;
    }

    public void addActionToSequentialSolution(Object o) {
        this.addActionToSolution(o, this.d_length + 1);
    }

    public ArrayList getPlanActionsInternal() {
        return this.d_sol;
    }

    public ArrayList getPlanActions() {
        IAction action = null;
        ArrayList actionList = new ArrayList();
        int i = 0;
        while (i < this.d_sol.size()) {
            ArrayList<IAction> newStepActions = new ArrayList<IAction>();
            ArrayList currentStep = (ArrayList)this.d_sol.get(i);
            int j = 0;
            while (j < currentStep.size()) {
                Object o = currentStep.get(j);
                action = o instanceof Integer ? this.d_am.getActionInExternalFormat((Integer)o) : (IAction)o;
                newStepActions.add(action);
                ++j;
            }
            actionList.add(newStepActions);
            ++i;
        }
        return actionList;
    }

    public void addActionToSolution(Object o, int step) {
        if (this.d_length < step) {
            ArrayList<Object> newStep = new ArrayList<Object>();
            newStep.add(o);
            this.d_sol.add(newStep);
            ++this.d_length;
        } else {
            ArrayList currentstep = (ArrayList)this.d_sol.get(step);
            currentstep.add(o);
        }
        ++this.d_numActionsInPlan;
    }

    public void setStatus(boolean status) {
        this.d_solved = status;
    }

    public boolean getStatus() {
        return this.d_solved;
    }

    public boolean isSolved() {
        return this.d_solved;
    }

    public void setSolutionLength(int length) {
        if (this.d_length != this.d_sol.size()) {
            System.out.println("WARNING: The value of plan length attempting to set is not the same as internal plan length");
        }
        this.d_length = length;
    }

    public int getSolutionLength() {
        return this.d_length;
    }

    public void setNumActionsInPlan(int count) {
        this.d_numActionsInPlan = count;
    }

    public int getNumActionsInPlan() {
        return this.d_numActionsInPlan;
    }

    public void setLoopChecks(int count) {
        this.d_loopChecks = count;
    }

    public int getLoopChecks() {
        return this.d_loopChecks;
    }

    public void setCacheHits(int count) {
        this.d_cacheHits = count;
    }

    public int getCacheHits() {
        return this.d_cacheHits;
    }

    public void setStateExplored(int count) {
        this.d_stateExplored = count;
    }

    public int getStateExplored() {
        return this.d_stateExplored;
    }

    public void setStateSearched(int count) {
        this.d_stateSearched = count;
    }

    public int getStateSearched() {
        return this.d_stateSearched;
    }

    public void setSearchTime(long time) {
        this.d_searchTime = time;
    }

    public long getSearchTime() {
        return this.d_searchTime;
    }

    public void printSolution() {
        String s;
        if (!this.d_solved) {
            s = "\n*** No solution plan found for the problem! ***\n";
            if (Options.getCalcClosestStateOption()) {
                s = String.valueOf(s) + "\nClosest partial solution is:\n";
            }
        } else {
            s = "\nSolution is:\n";
        }
        if (this.d_solved || Options.getCalcClosestStateOption()) {
            int count = this.d_sol.size();
            int i = 0;
            while (i < count) {
                s = String.valueOf(s) + "\t " + i + ": ";
                ArrayList currentStep = (ArrayList)this.d_sol.get(i);
                int j = 0;
                while (j < currentStep.size()) {
                    Object o;
                    if (j > 0) {
                        s = String.valueOf(s) + "\t     ";
                    }
                    IAction action = (o = currentStep.get(j)) instanceof Integer ? this.d_am.getAction((int)((Integer)o)) : (IAction)o;
                    s = String.valueOf(s) + action.getName() + "\n";
                    ++j;
                }
                ++i;
            }
        }
        System.out.println(s);
        this.printStatistics();
    }

    public void printStatistics() {
        String s = "\nSearch Statistics:\n";
        s = String.valueOf(s) + "Search time: " + this.d_searchTime + "\n";
        s = String.valueOf(s) + "States explored: " + this.d_stateExplored + "\n";
        s = String.valueOf(s) + "States searched: " + this.d_stateSearched + "\n";
        System.out.println(s);
    }

    public String toString() {
        String s;
        if (!this.d_solved) {
            s = "\n*** No solution plan found for the problem! ***\n";
        } else {
            s = "\nSolution is:\n";
            int count = this.d_sol.size();
            int i = 0;
            while (i < count) {
                s = String.valueOf(s) + "\t " + i + ": ";
                ArrayList currentStep = (ArrayList)this.d_sol.get(i);
                int j = 0;
                while (j < currentStep.size()) {
                    Object o;
                    if (j > 0) {
                        s = String.valueOf(s) + "\t     ";
                    }
                    IAction action = (o = currentStep.get(j)) instanceof Integer ? this.d_am.getAction((int)((Integer)o)) : (IAction)o;
                    s = String.valueOf(s) + action.getName() + "\n";
                    ++j;
                }
                ++i;
            }
        }
        s = String.valueOf(s) + "\nSearch Statistics:\n";
        s = String.valueOf(s) + "Search time: " + this.d_searchTime + "\n";
        s = String.valueOf(s) + "States explored: " + this.d_stateExplored + "\n";
        s = String.valueOf(s) + "States searched: " + this.d_stateSearched + "\n";
        return s;
    }
}

