/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.planner4J.planners.classicalPlannerImpl;

import com.ibm.able.planner4J.planners.IDomain;
import com.ibm.able.planner4J.planners.IProblem;
import com.ibm.able.planner4J.planners.Options;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ActionImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ActionManager;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.DomainImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.PredicateImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.PredicateManager;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ProblemImpl;
import com.ibm.able.planner4J.state.IState;
import com.ibm.able.planner4J.state.StripsStateImpl;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class HelperUtil
implements Serializable {
    static final long serialVersionUID = 2004100100000000001L;
    protected DomainImpl d_domain;
    ProblemImpl d_problem;
    protected StripsStateImpl d_init;
    protected StripsStateImpl d_goal;
    ArrayList d_dynamicPredicates;
    protected ArrayList d_groundActions;
    protected ArrayList d_classicalActions = new ArrayList();
    public static final String UNKNOWN_MARKER = "unknown";
    public static final String WILLKNOW_MARKER = "willknow";
    protected StripsStateImpl d_relevantfacts;
    protected ArrayList d_commonArrayList;
    protected ActionManager d_am = ActionManager.getActionManager();
    protected PredicateManager d_pm = PredicateManager.getPredicateManager();

    public HelperUtil(IDomain domain, IProblem problem, IState initial, IState goal) {
        this.d_domain = (DomainImpl)domain;
        this.d_problem = (ProblemImpl)problem;
        this.d_init = (StripsStateImpl)initial;
        this.d_goal = (StripsStateImpl)goal;
        this.d_commonArrayList = new ArrayList();
        this.d_dynamicPredicates = new ArrayList();
    }

    protected int groundPredicate(Hashtable objMap, PredicateImpl template) {
        PredicateImpl instance = new PredicateImpl(false);
        instance.setName(template.getPredicateName());
        int id = this.d_pm.getIdFromFactName(template.getPredicateName());
        if (id == Options.getUndefinedValue()) {
            System.out.println("Error while finding predicate template for '" + template.getPredicateName() + "' during " + "grounding predicate");
            return Options.getUndefinedValue();
        }
        instance.setTemplateId(id);
        int i = 0;
        while (i < template.predSize()) {
            Object temp = objMap.get(template.getObj(i));
            if (temp == null) {
                return Options.getUndefinedValue();
            }
            instance.addObj(temp);
            ++i;
        }
        instance.setFullName();
        id = this.d_pm.getIdFromFactName(instance.getFullName());
        if (id != Options.getUndefinedValue()) {
            return id;
        }
        id = this.d_pm.recordFact(instance);
        return id;
    }

    protected void getObjSet(ArrayList types, ArrayList ins, int index) {
        if (types.isEmpty()) {
            return;
        }
        String type = (String)types.get(index);
        ArrayList objIns = this.d_problem.getObjectMap(type);
        if (objIns == null) {
            System.out.println("Error while finding object instances of type = '" + type + "'. Check problem encoding.");
            return;
        }
        if (Options.getDebugOption()) {
            System.out.println("\ttype = " + type);
            System.out.println("\t#objects = " + objIns.size());
        }
        int i = 0;
        while (i < objIns.size()) {
            if (index >= ins.size()) {
                ins.add(objIns.get(i));
            } else {
                ins.set(index, objIns.get(i));
            }
            if (index == types.size() - 1) {
                this.d_commonArrayList.add(new ArrayList(ins));
            } else {
                this.getObjSet(types, ins, index + 1);
            }
            ++i;
        }
    }

    protected boolean checkDuplicateParameter(ArrayList paraList) {
        int i = 0;
        while (i < paraList.size()) {
            Object s = paraList.get(i);
            if (paraList.indexOf(s) != paraList.lastIndexOf(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void calculateDynamicPredicates() {
        int i = 0;
        while (i < this.d_domain.getNumAction()) {
            String s;
            ActionImpl act = (ActionImpl)this.d_domain.getAction(i);
            int j = 0;
            while (j < act.getNumAdd()) {
                s = ((PredicateImpl)act.getAdd(j)).getPredicateName();
                if (!this.d_dynamicPredicates.contains(s)) {
                    this.d_dynamicPredicates.add(s);
                }
                ++j;
            }
            j = 0;
            while (j < act.getNumDelete()) {
                s = ((PredicateImpl)act.getDelete(j)).getPredicateName();
                if (!this.d_dynamicPredicates.contains(s)) {
                    this.d_dynamicPredicates.add(s);
                }
                ++j;
            }
            ++i;
        }
    }

    protected boolean checkViolateStaticPrecond(ActionImpl aAction) {
        int i = 0;
        while (i < aAction.getNumPrecond()) {
            int id = (Integer)aAction.getPrecond(i);
            PredicateImpl pred = this.d_pm.getFact(id);
            if (pred == null) {
                return false;
            }
            if (!this.d_dynamicPredicates.contains(pred.getPredicateName()) && !this.d_init.isTrue(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ArrayList getGroundActions() {
        ArrayList<Integer> groundActions = new ArrayList<Integer>();
        ArrayList<String> objList = new ArrayList<String>();
        this.calculateDynamicPredicates();
        int i = 0;
        while (i < this.d_domain.getNumAction()) {
            ActionImpl template = (ActionImpl)this.d_domain.getAction(i);
            objList.clear();
            int j = 0;
            while (j < template.getNumParam()) {
                String obj = template.getParam(j);
                objList.add(template.getParamType(obj));
                ++j;
            }
            if (Options.getDebugOption()) {
                System.out.println("Grounding action = " + template.getActionName());
                System.out.println("\t#parameters = " + objList.size());
            }
            this.d_commonArrayList.clear();
            if (template.getNumParam() == 0) {
                this.d_commonArrayList.add(new ArrayList());
            } else {
                this.getObjSet(objList, new ArrayList(), 0);
            }
            if (Options.getDebugOption()) {
                System.out.println("Instance sets = " + this.d_commonArrayList.size());
            }
            j = 0;
            while (j < this.d_commonArrayList.size()) {
                ArrayList gIns = (ArrayList)this.d_commonArrayList.get(j);
                if (!this.checkDuplicateParameter(gIns)) {
                    PredicateImpl pred;
                    Hashtable objMap = new Hashtable();
                    int k = 0;
                    while (k < gIns.size()) {
                        objMap.put(template.getParam(k), gIns.get(k));
                        ++k;
                    }
                    ActionImpl instance = new ActionImpl(false);
                    instance.setName(template.getActionName());
                    int id = this.d_am.getIdFromActionName(template.getActionName());
                    if (id == Options.getUndefinedValue()) {
                        System.out.println("Error while finding action template for '" + template.getActionName() + "' during " + "grounding action");
                        return null;
                    }
                    instance.setTemplateId(id);
                    k = 0;
                    while (k < gIns.size()) {
                        instance.putParam(gIns.get(k));
                        ++k;
                    }
                    instance.setFullName();
                    id = this.d_am.getIdFromActionName(instance.getFullName());
                    k = 0;
                    while (k < template.getNumPrecond()) {
                        pred = (PredicateImpl)template.getPrecond(k);
                        id = this.groundPredicate(objMap, pred);
                        if (id == Options.getUndefinedValue()) break;
                        instance.putPrecond(new Integer(id));
                        ++k;
                    }
                    if (k >= template.getNumPrecond()) {
                        k = 0;
                        while (k < template.getNumAdd()) {
                            pred = (PredicateImpl)template.getAdd(k);
                            id = this.groundPredicate(objMap, pred);
                            if (id == Options.getUndefinedValue()) break;
                            instance.putAdd(new Integer(id));
                            ++k;
                        }
                        if (k >= template.getNumAdd()) {
                            k = 0;
                            while (k < template.getNumDelete()) {
                                pred = (PredicateImpl)template.getDelete(k);
                                id = this.groundPredicate(objMap, pred);
                                if (id == Options.getUndefinedValue()) break;
                                instance.putDelete(new Integer(id));
                                ++k;
                            }
                            if (k >= template.getNumDelete() && !this.checkViolateStaticPrecond(instance)) {
                                id = this.d_am.recordAction(instance);
                                groundActions.add(new Integer(id));
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        this.d_groundActions = new ArrayList(groundActions);
        return groundActions;
    }

    public ArrayList getClassicalActions() {
        return this.d_classicalActions;
    }

    public ArrayList getGroundRelevantActions() {
        ArrayList groundActions = this.d_groundActions;
        ArrayList relevantActions = new ArrayList();
        HashSet<Integer> relevantActionsSet = new HashSet<Integer>();
        StripsStateImpl currentState = new StripsStateImpl(this.d_goal);
        StripsStateImpl lastState = new StripsStateImpl();
        StripsStateImpl tmpState = null;
        int opcount = groundActions.size();
        if (Options.getDebugOption()) {
            System.out.println("#Ground actions = " + opcount);
        }
        int opadded = 1;
        while (opadded != 0 && !lastState.isSubset(currentState)) {
            if (Options.getDebugOption()) {
                System.out.println("Inside helper::");
                System.out.println("last = " + lastState + "current = " + currentState);
            }
            opadded = 0;
            int i = 0;
            while (i < opcount) {
                int id = (Integer)groundActions.get(i);
                tmpState = currentState.applyActionBackward(id);
                if (tmpState != null) {
                    ++opadded;
                    relevantActionsSet.add(new Integer(id));
                    lastState = currentState;
                    currentState = tmpState;
                }
                ++i;
            }
        }
        Iterator iter = relevantActionsSet.iterator();
        while (iter.hasNext()) {
            relevantActions.add(iter.next());
        }
        return relevantActions;
    }

    public ArrayList getGroundRelevantActions2() {
        ArrayList groundActions = this.d_groundActions;
        ArrayList relevantActions = new ArrayList();
        HashSet<Integer> relevantActionsSet = new HashSet<Integer>();
        StripsStateImpl currentState = new StripsStateImpl(this.d_goal);
        StripsStateImpl lastState = new StripsStateImpl();
        StripsStateImpl tmpState = null;
        int opcount = groundActions.size();
        if (Options.getDebugOption()) {
            System.out.println("#Ground actions = " + opcount);
        }
        int opadded = 1;
        while (opadded != 0) {
            if (Options.getDebugOption()) {
                System.out.println("Inside helper::");
                System.out.println("last = " + lastState + "current = " + currentState);
            }
            opadded = 0;
            int i = 0;
            while (i < opcount) {
                Integer idInteger = (Integer)groundActions.get(i);
                int id = idInteger;
                tmpState = this.updateActionBackward(id, currentState);
                if (!(tmpState == null || currentState.isSubset(tmpState) && relevantActionsSet.contains(idInteger))) {
                    lastState = currentState;
                    currentState = tmpState;
                    relevantActionsSet.add(idInteger);
                    ++opadded;
                }
                ++i;
            }
        }
        this.d_relevantfacts = currentState;
        Iterator iter = relevantActionsSet.iterator();
        while (iter.hasNext()) {
            relevantActions.add(iter.next());
        }
        return relevantActions;
    }

    public Collection getRelevantFacts() {
        if (this.d_relevantfacts != null) {
            return this.d_relevantfacts.getFactsInternal();
        }
        return null;
    }

    public StripsStateImpl updateActionBackward(int actionId, StripsStateImpl start) {
        Integer id;
        if (start == null) {
            return null;
        }
        ActionImpl action = this.d_am.getAction(actionId);
        if (action == null) {
            return null;
        }
        int i = 0;
        while (i < action.getNumAdd()) {
            id = (Integer)action.getAdd(i);
            if (start.isTrue(id)) break;
            ++i;
        }
        if (i >= action.getNumAdd()) {
            return null;
        }
        StripsStateImpl newState = new StripsStateImpl(start);
        i = 0;
        while (i < action.getNumPrecond()) {
            id = (Integer)action.getPrecond(i);
            newState.addFact(id);
            ++i;
        }
        return newState;
    }

    public StripsStateImpl regressActionBackward(int actionId, StripsStateImpl start) {
        Integer id;
        if (start == null) {
            return null;
        }
        StripsStateImpl newState = new StripsStateImpl(start);
        ActionImpl action = this.d_am.getAction(actionId);
        if (action == null) {
            return null;
        }
        int i = 0;
        while (i < action.getNumAdd()) {
            id = (Integer)action.getAdd(i);
            newState.delFact(id);
            ++i;
        }
        i = 0;
        while (i < action.getNumPrecond()) {
            id = (Integer)action.getPrecond(i);
            newState.addFact(id);
            ++i;
        }
        return newState;
    }

    public StripsStateImpl getReachablePredicates(ArrayList actions) {
        int opadded;
        StripsStateImpl currentState = new StripsStateImpl(this.d_init);
        StripsStateImpl tmpState = new StripsStateImpl();
        StripsStateImpl finalState = new StripsStateImpl();
        ArrayList<Integer> operadded = new ArrayList<Integer>();
        do {
            Iterator iter = ((AbstractList)actions).iterator();
            opadded = 0;
            while (iter.hasNext()) {
                Integer tmpInteger = (Integer)iter.next();
                tmpState = currentState.applyActionForward(tmpInteger);
                if (tmpState == null || operadded.contains(tmpInteger)) continue;
                finalState = this.addReachablePredicates(finalState, tmpInteger);
                ++opadded;
                operadded.add(tmpInteger);
                currentState = currentState.createUnion(finalState);
            }
        } while (opadded != 0);
        return finalState;
    }

    public StripsStateImpl addReachablePredicates(StripsStateImpl currentState, Integer tmpInteger) {
        ActionImpl a = this.d_am.getAction(tmpInteger);
        String tmpStr = "";
        String tmpStr1 = "";
        int i = 0;
        while (i < a.getNumPrecond()) {
            currentState.addFact((int)((Integer)a.getPrecond(i)));
            ++i;
        }
        i = 0;
        while (i < a.getNumAdd()) {
            int id = (Integer)a.getAdd(i);
            currentState.addFact(id);
            tmpStr = this.d_pm.getFact(id).toString();
            if (tmpStr.indexOf(WILLKNOW_MARKER) != -1) {
                tmpStr1 = tmpStr.substring(tmpStr.indexOf("(") + WILLKNOW_MARKER.length() + 2, tmpStr.length() - 1).trim();
                currentState.addFact(this.d_pm.getIdFromFactName(tmpStr1));
                currentState.addFact(this.d_pm.getIdFromFactName("not-" + tmpStr1));
            }
            ++i;
        }
        return currentState;
    }
}

