/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.planner4J.planners.classicalPlannerImpl;

import com.ibm.able.planner4J.parsers.pddl1ParserImpl.PDDL1Parser;
import com.ibm.able.planner4J.parsers.pddl1ParserImpl.ParseException;
import com.ibm.able.planner4J.planners.IDomain;
import com.ibm.able.planner4J.planners.IPlanSolution;
import com.ibm.able.planner4J.planners.IPlanner;
import com.ibm.able.planner4J.planners.IProblem;
import com.ibm.able.planner4J.planners.Options;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ActionImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ActionManager;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.DomainImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.PlanSolutionImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.PredicateImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.PredicateManager;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ProblemImpl;
import com.ibm.able.planner4J.search.ISearch;
import com.ibm.able.planner4J.search.stateSpaceSearchImpl.StateSpaceSearchImpl;
import com.ibm.able.planner4J.state.StripsStateImpl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.HashMap;

public class ClassicalPlanner
implements IPlanner,
Serializable {
    static final long serialVersionUID = 2004100100000000001L;
    ActionManager d_am = ActionManager.getActionManager();
    PredicateManager d_pm = PredicateManager.getPredicateManager();
    Options opt = new Options();
    private DomainImpl d_domain;
    private ProblemImpl d_problem;
    private StripsStateImpl d_init;
    private StripsStateImpl d_goal;
    private PlanSolutionImpl d_plan;
    private HashMap d_paramMap;

    public ClassicalPlanner() {
        this.initializePlanner();
    }

    public void initializePlanner() {
        this.d_init = new StripsStateImpl();
        this.d_init.setHeuristicValue(Options.getInfiniteValue());
        this.d_goal = new StripsStateImpl();
        this.d_goal.setHeuristicValue(0);
        this.d_plan = null;
    }

    public IPlanner createPlanner() {
        ClassicalPlanner planner = this;
        this.initializePlanner();
        return planner;
    }

    public IPlanner createPlanner(String domainFile, String problemFile, HashMap paramMap) {
        ClassicalPlanner planner = this;
        this.initializePlanner();
        this.processArgs(paramMap);
        planner.parseInputFiles(domainFile, problemFile);
        return planner;
    }

    public IPlanner createPlanner(IDomain domain, IProblem problem, HashMap paramMap) {
        ClassicalPlanner planner = this;
        this.initializePlanner();
        this.processArgs(paramMap);
        planner.d_domain = (DomainImpl)domain;
        planner.d_problem = (ProblemImpl)problem;
        return planner;
    }

    public boolean setDomain(IDomain domain) {
        this.d_domain = (DomainImpl)domain;
        return true;
    }

    public IDomain getDomain() {
        return this.d_domain;
    }

    public boolean setProblem(IProblem problem) {
        this.d_problem = (ProblemImpl)problem;
        return true;
    }

    public IProblem getProblem() {
        return this.d_problem;
    }

    public boolean setParameterMap(HashMap paramMap) {
        this.d_paramMap = paramMap;
        this.processArgs(this.d_paramMap);
        return true;
    }

    public IPlanSolution generatePlan() {
        PlanSolutionImpl result = null;
        if (this.d_domain == null || this.d_problem == null) {
            return null;
        }
        System.out.println(this.getRuntimeSetting());
        result = this.controlPlanner(this);
        return result;
    }

    public void processArgs(HashMap params) {
        int tmpInt;
        if (params == null) {
            return;
        }
        String tmpStr = (String)params.get("direction");
        if (tmpStr != null && tmpStr.equalsIgnoreCase("backward")) {
            Options.setForwardDirectionFlag(false);
        }
        if ((tmpStr = (String)params.get("debug")) != null && tmpStr.equalsIgnoreCase("true")) {
            Options.setDebugOption(true);
        }
        if ((tmpStr = (String)params.get("searchExploreLimit")) != null) {
            tmpInt = Integer.parseInt(tmpStr);
            Options.setMaxStateExploreLimit(tmpInt);
        }
        if ((tmpStr = (String)params.get("searchLimit")) != null) {
            tmpInt = Integer.parseInt(tmpStr);
            Options.setMaxStateSearchLimit(tmpInt);
        }
        if ((tmpStr = (String)params.get("heuristicType")) != null) {
            tmpInt = Integer.parseInt(tmpStr);
            Options.setSearchHeuristicType(tmpInt);
        }
        if ((tmpStr = (String)params.get("minimal")) != null && tmpStr.equalsIgnoreCase("false")) {
            Options.setMinimalTestOption(false);
        }
        if ((tmpStr = (String)params.get("closest")) != null && tmpStr.equalsIgnoreCase("true")) {
            Options.setCalcClosestStateOption(true);
        }
        if ((tmpStr = (String)params.get("reduce")) != null && tmpStr.equalsIgnoreCase("false")) {
            Options.setReduceOpsOption(false);
        }
        if ((tmpStr = (String)params.get("fullgoal")) != null && tmpStr.equalsIgnoreCase("true")) {
            Options.setCompleteGoalFlag(true);
        }
        if ((tmpStr = (String)params.get("weight")) != null) {
            float tmpFloat = Float.parseFloat(tmpStr);
            Options.setWeight(tmpFloat);
        }
        if ((tmpStr = (String)params.get("heuristicWeight")) != null) {
            int tmpInt2 = Integer.parseInt(tmpStr);
            Options.setHeuristicWeight(tmpInt2);
        }
        if ((tmpStr = (String)params.get("allsols")) != null && tmpStr.equalsIgnoreCase("true")) {
            Options.setSingleSolOption(false);
        }
        if ((tmpStr = (String)params.get("reachability")) != null && tmpStr.equalsIgnoreCase("false")) {
            Options.setReachFactsCheckOption(false);
        }
    }

    public String getRuntimeSetting() {
        String result = "-------------------  ClassicalPlanner invoked with options  -------------------\n   Debug ? = " + Options.getDebugOption() + ", " + " Forward search ? = " + Options.getForwardDirectionOption() + ", " + " All sols ? = " + !Options.getSingleSolOption() + " \n   Reduce ops ? = " + Options.getReduceOpsOption() + ", " + " Minimal pruning ? = " + Options.getMinimalTestOption() + ", " + " Closest failed sol ? = " + Options.getCalcClosestStateOption() + "\n   Heuristic type = " + Options.getSearchHeuristicType() + ", " + " Rel. Heur. wt (to h) = " + Options.getHeuristicWeight() + ", CompleteGoals = " + Options.getCompleteGoalFlag() + "\n   Search limit = " + Options.getMaxStateSearchLimit() + ", " + " Search explore limit = " + Options.getMaxStateExploreLimit();
        result = String.valueOf(result) + "\n--------------------------------------------------------------------";
        return result;
    }

    public boolean parseInputFiles(String domainFile, String problemFile) {
        FileInputStream input_file;
        try {
            input_file = new FileInputStream(domainFile);
            PDDL1Parser.ReInit(input_file);
        }
        catch (FileNotFoundException e) {
            System.out.println("Error while parsing domain file: " + e);
            return false;
        }
        try {
            this.d_domain = (DomainImpl)PDDL1Parser.parse_domain_pddl();
            System.out.println("STATUS: Domain file parsed successfully !");
        }
        catch (ParseException e) {
            System.out.println("Exception while parsing domain file:");
            e.printStackTrace();
            return false;
        }
        try {
            input_file = new FileInputStream(problemFile);
            PDDL1Parser.ReInit(input_file);
        }
        catch (FileNotFoundException e) {
            System.out.println("Error while parsing problem file: " + e);
            return false;
        }
        try {
            this.d_problem = (ProblemImpl)PDDL1Parser.parse_problem_pddl();
            System.out.println("STATUS: Problem parsed successfully !");
        }
        catch (ParseException e) {
            System.out.println("Exception while parsing problem file:");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean initializePlanningProblem() {
        int id;
        PredicateImpl pred;
        this.d_problem.makeTypeMap(this.d_domain);
        this.d_pm.reset();
        this.d_am.reset();
        int count = this.d_domain.getNumAction();
        int i = 0;
        while (i < count) {
            ActionImpl action = (ActionImpl)this.d_domain.getAction(i);
            this.d_am.recordAction(action);
            ++i;
        }
        count = this.d_domain.getNumPred();
        i = 0;
        while (i < count) {
            pred = this.d_domain.getPred(i);
            this.d_pm.recordFact(pred);
            ++i;
        }
        count = this.d_problem.numInitPred();
        i = 0;
        while (i < count) {
            pred = this.d_problem.getInitPred(i);
            pred.setType(false);
            id = this.d_pm.getIdFromFactName(pred.getFullName());
            if (id != Options.getUndefinedValue()) {
                this.d_init.addFact(id);
            } else {
                id = this.d_pm.getIdFromFactName(pred.getPredicateName());
                if (id == Options.getUndefinedValue()) {
                    System.out.println("Error while recording predicate template for '" + pred.getPredicateName() + "' in initial state.");
                    return false;
                }
                pred.setTemplateId(id);
                id = this.d_pm.recordFact(pred);
                this.d_init.addFact(id);
            }
            ++i;
        }
        this.d_problem.setInitState(this.d_init);
        count = this.d_problem.numGoalPred();
        i = 0;
        while (i < count) {
            pred = this.d_problem.getGoalPred(i);
            pred.setType(false);
            id = this.d_pm.getIdFromFactName(pred.getFullName());
            if (id != Options.getUndefinedValue()) {
                this.d_goal.addFact(id);
            } else {
                id = this.d_pm.getIdFromFactName(pred.getPredicateName());
                if (id == Options.getUndefinedValue()) {
                    System.out.println("Error while recording predicate template for '" + pred.getPredicateName() + "' in goal state.");
                    return false;
                }
                pred.setTemplateId(id);
                id = this.d_pm.recordFact(pred);
                this.d_goal.addFact(id);
            }
            ++i;
        }
        this.d_problem.setGoalState(this.d_goal);
        return true;
    }

    public StripsStateImpl getInitialState() {
        return this.d_init;
    }

    public StripsStateImpl getGoalState() {
        return this.d_goal;
    }

    public static void main(String[] args) {
        PlanSolutionImpl result = null;
        ClassicalPlanner planner = new ClassicalPlanner();
        ISearch cfr_ignored_0 = new StateSpaceSearchImpl();
        if (args.length < 2) {
            System.out.println("Usage: java ClassicalPlanner <domain.pddl> <problem.pddl> [debug|backward|minimaloff|closest]");
            return;
        }
        String domainFile = args[0];
        String problemFile = args[1];
        if (args.length >= 3 && args[2].indexOf("debug") != -1) {
            Options.setDebugOption(true);
        }
        if (args.length >= 3 && args[2].indexOf("backward") != -1) {
            Options.setForwardDirectionFlag(false);
        }
        if (args.length >= 3 && args[2].indexOf("minimaloff") != -1) {
            Options.setMinimalTestOption(false);
        }
        if (args.length >= 3 && args[2].indexOf("closest") != -1) {
            Options.setCalcClosestStateOption(true);
        }
        planner.parseInputFiles(domainFile, problemFile);
        result = planner.controlPlanner(planner);
        if (result != null) {
            if (result.isSolved()) {
                System.out.println(result.toString());
            } else if (Options.getCalcClosestStateOption()) {
                result.printSolution();
            } else {
                result.printStatistics();
            }
        }
    }

    public IPlanSolution generatePlan(IDomain domain, IProblem problem) {
        PlanSolutionImpl result = null;
        ClassicalPlanner planner = this;
        this.d_domain = (DomainImpl)domain;
        this.d_problem = (ProblemImpl)problem;
        result = planner.controlPlanner(planner);
        return result;
    }

    public IPlanSolution generatePlan(String domainFile, String problemFile) {
        PlanSolutionImpl result = null;
        ClassicalPlanner planner = this;
        planner.parseInputFiles(domainFile, problemFile);
        result = planner.controlPlanner(planner);
        return result;
    }

    public IPlanSolution generatePlan(String baseDir, String domain, String problem) {
        PlanSolutionImpl result = null;
        ClassicalPlanner planner = this;
        String domainFile = String.valueOf(baseDir) + domain;
        String problemFile = String.valueOf(baseDir) + problem;
        planner.parseInputFiles(domainFile, problemFile);
        result = planner.controlPlanner(planner);
        return result;
    }

    public PlanSolutionImpl controlPlanner(ClassicalPlanner planner) {
        PlanSolutionImpl result = null;
        ISearch solver = new StateSpaceSearchImpl();
        if (!this.d_domain.getName().equals(this.d_problem.getDomain())) {
            System.out.println("Error in domain or problem specification file. Domain name does not match !");
            return null;
        }
        if (!planner.initializePlanningProblem()) {
            return null;
        }
        if (Options.getForwardDirectionOption()) {
            this.d_init.setHeuristicValue(Options.getInfiniteValue());
            this.d_goal.setHeuristicValue(0);
        } else {
            this.d_init.setHeuristicValue(0);
            this.d_goal.setHeuristicValue(Options.getInfiniteValue());
        }
        if (Options.getDebugOption()) {
            System.out.println("Problem: " + this.d_problem);
            System.out.println("Init state: " + this.d_init);
            System.out.println("Goal state: " + this.d_goal);
        }
        System.out.println("STATUS: Bookkeeping complete. Ready for planning !");
        if (solver.solve(planner.d_domain, planner.d_problem, planner.d_init, planner.d_goal)) {
            if (Options.getDebugOption()) {
                System.out.println("In planner control loop:");
                solver.getSolution().printSolution();
            }
        } else if (Options.getDebugOption()) {
            System.out.println("In planner control loop:");
            if (Options.getCalcClosestStateOption()) {
                solver.getSolution().printSolution();
            } else {
                solver.getSolution().printStatistics();
            }
        }
        result = (PlanSolutionImpl)solver.getSolution();
        System.out.println("STATUS: End of planning !");
        return result;
    }
}

