/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.planner4J.planners.classicalPlannerImpl;

import com.ibm.able.planner4J.planners.Options;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ActionImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.PredicateImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.PredicateManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class ActionManager
implements Serializable {
    static final long serialVersionUID = 2004100100000000001L;
    public int ILLEGAL_ID = Options.getUndefinedValue();
    private final int INIT_ACTION_HASHSIZE = 100;
    private int d_idCounter;
    private Hashtable d_actionMap;
    private Hashtable d_actionNameToIDMap;
    private static ActionManager d_singleRef;
    PredicateManager d_pm = PredicateManager.getPredicateManager();

    public ActionManager() {
        this.reset();
    }

    public static ActionManager getActionManager() {
        if (d_singleRef == null) {
            d_singleRef = new ActionManager();
        }
        return d_singleRef;
    }

    public void reset() {
        this.d_actionMap = new Hashtable(100);
        this.d_actionNameToIDMap = new Hashtable(100);
        this.d_idCounter = 0;
    }

    public int recordAction(ActionImpl value) {
        Integer key = new Integer(this.d_idCounter);
        value.setId(this.d_idCounter);
        value.setFullName();
        this.d_actionMap.put(key, value);
        if (value.getType()) {
            this.d_actionNameToIDMap.put(value.getActionName(), key);
        } else {
            this.d_actionNameToIDMap.put(value.getFullName(), key);
        }
        ++this.d_idCounter;
        if (Options.getDebugOption()) {
            System.out.println("Recording " + value);
            System.out.println("Recording " + value.getFullName());
        }
        return key;
    }

    public ActionImpl getAction(int id) {
        Integer keyId = new Integer(id);
        return (ActionImpl)this.d_actionMap.get(keyId);
    }

    public ActionImpl getAction(Integer keyId) {
        return (ActionImpl)this.d_actionMap.get(keyId);
    }

    public ActionImpl getActionInExternalFormat(Integer keyId) {
        Integer tmpId;
        PredicateImpl p = null;
        ActionImpl action = (ActionImpl)this.d_actionMap.get(keyId);
        ActionImpl external = new ActionImpl(action.getType());
        external.d_fullName = action.d_fullName;
        external.d_name = action.d_name;
        external.d_id = action.d_id;
        external.d_templateId = action.d_templateId;
        external.d_param_map = action.d_param_map;
        external.d_paramList = action.d_paramList;
        int i = 0;
        while (i < action.d_precondList.size()) {
            tmpId = (Integer)action.d_precondList.get(i);
            p = this.d_pm.getFact(tmpId);
            external.d_precondList.add(p);
            ++i;
        }
        i = 0;
        while (i < action.d_addList.size()) {
            tmpId = (Integer)action.d_addList.get(i);
            p = this.d_pm.getFact(tmpId);
            external.d_addList.add(p);
            ++i;
        }
        i = 0;
        while (i < action.d_deleteList.size()) {
            tmpId = (Integer)action.d_deleteList.get(i);
            p = this.d_pm.getFact(tmpId);
            external.d_deleteList.add(p);
            ++i;
        }
        return external;
    }

    public int getIdFromActionName(String actionName) {
        int retval = this.ILLEGAL_ID;
        if (this.d_actionNameToIDMap.containsKey(actionName)) {
            retval = (Integer)this.d_actionNameToIDMap.get(actionName);
        }
        return retval;
    }

    public int numKey() {
        return this.d_actionMap.size();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(d_singleRef);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        d_singleRef = (ActionManager)in.readObject();
    }
}

