/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleEventListener;
import com.ibm.able.data.AbleBuiltInVariable;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleRuleSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AbleVariableTextView
extends JPanel
implements AbleEventListener,
PropertyChangeListener,
Serializable {
    static final long serialVersionUID = 2001100100000000001L;
    AbleBean myBean;
    Hashtable myVariables;
    JScrollPane myTextScrollPane = new JScrollPane();
    JTextArea myTextArea = new JTextArea();
    boolean myRefreshAllowed = true;
    int myCurrentStepCount = 0;
    int myStepsPerRefresh = 1;

    public AbleVariableTextView(Object object) {
        this.enableEvents(64L);
        try {
            this.myBean = (AbleBean)object;
            this.myBean.addAbleEventListener((AbleEventListener)this);
            if (this.myBean instanceof AbleRuleSet) {
                this.myVariables = ((AbleRuleSet)this.myBean).getVariables();
            }
            this.myBean.addPropertyChangeListener((PropertyChangeListener)this);
            this.setLayout(new BorderLayout());
            this.setBackground(Color.white);
            this.add((Component)this.myTextScrollPane, "Center");
            this.myTextScrollPane.getViewport().add((Component)this.myTextArea, null);
            this.myTextArea.setText("No data to display...");
            this.refreshView();
        }
        catch (Exception exception) {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(262144L, (Object)this, "AbleTraceTextView()", "Error: " + exception.toString());
            }
            exception.printStackTrace();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.refreshView();
    }

    public void handleAbleEvent(AbleEvent ableEvent) {
        ++this.myCurrentStepCount;
        if (this.myCurrentStepCount >= this.myStepsPerRefresh) {
            this.myCurrentStepCount = 0;
            if (this.myRefreshAllowed) {
                this.refreshView();
            }
        }
    }

    protected void refreshView() {
        this.myTextArea.setText("");
        Enumeration enumeration = this.myVariables.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            AbleVariable ableVariable = (AbleVariable)this.myVariables.get(k);
            if (ableVariable instanceof AbleBuiltInVariable || ableVariable.getName().equals("wm")) continue;
            try {
                Object object = ableVariable.getGenericValue();
                String string = "null";
                if (object != null) {
                    string = object.toString();
                }
                this.myTextArea.append(ableVariable.getName() + " " + ableVariable.getDataTypeAsString() + " = " + string + Able.LS);
            }
            catch (AbleDataException ableDataException) {}
        }
        this.invalidate();
        this.repaint();
    }

    public void init() {
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

