/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleJTextAreaHandler;
import com.ibm.able.AbleLogger;
import com.ibm.able.AbleTraceLogger;
import com.ibm.able.editor.AbleAboutDialog;
import com.ibm.able.editor.AbleEditor;
import com.ibm.able.rules.AbleRuleSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class AbleRuleSetDebugConsole
extends JFrame {
    JMenuBar jMenuBar1 = new JMenuBar();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JButton clauseButton = new JButton();
    JButton ruleButton = new JButton();
    JButton ruleBlockButton = new JButton();
    JButton runButton = new JButton();
    JButton quitButton = new JButton();
    JSplitPane jSplitPane1 = new JSplitPane();
    JScrollPane jScrollPane1 = new JScrollPane();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTextArea traceTextArea = new JTextArea();
    JTextArea contextTextArea = new JTextArea();
    JMenu fileMenu = new JMenu();
    JMenu runMenu = new JMenu();
    JMenu traceMenu = new JMenu();
    JMenuItem exitMenuItem = new JMenuItem();
    JMenuItem clauseMenuItem = new JMenuItem();
    JMenuItem ruleMenuItem = new JMenuItem();
    JMenuItem ruleBlockMenuItem = new JMenuItem();
    JMenuItem runMenuItem = new JMenuItem();
    JRadioButtonMenuItem traceNoneRadioButtonMenuItem = new JRadioButtonMenuItem();
    JRadioButtonMenuItem traceLowRadioButtonMenuItem = new JRadioButtonMenuItem();
    JRadioButtonMenuItem traceMediumRadioButtonMenuItem = new JRadioButtonMenuItem();
    JRadioButtonMenuItem traceHighRadioButtonMenuItem = new JRadioButtonMenuItem();
    ButtonGroup traceButtonGroup = new ButtonGroup();
    JMenu optionMenu = new JMenu();
    JMenu helpMenu = new JMenu();
    JMenuItem usingMenuItem = new JMenuItem();
    JMenuItem aboutMenuItem = new JMenuItem();
    JCheckBoxMenuItem viewMenuItem = new JCheckBoxMenuItem();
    AbleRuleSet myRuleSet = null;
    boolean buttonPressed = false;
    boolean quitFlag = false;
    protected String userMessage = "";
    JPanel jPanel3 = new JPanel();
    JLabel statusLabel = new JLabel();
    JLabel userMessageLabel = new JLabel();

    public AbleRuleSetDebugConsole(AbleRuleSet ableRuleSet) {
        try {
            this.myRuleSet = ableRuleSet;
            this.jbInit();
            this.initTraceLogging();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jPanel1.setLayout(this.borderLayout1);
        this.clauseButton.setToolTipText("Step to next clause evaluation");
        this.clauseButton.setText("Clause");
        this.clauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.clauseButton_actionPerformed(actionEvent);
            }
        });
        this.ruleButton.setToolTipText("Step to next rule firing");
        this.ruleButton.setText("Rule");
        this.ruleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.ruleButton_actionPerformed(actionEvent);
            }
        });
        this.ruleBlockButton.setToolTipText("Step to start of next ruleblock");
        this.ruleBlockButton.setText("RuleBlock");
        this.ruleBlockButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.ruleBlockButton_actionPerformed(actionEvent);
            }
        });
        this.runButton.setToolTipText("Run until next user breakpoint");
        this.runButton.setText("Run");
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.runButton_actionPerformed(actionEvent);
            }
        });
        this.quitButton.setToolTipText("Quit debugging this ruleset");
        this.quitButton.setText("Quit");
        this.quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.quitButton_actionPerformed(actionEvent);
            }
        });
        this.traceTextArea.setText("Trace info...");
        this.contextTextArea.setText("Inference Engine Context:");
        this.fileMenu.setText("File");
        this.runMenu.setText("Run");
        this.traceMenu.setText("Trace");
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.exitMenuItem_actionPerformed(actionEvent);
            }
        });
        this.clauseMenuItem.setText("Step to next clause");
        this.clauseMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.clauseMenuItem_actionPerformed(actionEvent);
            }
        });
        this.ruleMenuItem.setText("Step to next rule");
        this.ruleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.ruleMenuItem_actionPerformed(actionEvent);
            }
        });
        this.ruleBlockMenuItem.setText("Step to next ruleblock");
        this.ruleBlockMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.ruleBlockMenuItem_actionPerformed(actionEvent);
            }
        });
        this.runMenuItem.setText("Run to next breakpoint");
        this.runMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.runMenuItem_actionPerformed(actionEvent);
            }
        });
        this.traceNoneRadioButtonMenuItem.setText("None");
        this.traceNoneRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.traceMenuItem_actionPerformed(actionEvent);
            }
        });
        this.jPanel3.setLayout(null);
        this.statusLabel.setBounds(new Rectangle(8, 5, 89, 17));
        this.jPanel3.setPreferredSize(new Dimension(200, 25));
        this.userMessageLabel.setBounds(new Rectangle(96, 5, 323, 17));
        this.traceButtonGroup.add(this.traceNoneRadioButtonMenuItem);
        this.traceLowRadioButtonMenuItem.setText("Low");
        this.traceLowRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.traceMenuItem_actionPerformed(actionEvent);
            }
        });
        this.traceButtonGroup.add(this.traceLowRadioButtonMenuItem);
        this.traceMediumRadioButtonMenuItem.setText("Medium");
        this.traceMediumRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.traceMenuItem_actionPerformed(actionEvent);
            }
        });
        this.traceButtonGroup.add(this.traceMediumRadioButtonMenuItem);
        this.traceHighRadioButtonMenuItem.setText("High");
        this.traceHighRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.traceMenuItem_actionPerformed(actionEvent);
            }
        });
        this.traceButtonGroup.add(this.traceHighRadioButtonMenuItem);
        this.traceMediumRadioButtonMenuItem.setSelected(true);
        this.optionMenu.setText("Option");
        this.viewMenuItem.setText("Horizontal");
        boolean bl = AbleEditor.Preferences.getRuleDebuggerPanelHorizontal();
        this.viewMenuItem.setSelected(bl);
        this.addScrollPanes(bl);
        this.jSplitPane1.setDividerLocation(AbleEditor.Preferences.getRuleDebuggerPanelDividerLocation());
        this.helpMenu.setText("Help");
        this.usingMenuItem.setText("Using the Debugger");
        this.usingMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.usingMenuItem_actionPerformed(actionEvent);
            }
        });
        this.aboutMenuItem.setText("About ABLE");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.aboutMenuItem_actionPerformed(actionEvent);
            }
        });
        this.viewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleSetDebugConsole.this.viewMenuItem_actionPerformed(actionEvent);
            }
        });
        this.statusLabel.setPreferredSize(new Dimension(200, 17));
        this.statusLabel.setText("Debug status:");
        this.setJMenuBar(this.jMenuBar1);
        this.setTitle("AbleRuleSet Debug Console - " + this.myRuleSet.getName());
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("resources/rules16.gif"));
        this.setIconImage(imageIcon.getImage());
        this.setSize(AbleEditor.Preferences.getRuleDebuggerPanelSize());
        this.setLocation(AbleEditor.Preferences.getRuleDebuggerPanelLocation());
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.clauseButton, null);
        this.jPanel2.add((Component)this.ruleButton, null);
        this.jPanel2.add((Component)this.ruleBlockButton, null);
        this.jPanel2.add((Component)this.runButton, null);
        this.jPanel2.add((Component)this.quitButton, null);
        this.jPanel1.add((Component)this.jSplitPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.contextTextArea, null);
        this.getContentPane().add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.statusLabel, null);
        this.jPanel3.add((Component)this.userMessageLabel, null);
        this.jScrollPane2.getViewport().add((Component)this.traceTextArea, null);
        this.jMenuBar1.add(this.fileMenu);
        this.jMenuBar1.add(this.runMenu);
        this.jMenuBar1.add(this.traceMenu);
        this.jMenuBar1.add(this.optionMenu);
        this.jMenuBar1.add(this.helpMenu);
        this.fileMenu.add(this.exitMenuItem);
        this.runMenu.add(this.clauseMenuItem);
        this.runMenu.add(this.ruleMenuItem);
        this.runMenu.add(this.ruleBlockMenuItem);
        this.runMenu.add(this.runMenuItem);
        this.traceMenu.add(this.traceNoneRadioButtonMenuItem);
        this.traceMenu.add(this.traceLowRadioButtonMenuItem);
        this.traceMenu.add(this.traceMediumRadioButtonMenuItem);
        this.traceMenu.add(this.traceHighRadioButtonMenuItem);
        this.helpMenu.add(this.usingMenuItem);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.aboutMenuItem);
        this.optionMenu.add(this.viewMenuItem);
    }

    void clauseButton_actionPerformed(ActionEvent actionEvent) {
        this.myRuleSet.setDebugLevel(5);
        this.buttonPressed = true;
    }

    void ruleButton_actionPerformed(ActionEvent actionEvent) {
        this.myRuleSet.setDebugLevel(4);
        this.buttonPressed = true;
    }

    void ruleBlockButton_actionPerformed(ActionEvent actionEvent) {
        this.myRuleSet.setDebugLevel(3);
        this.buttonPressed = true;
    }

    void runButton_actionPerformed(ActionEvent actionEvent) {
        this.myRuleSet.setDebugLevel(1);
        this.buttonPressed = true;
    }

    void quitButton_actionPerformed(ActionEvent actionEvent) {
        this.myRuleSet.setDebugLevel(0);
        this.buttonPressed = true;
        this.quitFlag = true;
        this.saveGUIPreferences();
        this.setVisible(false);
    }

    void exitMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.myRuleSet.setDebugLevel(0);
        this.buttonPressed = true;
        this.quitFlag = true;
        this.saveGUIPreferences();
        this.setVisible(false);
    }

    void clauseMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.myRuleSet.setDebugLevel(5);
        this.buttonPressed = true;
    }

    void ruleMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.myRuleSet.setDebugLevel(4);
        this.buttonPressed = true;
    }

    void ruleBlockMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.myRuleSet.setDebugLevel(3);
        this.buttonPressed = true;
    }

    void runMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.myRuleSet.setDebugLevel(1);
        this.buttonPressed = true;
    }

    private void initTraceLogging() {
        try {
            AbleLogger ableLogger = Able.startBeanTraceLogging((AbleBean)this.myRuleSet);
            String string = this.myRuleSet.getName() + "debugConsole";
            this.addJTextAreaHandler(ableLogger, string, 524288L, this.traceTextArea);
            this.traceTextArea.setText("Starting trace... " + Able.LS);
        }
        catch (RemoteException remoteException) {
            Able.MessageLog.message(4L, (Object)this, "initTraceLogging()", "Error: " + remoteException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traceMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleRuleSetDebugConsole ableRuleSetDebugConsole = this;
        synchronized (ableRuleSetDebugConsole) {
            try {
                Object object = actionEvent.getSource();
                if (object != this.traceNoneRadioButtonMenuItem) {
                    AbleLogger ableLogger = Able.startBeanTraceLogging((AbleBean)this.myRuleSet);
                    String string = this.myRuleSet.getName() + "debugConsole";
                    if (object == this.traceLowRadioButtonMenuItem) {
                        this.addJTextAreaHandler(ableLogger, string, 262144L, this.traceTextArea);
                    } else if (object == this.traceMediumRadioButtonMenuItem) {
                        this.addJTextAreaHandler(ableLogger, string, 524288L, this.traceTextArea);
                    } else if (object == this.traceHighRadioButtonMenuItem) {
                        this.addJTextAreaHandler(ableLogger, string, 0x100000L, this.traceTextArea);
                    }
                    this.traceTextArea.setText("Starting bean trace... " + Able.LS);
                }
            }
            catch (RemoteException remoteException) {
                Able.MessageLog.message(4L, (Object)this, "traceMenuItem_actionPerformed()", "Error: " + remoteException.toString());
            }
        }
    }

    void viewMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.jSplitPane1.remove(this.jScrollPane1);
        this.jSplitPane1.remove(this.jScrollPane2);
        boolean bl = this.viewMenuItem.isSelected();
        this.addScrollPanes(bl);
        AbleEditor.Preferences.setRuleDebuggerPanelHorizontal(bl);
    }

    private void addScrollPanes(boolean bl) {
        if (bl) {
            this.jSplitPane1.setOrientation(1);
            this.jSplitPane1.add((Component)this.jScrollPane1, "left");
            this.jSplitPane1.add((Component)this.jScrollPane2, "right");
        } else {
            this.jSplitPane1.setOrientation(0);
            this.jSplitPane1.add((Component)this.jScrollPane1, "top");
            this.jSplitPane1.add((Component)this.jScrollPane2, "bottom");
        }
    }

    void aboutMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleAboutDialog ableAboutDialog = new AbleAboutDialog(this, "About Able", true);
        ableAboutDialog.setLocationRelativeTo(null);
        ableAboutDialog.setVisible(true);
    }

    void usingMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleHelp.displayHelp(this, "rules/doc-files/lngMisc.html#debug");
    }

    public boolean processEngineBreakpoint() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.buttonPressed = false;
        this.quitFlag = false;
        if (this.userMessage.equals("")) {
            this.userMessageLabel.setText("Engine breakpoint...");
        } else {
            this.userMessageLabel.setText("User breakpoint... " + this.userMessage);
        }
        this.contextTextArea.setText(this.myRuleSet.getInferenceContextStack().toString());
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.buttonPressed);
        this.userMessageLabel.setText("Inferencing...");
        this.userMessage = "";
        if (!this.quitFlag) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
        return this.quitFlag;
    }

    public AbleJTextAreaHandler addJTextAreaHandler(AbleLogger ableLogger, String string, long l, JTextArea jTextArea) {
        Object object = AbleTraceLogger.getHandler((AbleLogger)ableLogger, (String)string);
        AbleJTextAreaHandler ableJTextAreaHandler = object == null || !(object instanceof AbleJTextAreaHandler) ? new AbleJTextAreaHandler(string, string, jTextArea) : (AbleJTextAreaHandler)((Object)object);
        ableLogger.addHandler((Object)ableJTextAreaHandler, l);
        return ableJTextAreaHandler;
    }

    public void removeTraceJTextAreaHandler(AbleRuleSet ableRuleSet, String string) throws RemoteException {
        AbleTraceLogger.removeHandler((AbleLogger)ableRuleSet.getTraceLogger(), (Object)string);
    }

    private void saveGUIPreferences() {
        AbleEditor.Preferences.setRuleDebuggerPanelHorizontal(this.jSplitPane1.getOrientation() == 1);
        AbleEditor.Preferences.setRuleDebuggerPanelSize(this.getSize());
        AbleEditor.Preferences.setRuleDebuggerPanelLocation(this.getLocation());
        AbleEditor.Preferences.setRuleDebuggerPanelDividerLocation(this.jSplitPane1.getDividerLocation());
    }

    public void setUserMessage(String string) {
        this.userMessage = string;
    }
}

