/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleProperty;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleFuzzyVariable;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleGuiFuzzySetChartable;
import com.ibm.able.rules.AbleGuiFuzzySetRenderer;
import com.ibm.able.rules.AbleRuleSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jclass.chart.Chartable;
import jclass.chart.EventTrigger;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;

public class AbleGuiFuzzySetViewer
extends JPanel
implements PropertyChangeListener,
Serializable {
    static final long serialVersionUID = 2000022500000000001L;
    private JTable myTable = null;
    private TableModel myTableModel = null;
    private Vector myTableData = null;
    private int myMaxColumns = 2;
    private JScrollPane myScrollPane = null;
    private JPanel myChartPanel = new JPanel();
    private AbleRuleSet myRuleSet = null;
    private Hashtable mySolutnSetList = new Hashtable();
    private Color[] myColors = new Color[]{Color.red, Color.cyan, Color.white, Color.green, Color.black};

    public AbleGuiFuzzySetViewer() {
        this.ctorHelper();
        this.myRuleSet = null;
    }

    public AbleGuiFuzzySetViewer(AbleRuleSet ableRuleSet) throws AbleDataException {
        this.ctorHelper();
        this.setRuleSet(ableRuleSet);
    }

    private void ctorHelper() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.myChartPanel, "Center");
        this.myChartPanel.setLayout(new BorderLayout());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        int n;
        AbleRuleSet ableRuleSet = (AbleRuleSet)propertyChangeEvent.getSource();
        String string2 = propertyChangeEvent.getPropertyName();
        int n2 = string2.indexOf(32);
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        if (n2 == -1) {
            n = AbleProperty.PropertyId((String)string2);
            string = "";
        } else {
            n = AbleProperty.PropertyId((String)string2.substring(0, n2));
            string = string2.substring(n2 + 1);
        }
        switch (n) {
            case 1227: {
                JCChart jCChart = (JCChart)this.mySolutnSetList.get(string);
                AbleGuiFuzzySetChartable ableGuiFuzzySetChartable = (AbleGuiFuzzySetChartable)jCChart.getDataView(0).getDataSource();
                AbleFuzzySet ableFuzzySet = ableGuiFuzzySetChartable.getSet(0);
                try {
                    jCChart.getFooter().setText("Solution: " + ableFuzzySet.getNumericValue());
                }
                catch (AbleDataException ableDataException) {
                    // empty catch block
                }
                ableGuiFuzzySetChartable.letEmKnow();
                this.myTable.tableChanged(new TableModelEvent(this.myTableModel));
                break;
            }
        }
    }

    public void setRuleSet(AbleRuleSet ableRuleSet) throws AbleDataException {
        this.myRuleSet = ableRuleSet;
        this.ruleSetChanged();
    }

    public void ruleSetChanged() throws AbleDataException {
        Vector vector = new Vector();
        int n = 2;
        this.mySolutnSetList.clear();
        Hashtable hashtable = this.myRuleSet.getVariables();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            String string;
            Object object3;
            AbleFuzzySet ableFuzzySet;
            AbleVariable ableVariable = (AbleVariable)enumeration.nextElement();
            int n2 = ableVariable.getDataType();
            if (n2 != 15) continue;
            String string2 = ableVariable.getName();
            String string3 = string2 + "(" + ((AbleFuzzyVariable)ableVariable).getDiscourseLo() + "," + ((AbleFuzzyVariable)ableVariable).getDiscourseHi() + ")";
            AbleFuzzySet ableFuzzySet2 = ((AbleFuzzyVariable)ableVariable).getFuzzyValue();
            Hashtable hashtable2 = ((AbleFuzzyVariable)ableVariable).getFuzzySets();
            Enumeration enumeration2 = hashtable2.elements();
            Hashtable<String, AbleFuzzySet> hashtable3 = new Hashtable<String, AbleFuzzySet>();
            Hashtable<String, Hashtable> hashtable4 = new Hashtable<String, Hashtable>();
            String string4 = "";
            Vector<AbleFuzzySet> vector2 = new Vector<AbleFuzzySet>();
            Vector<Object> vector3 = new Vector<Object>();
            Vector<String> vector4 = new Vector<String>();
            String string5 = "Solution: " + ableFuzzySet2.getNumericValue();
            Vector<AbleFuzzySet> vector5 = new Vector<AbleFuzzySet>();
            vector5.addElement(ableFuzzySet2);
            while (enumeration2.hasMoreElements()) {
                ableFuzzySet = (AbleFuzzySet)enumeration2.nextElement();
                object3 = ableFuzzySet.getSetName();
                int n3 = ((String)object3).indexOf(" ");
                if (n3 < 0) {
                    hashtable3.put((String)object3, ableFuzzySet);
                    if (vector2.size() > 0) {
                        string4 = string4 + "+";
                    }
                    string4 = string4 + (String)object3;
                    vector2.addElement(ableFuzzySet);
                    continue;
                }
                string = ((String)object3).substring(0, n3);
                object2 = ((String)object3).substring(n3 + 1);
                object = null;
                if (hashtable4.containsKey(string)) {
                    object = (Hashtable)hashtable4.get(string);
                    ((Hashtable)object).put(object2, ableFuzzySet);
                    continue;
                }
                object = new Hashtable();
                ((Hashtable)object).put(object2, ableFuzzySet);
                hashtable4.put(string, (Hashtable)object);
            }
            ableFuzzySet = this.createChart(string3, string5, vector5, true);
            vector3.addElement(ableFuzzySet);
            vector3.addElement(this.createChart(string2, string4, vector2, false));
            vector.addElement(vector3);
            this.mySolutnSetList.put(string2, ableFuzzySet);
            object3 = hashtable3.keys();
            while (object3.hasMoreElements()) {
                String string6 = (String)object3.nextElement();
                string = (AbleFuzzySet)hashtable3.get(string6);
                vector4 = new Vector();
                vector4.addElement(string);
                vector3 = new Vector();
                vector3.addElement(new String(""));
                vector3.addElement(this.createChart(string2, string6, vector4, true));
                if (hashtable4.containsKey(string6)) {
                    object2 = (Hashtable)hashtable4.get(string6);
                    object = ((Hashtable)object2).keys();
                    n = Math.max(n, ((Hashtable)object2).size() + 2);
                    while (object.hasMoreElements()) {
                        String string7 = (String)object.nextElement();
                        AbleFuzzySet ableFuzzySet3 = (AbleFuzzySet)((Hashtable)object2).get(string7);
                        String string8 = "";
                        string8 = string8 + AbleFuzzySet.HedgeRl((char)string7.charAt(0));
                        for (int i = 1; i < string7.length(); ++i) {
                            string8 = string8 + " " + AbleFuzzySet.HedgeRl((char)string7.charAt(i));
                        }
                        string8 = string8 + " " + string6;
                        vector4 = new Vector();
                        vector4.addElement(string);
                        vector4.addElement((String)ableFuzzySet3);
                        vector3.addElement(this.createChart(string2, string8, vector4, false));
                    }
                }
                vector.addElement(vector3);
            }
        }
        this.reloadPanel(vector, n);
    }

    private JCChart createChart(String string, String string2, Vector vector, boolean bl) {
        JCChart jCChart = null;
        JCAxis jCAxis = null;
        JCAxis jCAxis2 = null;
        Color color = bl ? new Color(255, 231, 186) : new Color(218, 200, 149);
        AbleGuiFuzzySetChartable ableGuiFuzzySetChartable = new AbleGuiFuzzySetChartable(vector);
        jCChart = new JCChart(0);
        jCAxis = jCChart.getDataView(0).getXAxis();
        jCAxis.setNumSpacing(256.0);
        jCAxis.setMaxIsDefault(true);
        jCAxis2 = jCChart.getDataView(0).getYAxis();
        jCAxis2.setGridIsShowing(true);
        jCAxis2.setMin(0.0);
        jCAxis2.setMax(1.0);
        try {
            jCChart.getDataView(0).setDataSource((Chartable)ableGuiFuzzySetChartable);
            jCChart.setPreferredSize(new Dimension(175, 135));
            jCChart.setAllowUserChanges(true);
            jCChart.setTrigger(0, new EventTrigger(4, 6));
            jCChart.setBackground(new Color(218, 200, 149));
            jCChart.setBorderType(8);
            jCChart.setBorderWidth(2);
            jCChart.getChartArea().setBackground(color);
            jCChart.getChartArea().setBorderType(9);
            jCChart.getChartArea().setBorderWidth(2);
            jCChart.getHeader().setText(string);
            jCChart.getHeader().setIsShowing(true);
            jCChart.getFooter().setText(string2);
            jCChart.getFooter().setIsShowing(true);
            for (int i = 0; i < vector.size(); ++i) {
                jCChart.getDataView(0).getSeries(i).getStyle().getSymbolStyle().setShape(0);
                jCChart.getDataView(0).getSeries(i).getStyle().getLineStyle().setColor(this.myColors[i < this.myColors.length ? i : i % this.myColors.length]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return jCChart;
    }

    private void reloadPanel(Vector vector, int n) {
        this.myTableData = vector;
        this.myMaxColumns = n;
        this.myTableModel = new AbstractTableModel(){

            public int getColumnCount() {
                return AbleGuiFuzzySetViewer.this.myMaxColumns;
            }

            public int getRowCount() {
                return AbleGuiFuzzySetViewer.this.myTableData.size();
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public Object getValueAt(int n, int n2) {
                Vector vector = (Vector)AbleGuiFuzzySetViewer.this.myTableData.elementAt(n);
                if (n2 >= vector.size()) {
                    return "";
                }
                return vector.elementAt(n2);
            }
        };
        this.myTable = new JTable(this.myTableModel);
        this.myTable.setAutoResizeMode(0);
        this.myTable.setSelectionMode(0);
        this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        this.myTable.setCellSelectionEnabled(false);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.setRowSelectionAllowed(false);
        this.myTable.setShowHorizontalLines(false);
        this.myTable.setShowVerticalLines(false);
        this.myTable.setBackground(new Color(218, 200, 149));
        for (int i = 0; i < this.myTable.getColumnCount(); ++i) {
            TableColumn tableColumn = this.myTable.getColumn(this.myTable.getColumnName(i));
            tableColumn.setCellRenderer(new AbleGuiFuzzySetRenderer());
            tableColumn.setMinWidth(175);
            if (i == 0) {
                tableColumn.setHeaderValue("Fuzzy Variable");
            }
            if (i == 1) {
                tableColumn.setHeaderValue("User-defined Sets");
            }
            if (i <= 1) continue;
            tableColumn.setHeaderValue("Hedged Sets " + new Integer(i - 1));
        }
        this.myTable.setRowHeight(135);
        this.myTable.sizeColumnsToFit(0);
        this.myScrollPane = new JScrollPane(this.myTable, 20, 30);
        this.myScrollPane.setBorder(new SoftBevelBorder(1));
        this.myChartPanel.removeAll();
        this.myChartPanel.invalidate();
        this.myChartPanel.add((Component)this.myScrollPane, "Center");
        this.myChartPanel.validate();
    }

    public String toString() {
        String string = "";
        string = string + "AbleGuiFuzzySetViewer----------------------------" + Able.LS;
        string = string + super.toString() + Able.LS;
        string = string + "--End AbleGuiFuzzySetViewer----------------------" + Able.LS;
        return string;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

