/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleProperty;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleFuzzyVariable;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleGuiFuzzySetChartable;
import com.ibm.able.rules.AbleGuiFuzzySetRenderer;
import com.ibm.able.rules.AbleRuleSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jclass.chart.Chartable;
import jclass.chart.EventTrigger;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;

public class AbleGuiFuzzySetInspector
extends JPanel
implements PropertyChangeListener,
Serializable {
    static final long serialVersionUID = 2000022500000000001L;
    private JTable myTable = null;
    private TableModel myTableModel = null;
    private Vector myTableData = null;
    private int myMaxColumns = 2;
    private JScrollPane myScrollPane = null;
    private JPanel myChartPanel = new JPanel();
    private AbleRuleSet myRuleSet = null;
    private Hashtable mySolutionSetList = new Hashtable();
    private Hashtable myWorkAreaSetList = new Hashtable();
    private Color[] myColors = new Color[]{Color.red, Color.cyan, Color.white, Color.green, Color.black};

    public AbleGuiFuzzySetInspector() {
        this.ctorHelper();
        this.myRuleSet = null;
    }

    public AbleGuiFuzzySetInspector(Object object) throws RemoteException {
        this.ctorHelper();
        this.setRuleSet((AbleRuleSet)object);
    }

    private void ctorHelper() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.myChartPanel, "Center");
        this.myChartPanel.setLayout(new BorderLayout());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        int n;
        AbleRuleSet ableRuleSet = (AbleRuleSet)propertyChangeEvent.getSource();
        String string2 = propertyChangeEvent.getPropertyName();
        int n2 = string2.indexOf(32);
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        if (n2 == -1) {
            n = AbleProperty.PropertyId((String)string2);
            string = "";
        } else {
            n = AbleProperty.PropertyId((String)string2.substring(0, n2));
            string = string2.substring(n2 + 1);
        }
        switch (n) {
            case 1227: {
                JCChart jCChart = (JCChart)this.mySolutionSetList.get(string);
                AbleGuiFuzzySetChartable ableGuiFuzzySetChartable = (AbleGuiFuzzySetChartable)jCChart.getDataView(0).getDataSource();
                AbleFuzzySet ableFuzzySet = ableGuiFuzzySetChartable.getSet(0);
                try {
                    jCChart.getFooter().setText("Solution: " + ableFuzzySet.getNumericValue());
                }
                catch (AbleDataException ableDataException) {
                    // empty catch block
                }
                ableGuiFuzzySetChartable.letEmKnow();
                this.myTable.tableChanged(new TableModelEvent(this.myTableModel));
                break;
            }
            case 1228: {
                JCChart jCChart = (JCChart)this.myWorkAreaSetList.get(string);
                AbleGuiFuzzySetChartable ableGuiFuzzySetChartable = (AbleGuiFuzzySetChartable)jCChart.getDataView(0).getDataSource();
                AbleFuzzySet ableFuzzySet = ableGuiFuzzySetChartable.getSet(0);
                try {
                    jCChart.getFooter().setText("Solution: " + ableFuzzySet.getNumericValue());
                }
                catch (AbleDataException ableDataException) {
                    // empty catch block
                }
                ableGuiFuzzySetChartable.letEmKnow();
                this.myTable.tableChanged(new TableModelEvent(this.myTableModel));
                break;
            }
        }
    }

    public void setRuleSet(AbleRuleSet ableRuleSet) throws RemoteException {
        if (this.myRuleSet != null) {
            this.myRuleSet.removeRuleSetChangeListener((PropertyChangeListener)this);
        }
        this.myRuleSet = ableRuleSet;
        this.ruleSetChanged();
        this.myRuleSet.addRuleSetChangeListener((PropertyChangeListener)this);
    }

    public void ruleSetChanged() throws AbleDataException {
        Vector vector = new Vector();
        int n = 2;
        this.mySolutionSetList.clear();
        this.myWorkAreaSetList.clear();
        Hashtable hashtable = this.myRuleSet.getVariables();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            AbleVariable ableVariable = (AbleVariable)enumeration.nextElement();
            int n2 = ableVariable.getDataType();
            if (n2 != 15) continue;
            String string = ableVariable.getName();
            String string2 = string + "(" + ((AbleFuzzyVariable)ableVariable).getDiscourseLo() + "," + ((AbleFuzzyVariable)ableVariable).getDiscourseHi() + ")";
            AbleFuzzySet ableFuzzySet = ((AbleFuzzyVariable)ableVariable).getFuzzyValue();
            AbleFuzzySet ableFuzzySet2 = ((AbleFuzzyVariable)ableVariable).getFuzzyWorkArea();
            String string3 = "Solution: " + ableFuzzySet.getNumericValue();
            Vector<AbleFuzzySet> vector2 = new Vector<AbleFuzzySet>();
            vector2.addElement(ableFuzzySet);
            String string4 = "Solution: " + ableFuzzySet2.getNumericValue();
            Vector<AbleFuzzySet> vector3 = new Vector<AbleFuzzySet>();
            vector3.addElement(ableFuzzySet2);
            JCChart jCChart = this.createChart(string2, string3, vector2, true);
            JCChart jCChart2 = this.createChart(string2, string4, vector3, true);
            Vector<JCChart> vector4 = new Vector<JCChart>();
            vector4.addElement(jCChart);
            vector4.addElement(jCChart2);
            vector.addElement(vector4);
            this.mySolutionSetList.put(string, jCChart);
            this.myWorkAreaSetList.put(string, jCChart2);
        }
        this.reloadPanel(vector, n);
    }

    private JCChart createChart(String string, String string2, Vector vector, boolean bl) {
        JCChart jCChart = null;
        JCAxis jCAxis = null;
        JCAxis jCAxis2 = null;
        Color color = bl ? new Color(255, 231, 186) : new Color(218, 200, 149);
        AbleGuiFuzzySetChartable ableGuiFuzzySetChartable = new AbleGuiFuzzySetChartable(vector);
        jCChart = new JCChart(0);
        jCAxis = jCChart.getDataView(0).getXAxis();
        jCAxis.setNumSpacing(256.0);
        jCAxis.setMaxIsDefault(true);
        jCAxis2 = jCChart.getDataView(0).getYAxis();
        jCAxis2.setGridIsShowing(true);
        jCAxis2.setMin(0.0);
        jCAxis2.setMax(1.0);
        try {
            jCChart.getDataView(0).setDataSource((Chartable)ableGuiFuzzySetChartable);
            jCChart.setPreferredSize(new Dimension(175, 135));
            jCChart.setAllowUserChanges(true);
            jCChart.setTrigger(0, new EventTrigger(4, 6));
            jCChart.setBackground(new Color(218, 200, 149));
            jCChart.setBorderType(8);
            jCChart.setBorderWidth(2);
            jCChart.getChartArea().setBackground(color);
            jCChart.getChartArea().setBorderType(9);
            jCChart.getChartArea().setBorderWidth(2);
            jCChart.getHeader().setText(string);
            jCChart.getHeader().setIsShowing(true);
            jCChart.getFooter().setText(string2);
            jCChart.getFooter().setIsShowing(true);
            for (int i = 0; i < vector.size(); ++i) {
                jCChart.getDataView(0).getSeries(i).getStyle().getSymbolStyle().setShape(0);
                jCChart.getDataView(0).getSeries(i).getStyle().getLineStyle().setColor(this.myColors[i < this.myColors.length ? i : i % this.myColors.length]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return jCChart;
    }

    private void reloadPanel(Vector vector, int n) {
        this.myTableData = vector;
        this.myMaxColumns = n;
        this.myTableModel = new AbstractTableModel(){

            public int getColumnCount() {
                return AbleGuiFuzzySetInspector.this.myMaxColumns;
            }

            public int getRowCount() {
                return AbleGuiFuzzySetInspector.this.myTableData.size();
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public Object getValueAt(int n, int n2) {
                Vector vector = (Vector)AbleGuiFuzzySetInspector.this.myTableData.elementAt(n);
                if (n2 >= vector.size()) {
                    return "";
                }
                return vector.elementAt(n2);
            }
        };
        this.myTable = new JTable(this.myTableModel);
        this.myTable.setAutoResizeMode(0);
        this.myTable.setSelectionMode(0);
        this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        this.myTable.setCellSelectionEnabled(false);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.setRowSelectionAllowed(false);
        this.myTable.setShowHorizontalLines(false);
        this.myTable.setShowVerticalLines(false);
        this.myTable.setBackground(new Color(218, 200, 149));
        TableColumn tableColumn = this.myTable.getColumn(this.myTable.getColumnName(0));
        tableColumn.setCellRenderer(new AbleGuiFuzzySetRenderer());
        tableColumn.setMinWidth(175);
        tableColumn.setHeaderValue("Fuzzy Variable");
        tableColumn = this.myTable.getColumn(this.myTable.getColumnName(1));
        tableColumn.setCellRenderer(new AbleGuiFuzzySetRenderer());
        tableColumn.setMinWidth(175);
        tableColumn.setHeaderValue("Work Area");
        this.myTable.setRowHeight(135);
        this.myTable.sizeColumnsToFit(0);
        this.myScrollPane = new JScrollPane(this.myTable, 20, 30);
        this.myScrollPane.setBorder(new SoftBevelBorder(1));
        this.myChartPanel.removeAll();
        this.myChartPanel.invalidate();
        this.myChartPanel.add((Component)this.myScrollPane, "Center");
        this.myChartPanel.validate();
    }

    public String toString() {
        String string = "";
        string = string + "AbleGuiFuzzySetInspector-------------------------" + Able.LS;
        string = string + super.toString() + Able.LS;
        string = string + "--End AbleGuiFuzzySetInspector-------------------" + Able.LS;
        return string;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

