/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleUserDefinedFunction;
import com.ibm.able.editor.AbleGridBagConstraints;
import com.ibm.able.platform.AblePlatform;
import com.ibm.able.platform.AblePlatformDefaultAgent;
import com.ibm.able.platform.AblePlatformDefaultAgentCustomizer;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;

public class AblePlatformDefaultAgentPanel
extends JPanel
implements AbleCustomizerPanel {
    private AblePlatformDefaultAgent myAgent = null;
    private AblePlatformDefaultAgentCustomizer myCustomizer = null;
    private JTextField myAgentTypeTextField = null;
    private JTextField myAgentVersionTextField = null;
    private JTextField myAgentVendorTextField = null;
    private JCheckBox myAgentToBindToRmiCheckBox = null;
    private JCheckBox myAgentMovableCheckBox = null;
    private JCheckBox myAgentToAutoRegisterCheckBox = null;
    private JComboBox myAgentHostComboBox = null;
    private InboxTableModel myInboxTableModel = null;
    private JTextField myAgentPoolTextField = null;
    private AttributesTableModel myAttributesTableModel = null;
    private JLabel myAgentNameLabel = null;
    private JLabel myAgentJasNameLabel = null;
    private JLabel myAgentHostLabel = null;
    private JLabel myAgentAutonomyLevelLabel = null;
    private JLabel myAgentAddressLabel = null;
    private JLabel myAgentStatusLabel = null;
    private JLabel myAgentLastUpdateLabel = null;
    private JLabel myAgentSummaryLabel = null;

    private AblePlatformDefaultAgentPanel() {
    }

    public AblePlatformDefaultAgentPanel(AblePlatformDefaultAgentCustomizer ablePlatformDefaultAgentCustomizer) {
        this.myCustomizer = ablePlatformDefaultAgentCustomizer;
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        if (this.myAgent == null) {
            this.myAgent = (AblePlatformDefaultAgent)object;
        }
        this.myAgentTypeTextField.setText(this.myAgent.getAgentType());
        this.myAgentVersionTextField.setText(this.myAgent.getAgentVersion());
        this.myAgentVendorTextField.setText(this.myAgent.getAgentVendor());
        this.myAgentToBindToRmiCheckBox.setSelected(this.myAgent.isAgentToBindToRmi());
        this.myAgentMovableCheckBox.setSelected(this.myAgent.isAgentMovable());
        this.myAgentToAutoRegisterCheckBox.setSelected(this.myAgent.isAgentToAutoRegister());
        this.myAgentNameLabel.setText(this.myAgent.getAgentName());
        this.myAgentHostComboBox.setSelectedItem(this.myAgent.getAgentHost());
        this.myInboxTableModel.setData(this.myAgent);
        this.myAttributesTableModel.setData(this.myAgent.getJasAgentAttributes());
        String string = this.myAgent.getJasAgentName();
        if (string != null) {
            this.myAgentJasNameLabel.setText(string);
            this.myAgentJasNameLabel.setToolTipText(string);
        }
        this.myAgentAutonomyLevelLabel.setText(this.myAgent.getAgentAutonomyLevel() + ". " + AblePlatform.AutonomyLevel((int)this.myAgent.getAgentAutonomyLevel()).getMessageID());
        this.myAgentHostLabel.setText(this.myAgent.getAgentHost());
        this.myAgentAddressLabel.setText(this.myAgent.getAgentAddr());
        this.myAgentStatusLabel.setText(this.myAgent.getAgentStatus());
        String string2 = this.myAgent.getAgentLastUpdate().toString();
        this.myAgentLastUpdateLabel.setText("Last update: " + string2);
        this.myAgentLastUpdateLabel.setToolTipText(string2);
        this.myAgentSummaryLabel.setText(this.myAgent.getAgentSummary().toString());
    }

    public void setDataOnBean() throws RemoteException {
        this.myAgent.setAgentType(this.myAgentTypeTextField.getText());
        this.myAgent.setAgentVersion(this.myAgentVersionTextField.getText());
        this.myAgent.setAgentVendor(this.myAgentVendorTextField.getText());
        AblePlatform.Preferences.setLocalAgentPool(this.myAgentPoolTextField.getText());
        this.myAgent.setAgentToBindToRmi(this.myAgentToBindToRmiCheckBox.isSelected());
        this.myAgent.setAgentMovable(this.myAgentMovableCheckBox.isSelected());
        this.myAgent.setAgentToAutoRegister(this.myAgentToAutoRegisterCheckBox.isSelected());
        this.myInboxTableModel.setDataOnBean(this.myAgent);
        this.myAttributesTableModel.setDataOnBean(this.myAgent);
    }

    private void initializePanel() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add((Component)new JLabel("Type:"), new AbleGridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.myAgentTypeTextField = new JTextField();
        this.add((Component)this.myAgentTypeTextField, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)new JLabel("Version:"), new AbleGridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.myAgentVersionTextField = new JTextField();
        this.add((Component)this.myAgentVersionTextField, new AbleGridBagConstraints(3, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)new JLabel("Vendor:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.myAgentVendorTextField = new JTextField();
        this.add((Component)this.myAgentVendorTextField, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)new JLabel("Host:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.myAgentHostComboBox = new JComboBox();
        this.myAgentHostComboBox.addItem("localhost");
        this.add((Component)this.myAgentHostComboBox, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)new JLabel("Local pool:"), new AbleGridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.myAgentPoolTextField = new JTextField();
        this.add((Component)this.myAgentPoolTextField, new AbleGridBagConstraints(3, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.add((Component)jPanel, new AbleGridBagConstraints(0, ++n, 4, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.myAgentToBindToRmiCheckBox = new JCheckBox("Bind to RMI");
        jPanel.add((Component)this.myAgentToBindToRmiCheckBox, new AbleGridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.myAgentMovableCheckBox = new JCheckBox("Movable");
        jPanel.add((Component)this.myAgentMovableCheckBox, new AbleGridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.myAgentToAutoRegisterCheckBox = new JCheckBox("AutoRegister");
        jPanel.add((Component)this.myAgentToAutoRegisterCheckBox, new AbleGridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)new JLabel("Agent attributes"), new AbleGridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)new JLabel("Message inboxes"), new AbleGridBagConstraints(2, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.myAttributesTableModel = new AttributesTableModel();
        this.add((Component)new JScrollPane(this.myAttributesTableModel.getTable()), new AbleGridBagConstraints(0, ++n, 2, 1, 0.5, 0.5, 17, 1, new Insets(5, 10, 0, 0), 0, 0));
        this.myInboxTableModel = new InboxTableModel();
        this.add((Component)new JScrollPane(this.myInboxTableModel.getTable()), new AbleGridBagConstraints(2, n, 2, 1, 0.5, 0.5, 17, 1, new Insets(5, 10, 0, 10), 0, 0));
        JButton jButton = new JButton("Initialize");
        jButton.setToolTipText("Initialize the agent");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AblePlatformDefaultAgentPanel.this.InitializeButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)jButton, new AbleGridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 50, 10, 50), 100, 0));
        JButton jButton2 = new JButton("Reset");
        jButton2.setToolTipText("Reset the agent");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AblePlatformDefaultAgentPanel.this.ResetButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)jButton2, new AbleGridBagConstraints(2, n, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 50, 10, 50), 100, 0));
        this.add((Component)new JLabel("Agent name:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.myAgentNameLabel = new JLabel();
        this.add((Component)this.myAgentNameLabel, new AbleGridBagConstraints(1, n, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)new JLabel("JAS name:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.myAgentJasNameLabel = new JLabel();
        this.add((Component)this.myAgentJasNameLabel, new AbleGridBagConstraints(1, n, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)new JLabel("Autonomy level:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.myAgentAutonomyLevelLabel = new JLabel();
        this.add((Component)this.myAgentAutonomyLevelLabel, new AbleGridBagConstraints(1, n, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.myAgentHostLabel = new JLabel();
        this.myAgentAddressLabel = new JLabel();
        this.add((Component)new JLabel("Status:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.myAgentStatusLabel = new JLabel();
        this.add((Component)this.myAgentStatusLabel, new AbleGridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.myAgentLastUpdateLabel = new JLabel();
        this.add((Component)this.myAgentLastUpdateLabel, new AbleGridBagConstraints(2, n, 2, 1, 0.5, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)new JLabel("Summary:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 0), 0, 0));
        this.myAgentSummaryLabel = new JLabel();
        this.add((Component)this.myAgentSummaryLabel, new AbleGridBagConstraints(1, n, 3, 1, 0.5, 0.0, 17, 2, new Insets(5, 10, 10, 10), 0, 0));
    }

    private void addPropertyListeners() {
        this.myCustomizer.addPropertyChangeMethod("ableEventProcessingEnabled", this, "refreshPanel");
    }

    private void InitializeButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            this.myCustomizer.updateProperties();
            this.myAgent.init();
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
            this.myCustomizer.setObject(this.myAgent);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getLocalizedMessage(), "AblePlatformDefaultAgentPanel Error: InitializeButton()", 0);
        }
    }

    private void ResetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myCustomizer.updateProperties();
            this.myAgent.reset();
            this.myCustomizer.setObject(this.myAgent);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getLocalizedMessage(), "AblePlatformDefaultAgentPanel Error: ResetButton()", 0);
        }
    }

    public void refreshPanel(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.getDataFromBean(this.myAgent);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this.myCustomizer, "Panel values for training changed, but were not updated." + Able.LS + remoteException.toString(), "AblePlatformDefaultAgentPanel Warning: refreshPanel()", 2);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "jas/doc-files/AblePlatformDefaultAgentHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    class InboxTableModel
    extends AbstractTableModel
    implements ActionListener {
        private JTable table = null;
        private Vector attributes = new Vector();
        private Vector values = new Vector();
        Vector[] data = new Vector[]{this.attributes, this.values};
        private final String[] columnNames = new String[]{"Name", "Method"};
        private final String NewAtt = "<New>";
        private final String NewVal = "";
        private JComboBox methodComboBox = null;
        private Hashtable inboxMethods = null;
        private Vector inboxMethodNames = null;

        public InboxTableModel() {
            this.table = new JTable();
            this.table.setModel(this);
            this.methodComboBox = new JComboBox();
            this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.methodComboBox));
            this.table.setCellSelectionEnabled(true);
            this.addKeyListeners();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.attributes.size();
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n2].elementAt(n);
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public JTable getTable() {
            return this.table;
        }

        public Vector[] getData() {
            return this.data;
        }

        private void setInboxMethods(AblePlatformDefaultAgent ablePlatformDefaultAgent) {
            this.inboxMethodNames = new Vector();
            this.inboxMethods = new Hashtable();
            Method[] methodArray = ablePlatformDefaultAgent.getClass().getMethods();
            try {
                Class<?> clazz = Class.forName("javax.agent.TransportMessage");
                for (int i = 0; i < methodArray.length; ++i) {
                    Class<?>[] classArray = methodArray[i].getParameterTypes();
                    if (classArray.length != 1 || !classArray[0].equals(clazz)) continue;
                    String string = methodArray[i].getName();
                    this.inboxMethodNames.addElement(string);
                    this.inboxMethods.put(string, methodArray[i]);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println(classNotFoundException.getLocalizedMessage());
                classNotFoundException.printStackTrace();
            }
            this.methodComboBox.setModel(new DefaultComboBoxModel(this.inboxMethodNames));
        }

        public void setData(AblePlatformDefaultAgent ablePlatformDefaultAgent) {
            this.attributes.removeAllElements();
            this.values.removeAllElements();
            this.setInboxMethods(ablePlatformDefaultAgent);
            Vector vector = ablePlatformDefaultAgent.getAgentInboxes();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                this.attributes.add(objectArray[0]);
                this.values.add(((AbleUserDefinedFunction)objectArray[1]).getMethodName());
            }
            this.attributes.addElement("<New>");
            this.values.addElement("");
            this.fireTableRowsInserted(0, this.attributes.size());
        }

        public void setDataOnBean(AblePlatformDefaultAgent ablePlatformDefaultAgent) {
            ablePlatformDefaultAgent.removeAgentInboxes();
            for (int i = 0; i < this.attributes.size(); ++i) {
                if (this.attributes.elementAt(i).equals("<New>")) continue;
                Object[] objectArray = new Object[2];
                objectArray[0] = this.attributes.elementAt(i);
                Method method = (Method)this.inboxMethods.get(this.values.elementAt(i));
                objectArray[1] = new AbleUserDefinedFunction(method.getName(), (Object)ablePlatformDefaultAgent, method);
                ablePlatformDefaultAgent.addAgentInbox(objectArray);
            }
        }

        public boolean isCellEditable(int n, int n2) {
            boolean bl = false;
            switch (n2) {
                case 0: {
                    bl = this.getValueAt(n, n2).equals("<New>");
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    if (object.equals("<New>")) {
                        JOptionPane.showMessageDialog(this.table, "Conversation name not allowed; provide another name.", "Invalid name", 0);
                        break;
                    }
                    this.attributes.setElementAt(object, n);
                    if (this.attributes.contains("<New>")) break;
                    this.attributes.add("<New>");
                    this.values.add("");
                    this.fireTableRowsInserted(this.attributes.size() - 1, 1);
                    break;
                }
                case 1: {
                    this.values.setElementAt(object, n);
                    break;
                }
            }
        }

        private void addKeyListeners() {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
            this.table.registerKeyboardAction(this, "Delete", keyStroke, 0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            String string = actionEvent.getActionCommand();
            if (string.compareTo("Delete") == 0 && this.table.columnAtPoint(this.table.getLocation()) == 0 && !this.attributes.elementAt(n = this.table.rowAtPoint(this.table.getLocation())).equals("<New>")) {
                this.attributes.removeElementAt(n);
                this.values.removeElementAt(n);
                this.fireTableRowsDeleted(n, 1);
            }
        }
    }

    class AttributesTableModel
    extends AbstractTableModel
    implements ActionListener {
        private JTable table = null;
        private Vector attributes = new Vector();
        private Vector values = new Vector();
        Vector[] data = new Vector[]{this.attributes, this.values};
        private final String[] columnNames = new String[]{"Attribute", "Value"};
        private final String NewAtt = "<New>";
        private final String NewVal = "";

        public AttributesTableModel() {
            this.table = new JTable();
            this.table.setModel(this);
            this.table.setCellSelectionEnabled(true);
            this.addKeyListeners();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.attributes.size();
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n2].elementAt(n);
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public JTable getTable() {
            return this.table;
        }

        public Vector[] getData() {
            return this.data;
        }

        public void setData(Hashtable hashtable) {
            this.attributes.removeAllElements();
            this.values.removeAllElements();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                this.attributes.add(k);
                this.values.add(hashtable.get(k));
            }
            this.attributes.addElement("<New>");
            this.values.addElement("");
            this.fireTableRowsInserted(0, this.attributes.size());
        }

        public void setDataOnBean(AblePlatformDefaultAgent ablePlatformDefaultAgent) throws RemoteException {
            Object object;
            Hashtable hashtable = ablePlatformDefaultAgent.getJasAgentAttributes();
            Vector vector = (Vector)this.attributes.clone();
            vector.remove("<New>");
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (!vector.contains(object)) {
                    ablePlatformDefaultAgent.removeJasAgentAttribute((String)object);
                    continue;
                }
                int n = this.attributes.indexOf(object);
                ablePlatformDefaultAgent.addJasAgentAttribute((String)object, this.values.elementAt(n));
                vector.remove(object);
            }
            object = vector.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                int n = this.attributes.indexOf(string);
                ablePlatformDefaultAgent.addJasAgentAttribute(string, this.values.elementAt(n));
            }
        }

        public boolean isCellEditable(int n, int n2) {
            boolean bl = false;
            switch (n2) {
                case 0: {
                    bl = this.getValueAt(n, n2).equals("<New>");
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    if (object.equals("<New>")) {
                        JOptionPane.showMessageDialog(this.table, "Attribute '" + object + "' not allowed; provide another name.", "Invalid attribute name", 0);
                        break;
                    }
                    if (this.attributes.contains(object)) {
                        JOptionPane.showMessageDialog(this.table, "Attribute not allowed; '" + object + "' is already in use.", "Duplicate attribute name", 0);
                        break;
                    }
                    this.attributes.setElementAt(object, n);
                    if (this.attributes.contains("<New>")) break;
                    this.attributes.add("<New>");
                    this.values.add("");
                    this.fireTableRowsInserted(this.attributes.size() - 1, 1);
                    break;
                }
                case 1: {
                    this.values.setElementAt(object, n);
                    break;
                }
            }
        }

        private void addKeyListeners() {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
            this.table.registerKeyboardAction(this, "Delete", keyStroke, 0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            String string = actionEvent.getActionCommand();
            if (string.compareTo("Delete") == 0 && this.table.columnAtPoint(this.table.getLocation()) == 0 && !this.attributes.elementAt(n = this.table.rowAtPoint(this.table.getLocation())).equals("<New>")) {
                this.attributes.removeElementAt(n);
                this.values.removeElementAt(n);
                this.fireTableRowsDeleted(n, 1);
            }
        }
    }
}

