/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizer;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObject;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.AbleUserDefinedFunctionPanel;
import com.ibm.able.editor.AbleJarInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AbleUserDefinedFunctionDialog
extends JDialog
implements AbleCustomizer {
    private boolean isCancelled = false;
    private AbleObject myAbleObject = null;
    private PropertyChangeSupport myChgSupport = null;
    private AbleUserDefinedFunctionPanel myPanel = null;
    private JFrame myFrameParent = null;
    private URL myHelpURL = null;

    private AbleUserDefinedFunctionDialog() {
    }

    public AbleUserDefinedFunctionDialog(JFrame jFrame, String string) {
        super(jFrame, string, false);
        this.setVisible(false);
        this.myFrameParent = jFrame;
        this.initializePanel();
        this.setAbleHelpURL("docs/AbleObjectCustomizer.html");
    }

    private void initializePanel() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(525, 430);
        this.constructButtons();
        this.myPanel = new AbleUserDefinedFunctionPanel(null);
        this.getContentPane().add((Component)this.myPanel, "North");
    }

    private void constructButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.getContentPane().add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "East");
        JButton jButton = AblePanelHelper.addButton(jPanel2, "OK", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleUserDefinedFunctionDialog.this.OKButton_actionPerformed(actionEvent);
            }
        }, "");
        jButton.setRequestFocusEnabled(false);
        AblePanelHelper.addButton(jPanel2, "Cancel", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleUserDefinedFunctionDialog.this.CancelButton_actionPerformed(actionEvent);
            }
        }, "");
        jPanel2.add(Box.createHorizontalStrut(40));
        AblePanelHelper.addButton(jPanel2, "Help", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleUserDefinedFunctionDialog.this.HelpButton_actionPerformed(actionEvent);
            }
        }, "");
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.myFrameParent != null) {
                Point point = new Point(this.myFrameParent.getLocation().x + 15, this.myFrameParent.getLocation().y + 15);
                this.setLocation(point);
            } else {
                this.setLocation(50, 50);
            }
        }
        super.setVisible(bl);
    }

    public void setObject(Object object) {
        try {
            this.myAbleObject = (AbleObject)object;
            this.myPanel.getDataFromBean(this.myAbleObject);
            BeanInfo beanInfo = AbleJarInfo.getBeanInfo(this.myAbleObject.getClass());
            this.setTitle(this.myAbleObject.getName() + " user-defined functions");
            if (this.myFrameParent != null) {
                this.myFrameParent.setIconImage(beanInfo.getIcon(1));
            }
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this, remoteException.getLocalizedMessage(), "AbleUserDefinedFunctionDialog Error: setObject()", 0);
            Able.TraceLog.exception(262144L, (Object)this, "setObject()", (Throwable)remoteException);
        }
    }

    public void updateObject() throws RemoteException {
        this.myPanel.setDataOnBean();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myChgSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myChgSupport.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void OKButton_actionPerformed(ActionEvent actionEvent) {
        this.isCancelled = false;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.updateObject();
            this.endCustomizer(false);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this, remoteException.toString(), "Editor Error: setDataOnBean()", 0);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CancelButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.endCustomizer(true);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this, remoteException.toString(), "Editor Error: CancelButton_actionPerformed()", 0);
        }
        finally {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void endCustomizer(boolean bl) throws RemoteException {
        this.isCancelled = bl;
        this.setVisible(false);
        this.dispose();
    }

    public boolean userCancelled() {
        return this.isCancelled;
    }

    private void HelpButton_actionPerformed(ActionEvent actionEvent) {
        if (this.myHelpURL != null) {
            AbleHelp.displayHelpURL(this, this.myHelpURL);
        } else {
            JOptionPane.showMessageDialog(this, "No help file specified.", "AbleObjectCustomizer.html Warning", 2);
        }
    }

    public URL getHelpURL() {
        return this.myHelpURL;
    }

    public void setHelpURL(URL uRL, String string) {
        try {
            URL uRL2;
            this.myHelpURL = uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(this, malformedURLException.toString(), "AbleObjectCustomizer.setHelpURL Warning", 2);
        }
    }

    public void setAbleHelpURL(String string) {
        String string2 = "docs/AbleObjectCustomizer.html";
        if (string != null) {
            string2 = string;
        }
        this.setHelpURL(Able.HomeUrl, string2);
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

