/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class AblePrintPreviewDialog
extends JDialog
implements ActionListener {
    protected JButton nextButton;
    protected JButton previousButton;
    protected JButton closeButton;
    private PrintPreviewCanvas canvas;

    public AblePrintPreviewDialog(Printable printable, PageFormat pageFormat, int n) {
        Book book = new Book();
        book.append(printable, pageFormat, n);
        this.layoutUI(book);
    }

    public AblePrintPreviewDialog(Book book) {
        this.layoutUI(book);
    }

    public void layoutUI(Book book) {
        this.setSize(300, 300);
        Container container = this.getContentPane();
        this.canvas = new PrintPreviewCanvas(book);
        container.add((Component)this.canvas, "Center");
        JPanel jPanel = new JPanel();
        this.nextButton = new JButton("Next");
        jPanel.add(this.nextButton);
        this.nextButton.addActionListener(this);
        this.previousButton = new JButton("Previous");
        jPanel.add(this.previousButton);
        this.previousButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        jPanel.add(this.closeButton);
        this.closeButton.addActionListener(this);
        container.add((Component)jPanel, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.nextButton) {
            this.canvas.flipPage(1);
        } else if (object == this.previousButton) {
            this.canvas.flipPage(-1);
        } else if (object == this.closeButton) {
            this.setVisible(false);
        }
    }

    class PrintPreviewCanvas
    extends JPanel {
        protected Book book;
        protected int currentPage;

        public PrintPreviewCanvas(Book book) {
            this.book = book;
            this.currentPage = 0;
        }

        public void paintComponent(Graphics graphics) {
            double d;
            double d2;
            double d3;
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            PageFormat pageFormat = this.book.getPageFormat(this.currentPage);
            double d4 = pageFormat.getWidth();
            double d5 = pageFormat.getHeight();
            double d6 = this.getWidth() - 1;
            double d7 = this.getHeight() - 1;
            if (d4 / d5 < d6 / d7) {
                d3 = d7 / d5;
                d2 = 0.5 * (d6 - d3 * d4);
                d = 0.0;
            } else {
                d3 = d6 / d4;
                d2 = 0.0;
                d = 0.5 * (d7 - d3 * d5);
            }
            graphics2D.translate((float)d2, (float)d);
            graphics2D.scale((float)d3, (float)d3);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d4, d5);
            graphics2D.setPaint(Color.white);
            graphics2D.fill(double_);
            graphics2D.setPaint(Color.black);
            graphics2D.draw(double_);
            Printable printable = this.book.getPrintable(this.currentPage);
            try {
                printable.print(graphics2D, pageFormat, this.currentPage);
            }
            catch (PrinterException printerException) {
                System.out.println("Print error: " + printerException.toString());
                graphics2D.draw(new Line2D.Double(0.0, 0.0, d4, d5));
                graphics2D.draw(new Line2D.Double(0.0, d4, 0.0, d5));
            }
        }

        public void flipPage(int n) {
            int n2 = this.currentPage + n;
            if (0 <= n2 && n2 < this.book.getNumberOfPages()) {
                this.currentPage = n2;
                this.repaint();
            }
        }
    }
}

