/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.AbleBean;
import com.ibm.able.editor.AbleEditorFrame;
import com.ibm.able.editor.AbleSeriesItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AbleParametersDialog
extends JDialog {
    JPanel xPn_Dialog = new JPanel(new BorderLayout());
    JPanel xPn_Button = new JPanel();
    JButton xBt_Ok = new JButton();
    JButton xBt_Cancel = new JButton();
    JButton xBt_Help = new JButton();
    AbleBean myUnderlyingObject;
    Object[] myParameterNames;
    Object[] myArrayNames;
    Hashtable myArrays;
    Vector mySeriesData;
    Vector myLocalSeriesData;
    int myNumDataPoints;
    int myArraySize = 0;
    boolean myCancelledFlag = true;
    JList xLst_Parms = null;
    JList xLst_Arrays = null;
    JList xLst_Selected = null;
    JButton xBtn_Add = null;
    JButton xBtn_Rem = null;
    JButton xBtn_RemAll = null;
    DocumentListener xDoL_Index = null;
    ChangeListener xChL_Index = null;
    JTextField xTxF_Index = null;
    JLabel xLbl_Index = null;
    JSlider xSld_Index = null;
    JTextField xTxF_DataPts = null;

    public AbleParametersDialog() {
        this(null, "", false, null, new Object[]{""}, new Object[]{""}, new Hashtable(), new Vector(), 1);
    }

    public AbleParametersDialog(JFrame jFrame, String string, boolean bl, AbleBean ableBean, Object[] objectArray, Object[] objectArray2, Hashtable hashtable, Vector vector, int n) {
        super(jFrame, string, bl);
        this.myUnderlyingObject = ableBean;
        this.myParameterNames = this.sort(objectArray);
        this.myArrayNames = this.sort(objectArray2);
        this.myArrays = hashtable;
        this.mySeriesData = vector;
        this.myLocalSeriesData = (Vector)vector.clone();
        this.myNumDataPoints = n;
        try {
            this.ctorHelperInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    Object[] sort(Object[] objectArray) {
        int n;
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n2];
        for (n = 0; n < n2; ++n) {
            objectArray2[n] = objectArray[n];
        }
        for (n = 0; n != n2; ++n) {
            for (int i = n + 1; i < n2; ++i) {
                if (((String)objectArray2[i]).compareTo((String)objectArray2[n]) >= 0) continue;
                Object object = objectArray2[n];
                objectArray2[n] = objectArray2[i];
                objectArray2[i] = object;
            }
        }
        return objectArray2;
    }

    public void setData(AbleBean ableBean, Object[] objectArray, Object[] objectArray2, Hashtable hashtable, Vector vector, int n) {
        this.myUnderlyingObject = ableBean;
        this.myParameterNames = this.sort(objectArray);
        this.myArrayNames = this.sort(objectArray2);
        this.myArrays = hashtable;
        this.mySeriesData = vector;
        this.myLocalSeriesData = (Vector)vector.clone();
        this.myNumDataPoints = n;
        this.xLst_Parms.setListData(this.myParameterNames);
        this.xLst_Arrays.setListData(this.myArrayNames);
        this.xLst_Selected.setListData(this.myLocalSeriesData);
        this.xTxF_DataPts.setText(String.valueOf(this.myNumDataPoints));
    }

    public Vector getData() {
        return this.myLocalSeriesData;
    }

    public void setNumDataPoints(int n) {
        this.myNumDataPoints = n;
        this.xTxF_DataPts.setText(String.valueOf(this.myNumDataPoints));
    }

    public int getNumDataPoints() {
        String string = this.xTxF_DataPts.getText().trim();
        this.myNumDataPoints = Integer.parseInt(string);
        return this.myNumDataPoints;
    }

    public boolean userCancelled() {
        return this.myCancelledFlag;
    }

    void ctorHelperInit() throws Exception {
        JLabel jLabel = new JLabel("Available Properties");
        jLabel.setDisplayedMnemonic('A');
        jLabel.setToolTipText("Properties available for inspection");
        jLabel.setLabelFor(this.xLst_Parms);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        this.xLst_Parms = new JList<Object>(this.myParameterNames);
        this.xLst_Parms.setSelectionMode(2);
        this.xLst_Parms.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AbleParametersDialog.this.xLst_Parms_valueChanged(listSelectionEvent);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.xLst_Parms);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        this.xLst_Arrays = new JList<Object>(this.myArrayNames);
        this.xLst_Arrays.setSelectionMode(0);
        this.xLst_Arrays.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AbleParametersDialog.this.xLst_Arrays_valueChanged(listSelectionEvent);
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.xLst_Arrays);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jScrollPane2, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel2, "North");
        jPanel4.add((Component)jPanel3, "Center");
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                AbleParametersDialog.this.xTxF_DataPts_docChanged(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                AbleParametersDialog.this.xTxF_DataPts_docChanged(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                AbleParametersDialog.this.xTxF_DataPts_docChanged(documentEvent);
            }
        };
        this.xTxF_DataPts = new JTextField(String.valueOf(this.myNumDataPoints));
        this.xTxF_DataPts.getDocument().addDocumentListener(documentListener);
        JLabel jLabel2 = new JLabel("Number of data points:");
        jLabel2.setDisplayedMnemonic('N');
        jLabel2.setToolTipText("Number of ticks on time-series graph");
        jLabel2.setLabelFor(this.xTxF_DataPts);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jLabel2, "North");
        jPanel5.add((Component)this.xTxF_DataPts, "Center");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel, "North");
        jPanel6.add((Component)jPanel4, "Center");
        jPanel6.add((Component)jPanel5, "South");
        Dimension dimension = null;
        this.xBtn_Add = new JButton("Add ->");
        this.xBtn_Add.setEnabled(false);
        this.xBtn_Add.setToolTipText("Add properties to the 'selected' list");
        this.xBtn_Add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleParametersDialog.this.xBtn_Add_actionPerformed(actionEvent);
            }
        });
        this.xBtn_Rem = new JButton("<- Remove");
        this.xBtn_Rem.setEnabled(false);
        this.xBtn_Rem.setToolTipText("Remove properties from the 'selected' list");
        this.xBtn_Rem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleParametersDialog.this.xBtn_Rem_actionPerformed(actionEvent);
            }
        });
        dimension = this.xBtn_Rem.getSize();
        JPanel jPanel7 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel8 = new JPanel(new BorderLayout());
        JPanel jPanel9 = new JPanel(new BorderLayout());
        JPanel jPanel10 = new JPanel(new BorderLayout());
        JPanel jPanel11 = new JPanel(new BorderLayout());
        jPanel7.add(this.xBtn_Add);
        jPanel7.add(this.xBtn_Rem);
        jPanel8.add((Component)new JLabel("  "), "North");
        jPanel8.add((Component)new JLabel("               "), "West");
        jPanel8.add((Component)new JLabel("               "), "East");
        jPanel8.add((Component)jPanel7, "Center");
        jPanel8.add((Component)new JLabel("  "), "South");
        jPanel9.add((Component)new JLabel("  "), "North");
        jPanel9.add((Component)jPanel8, "Center");
        jPanel9.add((Component)new JLabel("  "), "South");
        jPanel10.add((Component)new JLabel("  "), "Center");
        dimension = jPanel11.getSize();
        jPanel11.setSize(50, dimension.height);
        jPanel11.add((Component)jPanel9, "North");
        jPanel11.add((Component)jPanel10, "Center");
        jPanel11.add((Component)new JLabel("  "), "South");
        this.xLbl_Index = new JLabel("0..100");
        this.xDoL_Index = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                AbleParametersDialog.this.xTxF_Index_docChanged(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                AbleParametersDialog.this.xTxF_Index_docChanged(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                AbleParametersDialog.this.xTxF_Index_docChanged(documentEvent);
            }
        };
        this.xTxF_Index = new JTextField("0", 4);
        this.xTxF_Index.setEnabled(false);
        this.xTxF_Index.getDocument().addDocumentListener(this.xDoL_Index);
        this.xChL_Index = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AbleParametersDialog.this.xSld_Index_stateChanged(changeEvent);
            }
        };
        this.xSld_Index = new JSlider(0, 0, 100, 0);
        this.xSld_Index.setEnabled(false);
        this.xSld_Index.setToolTipText("Set the index for the selected array and then press 'Add'");
        this.xSld_Index.addChangeListener(this.xChL_Index);
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(1), "Array Element", 2, 2);
        CompoundBorder compoundBorder = new CompoundBorder(titledBorder, new EmptyBorder(3, 3, 3, 3));
        CompoundBorder compoundBorder2 = new CompoundBorder(new EmptyBorder(3, 3, 3, 3), compoundBorder);
        JPanel jPanel12 = new JPanel(new BorderLayout());
        JPanel jPanel13 = new JPanel(new BorderLayout());
        JPanel jPanel14 = new JPanel(new BorderLayout());
        jPanel12.setBorder(compoundBorder2);
        jPanel12.add((Component)this.xTxF_Index, "North");
        jPanel12.add((Component)this.xSld_Index, "Center");
        jPanel12.add((Component)this.xLbl_Index, "South");
        jPanel13.add((Component)new JLabel("  "), "North");
        jPanel14.add((Component)jPanel12, "North");
        jPanel14.add((Component)jPanel13, "Center");
        JPanel jPanel15 = new JPanel(new BorderLayout());
        jPanel15.add((Component)jPanel11, "North");
        jPanel15.add((Component)jPanel14, "Center");
        JLabel jLabel3 = new JLabel("Selected Properties");
        jLabel3.setDisplayedMnemonic('S');
        jLabel3.setToolTipText("Properties you've selected for inspection");
        jLabel3.setLabelFor(this.xLst_Selected);
        this.xLst_Selected = new JList(this.myLocalSeriesData);
        this.xLst_Selected.setSelectionMode(2);
        this.xLst_Selected.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AbleParametersDialog.this.xLst_Selected_valueChanged(listSelectionEvent);
            }
        });
        JScrollPane jScrollPane3 = new JScrollPane(this.xLst_Selected);
        this.xBtn_RemAll = new JButton("<= Remove All");
        this.xBtn_RemAll.setEnabled(true);
        this.xBtn_RemAll.setToolTipText("Remove all properties from the 'selected' list");
        this.xBtn_RemAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleParametersDialog.this.xBtn_RemAll_actionPerformed(actionEvent);
            }
        });
        JPanel jPanel16 = new JPanel(new BorderLayout());
        jPanel16.add((Component)jScrollPane3, "Center");
        JPanel jPanel17 = new JPanel(new BorderLayout());
        jPanel17.add((Component)new JLabel(" "), "North");
        jPanel17.add((Component)new JLabel("          "), "West");
        jPanel17.add((Component)this.xBtn_RemAll, "Center");
        jPanel17.add((Component)new JLabel("          "), "East");
        jPanel17.add((Component)new JLabel(" "), "South");
        JPanel jPanel18 = new JPanel(new BorderLayout());
        jPanel18.add((Component)jLabel3, "North");
        jPanel18.add((Component)jPanel16, "Center");
        jPanel18.add((Component)jPanel17, "South");
        this.xBt_Ok.setText("OK");
        this.xBt_Ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleParametersDialog.this.xBt_Ok_actionPerformed(actionEvent);
            }
        });
        this.xBt_Cancel.setText("Cancel");
        this.xBt_Cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleParametersDialog.this.xBt_Cancel_actionPerformed(actionEvent);
            }
        });
        this.xBt_Help.setText("Help");
        this.xBt_Help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleParametersDialog.this.xBt_Help_actionPerformed(actionEvent);
            }
        });
        this.xPn_Button.add((Component)this.xBt_Ok, null);
        this.xPn_Button.add((Component)this.xBt_Cancel, null);
        this.xPn_Button.add((Component)this.xBt_Help, null);
        TitledBorder titledBorder2 = new TitledBorder(new EtchedBorder(1), "Properties to Inspect", 2, 2);
        CompoundBorder compoundBorder3 = new CompoundBorder(titledBorder2, new EmptyBorder(10, 10, 10, 10));
        CompoundBorder compoundBorder4 = new CompoundBorder(new EmptyBorder(5, 5, 5, 5), compoundBorder3);
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout(new BoxLayout(jPanel19, 0));
        jPanel19.setBorder(compoundBorder4);
        jPanel19.add(jPanel6);
        jPanel19.add(Box.createHorizontalGlue());
        jPanel19.add(jPanel15);
        jPanel19.add(Box.createHorizontalGlue());
        jPanel19.add(jPanel18);
        this.xPn_Dialog.add((Component)jPanel19, "Center");
        this.xPn_Dialog.add((Component)this.xPn_Button, "South");
        this.xPn_Dialog.setPreferredSize(new Dimension(700, 500));
        this.xPn_Dialog.setMinimumSize(new Dimension(700, 500));
        this.getContentPane().add(this.xPn_Dialog);
    }

    void xLst_Parms_valueChanged(ListSelectionEvent listSelectionEvent) {
        this.xLst_Arrays.clearSelection();
        this.xLst_Selected.clearSelection();
        this.xBtn_Add.setEnabled(!this.xLst_Parms.isSelectionEmpty());
        this.xBtn_Rem.setEnabled(false);
        this.xTxF_Index.setEnabled(false);
        this.xSld_Index.setEnabled(false);
    }

    void xLst_Arrays_valueChanged(ListSelectionEvent listSelectionEvent) {
        this.xLst_Parms.clearSelection();
        this.xLst_Selected.clearSelection();
        this.xBtn_Add.setEnabled(!this.xLst_Arrays.isSelectionEmpty());
        if (this.xLst_Arrays.isSelectionEmpty()) {
            this.xBtn_Rem.setEnabled(false);
            this.xTxF_Index.setEnabled(false);
            this.xSld_Index.setEnabled(false);
            return;
        }
        String string = (String)this.xLst_Arrays.getSelectedValue();
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.myArrays.get(string);
        if (propertyDescriptor == null) {
            System.out.println("AbleParametersDialog.valueChanged(): can't get array property descriptor for " + string);
            this.xBtn_Add.setEnabled(false);
            this.xTxF_Index.setEnabled(false);
            this.xSld_Index.setEnabled(false);
            return;
        }
        Method method = propertyDescriptor.getReadMethod();
        Object object = "";
        try {
            object = method.invoke((Object)this.myUnderlyingObject, null);
        }
        catch (Exception exception) {
            this.xBtn_Add.setEnabled(false);
            this.xTxF_Index.setEnabled(false);
            this.xSld_Index.setEnabled(false);
            System.out.println("AbleParametersDialog.valueChanged(): Error: " + exception + " can't get array value for " + string);
        }
        if (object == null) {
            this.xBtn_Add.setEnabled(false);
            this.xTxF_Index.setEnabled(false);
            this.xSld_Index.setEnabled(false);
            return;
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            this.myArraySize = vector.size();
            if (this.myArraySize == 0) {
                this.xBtn_Add.setEnabled(false);
                this.xTxF_Index.setEnabled(false);
                this.xSld_Index.setEnabled(false);
            } else {
                this.xBtn_Add.setEnabled(true);
                this.xTxF_Index.setEnabled(true);
                this.xSld_Index.setEnabled(true);
                this.xSld_Index.setMaximum(this.myArraySize - 1);
                this.xLbl_Index.setText("0.." + String.valueOf(this.myArraySize - 1));
            }
        } else if (object instanceof String[] || object instanceof Object[] || object instanceof byte[] || object instanceof double[] || object instanceof float[] || object instanceof int[] || object instanceof long[] || object instanceof short[]) {
            this.myArraySize = Array.getLength(object);
            if (this.myArraySize == 0) {
                this.xBtn_Add.setEnabled(false);
                this.xTxF_Index.setEnabled(false);
                this.xSld_Index.setEnabled(false);
            } else {
                this.xBtn_Add.setEnabled(true);
                this.xTxF_Index.setEnabled(true);
                this.xSld_Index.setEnabled(true);
                this.xSld_Index.setMaximum(this.myArraySize - 1);
                this.xLbl_Index.setText("0.." + String.valueOf(this.myArraySize - 1));
            }
        }
    }

    void xLst_Selected_valueChanged(ListSelectionEvent listSelectionEvent) {
        this.xBtn_Rem.setEnabled(!this.xLst_Selected.isSelectionEmpty());
    }

    void xBtn_Add_actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        if (!this.xLst_Parms.isSelectionEmpty()) {
            object2 = this.xLst_Parms.getSelectedValues();
            object = new int[((Object[])object2).length];
            int n = this.myLocalSeriesData.size();
            for (int i = 0; i < ((Object[])object2).length; ++i) {
                this.myLocalSeriesData.addElement(new AbleSeriesItem((String)object2[i], ""));
                object[i] = n++;
            }
            this.xLst_Selected.setListData(this.myLocalSeriesData);
            this.xLst_Selected.setSelectedIndices((int[])object);
        }
        if (!this.xLst_Arrays.isSelectionEmpty()) {
            object2 = (String)this.xLst_Arrays.getSelectedValue();
            object = String.valueOf(this.xSld_Index.getValue());
            this.myLocalSeriesData.addElement(new AbleSeriesItem((String)object2, (String)object));
            this.xLst_Selected.setListData(this.myLocalSeriesData);
            this.xLst_Selected.setSelectedIndex(this.myLocalSeriesData.size() - 1);
        }
        this.xLst_Selected.ensureIndexIsVisible(this.myLocalSeriesData.size() - 1);
        this.xBtn_Rem.setEnabled(true);
        this.xBtn_RemAll.setEnabled(true);
    }

    void xBtn_Rem_actionPerformed(ActionEvent actionEvent) {
        if (!this.xLst_Selected.isSelectionEmpty()) {
            int n = this.xLst_Selected.getSelectedIndex();
            int[] nArray = this.xLst_Selected.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.myLocalSeriesData.removeElementAt(nArray[i]);
            }
            this.xLst_Selected.setListData(this.myLocalSeriesData);
            this.xLst_Selected.ensureIndexIsVisible(Math.max(0, n - 1));
            this.xBtn_Rem.setEnabled(false);
            if (this.xLst_Selected.getModel().getSize() == 0) {
                this.xBtn_RemAll.setEnabled(false);
            } else {
                this.xBtn_RemAll.setEnabled(true);
            }
        }
    }

    void xBtn_RemAll_actionPerformed(ActionEvent actionEvent) {
        if (this.xLst_Selected.getModel().getSize() != 0) {
            this.myLocalSeriesData.removeAllElements();
            this.xLst_Selected.setListData(this.myLocalSeriesData);
        }
        this.xBtn_Rem.setEnabled(false);
        this.xBtn_RemAll.setEnabled(false);
    }

    void xTxF_Index_docChanged(DocumentEvent documentEvent) {
        String string = this.xTxF_Index.getText().trim();
        if (string.length() == 0) {
            this.newSliderValue(0);
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Toolkit.getDefaultToolkit().beep();
            this.newSliderValue(0);
            return;
        }
        if (n >= 0 && n < this.myArraySize) {
            this.newSliderValue(n);
        } else {
            Toolkit.getDefaultToolkit().beep();
            this.newSliderValue(0);
        }
    }

    void newSliderValue(int n) {
        this.xSld_Index.removeChangeListener(this.xChL_Index);
        this.xSld_Index.setValue(n);
        this.xSld_Index.addChangeListener(this.xChL_Index);
    }

    void xSld_Index_stateChanged(ChangeEvent changeEvent) {
        this.newTextValue(String.valueOf(this.xSld_Index.getValue()));
    }

    void newTextValue(String string) {
        this.xTxF_Index.getDocument().removeDocumentListener(this.xDoL_Index);
        this.xTxF_Index.setText(String.valueOf(this.xSld_Index.getValue()));
        this.xTxF_Index.getDocument().addDocumentListener(this.xDoL_Index);
    }

    void xTxF_DataPts_docChanged(DocumentEvent documentEvent) {
        String string = this.xTxF_DataPts.getText().trim();
        if (string.length() == 0) {
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (n <= 0 || n >= 10000) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    void xBt_Ok_actionPerformed(ActionEvent actionEvent) {
        this.myCancelledFlag = false;
        this.mySeriesData = this.myLocalSeriesData;
        String string = this.xTxF_DataPts.getText().trim();
        if (string.length() == 0) {
            this.xTxF_DataPts.setText("1");
        } else {
            try {
                int n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.xTxF_DataPts.setText("1");
            }
        }
        this.dispose();
    }

    void xBt_Cancel_actionPerformed(ActionEvent actionEvent) {
        this.myCancelledFlag = true;
        this.dispose();
    }

    void xBt_Help_actionPerformed(ActionEvent actionEvent) {
        AbleEditorFrame.displayHelp(this, "Inspector.html");
    }
}

