/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.editor.AbleJarMessageHeader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class AbleJarManifest {
    private Vector entries = new Vector();
    static final boolean debug = false;

    static final void debug(String string) {
    }

    public AbleJarManifest() {
    }

    public AbleJarManifest(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public AbleJarManifest(InputStream inputStream) throws IOException {
        while (inputStream.available() != 0) {
            AbleJarMessageHeader ableJarMessageHeader = new AbleJarMessageHeader(inputStream);
            this.entries.addElement(ableJarMessageHeader);
        }
    }

    public AbleJarManifest(String[] stringArray) throws IOException {
        AbleJarMessageHeader ableJarMessageHeader = new AbleJarMessageHeader();
        ableJarMessageHeader.add("Manifest-Version", "1.0");
        this.addEntry(ableJarMessageHeader);
        this.addFiles(null, stringArray);
    }

    public void addEntry(AbleJarMessageHeader ableJarMessageHeader) {
        this.entries.addElement(ableJarMessageHeader);
    }

    public AbleJarMessageHeader getEntry(String string) {
        Enumeration enumeration = this.entries();
        while (enumeration.hasMoreElements()) {
            AbleJarMessageHeader ableJarMessageHeader = (AbleJarMessageHeader)enumeration.nextElement();
            String string2 = ableJarMessageHeader.findValue("Name");
            if (string2 == null || !string2.equals(string)) continue;
            return ableJarMessageHeader;
        }
        return null;
    }

    public AbleJarMessageHeader entryAt(int n) {
        return (AbleJarMessageHeader)this.entries.elementAt(n);
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    public void addFiles(File file, String[] stringArray) throws IOException {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = file == null ? new File(stringArray[i]) : new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                this.addFiles(file2, file2.list());
                continue;
            }
            this.addFile(file2);
        }
    }

    public void addFile(File file) throws IOException {
        AbleJarMessageHeader ableJarMessageHeader = new AbleJarMessageHeader();
        ableJarMessageHeader.add("Name", file.getPath());
        this.addEntry(ableJarMessageHeader);
    }

    public void stream(OutputStream outputStream, Vector vector) throws IOException {
        AbleJarMessageHeader ableJarMessageHeader = (AbleJarMessageHeader)this.entries.elementAt(0);
        if (ableJarMessageHeader.findValue("Manifest-Version") == null) {
            throw new IOException("Manifest file requires Manifest-Version: 1.0 in 1st header");
        }
        PrintWriter printWriter = new PrintWriter(outputStream);
        ableJarMessageHeader.print(printWriter);
        for (int i = 1; i < this.entries.size(); ++i) {
            AbleJarMessageHeader ableJarMessageHeader2 = (AbleJarMessageHeader)this.entries.elementAt(i);
            ableJarMessageHeader2.print(printWriter);
            String string = ableJarMessageHeader2.findValue("name");
            if (vector == null || string == null) continue;
            vector.addElement(string);
        }
    }

    public static boolean isManifestName(String string) {
        if (string.charAt(0) == '/') {
            string = string.substring(1, string.length());
        }
        return (string = string.toUpperCase()).equals("META-INF/MANIFEST.MF");
    }
}

