/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.Able;
import com.ibm.able.editor.AbleClassLoader;
import com.ibm.able.editor.AbleDoOnBean;
import com.ibm.able.editor.AbleJarInfo;
import com.ibm.able.editor.AbleJarManifest;
import com.ibm.able.editor.AbleJarMessageHeader;
import java.beans.BeanInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class AbleJarLoader {
    private static boolean debug = false;
    private InputStream jarStream;
    private String jarName;
    private AbleClassLoader loader;
    private static boolean warnedAboutNoBeans;

    public AbleJarLoader(String string) throws FileNotFoundException {
        AbleJarLoader.debug("(" + string + ")");
        this.jarName = string;
        FileInputStream fileInputStream = new FileInputStream(string);
        this.jarStream = new BufferedInputStream(fileInputStream);
        this.loader = AbleClassLoader.ourLoader;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    private String guessContentTypeFromStream(InputStream inputStream) throws IOException {
        String string = URLConnection.guessContentTypeFromStream(inputStream);
        if (string == null) {
            inputStream.mark(10);
            int n = inputStream.read();
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            int n6 = inputStream.read();
            inputStream.reset();
            if (n == 172 && n2 == 237) {
                string = "application/java-serialized-object";
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbleJarInfo loadJar() throws IOException {
        boolean bl;
        Vector<Object> vector;
        Vector<Object> vector2;
        AbleJarManifest ableJarManifest;
        block18: {
            ZipInputStream zipInputStream = null;
            ableJarManifest = null;
            vector2 = new Vector<Object>();
            vector = new Vector<Object>();
            byte[] byArray = new byte[1024];
            bl = true;
            try {
                try {
                    zipInputStream = new ZipInputStream(this.jarStream);
                    Object object = null;
                    while ((object = zipInputStream.getNextEntry()) != null) {
                        Object object2;
                        byte[] byArray2;
                        String string;
                        String string2;
                        block17: {
                            bl = false;
                            string2 = ((ZipEntry)object).getName();
                            string = null;
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            while (true) {
                                int n;
                                if ((n = zipInputStream.read(byArray)) < 0) {
                                    byArray2 = byteArrayOutputStream.toByteArray();
                                    int n2 = byArray2.length;
                                    if (AbleJarManifest.isManifestName(string2)) {
                                        break;
                                    }
                                    break block17;
                                }
                                byteArrayOutputStream.write(byArray, 0, n);
                            }
                            string = "manifest/manifest";
                        }
                        if (string == null) {
                            object2 = new ByteArrayInputStream(byArray2);
                            string = this.guessContentTypeFromStream((InputStream)object2);
                            ((InputStream)object2).close();
                        }
                        if (string == null) {
                            string = "input-stream/input-stream";
                        }
                        if (string.startsWith("application/java-serialized-object") || string.startsWith("application/x-java-serialized-object")) {
                            this.loader.putLocalResource(string2, byArray2, string);
                            object2 = string2.substring(0, string2.length() - 4);
                            object2 = ((String)object2).replace('/', '.');
                            vector.addElement(object2);
                            System.out.println("jarloader --- found a serialized object " + (String)object2 + " " + string2);
                            continue;
                        }
                        if (string.startsWith("application/java-vm") || string.startsWith("application/x-java-vm")) {
                            this.loader.putClassResource(string2, string);
                            object2 = string2.substring(0, string2.length() - 6);
                            object2 = ((String)object2).replace('/', '.');
                            this.loader.defineClassFromBytes((String)object2, byArray2);
                            vector2.addElement(object2);
                            continue;
                        }
                        if (string.equals("manifest/manifest")) {
                            ableJarManifest = new AbleJarManifest(byArray2);
                            continue;
                        }
                        this.loader.putLocalResource(string2, byArray2, string);
                    }
                    Object var15_17 = null;
                    if (zipInputStream == null) break block18;
                }
                catch (IOException iOException) {
                    AbleJarLoader.debug("IOException loading archive: " + iOException);
                    throw iOException;
                }
                catch (Throwable throwable) {
                    AbleJarLoader.debug("Caught " + throwable + " in loadit()");
                    throwable.printStackTrace();
                    throw new IOException("loadJar caught: " + throwable);
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                if (zipInputStream == null) throw throwable;
                try {
                    zipInputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            zipInputStream.close();
        }
        if (!bl) return this.createJarInfo(vector2, vector, ableJarManifest);
        throw new IOException("JAR file is corrupt or empty");
    }

    public static void loadJarDoOnBean(String string, AbleDoOnBean ableDoOnBean) throws IOException {
        AbleJarLoader ableJarLoader = new AbleJarLoader(string);
        AbleJarInfo ableJarInfo = ableJarLoader.loadJar();
        if (ableJarInfo == null) {
            System.err.println("JAR file " + string + " did not load properly!");
            System.err.println("Check for error messages possibly regarding");
            System.err.println("problems defining classes");
            return;
        }
        if (ableJarInfo.getCount() == 0) {
            System.err.println("Jar file " + string + " didn't have any beans!");
            if (!warnedAboutNoBeans) {
                warnedAboutNoBeans = true;
                System.err.println("");
                System.err.println("Each jar file needs to contain a manifest file describing which entries are");
                System.err.println("beans.  You can should provide a suitable manifest when you create the jar.");
                System.err.println("");
            }
        }
        for (int i = 0; i < ableJarInfo.getCount(); ++i) {
            String string2;
            String string3 = ableJarInfo.getName(i);
            try {
                BeanInfo beanInfo = ableJarInfo.getBeanInfo(i);
                if (beanInfo == null) {
                    string2 = "Unable to load bean '" + string3 + "' because beaninfo could not be constructed.";
                    if (Able.TraceLog.isLogging()) {
                        Able.TraceLog.text(262144L, (Object)"com.ibm.able.editor.AbleJarLoader", "loadJarDoOnBean", Able.LS + string2);
                        continue;
                    }
                    Able.MessageLog.text(2L, (Object)"com.ibm.able.editor.AbleJarLoader", "loadJarDoOnBean", Able.LS + string2);
                    continue;
                }
                ableDoOnBean.action(ableJarInfo, beanInfo, string3);
                continue;
            }
            catch (Throwable throwable) {
                string2 = "Unable to load bean '" + string3 + "' because class could not be loaded: " + throwable.getLocalizedMessage();
                if (Able.TraceLog.isLogging()) {
                    Able.TraceLog.text(262144L, (Object)"com.ibm.able.editor.AbleJarLoader", "loadJarDoOnBean", Able.LS + string2);
                    Able.TraceLog.exception(524288L, (Object)"com.ibm.able.editor.AbleJarLoader", "loadJarDoOnBean", throwable);
                    continue;
                }
                Able.MessageLog.text(2L, (Object)"com.ibm.able.editor.AbleJarLoader", "loadJarDoOnBean", Able.LS + string2);
            }
        }
    }

    private AbleJarInfo createJarInfo(Vector vector, Vector vector2, AbleJarManifest ableJarManifest) {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray;
        Hashtable<Object, Boolean> hashtable;
        Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
        if (ableJarManifest == null) {
            hashtable = new Hashtable<Object, Boolean>();
        } else {
            hashtable = new Hashtable();
            stringArray = ableJarManifest.entries();
            while (stringArray.hasMoreElements()) {
                Object object4;
                object3 = (AbleJarMessageHeader)stringArray.nextElement();
                object2 = ((AbleJarMessageHeader)object3).findValue("Name");
                object = ((AbleJarMessageHeader)object3).findValue("Java-Bean");
                if (object == null || !((String)object).equalsIgnoreCase("True")) continue;
                boolean bl = true;
                if (((String)object2).endsWith(".class")) {
                    bl = false;
                    object4 = ((String)object2).substring(0, ((String)object2).length() - 6);
                } else {
                    object4 = ((String)object2).endsWith(".ser") ? ((String)object2).substring(0, ((String)object2).length() - 4) : object2;
                }
                object4 = ((String)object4).replace('/', '.');
                hashtable.put(object4, new Boolean(bl));
                hashtable2.put(object4, object3);
            }
        }
        stringArray = new String[hashtable.size()];
        object3 = new boolean[hashtable.size()];
        object2 = new AbleJarMessageHeader[hashtable.size()];
        object = hashtable.keys();
        int n = 0;
        while (object.hasMoreElements()) {
            String string;
            stringArray[n] = string = (String)object.nextElement();
            object3[n] = (Boolean)hashtable.get(string);
            object2[n] = (AbleJarMessageHeader)hashtable2.get(string);
            ++n;
        }
        return new AbleJarInfo(this.jarName, this.loader, stringArray, (boolean[])object3, (AbleJarMessageHeader[])object2);
    }

    private static void debug(String string) {
        if (debug) {
            System.err.println("JarLoader:: " + string);
        }
    }
}

