/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.editor.AbleClassLoader;
import com.ibm.able.editor.AbleJarMessageHeader;
import com.ibm.able.editor.AbleObjectInputStreamLoader;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class AbleJarInfo {
    private AbleClassLoader classLoader;
    private String[] beanNames;
    private BeanInfo[] beanInfos;
    private boolean[] fromPrototype;
    private AbleJarMessageHeader[] manifestData;
    private String jarName;
    private static Hashtable beanToJar = new Hashtable();
    private static boolean debug = false;

    public AbleJarInfo(String string, AbleClassLoader ableClassLoader, String[] stringArray, boolean[] blArray, AbleJarMessageHeader[] ableJarMessageHeaderArray) {
        if (stringArray.length != blArray.length) {
            throw new Error("beanNames and fromPrototype need to have the same length");
        }
        this.jarName = string;
        this.classLoader = ableClassLoader;
        this.beanNames = stringArray;
        this.fromPrototype = blArray;
        this.manifestData = ableJarMessageHeaderArray;
        this.beanInfos = new BeanInfo[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            BeanInfo beanInfo;
            Class clazz;
            beanToJar.put(stringArray[i], string);
            if (blArray[i]) continue;
            try {
                clazz = ableClassLoader.loadClass(stringArray[i]);
            }
            catch (Throwable throwable) {
                continue;
            }
            try {
                beanInfo = AbleJarInfo.getBeanInfo(clazz);
            }
            catch (Throwable throwable) {
                if (Able.TraceLog.isLogging()) {
                    Able.TraceLog.text(262144L, (Object)this, "", Able.LS + "Unable to load bean '" + clazz + "'; caught '" + throwable + "'." + Able.LS + "Update classpath if bean '" + clazz + "' is to be used, " + "or remove its container jar from the plugin directory, " + "or ignore this warning.");
                    Able.TraceLog.exception(524288L, (Object)this, "AbleJarInfo", throwable);
                    continue;
                }
                Able.MessageLog.text(2L, (Object)this, "", Able.LS + "Unable to load bean '" + clazz + "'; caught '" + throwable + "'." + Able.LS + "Update classpath if bean '" + clazz + "' is to be used, " + "or remove its container jar from the plugin directory, " + "or ignore this warning.");
                continue;
            }
            this.beanInfos[i] = beanInfo;
            AbleJarInfo.debug("JarInfo:: @ " + i + "; beanName: " + stringArray[i] + "; fromPrototype: " + blArray[i]);
        }
    }

    public static String getJarName(String string) {
        return (String)beanToJar.get(string);
    }

    public String getJarName() {
        return this.jarName;
    }

    public int getCount() {
        return this.beanNames.length;
    }

    public BeanInfo getBeanInfo(int n) {
        if (this.beanInfos[n] != null) {
            return this.beanInfos[n];
        }
        Object object = this.getInstance(this.beanNames[n]);
        if (object != null) {
            BeanInfo beanInfo;
            try {
                beanInfo = AbleJarInfo.getBeanInfo(object.getClass());
            }
            catch (AbleException ableException) {
                Able.MessageLog.text(4L, (Object)this, "(int)", ableException.getLocalizedMessage());
                return null;
            }
            this.beanInfos[n] = beanInfo;
            return beanInfo;
        }
        return null;
    }

    public static BeanInfo getBeanInfo(Class clazz) throws AbleException {
        if (clazz == null) {
            return null;
        }
        Class<?> clazz2 = clazz;
        BeanInfo beanInfo = null;
        if (clazz2.getName().endsWith("_Stub")) {
            String string = clazz.getName();
            try {
                clazz2 = Class.forName(string.substring(0, string.length() - 5));
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (Able.TraceLog.isLogging()) {
                    Able.TraceLog.text(262144L, clazz, "", "JarInfo: couldn't find class for " + clazz2.getName() + "; caught " + classNotFoundException);
                    Able.TraceLog.exception(524288L, clazz, "", (Throwable)classNotFoundException);
                }
                throw new AbleException(classNotFoundException.getLocalizedMessage(), (Throwable)classNotFoundException);
            }
        }
        try {
            beanInfo = Introspector.getBeanInfo(clazz2);
        }
        catch (IntrospectionException introspectionException) {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(262144L, clazz, "", "JarInfo: couldn't find BeanInfo for " + clazz2.getName() + "; caught " + introspectionException);
                Able.TraceLog.exception(524288L, clazz, "", (Throwable)introspectionException);
            }
            throw new AbleException(introspectionException.getLocalizedMessage(), (Throwable)introspectionException);
        }
        return beanInfo;
    }

    public String getName(int n) {
        return this.beanNames[n];
    }

    public boolean isFromPrototype(String string) {
        return this.fromPrototype[this.indexForName(string)];
    }

    public AbleJarMessageHeader getManifestData(String string) {
        return this.manifestData[this.indexForName(string)];
    }

    public Object getInstance(String string) {
        try {
            return Beans.instantiate(this.classLoader, string);
        }
        catch (Throwable throwable) {
            if (Able.TraceLog.isLogging()) {
                if (string.indexOf(92) >= 0) {
                    Able.TraceLog.text(262144L, (Object)this, "", "    Note that file names in manifests must use forward slashes \"/\" \n    rather than back-slashes \"\\\"");
                }
                Able.TraceLog.text(262144L, (Object)this, "", Able.LS + "Unable to load bean '" + string + "'; caught '" + throwable + "'." + Able.LS + "Update classpath if bean '" + string + "' is to be used, " + "or remove its container jar from the plugin directory, " + "or ignore this warning.");
                Able.TraceLog.exception(524288L, (Object)this, "AbleJarInfo", throwable);
            } else {
                if (string.indexOf(92) >= 0) {
                    Able.MessageLog.text(2L, (Object)this, "", "    Note that file names in manifests must use forward slashes \"/\" \n    rather than back-slashes \"\\\"");
                }
                Able.MessageLog.text(2L, (Object)this, "", Able.LS + "Unable to load bean '" + string + "'; caught '" + throwable + "'." + Able.LS + "Update classpath if bean '" + string + "' is to be used, " + "or remove its container jar from the plugin directory, " + "or ignore this warning.");
            }
            this.diagnoseInstantiationException(this.classLoader, string, throwable);
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(262144L, (Object)this, "", "");
            }
            return null;
        }
    }

    void diagnoseInstantiationException(AbleClassLoader ableClassLoader, String string, Throwable throwable) {
        Object object;
        int n;
        Class clazz;
        boolean bl;
        block45: {
            String string2;
            String string3;
            InputStream inputStream;
            bl = Able.TraceLog.isLogging();
            String string4 = new String(Able.LS + "WARNING: Could not instantiate bean \"" + string + "\"");
            if (ableClassLoader == null) {
                if (bl) {
                    Able.TraceLog.text(262144L, (Object)this, "", string4 + " from the system class-loader");
                }
                return;
            }
            if (bl) {
                string4 = string4 + " from JAR \"" + this.jarName + "\"";
            }
            if ((inputStream = ableClassLoader.getResourceAsStream(string3 = string.replace('.', '/').concat(".ser"))) != null) {
                block44: {
                    if (bl) {
                        string4 = string4 + Able.LS + "    We found a serialized template file \"" + string3 + "\"";
                    }
                    try {
                        AbleObjectInputStreamLoader ableObjectInputStreamLoader = new AbleObjectInputStreamLoader(inputStream, ableClassLoader);
                        Object object2 = ableObjectInputStreamLoader.readObject();
                        if (bl) {
                            string4 = string4 + Able.LS + "    An object could be read from the serialized template OK.";
                            string4 = string4 + Able.LS + "    But an exception was generated in Beans.instantiate:";
                            Able.TraceLog.text(262144L, (Object)this, "", string4 + Able.LS + "        " + throwable);
                        }
                    }
                    catch (ObjectStreamException objectStreamException) {
                        if (bl) {
                            string4 = string4 + Able.LS + "    But caught an ObjectStreamException while reading the serialized object:";
                            string4 = string4 + Able.LS + "        " + objectStreamException;
                            string4 = string4 + Able.LS + "    This indicates there is a problem with the contents of the template file.";
                            Able.TraceLog.text(262144L, (Object)this, "", string4);
                        }
                    }
                    catch (IOException iOException) {
                        if (bl) {
                            string4 = string4 + Able.LS + "    But caught an IOException while reading the serialized object:";
                            Able.TraceLog.text(262144L, (Object)this, "", string4 + Able.LS + "        " + iOException);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (bl) {
                            string4 = string4 + Able.LS + "    But caught a ClassNotFoundException while reading the serialized object:";
                            string4 = string4 + Able.LS + "        " + classNotFoundException;
                            string4 = string4 + Able.LS + "    This indicates that there was a problem finding a .class file for one";
                            Able.TraceLog.text(262144L, (Object)this, "", string4 + Able.LS + "    of the serialized objects");
                        }
                    }
                    catch (Throwable throwable2) {
                        if (!bl) break block44;
                        string4 = string4 + Able.LS + "    But caught an unexpected exception while reading the serialized object:";
                        Able.TraceLog.text(262144L, (Object)this, "", string4 + Able.LS + "        " + throwable2);
                    }
                }
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            try {
                string2 = string.replace('.', '/').concat(".class");
                inputStream = ableClassLoader.getResourceAsStream(string2);
                if (inputStream == null) {
                    if (bl) {
                        Able.TraceLog.text(262144L, (Object)this, "", string4 + Able.LS + "    We couldn't open the class file \"" + string2 + "\" in the JAR");
                    }
                    return;
                }
                if (bl) {
                    Able.TraceLog.text(262144L, (Object)this, "", string4 + Able.LS + "    We found the class file \"" + string2 + "\"");
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            string2 = "the default package";
            String string5 = string;
            if (string.lastIndexOf(46) > 0) {
                string2 = "the package \"" + string.substring(0, string.lastIndexOf(46)) + "\"";
                string5 = string.substring(string.lastIndexOf(46) + 1);
            }
            clazz = null;
            try {
                clazz = ableClassLoader.loadClass(string);
            }
            catch (Exception exception) {
                if (bl) {
                    Able.TraceLog.text(262144L, (Object)this, "", "    But were unable to load the class \"" + string + "\" because of" + Able.LS + "        " + exception + Able.LS + "    Common reasons for this failure include:" + Able.LS + "    (1) The class is not defined in the expected package" + Able.LS + "    (2) The class has not been given the expected name <" + string5 + ">" + Able.LS + "    (3) The class file contains the wrong class or no class at all");
                }
                Able.TraceLog.exception(524288L, (Object)this, "", (Throwable)exception);
                return;
            }
            catch (Throwable throwable3) {
                if (!bl) break block45;
                Able.TraceLog.text(262144L, (Object)this, "", "    But were unable to load the class \"" + string + "\" because of " + Able.LS + "        " + throwable3);
                if (throwable3 instanceof ClassFormatError && throwable3.getMessage().equals("Duplicate name")) {
                    Able.TraceLog.text(262144L, (Object)this, "", "    This particular error is often caused by having a mismatch between the name of    the .class file and the name of the contained class.    In this case make sure that class file contains a class    called \"" + string5 + "\" in " + string2 + ".");
                }
                Able.TraceLog.exception(524288L, (Object)this, "", throwable3);
                return;
            }
        }
        if (bl) {
            Able.TraceLog.text(262144L, (Object)this, "", "    We located the class \"" + string + "\" OK");
        }
        if (!Modifier.isPublic(n = clazz.getModifiers())) {
            if (bl) {
                Able.TraceLog.text(262144L, (Object)this, "", "    But the class was not declared public, so we could not create a bean");
            }
            return;
        }
        try {
            object = new Class[]{};
            Constructor constructor = clazz.getConstructor((Class<?>)object);
            if (constructor == null) {
                if (bl) {
                    Able.TraceLog.text(262144L, (Object)this, "", "    But the class did not have a zero-arg constructor." + Able.LS + "    All beans must provide public zero-arg constructors.");
                }
                return;
            }
            n = constructor.getModifiers();
            if (!Modifier.isPublic(n)) {
                if (bl) {
                    Able.TraceLog.text(262144L, (Object)this, "", "    But the class's zero-arg constructor was not declared public" + Able.LS + "    All beans must provide public zero-arg constructors.");
                }
                return;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (bl) {
                Able.TraceLog.text(262144L, (Object)this, "", "    But the class did not have a zero-arg constructor." + Able.LS + "    All beans must provide public zero-arg constructors.");
            }
            return;
        }
        catch (Throwable throwable4) {
            if (bl) {
                Able.TraceLog.text(262144L, (Object)this, "", "    Unexpected exception in disgnoseInstantiationException" + Able.LS + "    " + throwable4);
            }
            throwable4.printStackTrace();
            return;
        }
        if (bl) {
            Able.TraceLog.text(262144L, (Object)this, "", "    The class provides a public zero-arg constructor");
        }
        try {
            object = clazz.newInstance();
        }
        catch (Throwable throwable5) {
            if (bl) {
                Able.TraceLog.text(262144L, (Object)this, "", "    But were unable to create an instance of the class because we" + Able.LS + "    got an exception while doing Class.newInstance() :" + Able.LS + "       " + throwable5);
                Able.TraceLog.exception(524288L, (Object)this, "diagnoseInstantiationException", throwable5);
            }
            return;
        }
        if (bl) {
            Able.TraceLog.text(262144L, (Object)this, "", "    But an exception was generated in Beans.instantiate:" + Able.LS + "        " + throwable);
            Able.TraceLog.exception(524288L, (Object)this, "diagnoseInstantiationException", throwable);
        }
    }

    private int indexForName(String string) {
        for (int i = 0; i < this.beanNames.length; ++i) {
            if (!this.beanNames[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    private static void debug(String string) {
        if (debug && Able.TraceLog.isLogging()) {
            Able.TraceLog.text(262144L, (Object)"com.ibm.able.editor.AbleJarInfo", "", "JarInfo:: " + string);
        }
    }
}

