/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.AbleBean;
import com.ibm.able.AbleException;
import com.ibm.able.editor.AbleEditor;
import com.ibm.able.editor.AbleEditorFrame;
import com.ibm.able.editor.AbleInspector;
import com.ibm.able.editor.AbleInspectorContext;
import com.ibm.able.editor.AbleInspectorHolder;
import com.ibm.able.editor.AbleJarInfo;
import com.ibm.able.editor.AbleViewObject;
import java.awt.Point;
import java.beans.BeanInfo;
import java.io.Serializable;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class AbleInspectorWindow
implements AbleInspectorHolder,
Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    AbleEditorFrame myParentFrame;
    AbleInspector myInspectorFrame;
    boolean mustPackFrame = false;

    public AbleInspectorWindow(JFrame jFrame, AbleInspector ableInspector) {
        this.myParentFrame = (AbleEditorFrame)jFrame;
        this.myInspectorFrame = ableInspector;
        this.myInspectorFrame.setOwner(this);
        if (this.mustPackFrame) {
            this.myInspectorFrame.pack();
        } else {
            this.myInspectorFrame.validate();
        }
        Point point = new Point(this.myParentFrame.getLocation().x + 20, this.myParentFrame.getLocation().y + 20);
        this.myInspectorFrame.setLocation(point);
        this.myInspectorFrame.setSize(AbleEditor.Preferences.getInspectorPanelSize());
        this.setFrameIcon();
    }

    public AbleInspectorWindow(JFrame jFrame, AbleViewObject ableViewObject) {
        this(jFrame, new AbleInspector(ableViewObject));
    }

    public void dispose() {
        this.myParentFrame.removeFromWindowList(this);
        this.myInspectorFrame.dispose();
    }

    public void setVisible(boolean bl) {
        this.myInspectorFrame.setVisible(bl);
    }

    public void requestFocus() {
        this.myInspectorFrame.requestFocus();
    }

    public void deiconifyFrame() {
        JDesktopPane jDesktopPane = JOptionPane.getDesktopPaneForComponent(this.myInspectorFrame);
        if (jDesktopPane != null) {
            JInternalFrame[] jInternalFrameArray = jDesktopPane.getAllFrames();
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                if (!jInternalFrameArray[i].equals(this.myInspectorFrame)) continue;
                if (!jInternalFrameArray[i].isIcon()) break;
                jDesktopPane.getDesktopManager().deiconifyFrame(jInternalFrameArray[i]);
                break;
            }
        }
    }

    public void refresh() {
    }

    public AbleEditorFrame getParent() {
        return this.myParentFrame;
    }

    public AbleInspector getInspector() {
        return this.myInspectorFrame;
    }

    public void setInspectorContext(AbleInspectorContext ableInspectorContext) {
        this.myInspectorFrame.setContext(ableInspectorContext);
    }

    private void setFrameIcon() {
        AbleBean ableBean = this.myInspectorFrame.getBean();
        try {
            BeanInfo beanInfo = AbleJarInfo.getBeanInfo(ableBean.getClass());
            this.myInspectorFrame.setIconImage(beanInfo.getIcon(1));
        }
        catch (AbleException ableException) {
            // empty catch block
        }
    }

    public void setFrameTitle(String string) {
        if (this.myInspectorFrame != null) {
            this.myInspectorFrame.setTitle(string);
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

