/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.Able;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.editor.AbleGridBagConstraints;
import com.ibm.able.editor.AbleInspector;
import com.ibm.able.editor.AbleInspectorContext;
import com.ibm.able.editor.AbleInspectorGeneralPanel;
import com.ibm.able.editor.AbleInspectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jclass.chart.ChartDataView;
import jclass.chart.JCBarChartFormat;

public class AbleInspectorOptionsDialog
extends JDialog {
    private boolean myFrameSizeAdjusted = false;
    private boolean isCancelled = false;
    private JFrame myFrameParent = null;
    private AbleInspector myInspector = null;
    private AbleInspectorContext myContext = null;
    private JTabbedPane myTabbedPane = null;

    public AbleInspectorOptionsDialog(AbleInspector ableInspector, String string, boolean bl) {
        super(ableInspector, string, bl);
        this.myFrameParent = ableInspector;
        this.myInspector = ableInspector;
        this.myTabbedPane = new JTabbedPane();
        this.setVisible(false);
        this.setSize(600, 400);
        this.initializePanel();
    }

    private AbleInspectorOptionsDialog() {
        this(new AbleInspector(null), "", false);
    }

    public AbleInspectorOptionsDialog(String string) {
        this();
        this.setTitle(string);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString(), "AbleInspectorOptionsDialog()", 0);
        }
        new AbleInspectorOptionsDialog().setVisible(true);
    }

    public void setContext(AbleInspectorContext ableInspectorContext) {
        this.myContext = ableInspectorContext;
        this.setTabbedPanes();
        int n = this.myTabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.myTabbedPane.getComponentAt(i);
            ((AbleInspectorPanel)((Object)component)).setObject(this.myContext);
        }
    }

    private void setTabbedPanes() {
        this.myTabbedPane.removeAll();
        if (this.myContext.textView == 0) {
            this.addTab(new AbleInspectorGeneralPanel());
            this.addTab(new AreaChartPanel());
            this.addTab(new StackedAreaPanel());
            this.addTab(new BarChartPanel());
            this.addTab(new StackedBarPanel());
            this.addTab(new LineChartPanel());
            this.addTab(new ScatterPlotPanel());
            this.addTab(new TimePlotPanel());
        } else if (this.myContext.textView == 2) {
            this.addTab(new TextPanel());
            this.addTab(new TextSeriesPanel());
        }
    }

    private void updateContext() throws Exception {
        int n = this.myTabbedPane.getTabCount();
        int n2 = this.myTabbedPane.getSelectedIndex();
        for (int i = 0; i < n; ++i) {
            if (i == n2) continue;
            Component component = this.myTabbedPane.getComponentAt(i);
            ((AbleInspectorPanel)((Object)component)).updateObject();
        }
        Component component = this.myTabbedPane.getSelectedComponent();
        ((AbleInspectorPanel)((Object)component)).updateObject();
    }

    public AbleInspectorContext getContext() {
        return this.myContext;
    }

    public boolean userCancelled() {
        return this.isCancelled;
    }

    public void addTab(AbleInspectorPanel ableInspectorPanel) {
        this.myTabbedPane.addTab(ableInspectorPanel.getName(), (Component)((Object)ableInspectorPanel));
    }

    public void addTab(String string, AbleInspectorPanel ableInspectorPanel) {
        this.myTabbedPane.addTab(string, (Component)((Object)ableInspectorPanel));
    }

    public void insertTab(String string, AbleInspectorPanel ableInspectorPanel, int n) {
        this.insertTab(string, null, ableInspectorPanel, null, n);
    }

    public void insertTab(String string, Icon icon, AbleInspectorPanel ableInspectorPanel, String string2, int n) {
        this.myTabbedPane.insertTab(string, icon, (Component)((Object)ableInspectorPanel), string2, n);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.myFrameSizeAdjusted) {
            return;
        }
        this.myFrameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    private void initializePanel() {
        boolean bl = false;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        container.add((Component)this.myTabbedPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2, 5, 5));
        container.add((Component)jPanel, "South");
        AblePanelHelper.addButton(jPanel, "OK", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspectorOptionsDialog.this.OKButton_actionPerformed(actionEvent);
            }
        }, "");
        AblePanelHelper.addButton(jPanel, "Apply", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspectorOptionsDialog.this.ApplyButton_actionPerformed(actionEvent);
            }
        }, "");
        AblePanelHelper.addButton(jPanel, "Cancel", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspectorOptionsDialog.this.CancelButton_actionPerformed(actionEvent);
            }
        }, "");
        jPanel.add(Box.createHorizontalStrut(40));
        AblePanelHelper.addButton(jPanel, "Help", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspectorOptionsDialog.this.HelpButton_actionPerformed(actionEvent);
            }
        }, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void OKButton_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.updateContext();
            this.endCustomizer(false);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleInspectorOptionsDialog Error: updateContext()", 0);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ApplyButton_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.updateContext();
            AbleInspectorPanel ableInspectorPanel = (AbleInspectorPanel)((Object)this.myTabbedPane.getSelectedComponent());
            ableInspectorPanel.setView();
            this.myInspector.setContext(this.myContext);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleInspectorOptionsDialog Error: updateContext()", 0);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void CancelButton_actionPerformed(ActionEvent actionEvent) {
        this.endCustomizer(true);
    }

    private void endCustomizer(boolean bl) {
        this.isCancelled = bl;
        this.setVisible(false);
        this.dispose();
    }

    private void HelpButton_actionPerformed(ActionEvent actionEvent) {
        Component component = this.myTabbedPane.getSelectedComponent();
        if (component != null && component instanceof AbleInspectorPanel) {
            try {
                URL uRL = new URL(((AbleInspectorPanel)((Object)component)).getHelpContext(), ((AbleInspectorPanel)((Object)component)).getHelpFileName());
                AbleHelp.displayHelpURL(this, uRL);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public class TimePlotPanel
    extends JPanel
    implements AbleInspectorPanel {
        AbleInspectorContext myContext = null;

        public TimePlotPanel() {
            this.initializePanel();
        }

        private void initializePanel() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel("Use the General tab for base customizable properties for now."), new AbleGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(10, 10, 10, 0), 0, 0));
            this.add((Component)new JLabel("To change advanced properties, right click on the graph."), new AbleGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
        }

        public void setObject(Object object) {
            this.myContext = (AbleInspectorContext)object;
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
            }
        }

        public void updateObject() throws Exception {
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
            }
        }

        public String getName() {
            return "Time Plot";
        }

        public void setView() {
            this.myContext.textView = 0;
            this.myContext.view = 5;
        }

        public void setPanel(Object object) {
        }

        public String getHelpFileName() {
            return AbleHelp.helpFilesPath + "editor/doc-files/AbleInspectorTimePlotHelp.html";
        }

        public URL getHelpContext() {
            return Able.HomeUrl;
        }
    }

    public class ScatterPlotPanel
    extends JPanel
    implements AbleInspectorPanel {
        AbleInspectorContext myContext = null;

        public ScatterPlotPanel() {
            this.initializePanel();
        }

        private void initializePanel() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel("Use the General tab for base customizable properties for now."), new AbleGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(10, 10, 10, 0), 0, 0));
            this.add((Component)new JLabel("To change advanced properties, right click on the graph."), new AbleGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
        }

        public void setObject(Object object) {
            this.myContext = (AbleInspectorContext)object;
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
            }
        }

        public void updateObject() throws Exception {
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
            }
        }

        public String getName() {
            return "Scatter Plot";
        }

        public void setView() {
            this.myContext.textView = 0;
            this.myContext.view = 4;
        }

        public void setPanel(Object object) {
        }

        public String getHelpFileName() {
            return AbleHelp.helpFilesPath + "editor/doc-files/AbleInspectorScatterPlotHelp.html";
        }

        public URL getHelpContext() {
            return Able.HomeUrl;
        }
    }

    public class LineChartPanel
    extends JPanel
    implements AbleInspectorPanel {
        AbleInspectorContext myContext = null;

        public LineChartPanel() {
            this.initializePanel();
        }

        private void initializePanel() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel("Use the General tab for base customizable properties for now."), new AbleGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(10, 10, 10, 0), 0, 0));
            this.add((Component)new JLabel("To change advanced properties, right click on the graph."), new AbleGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
        }

        public void setObject(Object object) {
            this.myContext = (AbleInspectorContext)object;
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
            }
        }

        public void updateObject() throws Exception {
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
            }
        }

        public String getName() {
            return "Line Chart";
        }

        public void setView() {
            this.myContext.textView = 0;
            this.myContext.view = 3;
        }

        public void setPanel(Object object) {
        }

        public String getHelpFileName() {
            return AbleHelp.helpFilesPath + "editor/doc-files/AbleInspectorLineChartHelp.html";
        }

        public URL getHelpContext() {
            return Able.HomeUrl;
        }
    }

    public class StackedBarPanel
    extends JPanel
    implements AbleInspectorPanel {
        JCheckBox myHorizontalCheckBox = null;
        JCheckBox my100PercentCheckBox = null;
        AbleInspectorContext myContext = null;

        public StackedBarPanel() {
            this.initializePanel();
        }

        private void initializePanel() {
            this.setLayout(new GridBagLayout());
            this.myHorizontalCheckBox = new JCheckBox("Horizontal");
            this.myHorizontalCheckBox.setSelected(false);
            this.add((Component)this.myHorizontalCheckBox, new AbleGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
            this.my100PercentCheckBox = new JCheckBox("100 percent");
            this.my100PercentCheckBox.setSelected(false);
            this.add((Component)this.my100PercentCheckBox, new AbleGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
        }

        public void setObject(Object object) {
            this.myContext = (AbleInspectorContext)object;
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
                this.myHorizontalCheckBox.setSelected(chartDataView.getIsInverted());
                JCBarChartFormat jCBarChartFormat = chartDataView.getBarChartFormat();
                if (jCBarChartFormat != null) {
                    this.my100PercentCheckBox.setSelected(jCBarChartFormat.get100Percent());
                }
            }
        }

        public void updateObject() throws Exception {
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
                chartDataView.setIsInverted(this.myHorizontalCheckBox.isSelected());
                JCBarChartFormat jCBarChartFormat = chartDataView.getBarChartFormat();
                if (jCBarChartFormat != null) {
                    jCBarChartFormat.set100Percent(this.my100PercentCheckBox.isSelected());
                }
            }
        }

        public String getName() {
            return "Stacked Bar";
        }

        public void setView() {
            this.myContext.textView = 0;
            this.myContext.view = 8;
        }

        public void setPanel(Object object) {
        }

        public String getHelpFileName() {
            return AbleHelp.helpFilesPath + "editor/doc-files/AbleInspectorStackedBarHelp.html";
        }

        public URL getHelpContext() {
            return Able.HomeUrl;
        }
    }

    public class BarChartPanel
    extends JPanel
    implements AbleInspectorPanel {
        JCheckBox myHorizontalCheckBox = null;
        AbleInspectorContext myContext = null;

        public BarChartPanel() {
            this.initializePanel();
        }

        private void initializePanel() {
            this.setLayout(new GridBagLayout());
            this.myHorizontalCheckBox = new JCheckBox("Horizontal");
            this.myHorizontalCheckBox.setSelected(false);
            this.add((Component)this.myHorizontalCheckBox, new AbleGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
        }

        public void setObject(Object object) {
            this.myContext = (AbleInspectorContext)object;
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
                this.myHorizontalCheckBox.setSelected(chartDataView.getIsInverted());
            }
        }

        public void updateObject() throws Exception {
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
                chartDataView.setIsInverted(this.myHorizontalCheckBox.isSelected());
            }
        }

        public String getName() {
            return "Bar Chart";
        }

        public void setView() {
            this.myContext.textView = 0;
            this.myContext.view = 0;
        }

        public void setPanel(Object object) {
        }

        public String getHelpFileName() {
            return AbleHelp.helpFilesPath + "editor/doc-files/AbleInspectorBarChartHelp.html";
        }

        public URL getHelpContext() {
            return Able.HomeUrl;
        }
    }

    public class StackedAreaPanel
    extends JPanel
    implements AbleInspectorPanel {
        AbleInspectorContext myContext = null;

        public StackedAreaPanel() {
            this.initializePanel();
        }

        private void initializePanel() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel("Use the General tab for base customizable properties for now."), new AbleGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(10, 10, 10, 0), 0, 0));
            this.add((Component)new JLabel("To change advanced properties, right click on the graph."), new AbleGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
        }

        public void setObject(Object object) {
            this.myContext = (AbleInspectorContext)object;
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
            }
        }

        public void updateObject() throws Exception {
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
            }
        }

        public String getName() {
            return "Stacked Area";
        }

        public void setView() {
            this.myContext.textView = 0;
            this.myContext.view = 7;
        }

        public void setPanel(Object object) {
        }

        public String getHelpFileName() {
            return AbleHelp.helpFilesPath + "editor/doc-files/AbleInspectorStackedAreaHelp.html";
        }

        public URL getHelpContext() {
            return Able.HomeUrl;
        }
    }

    public class AreaChartPanel
    extends JPanel
    implements AbleInspectorPanel {
        AbleInspectorContext myContext = null;

        public AreaChartPanel() {
            this.initializePanel();
        }

        private void initializePanel() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel("Use the General tab for base customizable properties for now."), new AbleGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(10, 10, 10, 0), 0, 0));
            this.add((Component)new JLabel("To change advanced properties, right click on the graph."), new AbleGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
        }

        public void setObject(Object object) {
            this.myContext = (AbleInspectorContext)object;
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
            }
        }

        public void updateObject() throws Exception {
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
            }
        }

        public String getName() {
            return "Area";
        }

        public void setView() {
            this.myContext.textView = 0;
            this.myContext.view = 6;
        }

        public void setPanel(Object object) {
        }

        public String getHelpFileName() {
            return AbleHelp.helpFilesPath + "editor/doc-files/AbleInspectorAreaChartHelp.html";
        }

        public URL getHelpContext() {
            return Able.HomeUrl;
        }
    }

    public class TextSeriesPanel
    extends JPanel
    implements AbleInspectorPanel {
        AbleInspectorContext myContext = null;

        public TextSeriesPanel() {
            this.initializePanel();
        }

        private void initializePanel() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel("No base customizable properties yet defined."), new AbleGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 0), 0, 0));
        }

        public void setObject(Object object) {
            this.myContext = (AbleInspectorContext)object;
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
            }
        }

        public void updateObject() throws Exception {
            if (this.myContext.chart != null) {
                ChartDataView chartDataView = this.myContext.chart.getDataView(0);
            }
        }

        public String getName() {
            return "Text Series";
        }

        public void setView() {
            this.myContext.textView = 3;
        }

        public void setPanel(Object object) {
        }

        public String getHelpFileName() {
            return AbleHelp.helpFilesPath + "editor/doc-files/AbleInspectorTextSeriesHelp.html";
        }

        public URL getHelpContext() {
            return Able.HomeUrl;
        }
    }

    public class TextPanel
    extends JPanel
    implements AbleInspectorPanel {
        JTextField myNumberOfColumnsTextField = null;
        AbleInspectorContext myContext = null;

        public TextPanel() {
            this.initializePanel();
        }

        private void initializePanel() {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel("Number of columns:");
            this.add((Component)jLabel, new AbleGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
            this.myNumberOfColumnsTextField = new JTextField();
            this.myNumberOfColumnsTextField.setToolTipText("Number of array columns to display before starting a new row");
            this.add((Component)this.myNumberOfColumnsTextField, new AbleGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 10, 10), 20, 0));
        }

        public void setObject(Object object) {
            this.myContext = (AbleInspectorContext)object;
            this.myNumberOfColumnsTextField.setText(String.valueOf(this.myContext.numColumns));
        }

        public void updateObject() throws Exception {
            try {
                this.myContext.numColumns = Integer.parseInt(this.myNumberOfColumnsTextField.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("Non-numeric input provided on " + this.getName() + numberFormatException.toString());
            }
            catch (NullPointerException nullPointerException) {
                throw new Exception("Blank input provided on " + this.getName() + nullPointerException.toString());
            }
        }

        public String getName() {
            return "Text";
        }

        public void setView() {
            this.myContext.textView = 2;
        }

        public void setPanel(Object object) {
        }

        public String getHelpFileName() {
            return AbleHelp.helpFilesPath + "editor/doc-files/AbleInspectorTextHelp.html";
        }

        public URL getHelpContext() {
            return Able.HomeUrl;
        }
    }
}

