/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.Able;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.editor.AbleGridBagConstraints;
import com.ibm.able.editor.AbleInspector;
import com.ibm.able.editor.AbleInspectorContext;
import com.ibm.able.editor.AbleInspectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class AbleInspectorLoggingDialog
extends JDialog {
    private boolean myFrameSizeAdjusted = false;
    private boolean isCancelled = false;
    private JFrame myFrameParent = null;
    private AbleInspector myInspector = null;
    private AbleInspectorContext myContext = null;
    private RefreshRatePanel myPanel = null;

    public AbleInspectorLoggingDialog(AbleInspector ableInspector, String string, boolean bl) {
        super(ableInspector, string, bl);
        this.myFrameParent = ableInspector;
        this.myInspector = ableInspector;
        this.setVisible(false);
        this.setSize(400, 300);
        this.initializePanel();
    }

    private AbleInspectorLoggingDialog() {
        this(new AbleInspector(null), "", false);
    }

    public AbleInspectorLoggingDialog(String string) {
        this();
        this.setTitle(string);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString(), "AbleInspectorLoggingDialog()", 0);
        }
        new AbleInspectorLoggingDialog().setVisible(true);
    }

    public void setData(int n) {
        this.myPanel.setObject(new Integer(n));
    }

    private void updateContext() throws Exception {
        this.myPanel.updateObject();
    }

    public int getData() {
        return this.myPanel.getRate();
    }

    public boolean userCancelled() {
        return this.isCancelled;
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.myFrameSizeAdjusted) {
            return;
        }
        this.myFrameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    private void initializePanel() {
        boolean bl = false;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        this.myPanel = new RefreshRatePanel();
        container.add((Component)this.myPanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2, 5, 5));
        container.add((Component)jPanel, "South");
        AblePanelHelper.addButton(jPanel, "OK", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspectorLoggingDialog.this.OKButton_actionPerformed(actionEvent);
            }
        }, "");
        AblePanelHelper.addButton(jPanel, "Cancel", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspectorLoggingDialog.this.CancelButton_actionPerformed(actionEvent);
            }
        }, "");
        jPanel.add(Box.createHorizontalStrut(40));
        AblePanelHelper.addButton(jPanel, "Help", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspectorLoggingDialog.this.HelpButton_actionPerformed(actionEvent);
            }
        }, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void OKButton_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.updateContext();
            this.endCustomizer(false);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleInspectorLoggingDialog Error: updateContext()", 0);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ApplyButton_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.updateContext();
            RefreshRatePanel refreshRatePanel = this.myPanel;
            refreshRatePanel.setView();
            this.myInspector.setContext(this.myContext);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleInspectorLoggingDialog Error: updateContext()", 0);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void CancelButton_actionPerformed(ActionEvent actionEvent) {
        this.endCustomizer(true);
    }

    private void endCustomizer(boolean bl) {
        this.isCancelled = bl;
        this.setVisible(false);
        this.dispose();
    }

    private void HelpButton_actionPerformed(ActionEvent actionEvent) {
        RefreshRatePanel refreshRatePanel = this.myPanel;
        if (refreshRatePanel != null && refreshRatePanel instanceof AbleInspectorPanel) {
            try {
                URL uRL = new URL(((AbleInspectorPanel)refreshRatePanel).getHelpContext(), ((AbleInspectorPanel)refreshRatePanel).getHelpFileName());
                AbleHelp.displayHelpURL(this, uRL);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public class RefreshRatePanel
    extends JPanel
    implements AbleInspectorPanel {
        JTextField myRefreshRateTextField = null;
        int myRate = 1;

        public RefreshRatePanel() {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel("Refresh rate:");
            this.add((Component)jLabel, new AbleGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
            this.myRefreshRateTextField = new JTextField();
            this.add((Component)this.myRefreshRateTextField, new AbleGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 10, 10), 20, 0));
            this.myRefreshRateTextField.setToolTipText("Refresh the inspector after this number of events");
        }

        public void setObject(Object object) {
            this.myRate = (Integer)object;
            this.myRefreshRateTextField.setText(String.valueOf(this.myRate));
        }

        public void updateObject() throws Exception {
            try {
                this.myRate = Integer.parseInt(this.myRefreshRateTextField.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("Non-numeric input provided on " + this.getName() + numberFormatException.toString());
            }
            catch (NullPointerException nullPointerException) {
                throw new Exception("Blank input provided on " + this.getName() + nullPointerException.toString());
            }
        }

        public int getRate() {
            return this.myRate;
        }

        public String getName() {
            return "Refresh Rate";
        }

        public void setView() {
        }

        public void setPanel(Object object) {
        }

        public String getHelpFileName() {
            return AbleHelp.helpFilesPath + "editor/doc-files/AbleInspectorRefreshRateHelp.html";
        }

        public URL getHelpContext() {
            return Able.HomeUrl;
        }
    }
}

