/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.Able;
import com.ibm.able.AbleHelp;
import com.ibm.able.editor.AbleGridBagConstraints;
import com.ibm.able.editor.AbleInspector;
import com.ibm.able.editor.AbleInspectorContext;
import com.ibm.able.editor.AbleInspectorPanel;
import com.ibm.able.editor.AbleNetworkGraphicPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jclass.chart.JCAxis;
import jclass.chart.JCLegend;

public class AbleInspectorGeneralPanel
extends JPanel
implements AbleInspectorPanel {
    private static Vector LegendAnchorStrings = new Vector();
    private static final int XAxis = 0;
    private static final int YAxis = 1;
    private static final String DefaultItem = "Default";
    private boolean myFrameSizeAdjusted = false;
    private AbleInspectorContext myContext = null;
    private JTextArea myTitleTextArea = null;
    private JTabbedPane myAxisTabbedPane = null;
    private JComboBox myLegendPositionComboBox = null;
    private JCheckBox myLegendCheckBox = null;
    private JTextArea myFooterTextArea = null;
    private AxesPanel myXAxisPanel = null;
    private AxesPanel myYAxisPanel = null;

    public AbleInspectorGeneralPanel() {
        this.setLayout(new GridBagLayout());
        this.setBounds(2, 26, 520, 377);
        this.initializePanel();
    }

    public void setObject(Object object) {
        this.myContext = (AbleInspectorContext)object;
        if (this.myContext.chart != null) {
            this.myTitleTextArea.setText(this.myContext.chart.getHeader().getText());
            int n = this.myContext.chart.getLegend().getAnchor();
            for (int i = 0; i < JCLegend.anchor_values.length; ++i) {
                if (n != JCLegend.anchor_values[i]) continue;
                this.myLegendPositionComboBox.setSelectedIndex(i);
                break;
            }
            this.myLegendCheckBox.setSelected(this.myContext.chart.getLegend().getIsShowing());
            this.myFooterTextArea.setText(this.myContext.chart.getFooter().getText());
            this.myXAxisPanel.setObject(this.myContext);
            this.myYAxisPanel.setObject(this.myContext);
        }
    }

    public void updateObject() throws Exception {
        if (this.myContext.chart != null) {
            try {
                this.myContext.chart.getHeader().setText(this.myTitleTextArea.getText());
                this.myContext.chart.getLegend().setAnchor(JCLegend.anchor_values[this.myLegendPositionComboBox.getSelectedIndex()]);
                this.myContext.chart.getLegend().setIsShowing(this.myLegendCheckBox.isSelected());
                this.myContext.chart.getFooter().setText(this.myFooterTextArea.getText());
                this.myXAxisPanel.updateObject();
                this.myYAxisPanel.updateObject();
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("Non-numeric input provided on " + this.getName() + numberFormatException.toString());
            }
            catch (NullPointerException nullPointerException) {
                throw new Exception("Blank input provided on " + this.getName() + nullPointerException.toString());
            }
        }
    }

    public String getName() {
        return "General";
    }

    public void setView() {
        if (this.myContext.textView != 0) {
            this.myContext.view = 0;
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "editor/doc-files/AbleInspectorGeneralHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private void initializePanel() {
        JLabel jLabel = new JLabel("Title:");
        this.add((Component)jLabel, new AbleGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setOpaque(true);
        this.add((Component)jScrollPane, new AbleGridBagConstraints(1, 0, 3, 1, 0.4, 0.3, 12, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.myTitleTextArea = new JTextArea();
        jScrollPane.getViewport().add(this.myTitleTextArea);
        this.myAxisTabbedPane = new JTabbedPane();
        this.add((Component)this.myAxisTabbedPane, new AbleGridBagConstraints(0, 3, 4, 8, 0.5, 0.4, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.myXAxisPanel = new AxesPanel(0);
        this.myAxisTabbedPane.add("X axis", this.myXAxisPanel);
        this.myYAxisPanel = new AxesPanel(1);
        this.myAxisTabbedPane.add("Y axis", this.myYAxisPanel);
        this.myLegendPositionComboBox = new JComboBox();
        this.add((Component)this.myLegendPositionComboBox, new AbleGridBagConstraints(2, 11, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.myLegendPositionComboBox.setModel(new DefaultComboBoxModel(LegendAnchorStrings));
        this.myLegendCheckBox = new JCheckBox();
        this.myLegendCheckBox.setText("Show legend at position");
        this.myLegendCheckBox.setActionCommand("Show legend at position");
        this.myLegendCheckBox.setSelected(true);
        this.myLegendCheckBox.setToolTipText("Show or hide the chart legend");
        this.add((Component)this.myLegendCheckBox, new AbleGridBagConstraints(0, 11, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 10, 0), 0, 0));
        JLabel jLabel2 = new JLabel("Footer:");
        this.add((Component)jLabel2, new AbleGridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 10, 10, 0), 0, 0));
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setOpaque(true);
        this.add((Component)jScrollPane2, new AbleGridBagConstraints(1, 12, 3, 3, 0.4, 0.3, 14, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.myFooterTextArea = new JTextArea();
        jScrollPane2.getViewport().add(this.myFooterTextArea);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.myFrameSizeAdjusted) {
            return;
        }
        this.myFrameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    public JPanel getCustomizer() {
        return new AbleNetworkGraphicPanel();
    }

    public void setPanel(Object object) {
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static {
        for (int i = 0; i < JCLegend.anchor_strings.length; ++i) {
            LegendAnchorStrings.addElement(JCLegend.anchor_strings[i]);
        }
    }

    public class AxesPanel
    extends JPanel
    implements AbleInspectorPanel {
        int myAxisMode = 0;
        AbleInspectorContext myContext = null;
        JCAxis myAxis = null;
        JTextField myAxisTitleTextField = null;
        JComboBox myOriginValueComboBox = null;
        JComboBox myMaximumValueComboBox = null;
        JComboBox myTickSpacingComboBox = null;
        JComboBox myTickNumSpacingComboBox = null;

        public AxesPanel(int n) {
            this.myAxisMode = n;
            this.setLayout(new GridBagLayout());
            this.initializePanel();
        }

        private void initializePanel() {
            this.setLayout(new GridBagLayout());
            this.setSize(496, 159);
            this.add((Component)new JLabel("Axis Title:"), new AbleGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
            this.myAxisTitleTextField = new JTextField();
            this.add((Component)this.myAxisTitleTextField, new AbleGridBagConstraints(1, 0, 5, 1, 0.5, 0.0, 18, 2, new Insets(10, 10, 10, 10), 0, 0));
            this.add((Component)new JLabel("Scale:"), new AbleGridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 0), 0, 0));
            this.add((Component)new JLabel("Origin value"), new AbleGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 10, 0), 0, 0));
            this.myOriginValueComboBox = new JComboBox();
            this.myOriginValueComboBox.setToolTipText("Origin axis value");
            this.myOriginValueComboBox.setEditable(true);
            this.myOriginValueComboBox.addItem(AbleInspectorGeneralPanel.DefaultItem);
            this.add((Component)this.myOriginValueComboBox, new AbleGridBagConstraints(2, 1, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 5, 10, 0), 0, 0));
            this.add((Component)new JLabel("Maximum value"), new AbleGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 10, 0), 0, 0));
            this.myMaximumValueComboBox = new JComboBox();
            this.myMaximumValueComboBox.setToolTipText("Maximum axis value");
            this.myMaximumValueComboBox.setEditable(true);
            this.myMaximumValueComboBox.addItem(AbleInspectorGeneralPanel.DefaultItem);
            this.add((Component)this.myMaximumValueComboBox, new AbleGridBagConstraints(4, 1, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 5, 10, 5), 0, 0));
            this.add((Component)new JLabel("Tick Marks:"), new AbleGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 0), 0, 0));
            this.add((Component)new JLabel("Interval"), new AbleGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 10, 0), 0, 0));
            this.myTickSpacingComboBox = new JComboBox();
            this.myTickSpacingComboBox.setToolTipText("Data value increment between tick marks");
            this.myTickSpacingComboBox.setEditable(true);
            this.myTickSpacingComboBox.addItem(AbleInspectorGeneralPanel.DefaultItem);
            this.add((Component)this.myTickSpacingComboBox, new AbleGridBagConstraints(2, 2, 1, 1, 0.5, 0.0, 10, 0, new Insets(0, 5, 10, 0), 0, 0));
            this.add((Component)new JLabel("Label every"), new AbleGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 20, 10, 0), 0, 0));
            this.myTickNumSpacingComboBox = new JComboBox();
            this.myTickNumSpacingComboBox.setToolTipText("Data value increment between tick mark labels");
            this.myTickNumSpacingComboBox.setEditable(true);
            this.myTickNumSpacingComboBox.addItem(AbleInspectorGeneralPanel.DefaultItem);
            this.add((Component)this.myTickNumSpacingComboBox, new AbleGridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 10, 5), 0, 0));
            this.add((Component)new JLabel("units"), new AbleGridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
        }

        public void setObject(Object object) {
            this.myContext = (AbleInspectorContext)object;
            if (this.myContext.chart != null) {
                if (this.myAxisMode == 0) {
                    this.myAxis = this.myContext.chart.getChartArea().getXAxis(0);
                } else if (this.myAxisMode == 1) {
                    this.myAxis = this.myContext.chart.getChartArea().getYAxis(0);
                }
                if (this.myAxis != null) {
                    String string;
                    this.myAxisTitleTextField.setText(this.myAxis.getTitle().getText());
                    if (this.myAxis.getOriginIsDefault()) {
                        this.myOriginValueComboBox.setSelectedItem(AbleInspectorGeneralPanel.DefaultItem);
                    } else {
                        string = String.valueOf(this.myAxis.getOrigin());
                        this.myOriginValueComboBox.setModel(this.newComboBoxModel(string));
                    }
                    if (this.myAxis.getMaxIsDefault()) {
                        this.myMaximumValueComboBox.setSelectedItem(AbleInspectorGeneralPanel.DefaultItem);
                    } else {
                        string = String.valueOf(this.myAxis.getMax());
                        this.myMaximumValueComboBox.setModel(this.newComboBoxModel(string));
                    }
                    if (this.myAxis.getTickSpacingIsDefault()) {
                        this.myTickSpacingComboBox.setSelectedItem(AbleInspectorGeneralPanel.DefaultItem);
                    } else {
                        string = String.valueOf(this.myAxis.getTickSpacing());
                        this.myTickSpacingComboBox.setModel(this.newComboBoxModel(string));
                    }
                    if (this.myAxis.getNumSpacingIsDefault()) {
                        this.myTickNumSpacingComboBox.setSelectedItem(AbleInspectorGeneralPanel.DefaultItem);
                    } else {
                        string = String.valueOf(this.myAxis.getNumSpacing());
                        this.myTickNumSpacingComboBox.setModel(this.newComboBoxModel(string));
                    }
                }
            }
        }

        private DefaultComboBoxModel newComboBoxModel(String string) {
            Vector<String> vector = new Vector<String>();
            vector.addElement(string);
            vector.addElement(AbleInspectorGeneralPanel.DefaultItem);
            return new DefaultComboBoxModel(vector);
        }

        public void updateObject() throws Exception {
            if (this.myAxis != null) {
                try {
                    this.myAxis.getTitle().setText(this.myAxisTitleTextField.getText());
                    String string = ((String)this.myOriginValueComboBox.getSelectedItem()).trim();
                    if (AbleInspectorGeneralPanel.DefaultItem.equals(string)) {
                        this.myAxis.setOriginIsDefault(true);
                    } else {
                        this.myAxis.setOrigin(this.asDouble(string));
                        this.myAxis.setOriginIsDefault(false);
                    }
                    string = ((String)this.myMaximumValueComboBox.getSelectedItem()).trim();
                    if (AbleInspectorGeneralPanel.DefaultItem.equals(string)) {
                        this.myAxis.setMaxIsDefault(true);
                    } else {
                        this.myAxis.setMax(this.asDouble(string));
                        this.myAxis.setMaxIsDefault(false);
                    }
                    string = ((String)this.myTickSpacingComboBox.getSelectedItem()).trim();
                    if (AbleInspectorGeneralPanel.DefaultItem.equals(string)) {
                        this.myAxis.setTickSpacingIsDefault(true);
                    } else {
                        this.myAxis.setTickSpacingIsDefault(false);
                        this.myAxis.setTickSpacing(this.asDouble(string));
                    }
                    string = ((String)this.myTickNumSpacingComboBox.getSelectedItem()).trim();
                    if (AbleInspectorGeneralPanel.DefaultItem.equals(string)) {
                        this.myAxis.setNumSpacingIsDefault(true);
                    } else {
                        this.myAxis.setNumSpacingIsDefault(false);
                        this.myAxis.setNumSpacing(this.asDouble(string));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("Non-numeric input provided on " + this.getName() + numberFormatException.toString());
                }
                catch (NullPointerException nullPointerException) {
                    throw new Exception("Blank input provided on " + this.getName() + nullPointerException.toString());
                }
            }
        }

        public String getName() {
            if (this.myAxisMode == 0) {
                return "X Axis tab";
            }
            if (this.myAxisMode == 1) {
                return "Y Axis tab";
            }
            return "Axis tab";
        }

        public void setView() {
        }

        public void setPanel(Object object) {
        }

        public String getHelpFileName() {
            return AbleHelp.helpFilesPath + "editor/doc-files/AbleInspectorGeneralHelp.html";
        }

        public URL getHelpContext() {
            return Able.HomeUrl;
        }

        public void setInspector(AbleInspector ableInspector) {
        }

        private double asDouble(String string) throws NumberFormatException {
            Double d = new Double(string.trim());
            return d;
        }
    }
}

