/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.AbleBean;
import com.ibm.able.AbleObject;
import com.ibm.able.editor.AbleSeriesItem;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;
import jclass.chart.ChartDataModelUpdate;
import jclass.chart.Chartable;
import jclass.chart.JCChart;

public class AbleInspectorData
extends Observable
implements Chartable,
Serializable {
    protected static final long serialVersionUID = 7621006106094786266L;
    AbleBean myAbleBean;
    Vector myData = new Vector();
    Vector myXSeries = new Vector();
    String[] myPointLabels;
    private int myNumDataPoints;
    private int myCurrentChartView = 0;
    private int myPreviousChartView = 0;
    JCChart myChart;
    transient Hashtable myArrays;
    transient Hashtable myParameters;
    transient Vector mySeriesData;
    String myCurrentArrayName = "";
    Vector myCurrentArrayData = new Vector();
    String myStatsText;

    public AbleInspectorData() {
    }

    public AbleInspectorData(AbleBean ableBean) {
        this.myAbleBean = ableBean;
        this.myData.addElement(new Vector());
        this.myData.addElement(new Vector());
    }

    public int getDataInterpretation() {
        if (this.myCurrentChartView == 4) {
            return 1;
        }
        return 0;
    }

    public Object getDataItem(int n, int n2) {
        Vector vector = this.getRow(n);
        return vector.elementAt(n2);
    }

    public Vector getRow(int n) {
        return (Vector)this.myData.elementAt(n);
    }

    public int getNumRows() {
        return this.myData.size();
    }

    public String[] getPointLabels() {
        Vector vector = this.getRow(0);
        int n = vector.size();
        this.myPointLabels = new String[n];
        for (int i = 0; i < n; ++i) {
            this.myPointLabels[i] = vector.elementAt(i).toString();
        }
        return this.myPointLabels;
    }

    public String getSeriesName(int n) {
        String string = "";
        try {
            string = this.mySeriesData.elementAt(n).toString();
        }
        catch (Exception exception) {
            string = "No series name available.";
        }
        return string;
    }

    public String getSeriesLabel(int n) {
        String string = "";
        try {
            string = this.mySeriesData.elementAt(n).toString();
        }
        catch (Exception exception) {
            string = "No series label available.";
        }
        return string;
    }

    public String getName() {
        try {
            return "Inspector:" + this.myAbleBean.getName();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setModel(AbleObject ableObject) {
        this.myAbleBean = ableObject;
    }

    public void setView(int n) {
        if (this.myCurrentChartView == 4 && n != 4) {
            this.myData.insertElementAt(this.myXSeries, 0);
        } else if (this.myCurrentChartView != 4 && n == 4) {
            this.myData.removeElementAt(0);
        }
        this.myPreviousChartView = this.myCurrentChartView;
        this.myCurrentChartView = n;
    }

    public int getPreviousView() {
        return this.myPreviousChartView;
    }

    public synchronized void setNumPoints(int n) {
        if (n == this.myNumDataPoints) {
            return;
        }
        this.myNumDataPoints = n;
        this.myXSeries.removeAllElements();
        for (int i = 0; i < this.myNumDataPoints; ++i) {
            this.myXSeries.addElement(new Double(i));
        }
        this.myPointLabels = new String[this.myNumDataPoints];
    }

    public void setChart(JCChart jCChart) {
        this.myChart = jCChart;
    }

    public String getStatsText() {
        return this.myStatsText;
    }

    public synchronized void addDataPoint(Double d, Vector vector) {
        if (!vector.isEmpty()) {
            vector.removeElementAt(0);
        }
        vector.addElement(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initArrayData(Object[] objectArray, Hashtable hashtable) {
        Object object;
        Vector vector = new Vector();
        this.myArrays = hashtable;
        this.myCurrentArrayName = (String)objectArray[0];
        this.myCurrentArrayData = vector;
        this.myXSeries.removeAllElements();
        this.myData.removeAllElements();
        this.myData.addElement(this.myXSeries);
        this.myData.addElement(vector);
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.myArrays.get(this.myCurrentArrayName);
        Method method = propertyDescriptor.getReadMethod();
        Object object2 = null;
        try {
            object = this.myAbleBean;
            synchronized (object) {
                object2 = method.invoke((Object)this.myAbleBean, null);
            }
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception + " can't get parameter value for " + this.myCurrentArrayName);
        }
        if (object2 == null) {
            return;
        }
        if (object2 instanceof Vector) {
            object = (Vector)object2;
            int n = ((Vector)object).size();
            for (int i = 0; i < n; ++i) {
                this.myXSeries.addElement(new Double(i));
            }
        } else if (object2 instanceof String[] || object2 instanceof Object[] || object2 instanceof byte[] || object2 instanceof double[] || object2 instanceof float[] || object2 instanceof int[] || object2 instanceof long[] || object2 instanceof short[]) {
            int n = Array.getLength(object2);
            for (int i = 0; i < n; ++i) {
                this.myXSeries.addElement(new Double(i));
            }
        } else {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void setArrayData() {
        Object object;
        this.myCurrentArrayData.removeAllElements();
        Vector vector = this.myCurrentArrayData;
        String string = this.myCurrentArrayName;
        if (this.myCurrentArrayName.trim().length() == 0) {
            System.out.println("AbleInspectorData.setArrayData(): Warning: no array selected.");
            return;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.myArrays.get(string);
        Method method = propertyDescriptor.getReadMethod();
        Object object2 = null;
        try {
            object = this.myAbleBean;
            synchronized (object) {
                object2 = method.invoke((Object)this.myAbleBean, null);
            }
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception + " can't get parameter value for " + string);
        }
        if (object2 == null) {
            return;
        }
        if (object2 instanceof Vector) {
            object = (Vector)object2;
            int n = ((Vector)object).size();
            for (int i = 0; i < n; ++i) {
                Double d = Double.valueOf((String)((Vector)object).elementAt(i));
                vector.addElement(d);
            }
        } else if (object2 instanceof String[]) {
            int n = Array.getLength(object2);
            for (int i = 0; i < n; ++i) {
                Double d = new Double(0.0);
                try {
                    d = Double.valueOf((String)Array.get(object2, i));
                    vector.addElement(d);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    vector.addElement(new Double(0.0));
                }
            }
        } else if (object2 instanceof Object[]) {
            int n = Array.getLength(object2);
            for (int i = 0; i < n; ++i) {
                Double d;
                Object object3 = Array.get(object2, i);
                if (object3 instanceof Number) {
                    d = new Double(((Number)object3).doubleValue());
                    vector.addElement(d);
                    continue;
                }
                if (object3 instanceof String) {
                    d = new Double(0.0);
                    try {
                        d = Double.valueOf((String)Array.get(object2, i));
                        vector.addElement(d);
                    }
                    catch (NumberFormatException numberFormatException) {
                        vector.addElement(new Double(0.0));
                    }
                    continue;
                }
                vector.addElement(new Double(0.0));
            }
        } else if (object2 instanceof byte[] || object2 instanceof double[] || object2 instanceof float[] || object2 instanceof int[] || object2 instanceof long[] || object2 instanceof short[]) {
            int n = Array.getLength(object2);
            for (int i = 0; i < n; ++i) {
                Double d = new Double(Array.getDouble(object2, i));
                vector.addElement(d);
            }
        } else {
            return;
        }
        this.setChanged();
        this.notifyObservers(new ChartDataModelUpdate(14, 0, 0));
    }

    public synchronized void initSeriesData(Vector vector, Hashtable hashtable, Hashtable hashtable2) {
        this.mySeriesData = vector;
        this.myParameters = hashtable;
        this.myArrays = hashtable2;
        int n = this.mySeriesData.size();
        this.myData.removeAllElements();
        if (this.myCurrentChartView == 4) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                this.myData.addElement(new Vector());
            }
            for (n2 = 0; n2 < n; ++n2) {
                Vector vector2 = (Vector)this.myData.elementAt(n2);
                for (int i = 0; i < this.myNumDataPoints; ++i) {
                    vector2.addElement(new Double(0.0));
                }
            }
        } else {
            int n3;
            this.myData.addElement(this.myXSeries);
            for (n3 = 0; n3 < n; ++n3) {
                this.myData.addElement(new Vector());
            }
            for (n3 = 0; n3 < n; ++n3) {
                Vector vector3 = (Vector)this.myData.elementAt(n3 + 1);
                for (int i = 0; i < this.myNumDataPoints; ++i) {
                    vector3.addElement(new Double(0.0));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void setSeriesData() {
        int n = this.mySeriesData.size();
        int n2 = 0;
        if (this.myCurrentChartView != 4) {
            n2 = 1;
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            Method method;
            PropertyDescriptor propertyDescriptor;
            String string;
            AbleSeriesItem ableSeriesItem = (AbleSeriesItem)this.mySeriesData.elementAt(i);
            String string2 = ableSeriesItem.getName();
            Vector vector = (Vector)this.myData.elementAt(n2++);
            String string3 = ableSeriesItem.getIndex();
            int n3 = 0;
            if (!string3.equals("")) {
                n3 = Integer.parseInt(string3);
            }
            if (this.myParameters.containsKey(string2)) {
                string = string2;
                propertyDescriptor = (PropertyDescriptor)this.myParameters.get(string);
                method = propertyDescriptor.getReadMethod();
                object3 = "";
                try {
                    object2 = this.myAbleBean;
                    synchronized (object2) {
                        object3 = method.invoke((Object)this.myAbleBean, null);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Error: " + exception + " can't get parameter value for " + string);
                }
                if (object3 == null) {
                    this.addDataPoint(new Double(0.0), vector);
                    continue;
                }
                if (object3 instanceof String) {
                    try {
                        object2 = Double.valueOf((String)object3);
                        this.addDataPoint((Double)object2, vector);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.addDataPoint(new Double(0.0), vector);
                    }
                    continue;
                }
                if (object3 instanceof Number) {
                    object2 = new Double(((Number)object3).doubleValue());
                    this.addDataPoint((Double)object2, vector);
                    continue;
                }
                this.addDataPoint(new Double(0.0), vector);
                continue;
            }
            if (!this.myArrays.containsKey(string2)) continue;
            string = string2;
            propertyDescriptor = (PropertyDescriptor)this.myArrays.get(string);
            method = propertyDescriptor.getReadMethod();
            object3 = "";
            try {
                object2 = this.myAbleBean;
                synchronized (object2) {
                    object3 = method.invoke((Object)this.myAbleBean, null);
                }
            }
            catch (Exception exception) {
                System.out.println("Error: " + exception + " can't get parameter value for " + string);
            }
            if (object3 == null) {
                this.addDataPoint(new Double(0.0), vector);
                continue;
            }
            if (object3 instanceof Vector) {
                object2 = (Vector)object3;
                try {
                    object = Double.valueOf((String)object2.elementAt(n3));
                    this.addDataPoint((Double)object, vector);
                }
                catch (NumberFormatException numberFormatException) {
                    this.addDataPoint(new Double(0.0), vector);
                }
                continue;
            }
            if (object3 instanceof String[]) {
                object2 = (String[])object3;
                try {
                    object = Double.valueOf(object2[n3]);
                    this.addDataPoint((Double)object, vector);
                }
                catch (NumberFormatException numberFormatException) {
                    this.addDataPoint(new Double(0.0), vector);
                }
                continue;
            }
            if (object3 instanceof Object[]) {
                object2 = (Object[])object3;
                try {
                    Double d;
                    object = object2[n3];
                    if (object instanceof String) {
                        d = Double.valueOf((String)object2[n3]);
                        this.addDataPoint(d, vector);
                        continue;
                    }
                    if (object instanceof Double) {
                        d = (Double)object2[n3];
                        this.addDataPoint(d, vector);
                        continue;
                    }
                    if (!(object instanceof Integer)) continue;
                    d = new Double(((Integer)object2[n3]).intValue());
                    this.addDataPoint(d, vector);
                }
                catch (NumberFormatException numberFormatException) {
                    this.addDataPoint(new Double(0.0), vector);
                }
                continue;
            }
            if (object3 instanceof byte[] || object3 instanceof double[] || object3 instanceof float[] || object3 instanceof int[] || object3 instanceof long[] || object3 instanceof short[]) {
                object2 = new Double(Array.getDouble(object3, n3));
                this.addDataPoint((Double)object2, vector);
                continue;
            }
            this.addDataPoint(new Double(0.0), vector);
        }
        this.setChanged();
        this.notifyObservers(new ChartDataModelUpdate(14, 0, 0));
    }

    public Vector getSeriesData() {
        return this.myData;
    }

    public String computeStatistics() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.myData.size();
        Vector vector = null;
        Vector vector2 = null;
        if (n == 1) {
            return "Can't compute stats for a single array";
        }
        if (n == 2) {
            vector = (Vector)this.myData.elementAt(0);
            vector2 = (Vector)this.myData.elementAt(1);
        } else if (n == 3) {
            vector = (Vector)this.myData.elementAt(1);
            vector2 = (Vector)this.myData.elementAt(2);
        } else {
            return "Can't compute stats for more than 2 arrays";
        }
        int n2 = vector.size();
        if (n2 != vector2.size()) {
            return "Stats arrays are of different sizes ";
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 100.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d19 = (Double)vector.elementAt(i);
            double d20 = (Double)vector2.elementAt(i);
            if (i == 0) {
                d = d19;
                d3 = d19;
                d5 = d20;
                d7 = d20;
            } else {
                if (d19 < d) {
                    d = d19;
                }
                if (d19 > d3) {
                    d3 = d19;
                }
                if (d20 < d5) {
                    d5 = d20;
                }
                if (d20 > d7) {
                    d7 = d20;
                }
            }
            d13 += d19;
            d15 += d20;
            d14 += d19 * d19;
            d16 += d20 * d20;
            d17 += d19 * d20;
            d18 += (d19 - d20) * (d19 - d20);
            double d21 = Math.abs(d19 - d20) / Math.abs(d20) * 100.0;
            System.out.print(d21 + " ");
            if (d21 < d9) {
                d9 = d21;
            }
            if (d21 > d11) {
                d11 = d21;
            }
            d12 += d21;
        }
        d2 = d13 / (double)n2;
        d6 = d15 / (double)n2;
        d10 = d12 / (double)n2;
        d4 = (d14 - d13 * d13 / (double)n2) / (double)n2;
        d8 = (d16 - d15 * d15 / (double)n2) / (double)n2;
        stringBuffer.append("Stats: num items = " + n2 + "\n");
        stringBuffer.append("X min/mean/max =   " + d + " " + d2 + " " + d3 + "\n");
        stringBuffer.append("Y min/mean/max =   " + d5 + " " + d6 + " " + d7 + "\n");
        stringBuffer.append(" Var x = " + d4 + " Var y = " + d8 + "\n");
        stringBuffer.append(" Var x / Var y = " + d4 / d8 + "\n");
        stringBuffer.append("SSx =  " + d14 + "\n");
        stringBuffer.append("SSy =  " + d16 + "\n");
        stringBuffer.append("SSxy = " + d17 + "\n");
        stringBuffer.append("SSE =  " + d18 + "  MSE = " + d18 / (double)n2 + "\n");
        stringBuffer.append("%Error min/mean/max =   " + d9 + " " + d10 + " " + d11 + "\n");
        double d22 = Math.sqrt(d18 / (double)n2);
        stringBuffer.append("RMS =  " + d22 + "\n");
        this.myStatsText = "R2=" + d4 / d8 + " RMS=" + d22 + " %Err=" + d10;
        stringBuffer.append(this.myStatsText + "\n");
        return stringBuffer.toString();
    }
}

