/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleEventListener;
import com.ibm.able.AbleException;
import com.ibm.able.AbleJTextAreaHandler;
import com.ibm.able.AbleLogger;
import com.ibm.able.AbleObject;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.editor.AbleAboutDialog;
import com.ibm.able.editor.AbleArraysDialog;
import com.ibm.able.editor.AbleCustomInspectorView;
import com.ibm.able.editor.AbleEditor;
import com.ibm.able.editor.AbleEditorFrame;
import com.ibm.able.editor.AbleInspectorContext;
import com.ibm.able.editor.AbleInspectorData;
import com.ibm.able.editor.AbleInspectorHolder;
import com.ibm.able.editor.AbleInspectorLoggingDialog;
import com.ibm.able.editor.AbleInspectorOptionsDialog;
import com.ibm.able.editor.AbleInspectorPanel;
import com.ibm.able.editor.AbleParametersDialog;
import com.ibm.able.editor.AblePrintPreviewDialog;
import com.ibm.able.editor.AbleSeriesItem;
import com.ibm.able.editor.AbleViewObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.AttributedString;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jclass.chart.Chartable;
import jclass.chart.EventTrigger;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.JCChartStyle;

public class AbleInspector
extends JFrame
implements AbleEventListener,
PropertyChangeListener,
Printable {
    public static final int PARAMETERS = 0;
    public static final int ARRAYS = 1;
    public static final int BARCHART = 0;
    public static final int BINARYGRID = 1;
    public static final int HINTONDIAGRAM = 2;
    public static final int LINECHART = 3;
    public static final int SCATTERPLOT = 4;
    public static final int TIMEPLOT = 5;
    public static final int AREA = 6;
    public static final int AREASTACKING = 7;
    public static final int BARSTACKING = 8;
    public static final int CHART = 0;
    public static final int CUSTOM = 1;
    public static final int TEXT = 2;
    public static final int TEXTSERIES = 3;
    public static final int TEXTTRACE = 4;
    public static final int TEXTSTATS = 5;
    static NumberFormat myNumberFormat = NumberFormat.getInstance();
    transient AbleViewObject myViewObject;
    AbleBean myUnderlyingObject;
    String myHierarchicalName;
    JCChart myChart = null;
    AbleInspectorData myDataSource;
    AbleInspectorHolder myOwner;
    Object[] myArrayNames;
    transient Hashtable myArrays = new Hashtable();
    Object[] myParameterNames;
    transient Hashtable myParameters = new Hashtable();
    Object[] mySeriesNames;
    transient Hashtable myCustomInspectors = new Hashtable();
    transient Hashtable myCustomInspectorPanels = new Hashtable();
    String myCustomInspectorName = "";
    String myCustomInspectorClass = "";
    Object[] mySelectedArrays = null;
    Vector mySeriesData = new Vector();
    int myNumDataPoints = 1;
    int myDataType = 1;
    int myCurrentChartView = 0;
    int myCurrentViewType = 2;
    public int myNumDisplayColumns = 2;
    int myStepsPerRefresh = 1;
    JMenuBar myMenuBar = new JMenuBar();
    JMenu objectMenu = new JMenu();
    JMenuItem openMenuItem = new JMenuItem();
    JMenuItem saveAsMenuItem = new JMenuItem();
    JMenuItem printMenuItem = new JMenuItem();
    JMenuItem printPreviewMenuItem = new JMenuItem();
    JMenuItem printSetMenuItem = new JMenuItem();
    JMenuItem closeMenuItem = new JMenuItem();
    JMenu editMenu = new JMenu();
    JMenuItem copyMenuItem = new JMenuItem();
    JMenuItem selectAllMenuItem = new JMenuItem();
    JMenuItem clearMenuItem = new JMenuItem();
    JMenu dataMenu = new JMenu();
    JCheckBoxMenuItem paramsMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem arraysMenuItem = new JCheckBoxMenuItem();
    JMenu viewMenu = new JMenu();
    JCheckBoxMenuItem textMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem textTraceMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem textSeriesMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem textStatsMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem barChartMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem binaryGridMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem hintonMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem lineChartMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem scatterPlotMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem timePlotMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem areaMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem areaStackingMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem barStackingMenuItem = new JCheckBoxMenuItem();
    JMenuItem refreshMenuItem = new JMenuItem();
    JMenu optionsMenu = new JMenu();
    ButtonGroup traceButtonGroup = new ButtonGroup();
    JMenu traceMenu = new JMenu();
    JRadioButtonMenuItem traceNoneMenuItem = new JRadioButtonMenuItem();
    JRadioButtonMenuItem traceLowMenuItem = new JRadioButtonMenuItem();
    JRadioButtonMenuItem traceMedMenuItem = new JRadioButtonMenuItem();
    JRadioButtonMenuItem traceHighMenuItem = new JRadioButtonMenuItem();
    JMenuItem settingsMenuItem = new JMenuItem();
    JMenuItem loggingMenuItem = new JMenuItem();
    JMenuItem statisticsMenuItem = new JMenuItem();
    JMenuItem UserReferenceMenuItem = new JMenuItem();
    JMenuItem APIReferenceMenuItem = new JMenuItem();
    JMenuItem InspectorReferenceMenuItem = new JMenuItem();
    JMenuItem TutorialMenuItem = new JMenuItem();
    JMenuItem AboutMenuItem = new JMenuItem();
    JMenu helpMenu = new JMenu();
    JPanel myInspectorPanel = new JPanel();
    JPanel myCustomPanel = new JPanel();
    JPanel myChartPanel = new JPanel();
    JScrollPane myChartScrollPane = new JScrollPane();
    JPanel myTextPanel = new JPanel();
    JScrollPane myTextScrollPane = new JScrollPane();
    JTextArea myTextArea = new JTextArea();
    AbleLogger traceLog = null;
    AbleJTextAreaHandler traceHandler = null;
    Hashtable myViewMenuItems = new Hashtable();
    private static final int POINTS_PER_INCH = 72;
    PageFormat pageFormat = null;
    boolean myRefreshAllowed = true;
    int myCurrentStepCount = 0;
    static /* synthetic */ Class class$java$lang$Object;

    public AbleInspector(AbleViewObject ableViewObject) {
        this.enableEvents(64L);
        try {
            this.myViewObject = ableViewObject;
            this.myUnderlyingObject = ableViewObject.getBean();
            this.myUnderlyingObject.addAbleEventListener((AbleEventListener)this);
            this.myUnderlyingObject.addPropertyChangeListener((PropertyChangeListener)this);
            this.myDataSource = new AbleInspectorData(this.myUnderlyingObject);
            this.introspectBean();
            this.jbInit();
            this.refreshSelectedView();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void handleAbleEvent(AbleEvent ableEvent) {
        ++this.myCurrentStepCount;
        if (this.myCurrentStepCount >= this.myStepsPerRefresh) {
            this.myCurrentStepCount = 0;
            if (this.myRefreshAllowed) {
                this.refreshSelectedView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            if ((this.myCurrentViewType == 2 || this.myCurrentViewType == 3 || this.myCurrentViewType == 5 || this.myCurrentViewType == 4 || this.myCurrentViewType == 1) && this.myRefreshAllowed) {
                this.refreshSelectedView();
            }
        }
    }

    public String getObjectName() {
        try {
            return this.myUnderlyingObject.getName();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public AbleBean getBean() {
        return this.myUnderlyingObject;
    }

    public AbleInspectorContext getContext() {
        AbleInspectorContext ableInspectorContext = new AbleInspectorContext();
        ableInspectorContext.beanId = this.getHierarchicalName();
        ableInspectorContext.selectedArrays = this.mySelectedArrays;
        ableInspectorContext.seriesData = this.mySeriesData;
        ableInspectorContext.numPoints = this.myNumDataPoints;
        ableInspectorContext.dataType = this.myDataType;
        ableInspectorContext.view = this.myCurrentChartView;
        ableInspectorContext.textView = this.myCurrentViewType;
        ableInspectorContext.numColumns = this.myNumDisplayColumns;
        ableInspectorContext.size = this.getSize();
        ableInspectorContext.location = this.getLocation();
        ableInspectorContext.chart = this.myChart;
        ableInspectorContext.stepsPerRefresh = this.myStepsPerRefresh;
        ableInspectorContext.name = this.myCustomInspectorName;
        if (this.myCustomPanel != null && this.myCustomPanel instanceof AbleCustomInspectorView) {
            ableInspectorContext.customViewData = ((AbleCustomInspectorView)((Object)this.myCustomPanel)).getContext();
        }
        return ableInspectorContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContext(AbleInspectorContext ableInspectorContext) {
        Serializable serializable;
        this.mySelectedArrays = ableInspectorContext.selectedArrays;
        this.mySeriesData = ableInspectorContext.seriesData;
        this.myNumDataPoints = ableInspectorContext.numPoints;
        this.myDataType = ableInspectorContext.dataType;
        this.setDataMenuItemStates();
        this.myCurrentChartView = ableInspectorContext.view;
        this.myCurrentViewType = ableInspectorContext.textView;
        this.myNumDisplayColumns = ableInspectorContext.numColumns;
        this.setSize(ableInspectorContext.size);
        this.setLocation(ableInspectorContext.location);
        this.myChart = ableInspectorContext.chart;
        this.myStepsPerRefresh = ableInspectorContext.stepsPerRefresh;
        if (this.myCurrentViewType == 1) {
            serializable = new ActionEvent(this, 1001, ableInspectorContext.name);
            this.customMenuItem_actionPerformed((ActionEvent)serializable);
            if (this.myCustomPanel != null && this.myCustomPanel instanceof AbleCustomInspectorView) {
                ((AbleCustomInspectorView)((Object)this.myCustomPanel)).setContext(ableInspectorContext);
            }
        }
        if (this.myChart != null) {
            this.myChart.getDataView(0).setDataSource((Chartable)this.myDataSource);
            this.myChartScrollPane.getViewport().add((Component)this.myChart);
        }
        this.myDataSource.setChart(this.myChart);
        this.myDataSource.setNumPoints(this.myNumDataPoints);
        if (this.myDataType == 1) {
            this.myDataSource.initArrayData(this.mySelectedArrays, this.myArrays);
        } else {
            serializable = this.myDataSource;
            synchronized (serializable) {
                this.myDataSource.initSeriesData(this.mySeriesData, this.myParameters, this.myArrays);
            }
        }
        if (this.myCurrentViewType == 0) {
            switch (this.myCurrentChartView) {
                case 6: {
                    this.areaMenuItem_actionPerformed(null);
                    break;
                }
                case 7: {
                    this.areaStackingMenuItem_actionPerformed(null);
                    break;
                }
                case 0: {
                    this.barChartMenuItem_actionPerformed(null);
                    break;
                }
                case 8: {
                    this.barStackingMenuItem_actionPerformed(null);
                    break;
                }
                case 1: {
                    this.binaryGridMenuItem_actionPerformed(null);
                    break;
                }
                case 2: {
                    this.hintonMenuItem_actionPerformed(null);
                    break;
                }
                case 3: {
                    this.lineChartMenuItem_actionPerformed(null);
                    break;
                }
                case 4: {
                    this.scatterPlotMenuItem_actionPerformed(null);
                    break;
                }
                case 5: {
                    this.timePlotMenuItem_actionPerformed(null);
                }
            }
        }
        this.refreshSelectedView();
    }

    public void setOwner(AbleInspectorHolder ableInspectorHolder) {
        this.myOwner = ableInspectorHolder;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            try {
                if (this.traceHandler != null) {
                    AblePanelHelper.removeTraceJTextAreaHandler(this.myUnderlyingObject);
                }
                this.myUnderlyingObject.removeAbleEventListener((AbleEventListener)this);
                this.myUnderlyingObject.removePropertyChangeListener((PropertyChangeListener)this);
                this.myOwner.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void introspectBean() throws AbleException {
        this.myArrayNames = this.myViewObject.getArrayNames();
        this.myArrays = this.myViewObject.getArrays();
        this.myParameterNames = this.myViewObject.getParameterNames();
        this.myParameters = this.myViewObject.getParameters();
        this.mySeriesNames = this.myViewObject.getProperties();
        this.myCustomInspectors = this.myViewObject.getCustomInspectors();
        this.myCustomInspectorPanels = this.myViewObject.getCustomInspectorPanels();
        if (this.mySelectedArrays == null) {
            this.mySelectedArrays = new Object[2];
            this.mySelectedArrays[0] = "inputBuffer";
            this.mySelectedArrays[1] = "outputBuffer";
        }
        if (this.mySeriesData.isEmpty()) {
            AbleSeriesItem ableSeriesItem = new AbleSeriesItem("inputBuffer", "0");
            AbleSeriesItem ableSeriesItem2 = new AbleSeriesItem("outputBuffer", "0");
            this.mySeriesData.addElement(ableSeriesItem);
            this.mySeriesData.addElement(ableSeriesItem2);
            AbleInspectorData ableInspectorData = this.myDataSource;
            synchronized (ableInspectorData) {
                this.myDataSource.setNumPoints(this.myNumDataPoints);
                this.myDataSource.initSeriesData(this.mySeriesData, this.myParameters, this.myArrays);
            }
        }
    }

    void printMenuItem_actionPerformed(ActionEvent actionEvent) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void printPreviewMenuItem_actionPerformed(ActionEvent actionEvent) {
        AblePrintPreviewDialog ablePrintPreviewDialog = new AblePrintPreviewDialog(this.createBook());
        ablePrintPreviewDialog.setTitle(this.getTitle() + " - Print Preview");
        Point point = this.getLocation();
        ablePrintPreviewDialog.setLocation(point.x + 20, point.y + 20);
        ablePrintPreviewDialog.show();
    }

    void printSetMenuItem_actionPerformed(ActionEvent actionEvent) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.pageFormat == null) {
            this.pageFormat = printerJob.defaultPage();
        }
        this.pageFormat = printerJob.pageDialog(this.pageFormat);
    }

    void closeMenuItem_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myUnderlyingObject.removeAbleEventListener((AbleEventListener)this);
            this.myUnderlyingObject.removePropertyChangeListener((PropertyChangeListener)this);
            this.myOwner.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paramMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.myRefreshAllowed = false;
        AbleParametersDialog ableParametersDialog = new AbleParametersDialog(this, "Select Properties to Inspect", true, this.myUnderlyingObject, this.myParameterNames, this.myArrayNames, this.myArrays, this.mySeriesData, this.myNumDataPoints);
        ableParametersDialog.setLocationRelativeTo(this);
        ableParametersDialog.setVisible(true);
        boolean bl = ableParametersDialog.userCancelled();
        if (!bl) {
            this.myDataType = 0;
            this.mySeriesData = ableParametersDialog.getData();
            this.myNumDataPoints = ableParametersDialog.getNumDataPoints();
            this.myDataSource.setNumPoints(this.myNumDataPoints);
            if (this.mySeriesData != null && this.mySeriesData.size() != 0) {
                AbleInspectorData ableInspectorData = this.myDataSource;
                synchronized (ableInspectorData) {
                    this.myDataSource.initSeriesData(this.mySeriesData, this.myParameters, this.myArrays);
                }
                this.setLabels();
            }
        }
        this.setDataMenuItemStates();
        this.refreshSelectedView();
        this.myRefreshAllowed = true;
        if (!bl) {
            this.setSymbols();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void arraysMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.myRefreshAllowed = false;
        Point point = this.getLocation();
        AbleArraysDialog ableArraysDialog = new AbleArraysDialog(this, "Select Arrays", true);
        ableArraysDialog.setData(this.myArrayNames, this.mySelectedArrays);
        ableArraysDialog.setLocation(point.x + 20, point.y + 20);
        ableArraysDialog.setVisible(true);
        boolean bl = ableArraysDialog.userCancelled();
        if (!bl) {
            this.myDataType = 1;
            this.mySelectedArrays = ableArraysDialog.getData();
            if (this.mySelectedArrays != null && this.mySelectedArrays.length != 0) {
                AbleInspectorData ableInspectorData = this.myDataSource;
                synchronized (ableInspectorData) {
                    this.myDataSource.initArrayData(this.mySelectedArrays, this.myArrays);
                }
                this.setLabels();
            }
        }
        this.setDataMenuItemStates();
        this.refreshSelectedView();
        if (!bl) {
            this.setSymbols();
        }
        this.myRefreshAllowed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            this.myTextArea.copy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            this.myTextArea.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectAllMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            this.myTextArea.selectAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void customMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            block10: {
                Enumeration enumeration;
                this.myCustomInspectorName = actionEvent.getActionCommand();
                if (this.myCustomInspectorName == null) {
                    enumeration = this.myCustomInspectors.keys();
                    if (enumeration.hasMoreElements()) {
                        this.myCustomInspectorName = (String)enumeration.nextElement();
                    }
                    if (this.myCustomInspectorName == null) {
                        return;
                    }
                }
                if (!this.myCustomInspectors.containsKey(this.myCustomInspectorName)) {
                    return;
                }
                this.myCurrentViewType = 1;
                this.myCustomInspectorClass = (String)this.myCustomInspectors.get(this.myCustomInspectorName);
                enumeration = (JCheckBoxMenuItem)this.myViewMenuItems.get(this.myCustomInspectorName);
                try {
                    Class<?> clazz = Class.forName(this.myCustomInspectorClass);
                    if (this.myCustomPanel == null || this.myCustomPanel != null && this.myCustomPanel.getClass() != clazz) {
                        Constructor<?> constructor = clazz.getConstructor(class$java$lang$Object == null ? (class$java$lang$Object = AbleInspector.class$("java.lang.Object")) : class$java$lang$Object);
                        Object obj = constructor.newInstance(this.myUnderlyingObject);
                        this.myCustomPanel = (JPanel)obj;
                    }
                    this.switchToSelectedView((JCheckBoxMenuItem)((Object)enumeration));
                }
                catch (Exception exception) {
                    Able.MessageLog.text(4L, (Object)this, "customMenuItem_actionPerformed", exception.getLocalizedMessage());
                    if (!Able.TraceLog.isLogging()) break block10;
                    Able.TraceLog.exception(262144L, (Object)this, "customMenuItem_actionPerformed", (Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traceMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            try {
                AbleBean ableBean = this.myUnderlyingObject;
                Object object = actionEvent.getSource();
                if (this.traceHandler != null) {
                    AblePanelHelper.removeTraceJTextAreaHandler(ableBean);
                }
                this.traceHandler = null;
                if (object == this.traceNoneMenuItem) {
                    this.myCurrentViewType = 2;
                    this.switchToSelectedView(this.textMenuItem);
                } else {
                    this.traceLog = Able.startBeanTraceLogging((AbleBean)ableBean);
                    if (object == this.traceLowMenuItem) {
                        this.traceHandler = AblePanelHelper.addTraceJTextAreaHandler(ableBean, 262144L, this.myTextArea);
                        this.myCurrentViewType = 4;
                        this.switchToSelectedView(this.textTraceMenuItem);
                    } else if (object == this.traceMedMenuItem) {
                        this.traceHandler = AblePanelHelper.addTraceJTextAreaHandler(ableBean, 524288L, this.myTextArea);
                        this.myCurrentViewType = 4;
                        this.switchToSelectedView(this.textTraceMenuItem);
                    } else if (object == this.traceHighMenuItem) {
                        this.traceHandler = AblePanelHelper.addTraceJTextAreaHandler(ableBean, 0x100000L, this.myTextArea);
                        this.myCurrentViewType = 4;
                        this.switchToSelectedView(this.textTraceMenuItem);
                    }
                    this.myTextArea.setText("Starting bean trace... \n");
                }
            }
            catch (AbleException ableException) {
                System.out.println("Error: " + ableException.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void textMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            this.myCurrentViewType = 2;
            this.switchToSelectedView(this.textMenuItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void textSeriesMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            this.myCurrentViewType = 3;
            this.switchToSelectedView(this.textSeriesMenuItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void textTraceMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            if (this.traceNoneMenuItem.isSelected()) {
                try {
                    AbleBean ableBean = this.myUnderlyingObject;
                    this.traceHandler = AblePanelHelper.addTraceJTextAreaHandler(ableBean, 524288L, this.myTextArea);
                    this.traceMedMenuItem.setSelected(true);
                    this.myTextArea.setText("Starting bean trace... medium level \n");
                }
                catch (AbleException ableException) {}
            } else {
                this.myTextArea.setText("Starting bean trace... \n");
            }
            this.myCurrentViewType = 4;
            this.switchToSelectedView(this.textTraceMenuItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void areaMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            this.myCurrentViewType = 0;
            this.myCurrentChartView = 6;
            this.myDataSource.setView(this.myCurrentChartView);
            if (this.myChart == null) {
                this.generateChartView(8);
            } else {
                this.myChart.getDataView(0).setChartType(8);
            }
            this.switchToSelectedView(this.areaMenuItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void areaStackingMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            this.myCurrentViewType = 0;
            this.myCurrentChartView = 7;
            this.myDataSource.setView(this.myCurrentChartView);
            if (this.myChart == null) {
                this.generateChartView(12);
            } else {
                this.myChart.getDataView(0).setChartType(12);
            }
            this.switchToSelectedView(this.areaStackingMenuItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void barChartMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            this.myCurrentViewType = 0;
            this.myCurrentChartView = 0;
            this.myDataSource.setView(this.myCurrentChartView);
            if (this.myChart == null) {
                this.generateChartView(9);
            } else {
                this.myChart.getDataView(0).setChartType(9);
            }
            this.switchToSelectedView(this.barChartMenuItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void barStackingMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            this.myCurrentViewType = 0;
            this.myCurrentChartView = 8;
            this.myDataSource.setView(this.myCurrentChartView);
            if (this.myChart == null) {
                this.generateChartView(10);
            } else {
                this.myChart.getDataView(0).setChartType(10);
            }
            this.switchToSelectedView(this.barStackingMenuItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void binaryGridMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            this.myCurrentViewType = 0;
            this.myCurrentChartView = 1;
            this.myDataSource.setView(this.myCurrentChartView);
            if (this.myChart == null) {
                this.generateChartView(9);
            } else {
                this.myChart.getDataView(0).setChartType(9);
            }
            this.switchToSelectedView(this.binaryGridMenuItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hintonMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            this.myCurrentViewType = 0;
            this.myCurrentChartView = 2;
            this.myDataSource.setView(this.myCurrentChartView);
            if (this.myChart == null) {
                this.generateChartView(9);
            } else {
                this.myChart.getDataView(0).setChartType(9);
            }
            this.switchToSelectedView(this.hintonMenuItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lineChartMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            this.myCurrentViewType = 0;
            this.myCurrentChartView = 3;
            this.myDataSource.setView(this.myCurrentChartView);
            if (this.myChart == null) {
                this.generateChartView(0);
            } else {
                this.myChart.getDataView(0).setChartType(0);
            }
            this.switchToSelectedView(this.lineChartMenuItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scatterPlotMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            this.myCurrentViewType = 0;
            this.myCurrentChartView = 4;
            this.myDataSource.setView(this.myCurrentChartView);
            if (this.myChart == null) {
                this.generateChartView(1);
            } else {
                this.myChart.getDataView(0).setChartType(1);
            }
            this.switchToSelectedView(this.scatterPlotMenuItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timePlotMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleInspector ableInspector = this;
        synchronized (ableInspector) {
            this.myCurrentViewType = 0;
            this.myCurrentChartView = 5;
            this.myDataSource.setView(this.myCurrentChartView);
            if (this.myChart == null) {
                this.generateChartView(0);
            } else {
                this.myChart.getDataView(0).setChartType(0);
            }
            this.switchToSelectedView(this.timePlotMenuItem);
        }
    }

    void refreshMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.refreshSelectedView();
    }

    void settingsMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.myRefreshAllowed = false;
        Point point = this.getLocation();
        AbleInspectorOptionsDialog ableInspectorOptionsDialog = new AbleInspectorOptionsDialog(this, "Inspector Options", true);
        ableInspectorOptionsDialog.setContext(this.getContext());
        if (this.myCurrentViewType == 1 && this.myCustomPanel != null) {
            String string = (String)this.myCustomInspectorPanels.get(this.myCustomInspectorName);
            AbleInspectorPanel ableInspectorPanel = null;
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    Object obj = clazz.newInstance();
                    ableInspectorPanel = (AbleInspectorPanel)obj;
                }
                catch (Exception exception) {
                    System.out.println("AbleInspector.settingsMenuItem_actionPerformed(): Caught exception: " + exception);
                }
                ableInspectorPanel.setPanel(this.myCustomPanel);
                ableInspectorOptionsDialog.addTab(ableInspectorPanel);
            }
        }
        ableInspectorOptionsDialog.setLocation(point.x + 20, point.y + 20);
        ableInspectorOptionsDialog.setVisible(true);
        if (!ableInspectorOptionsDialog.userCancelled()) {
            this.setContext(ableInspectorOptionsDialog.getContext());
        }
        this.myRefreshAllowed = true;
    }

    void loggingMenuItem_actionPerformed(ActionEvent actionEvent) {
        Point point = this.getLocation();
        AbleInspectorLoggingDialog ableInspectorLoggingDialog = new AbleInspectorLoggingDialog(this, "Inspector Refresh Rate", true);
        ableInspectorLoggingDialog.setData(this.myStepsPerRefresh);
        ableInspectorLoggingDialog.setLocation(point.x + 20, point.y + 20);
        ableInspectorLoggingDialog.setVisible(true);
        if (!ableInspectorLoggingDialog.userCancelled()) {
            this.myStepsPerRefresh = ableInspectorLoggingDialog.getData();
        }
        this.refreshSelectedView();
    }

    void statisticsMenuItem_actionPerformed(ActionEvent actionEvent) {
        String string = this.myDataSource.computeStatistics();
        this.setLabels("predicted", "actual", this.myDataSource.getStatsText());
        this.myCurrentViewType = 5;
        this.switchToSelectedView(this.textStatsMenuItem);
        this.myTextArea.setText(string);
    }

    void HelpTopicsMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleEditorFrame.displayHelp(this, "HelpTopics.html");
    }

    void UserReferenceMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleEditorFrame.displayHelp(this, "../../doc-files/index.html");
    }

    void APIReferenceMenuItem_actionPerformed(ActionEvent actionEvent) {
        URL uRL = null;
        try {
            uRL = new URL(Able.HomeUrl, "docs/index.html");
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(this, malformedURLException.toString(), "Inspector Error: APIMenuItem_actionPerformed() ", 0);
        }
        AbleEditorFrame.displayHelpURL(this, uRL);
    }

    void InspectorReferenceMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleEditorFrame.displayHelp(this, "Inspector.html");
    }

    void TutorialMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleEditorFrame.displayHelp(this, "Tutorial.html");
    }

    void AboutMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleAboutDialog ableAboutDialog = new AbleAboutDialog(this, "About Able", true);
        ableAboutDialog.setLocationRelativeTo(this);
        ableAboutDialog.setVisible(true);
    }

    public void generateChartView(int n) {
        try {
            this.myChart = new JCChart(n);
            this.myDataSource.setChart(this.myChart);
            this.myChart.setAllowUserChanges(true);
            this.myChart.setBackground(new Color(218, 200, 149));
            this.myChart.getChartArea().setBackground(new Color(255, 231, 186));
            this.myChart.getChartArea().setBorderType(9);
            this.myChart.getChartArea().setBorderWidth(2);
            this.myChart.setTrigger(0, new EventTrigger(4, 6));
            this.myChart.getDataView(0).setDataSource((Chartable)this.myDataSource);
            JCAxis jCAxis = this.myChart.getDataView(0).getXAxis();
            jCAxis.setNumSpacing(50.0);
            JCAxis jCAxis2 = this.myChart.getDataView(0).getYAxis();
            jCAxis2.setGridIsShowing(true);
            this.myChart.getDataView(0).getSeries(0).getStyle().getLineStyle().setColor(new Color(0, 255, 255));
            this.myChart.getDataView(0).getSeries(0).getStyle().getSymbolStyle().setColor(new Color(0, 255, 255));
            this.setLabels();
            this.setSymbols();
            this.myChartScrollPane.getViewport().add((Component)this.myChart);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    void setDataMenuItemStates() {
        switch (this.myDataType) {
            case 0: {
                this.arraysMenuItem.setState(false);
                this.paramsMenuItem.setState(true);
                break;
            }
            case 1: {
                this.arraysMenuItem.setState(true);
                this.paramsMenuItem.setState(false);
                break;
            }
            default: {
                this.arraysMenuItem.setState(true);
                this.paramsMenuItem.setState(false);
            }
        }
    }

    synchronized void setSymbols() {
        if (this.myChart == null) {
            return;
        }
        if (this.myChart.getDataView().length == 0) {
            return;
        }
        int n = this.myChart.getDataView(0).getSeries().length;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.myChart.getDataView(0).getSeries(0).getStyle().getSymbolStyle().setShape(this.myCurrentChartView == 4 ? 8 : 0);
                break;
            }
            default: {
                this.myChart.getDataView(0).getSeries(0).getStyle().getSymbolStyle().setShape(1);
            }
        }
    }

    synchronized void setLabels() {
        if (this.myChart != null) {
            JCAxis jCAxis = this.myChart.getDataView(0).getXAxis();
            jCAxis.setNumSpacing((double)this.myNumDataPoints);
            jCAxis.getTitle().setText("X Axis", false, true);
            jCAxis.setMaxIsDefault(true);
            JCAxis jCAxis2 = this.myChart.getDataView(0).getYAxis();
            jCAxis2.setGridIsShowing(true);
            jCAxis2.getTitle().setText("Y axis", false, true);
            try {
                this.myChart.getHeader().setText(this.myUnderlyingObject.getName());
                this.myChart.getHeader().setIsShowing(true);
                this.myChart.getFooter().setText("Footer");
                this.myChart.getFooter().setIsShowing(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    synchronized void setLabels(String string, String string2, String string3) {
        if (this.myChart != null) {
            JCAxis jCAxis = this.myChart.getDataView(0).getXAxis();
            jCAxis.setNumSpacing((double)this.myNumDataPoints);
            jCAxis.getTitle().setText(string, false, true);
            JCAxis jCAxis2 = this.myChart.getDataView(0).getYAxis();
            jCAxis2.setGridIsShowing(true);
            jCAxis2.getTitle().setText(string2, false, true);
            jCAxis.setMaxIsDefault(false);
            jCAxis.setMax(jCAxis2.getMax());
            jCAxis.setMinIsDefault(false);
            jCAxis.setMin(jCAxis2.getMin());
            try {
                this.myChart.getHeader().setText(this.myUnderlyingObject.getName());
                this.myChart.getHeader().setIsShowing(true);
                this.myChart.getFooter().setText(string3);
                this.myChart.getFooter().setIsShowing(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            JCChartStyle[] jCChartStyleArray = this.myChart.getDataView(0).getChartStyle();
            for (int i = 0; i < jCChartStyleArray.length; ++i) {
                jCChartStyleArray[i].setSymbolShape(8);
            }
        }
    }

    synchronized void switchToSelectedView(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.updateViewMenuStates(jCheckBoxMenuItem);
        int n = this.myDataSource.getPreviousView();
        if (this.myChart != null) {
            JCAxis jCAxis = this.myChart.getDataView(0).getXAxis();
            JCAxis jCAxis2 = this.myChart.getDataView(0).getYAxis();
            if (n == 4 && this.myCurrentChartView != 4) {
                jCAxis.setNumSpacing((double)this.myNumDataPoints);
                jCAxis.setNumSpacingIsDefault(false);
            } else if (n != 4 && this.myCurrentChartView == 4) {
                jCAxis.setNumSpacingIsDefault(true);
            }
        }
        this.myInspectorPanel.removeAll();
        switch (this.myCurrentViewType) {
            case 4: {
                this.myInspectorPanel.add(this.myTextPanel);
                break;
            }
            case 5: {
                this.myInspectorPanel.add(this.myTextPanel);
                break;
            }
            case 2: {
                this.myInspectorPanel.add(this.myTextPanel);
                break;
            }
            case 3: {
                this.myInspectorPanel.add(this.myTextPanel);
                break;
            }
            case 0: {
                this.myInspectorPanel.add(this.myChartPanel);
                break;
            }
            case 1: {
                this.myInspectorPanel.add(this.myCustomPanel);
                break;
            }
        }
        if (this.myCurrentViewType != 4 && this.traceHandler != null) {
            try {
                AblePanelHelper.removeTraceJTextAreaHandler(this.myUnderlyingObject);
                this.traceHandler = null;
            }
            catch (AbleException ableException) {
                // empty catch block
            }
        }
        this.myInspectorPanel.validate();
        this.refreshSelectedView();
        if (n != this.myCurrentChartView) {
            this.setSymbols();
        }
    }

    void updateViewMenuStates(JCheckBoxMenuItem jCheckBoxMenuItem) {
        Enumeration enumeration = this.myViewMenuItems.elements();
        while (enumeration.hasMoreElements()) {
            ((JCheckBoxMenuItem)enumeration.nextElement()).setState(false);
        }
        jCheckBoxMenuItem.setState(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refreshSelectedView() {
        block8 : switch (this.myCurrentViewType) {
            case 2: {
                switch (this.myDataType) {
                    case 1: {
                        this.displayArrays();
                        break block8;
                    }
                    case 0: {
                        this.displayParameters();
                        break block8;
                    }
                }
                this.displayParameters();
                break;
            }
            case 3: {
                if (this.mySeriesData == null || this.mySeriesData.isEmpty()) {
                    this.displaySeriesData();
                    break;
                }
                AbleInspectorData ableInspectorData = this.myDataSource;
                synchronized (ableInspectorData) {
                    this.myDataSource.setSeriesData();
                }
                this.displaySeriesData();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 0: {
                if (this.myChart == null) break;
                switch (this.myDataType) {
                    case 1: {
                        AbleInspectorData ableInspectorData = this.myDataSource;
                        synchronized (ableInspectorData) {
                            this.myDataSource.setArrayData();
                            break block8;
                        }
                    }
                    case 0: {
                        AbleInspectorData ableInspectorData = this.myDataSource;
                        synchronized (ableInspectorData) {
                            this.myDataSource.setSeriesData();
                            break block8;
                        }
                    }
                }
                AbleInspectorData ableInspectorData = this.myDataSource;
                synchronized (ableInspectorData) {
                    this.myDataSource.setSeriesData();
                    break;
                }
            }
            case 1: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void displayArrays() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mySelectedArrays == null || this.mySelectedArrays.length <= 0) {
            stringBuffer.append("No arrays selected.\n");
            this.myTextArea.setText(stringBuffer.toString());
            return;
        }
        myNumberFormat.setMaximumFractionDigits(6);
        int n = this.mySelectedArrays.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4;
            int n5;
            Object object;
            String string = (String)this.mySelectedArrays[i];
            stringBuffer.append(string + ": ");
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.myArrays.get(string);
            if (propertyDescriptor == null) {
                System.out.println("AbleInspector.displayArrays(): can't get property descriptor for " + string);
                return;
            }
            Method method = propertyDescriptor.getReadMethod();
            Object object2 = "";
            try {
                object = this.myUnderlyingObject;
                synchronized (object) {
                    object2 = method.invoke((Object)this.myUnderlyingObject, null);
                }
            }
            catch (Exception exception) {
                System.out.println("Error: " + exception + " can't get parameter value for " + string);
            }
            if (object2 == null) {
                stringBuffer.append("null");
            } else if (object2 instanceof Vector || object2 instanceof Enumeration) {
                if (object2 instanceof Enumeration) {
                    Enumeration enumeration = (Enumeration)object2;
                    object = new Vector();
                    while (enumeration.hasMoreElements()) {
                        ((Vector)object).addElement(enumeration.nextElement());
                    }
                } else {
                    object = (Vector)object2;
                }
                if ((n5 = ((Vector)object).size()) == 0) {
                    stringBuffer.append("[empty]");
                } else {
                    n4 = 0;
                    n3 = n5 / this.myNumDisplayColumns;
                    if (n5 % this.myNumDisplayColumns > 0) {
                        ++n3;
                    }
                    block7: for (n2 = 0; n2 < n3; ++n2) {
                        stringBuffer.append("\n    [" + n4 + "]: ");
                        for (int j = 0; j < this.myNumDisplayColumns; ++j) {
                            if (((Vector)object).elementAt(n4) == null) {
                                stringBuffer.append("null     ");
                            } else {
                                stringBuffer.append(((Vector)object).elementAt(n4).toString() + "     ");
                            }
                            if (++n4 == n5) continue block7;
                        }
                    }
                }
            } else if (object2 instanceof String[] || object2 instanceof Object[] || object2 instanceof byte[] || object2 instanceof double[] || object2 instanceof float[] || object2 instanceof int[] || object2 instanceof long[] || object2 instanceof short[]) {
                int n6 = Array.getLength(object2);
                if (n6 == 0) {
                    stringBuffer.append("[empty]");
                } else {
                    n5 = 0;
                    n4 = n6 / this.myNumDisplayColumns;
                    if (n6 % this.myNumDisplayColumns > 0) {
                        ++n4;
                    }
                    block9: for (n3 = 0; n3 < n4; ++n3) {
                        stringBuffer.append("\n    [" + n5 + "]: ");
                        for (n2 = 0; n2 < this.myNumDisplayColumns; ++n2) {
                            Object object3;
                            if ((object3 = Array.get(object2, n5++)) != null) {
                                if (object3 instanceof Number) {
                                    stringBuffer.append(myNumberFormat.format(object3) + "     ");
                                } else {
                                    stringBuffer.append(object3.toString() + "  ");
                                }
                            } else {
                                stringBuffer.append("<null>  ");
                            }
                            if (n5 == n6) continue block9;
                        }
                    }
                }
            } else {
                System.out.println("! AbleInspector.displayArrays(): Unsupported array type:" + object2.getClass());
            }
            stringBuffer.append("\n");
        }
        this.myTextArea.setText(stringBuffer.toString());
    }

    protected void displayBuffers() throws AbleException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = (String[])((AbleObject)this.myUnderlyingObject).getInputBuffer();
        if (stringArray != null) {
            stringBuffer.append("Input Buffer: \n");
            for (n = 0; n < stringArray.length; ++n) {
                stringBuffer.append("    [" + n + "]: " + stringArray[n] + "\n");
            }
            stringBuffer.append("\n");
        }
        if ((stringArray = (String[])((AbleObject)this.myUnderlyingObject).getOutputBuffer()) != null) {
            stringBuffer.append("Output Buffer: \n");
            for (n = 0; n < stringArray.length; ++n) {
                stringBuffer.append("    [" + n + "]: " + stringArray[n] + "\n");
            }
        }
        this.myTextArea.setText(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void displayParameters() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mySeriesData == null || this.mySeriesData.isEmpty()) {
            stringBuffer.append("No parameters selected.\n");
            this.myTextArea.setText(stringBuffer.toString());
            return;
        }
        int n = this.mySeriesData.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            AbleSeriesItem ableSeriesItem = (AbleSeriesItem)this.mySeriesData.elementAt(i);
            String string = ableSeriesItem.getName();
            String string2 = new String(ableSeriesItem.getIndex());
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.myParameters.get(string);
            if (propertyDescriptor == null && (propertyDescriptor = (PropertyDescriptor)this.myArrays.get(string)) == null) {
                System.out.println("AbleInspector.displayParameters(): can't get property descriptor for " + string);
                return;
            }
            Method method = null;
            Object object3 = "";
            method = propertyDescriptor.getReadMethod();
            try {
                object2 = this.myUnderlyingObject;
                synchronized (object2) {
                    object3 = method.invoke((Object)this.myUnderlyingObject, null);
                }
            }
            catch (Exception exception) {
                System.out.println("Error: " + exception + " can't get parameter value for " + string);
            }
            if (object3 == null) {
                stringBuffer.append(string + ": null\n");
                continue;
            }
            if (object3 instanceof Hashtable) {
                object2 = (Hashtable)object3;
                int n2 = ((Hashtable)object2).size();
                if (n2 == 0) {
                    stringBuffer.append(string + ": [empty] \n");
                    continue;
                }
                stringBuffer.append(string + ": \n");
                object = ((Hashtable)object2).keys();
                while (object.hasMoreElements()) {
                    String string3 = (String)object.nextElement();
                    stringBuffer.append("\n    [" + string3 + "]: ");
                    stringBuffer.append(((Hashtable)object2).get(string3).toString());
                }
                continue;
            }
            if (object3 instanceof Vector) {
                object2 = (Vector)object3;
                int n3 = ((Vector)object2).size();
                if (n3 == 0) {
                    stringBuffer.append(string + "[" + string2 + "]: empty");
                    continue;
                }
                int n4 = 0;
                try {
                    n4 = Integer.parseInt(string2);
                    if (((Vector)object2).elementAt(n4) == null) {
                        stringBuffer.append(string + "[" + string2 + "]: null \n");
                        continue;
                    }
                    stringBuffer.append(string + "[" + string2 + "]: " + ((Vector)object2).elementAt(n4).toString() + "\n");
                }
                catch (NumberFormatException numberFormatException) {
                    stringBuffer.append(string + "[" + string2 + "]: invalid array index!");
                }
                continue;
            }
            if (object3 instanceof Enumeration) {
                object2 = (Enumeration)object3;
                Vector vector = new Vector();
                while (object2.hasMoreElements()) {
                    vector.addElement(object2.nextElement());
                }
                int n5 = vector.size();
                if (n5 == 0) {
                    stringBuffer.append(string + "[" + string2 + "]: empty");
                    continue;
                }
                int n6 = 0;
                try {
                    n6 = Integer.parseInt(string2);
                    if (vector.elementAt(n6) == null) {
                        stringBuffer.append(string + "[" + string2 + "]: null \n");
                        continue;
                    }
                    stringBuffer.append(string + "[" + string2 + "]: " + vector.elementAt(n6).toString() + "\n");
                }
                catch (NumberFormatException numberFormatException) {
                    stringBuffer.append(string + "[" + string2 + "]: invalid array index!");
                }
                continue;
            }
            if (object3 instanceof String[] || object3 instanceof Object[] || object3 instanceof byte[] || object3 instanceof double[] || object3 instanceof float[] || object3 instanceof int[] || object3 instanceof long[] || object3 instanceof short[]) {
                int n7 = Array.getLength(object3);
                if (n7 == 0) {
                    stringBuffer.append(string + "[" + string2 + "]: empty");
                    continue;
                }
                int n8 = 0;
                try {
                    n8 = Integer.parseInt(string2);
                    object = Array.get(object3, n8);
                    if (object != null) {
                        if (object instanceof Number) {
                            stringBuffer.append(string + "[" + string2 + "]: " + myNumberFormat.format(object) + "\n");
                            continue;
                        }
                        stringBuffer.append(string + "[" + string2 + "]: " + object.toString() + "\n");
                        continue;
                    }
                    stringBuffer.append(string + "[" + string2 + "]: " + "<null>" + "\n");
                }
                catch (NumberFormatException numberFormatException) {
                    stringBuffer.append(string + "[" + string2 + "]: invalid array index!");
                }
                continue;
            }
            stringBuffer.append(string + ": " + object3.toString() + "\n");
        }
        this.myTextArea.setText(stringBuffer.toString());
    }

    protected synchronized void displaySeriesData() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mySeriesData == null || this.mySeriesData.isEmpty()) {
            stringBuffer.append("No parameters selected.\n");
            this.myTextArea.setText(stringBuffer.toString());
            return;
        }
        int n = this.mySeriesData.size();
        Vector vector = this.myDataSource.getSeriesData();
        int n2 = 1;
        if (n == vector.size()) {
            n2 = 0;
        }
        for (int i = 0; i < n; ++i) {
            AbleSeriesItem ableSeriesItem = (AbleSeriesItem)this.mySeriesData.elementAt(i);
            String string = ableSeriesItem.getName();
            String string2 = new String(ableSeriesItem.getIndex());
            Vector vector2 = (Vector)vector.elementAt(i + n2);
            stringBuffer.append(string + "[" + string2 + "]: ");
            int n3 = vector2.size();
            if (n3 == 0) {
                stringBuffer.append("[empty]");
                continue;
            }
            int n4 = 0;
            int n5 = n3 / this.myNumDisplayColumns;
            if (n3 % this.myNumDisplayColumns > 0) {
                ++n5;
            }
            block1: for (int j = 0; j < n5; ++j) {
                stringBuffer.append("\n    [" + n4 + "]: ");
                for (int k = 0; k < this.myNumDisplayColumns; ++k) {
                    stringBuffer.append(vector2.elementAt(n4++).toString() + "     ");
                    if (n4 == n3) continue block1;
                }
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        this.myTextArea.setText(stringBuffer.toString());
    }

    private void jbInit() throws Exception {
        Object object;
        this.setJMenuBar(this.myMenuBar);
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(AbleEditor.Preferences.getInspectorPanelSize());
        String string = "Inspector: ";
        this.myHierarchicalName = this.getHierarchicalName();
        string = string + this.myHierarchicalName;
        this.setTitle(string);
        this.objectMenu.setText("Bean");
        this.printMenuItem.setText("Print selected view");
        this.printMenuItem.setEnabled(true);
        this.printMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.printMenuItem_actionPerformed(actionEvent);
            }
        });
        this.objectMenu.add(this.printMenuItem);
        this.printPreviewMenuItem.setText("Print preview...");
        this.printPreviewMenuItem.setEnabled(true);
        this.printPreviewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.printPreviewMenuItem_actionPerformed(actionEvent);
            }
        });
        this.objectMenu.add(this.printPreviewMenuItem);
        this.printSetMenuItem.setText("Print setup...");
        this.printSetMenuItem.setEnabled(true);
        this.printSetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.printSetMenuItem_actionPerformed(actionEvent);
            }
        });
        this.objectMenu.add(this.printSetMenuItem);
        this.closeMenuItem.setText("Close inspector");
        this.closeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.closeMenuItem_actionPerformed(actionEvent);
            }
        });
        this.objectMenu.add(this.closeMenuItem);
        this.myMenuBar.add(this.objectMenu);
        this.editMenu.setText("Edit");
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.copyMenuItem_actionPerformed(actionEvent);
            }
        });
        this.copyMenuItem.setEnabled(true);
        this.editMenu.add(this.copyMenuItem);
        this.clearMenuItem.setText("Clear");
        this.clearMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.clearMenuItem_actionPerformed(actionEvent);
            }
        });
        this.clearMenuItem.setEnabled(true);
        this.editMenu.add(this.clearMenuItem);
        this.editMenu.addSeparator();
        this.selectAllMenuItem.setText("Select All");
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.selectAllMenuItem_actionPerformed(actionEvent);
            }
        });
        this.selectAllMenuItem.setEnabled(true);
        this.editMenu.add(this.selectAllMenuItem);
        this.myMenuBar.add(this.editMenu);
        this.dataMenu.setText("Data");
        this.paramsMenuItem.setText("Parameters...");
        this.paramsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.paramMenuItem_actionPerformed(actionEvent);
            }
        });
        this.dataMenu.add(this.paramsMenuItem);
        this.arraysMenuItem.setText("Arrays...");
        this.arraysMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.arraysMenuItem_actionPerformed(actionEvent);
            }
        });
        this.dataMenu.add(this.arraysMenuItem);
        this.setDataMenuItemStates();
        this.myMenuBar.add(this.dataMenu);
        this.viewMenu.setText("View");
        if (!this.myCustomInspectors.isEmpty()) {
            object = this.myCustomInspectors.keys();
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string2);
                jCheckBoxMenuItem.setActionCommand(string2);
                jCheckBoxMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        AbleInspector.this.customMenuItem_actionPerformed(actionEvent);
                    }
                });
                this.viewMenu.add(jCheckBoxMenuItem);
                this.myViewMenuItems.put(string2, jCheckBoxMenuItem);
            }
            this.viewMenu.addSeparator();
        }
        object = "Text";
        this.textMenuItem.setText((String)object);
        this.textMenuItem.setState(true);
        this.textMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.textMenuItem_actionPerformed(actionEvent);
            }
        });
        this.myViewMenuItems.put(object, this.textMenuItem);
        this.viewMenu.add(this.textMenuItem);
        object = "Text series";
        this.textSeriesMenuItem.setText((String)object);
        this.textSeriesMenuItem.setState(false);
        this.textSeriesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.textSeriesMenuItem_actionPerformed(actionEvent);
            }
        });
        this.myViewMenuItems.put(object, this.textSeriesMenuItem);
        this.viewMenu.add(this.textSeriesMenuItem);
        object = "Text statistics";
        this.textStatsMenuItem.setText((String)object);
        this.textStatsMenuItem.setState(false);
        this.textStatsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.statisticsMenuItem_actionPerformed(actionEvent);
            }
        });
        this.myViewMenuItems.put(object, this.textStatsMenuItem);
        this.viewMenu.add(this.textStatsMenuItem);
        object = "Text trace";
        this.textTraceMenuItem.setText((String)object);
        this.textTraceMenuItem.setState(false);
        this.textTraceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.textTraceMenuItem_actionPerformed(actionEvent);
            }
        });
        this.myViewMenuItems.put(object, this.textTraceMenuItem);
        this.viewMenu.add(this.textTraceMenuItem);
        this.viewMenu.addSeparator();
        object = "Area chart";
        this.areaMenuItem.setText((String)object);
        this.areaMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.areaMenuItem_actionPerformed(actionEvent);
            }
        });
        this.myViewMenuItems.put(object, this.areaMenuItem);
        this.viewMenu.add(this.areaMenuItem);
        object = "Area chart, stacking";
        this.areaStackingMenuItem.setText((String)object);
        this.areaStackingMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.areaStackingMenuItem_actionPerformed(actionEvent);
            }
        });
        this.myViewMenuItems.put(object, this.areaStackingMenuItem);
        this.viewMenu.add(this.areaStackingMenuItem);
        object = "Bar chart";
        this.barChartMenuItem.setText((String)object);
        this.barChartMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.barChartMenuItem_actionPerformed(actionEvent);
            }
        });
        this.myViewMenuItems.put(object, this.barChartMenuItem);
        this.viewMenu.add(this.barChartMenuItem);
        object = "Bar chart, stacking";
        this.barStackingMenuItem.setText((String)object);
        this.barStackingMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.barStackingMenuItem_actionPerformed(actionEvent);
            }
        });
        this.myViewMenuItems.put(object, this.barStackingMenuItem);
        this.viewMenu.add(this.barStackingMenuItem);
        object = "Binary grid";
        this.binaryGridMenuItem.setText((String)object);
        this.binaryGridMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.binaryGridMenuItem_actionPerformed(actionEvent);
            }
        });
        object = "Hinton diagram";
        this.hintonMenuItem.setText((String)object);
        this.hintonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.hintonMenuItem_actionPerformed(actionEvent);
            }
        });
        object = "Line chart";
        this.lineChartMenuItem.setText((String)object);
        this.lineChartMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.lineChartMenuItem_actionPerformed(actionEvent);
            }
        });
        this.myViewMenuItems.put(object, this.lineChartMenuItem);
        this.viewMenu.add(this.lineChartMenuItem);
        object = "Scatter plot";
        this.scatterPlotMenuItem.setText((String)object);
        this.scatterPlotMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.scatterPlotMenuItem_actionPerformed(actionEvent);
            }
        });
        this.myViewMenuItems.put(object, this.scatterPlotMenuItem);
        this.viewMenu.add(this.scatterPlotMenuItem);
        object = "Time plot";
        this.timePlotMenuItem.setText((String)object);
        this.timePlotMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.timePlotMenuItem_actionPerformed(actionEvent);
            }
        });
        this.myViewMenuItems.put(object, this.timePlotMenuItem);
        this.viewMenu.add(this.timePlotMenuItem);
        this.viewMenu.addSeparator();
        this.refreshMenuItem.setText("Refresh");
        this.refreshMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.refreshMenuItem_actionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.refreshMenuItem);
        this.myMenuBar.add(this.viewMenu);
        this.optionsMenu.setText("Options");
        this.traceMenu.setText("Trace");
        this.traceNoneMenuItem.setText("None");
        this.traceNoneMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.traceMenuItem_actionPerformed(actionEvent);
            }
        });
        this.traceMenu.add(this.traceNoneMenuItem);
        this.traceButtonGroup.add(this.traceNoneMenuItem);
        this.traceLowMenuItem.setText("Low");
        this.traceLowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.traceMenuItem_actionPerformed(actionEvent);
            }
        });
        this.traceMenu.add(this.traceLowMenuItem);
        this.traceButtonGroup.add(this.traceLowMenuItem);
        this.traceMedMenuItem.setText("Medium");
        this.traceMedMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.traceMenuItem_actionPerformed(actionEvent);
            }
        });
        this.traceMenu.add(this.traceMedMenuItem);
        this.traceButtonGroup.add(this.traceMedMenuItem);
        this.traceHighMenuItem.setText("High");
        this.traceHighMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.traceMenuItem_actionPerformed(actionEvent);
            }
        });
        this.traceMenu.add(this.traceHighMenuItem);
        this.traceButtonGroup.add(this.traceHighMenuItem);
        this.traceNoneMenuItem.setSelected(true);
        this.optionsMenu.add(this.traceMenu);
        this.optionsMenu.addSeparator();
        this.settingsMenuItem.setText("Properties...");
        this.settingsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.settingsMenuItem_actionPerformed(actionEvent);
            }
        });
        this.optionsMenu.add(this.settingsMenuItem);
        this.loggingMenuItem.setText("Refresh rate...");
        this.loggingMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.loggingMenuItem_actionPerformed(actionEvent);
            }
        });
        this.optionsMenu.add(this.loggingMenuItem);
        this.statisticsMenuItem.setText("Compute statistics");
        this.statisticsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.statisticsMenuItem_actionPerformed(actionEvent);
            }
        });
        this.optionsMenu.add(this.statisticsMenuItem);
        this.myMenuBar.add(this.optionsMenu);
        this.helpMenu.setText("Help");
        this.helpMenu.add(this.InspectorReferenceMenuItem);
        this.helpMenu.add(this.UserReferenceMenuItem);
        this.helpMenu.add(this.APIReferenceMenuItem);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.AboutMenuItem);
        this.myMenuBar.add(this.helpMenu);
        this.InspectorReferenceMenuItem.setText("Inspector Reference...");
        this.InspectorReferenceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.InspectorReferenceMenuItem_actionPerformed(actionEvent);
            }
        });
        this.UserReferenceMenuItem.setText("User's Reference...");
        this.UserReferenceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.UserReferenceMenuItem_actionPerformed(actionEvent);
            }
        });
        this.APIReferenceMenuItem.setText("API Reference...");
        this.APIReferenceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.APIReferenceMenuItem_actionPerformed(actionEvent);
            }
        });
        this.AboutMenuItem.setText("About...");
        this.AboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleInspector.this.AboutMenuItem_actionPerformed(actionEvent);
            }
        });
        this.myChartPanel.setLayout(new BorderLayout());
        this.myChartPanel.setBackground(Color.white);
        this.myChartPanel.add((Component)this.myChartScrollPane, "Center");
        this.myTextPanel.setLayout(new BorderLayout());
        this.myTextPanel.setBackground(Color.white);
        this.myTextPanel.add((Component)this.myTextScrollPane, "Center");
        this.myTextScrollPane.getViewport().add((Component)this.myTextArea, null);
        this.myTextArea.setText("No data to display...");
        this.myInspectorPanel.setLayout(new BorderLayout(5, 5));
        this.myInspectorPanel.setBackground(Color.white);
        this.myInspectorPanel.setMinimumSize(new Dimension(300, 200));
        this.myInspectorPanel.add((Component)this.myTextPanel, "Center");
        this.getContentPane().add((Component)this.myInspectorPanel, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHierarchicalName() {
        String string = null;
        AbleBean ableBean = this.myUnderlyingObject;
        synchronized (ableBean) {
            string = this.myUnderlyingObject.getName();
            for (AbleBean ableBean2 = (AbleBean)this.myUnderlyingObject.getParent(); ableBean2 != null; ableBean2 = (AbleBean)ableBean2.getParent()) {
                string = ableBean2.getName() + "." + string;
            }
        }
        return string;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2 = this.computeNumRowsPerPage(pageFormat);
        int n3 = new StringTokenizer(this.myTextArea.getText(), "\n").countTokens();
        int n4 = n3 / n2 + 1;
        if (n >= n4 + 1) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(Color.black);
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight()));
        if (this.myCurrentViewType == 0) {
            this.myChart.printAll(graphics);
        } else {
            this.drawPage(graphics2D, n, n2);
        }
        return 0;
    }

    public void drawPage(Graphics2D graphics2D, int n, int n2) {
        int n3;
        int n4 = n * n2;
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        double d = this.pageFormat.getImageableWidth();
        double d2 = this.pageFormat.getImageableHeight();
        StringTokenizer stringTokenizer = new StringTokenizer(this.myTextArea.getText());
        for (n3 = 0; n3 < n4; ++n3) {
            stringTokenizer.nextToken("\n");
        }
        n3 = 0;
        block1: while (stringTokenizer.hasMoreTokens() && n3 < n2) {
            TextLayout textLayout;
            ++n3;
            String string = stringTokenizer.nextToken("\n");
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, new Font("serif", 0, 12));
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), new FontRenderContext(null, true, true));
            while ((textLayout = lineBreakMeasurer.nextLayout((float)d)) != null) {
                double_.y += (double)textLayout.getAscent();
                textLayout.draw(graphics2D, (float)double_.x, (float)double_.y);
                double_.y += (double)(textLayout.getDescent() + textLayout.getLeading());
                if (!(double_.y >= d2)) continue;
                continue block1;
            }
        }
    }

    protected int computeNumRowsPerPage(PageFormat pageFormat) {
        double d = this.pageFormat.getImageableWidth();
        double d2 = this.pageFormat.getImageableHeight();
        AttributedString attributedString = new AttributedString("This is a TEST");
        attributedString.addAttribute(TextAttribute.FONT, new Font("serif", 0, 12));
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), new FontRenderContext(null, true, true));
        TextLayout textLayout = lineBreakMeasurer.nextLayout((float)d);
        double d3 = textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
        int n = new StringTokenizer(this.myTextArea.getText(), "\n").countTokens();
        int n2 = (int)(d2 / d3);
        int n3 = n / n2 + 1;
        return n2;
    }

    protected Book createBook() {
        Book book = new Book();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.pageFormat == null) {
            this.pageFormat = printerJob.defaultPage();
        }
        int n = this.computeNumRowsPerPage(this.pageFormat);
        int n2 = new StringTokenizer(this.myTextArea.getText(), "\n").countTokens();
        int n3 = n2 / n + 1;
        book.append(this, this.pageFormat, n3);
        return book;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

