/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.editor.AbleEditorFrame;
import com.ibm.able.editor.AbleGridBagConstraints;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class AbleImportRemoteAgentDialog
extends JDialog {
    private AbleEditorFrame target;
    private String myHostName;
    private String myPort;
    private TreeSet myAgentNames;
    private Registry myRegistry;
    private boolean myCancelledFlag = true;
    private JTextField myHostNameTextField = null;
    private JTextField myPortTextField = null;
    private JComboBox myAgentNamesComboBox = null;
    private boolean cancelled = false;

    private AbleImportRemoteAgentDialog() {
        this((AbleEditorFrame)null, "Import Remote Agent");
    }

    public AbleImportRemoteAgentDialog(AbleEditorFrame ableEditorFrame) {
        this(ableEditorFrame, "Import Remote Agent");
    }

    public AbleImportRemoteAgentDialog(AbleEditorFrame ableEditorFrame, String string) {
        super(ableEditorFrame, string, true);
        this.target = ableEditorFrame;
        this.initializePanel();
        this.setObject(ableEditorFrame);
    }

    public void setObject(Object object) {
        this.target = (AbleEditorFrame)object;
        this.myHostNameTextField.setText("");
        String string = Able.Preferences.getCommPort();
        if (string.startsWith(":")) {
            string = string.substring(1);
        }
        this.myPortTextField.setText(string);
        Vector vector = new Vector();
        this.myAgentNamesComboBox.setModel(new DefaultComboBoxModel(vector));
        if (vector.size() > 0) {
            this.myAgentNamesComboBox.setSelectedItem(vector.elementAt(0));
        }
    }

    public void updateObject() throws RemoteException {
        this.myHostName = this.myHostNameTextField.getText().trim();
        this.myPort = this.myPortTextField.getText().trim();
        if (this.myPort.startsWith(":")) {
            this.myPort.substring(1);
        }
        Able.Preferences.setCommPort(":" + this.myPort);
        Registry registry = LocateRegistry.getRegistry(this.myHostName, new Integer(this.myPort));
        Object[] objectArray = this.myAgentNamesComboBox.getSelectedObjects();
        for (int i = 0; i < objectArray.length; ++i) {
            Remote remote = null;
            try {
                remote = registry.lookup(objectArray[i].toString());
                this.target.importRemoteAgent((AbleBean)remote);
                continue;
            }
            catch (AccessException accessException) {
                continue;
            }
            catch (RemoteException remoteException) {
                continue;
            }
            catch (NotBoundException notBoundException) {
                // empty catch block
            }
        }
    }

    private void initializePanel() {
        this.setResizable(false);
        this.setSize(640, 420);
        if (this.target != null) {
            this.setLocation(this.target.getLocation());
        }
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(600, 400));
        jPanel.setMinimumSize(new Dimension(460, 313));
        container.add(jPanel);
        jPanel.add((Component)this.newImportPanel(), "Center");
        jPanel.add((Component)this.newButtonsPanel(), "South");
        this.validate();
    }

    private JPanel newImportPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = -1;
        jPanel.add((Component)new JLabel("Host:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.myHostNameTextField = new JTextField();
        this.myHostNameTextField.setToolTipText("Host where agent is registered");
        jPanel.add((Component)this.myHostNameTextField, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        jPanel.add((Component)new JLabel("Port:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.myPortTextField = new JTextField();
        this.myPortTextField.setToolTipText("Port where agent is registered");
        jPanel.add((Component)this.myPortTextField, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        jPanel.add((Component)new JLabel("Registered agents:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.myAgentNamesComboBox = new JComboBox();
        this.myAgentNamesComboBox.setToolTipText("Preferred look and feel name");
        jPanel.add((Component)this.myAgentNamesComboBox, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        JButton jButton = new JButton("List");
        jButton.setSize(90, 24);
        jButton.setToolTipText("Find the registered agents");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleImportRemoteAgentDialog.this.BrowseButton_actionPerformed(actionEvent);
            }
        });
        jPanel.add((Component)jButton, new AbleGridBagConstraints(5, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 10), 0, 0));
        return jPanel;
    }

    private JPanel newButtonsPanel() {
        JPanel jPanel = new JPanel();
        AblePanelHelper.addButton(jPanel, "OK", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleImportRemoteAgentDialog.this.okButton_actionPerformed(actionEvent);
            }
        }, "Import agents and close");
        AblePanelHelper.addButton(jPanel, "Apply", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleImportRemoteAgentDialog.this.applyButton_actionPerformed(actionEvent);
            }
        }, "Import agents and continue");
        AblePanelHelper.addButton(jPanel, "Cancel", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleImportRemoteAgentDialog.this.cancelButton_actionPerformed(actionEvent);
            }
        }, "Cancel and close");
        AblePanelHelper.addButton(jPanel, "Help", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleImportRemoteAgentDialog.this.helpButton_actionPerformed(actionEvent);
            }
        }, "Display help");
        return jPanel;
    }

    private void BrowseButton_actionPerformed(ActionEvent actionEvent) {
        this.myHostName = this.myHostNameTextField.getText().trim();
        this.myPort = this.myPortTextField.getText().trim();
        if (this.myPort.startsWith(":")) {
            this.myPort = this.myPort.substring(1);
        }
        try {
            Registry registry = LocateRegistry.getRegistry(this.myHostName, new Integer(this.myPort));
            String[] stringArray = registry.list();
            this.myAgentNames = new TreeSet();
            for (int i = 0; i < stringArray.length; ++i) {
                this.myAgentNames.add(stringArray[i]);
            }
            this.myAgentNamesComboBox.setModel(new DefaultComboBoxModel<Object>(this.myAgentNames.toArray()));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getLocalizedMessage(), "Editor Error: AbleImportRemoteAgentDialog()", 0);
        }
    }

    private void okButton_actionPerformed(ActionEvent actionEvent) {
        this.applyButton_actionPerformed(actionEvent);
        this.dispose();
    }

    private void applyButton_actionPerformed(ActionEvent actionEvent) {
        this.cancelled = false;
        try {
            this.updateObject();
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this, remoteException.getLocalizedMessage(), "Editor Error: AbleImportRemoteAgentDialog()", 0);
        }
    }

    private void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.cancelled = true;
        this.dispose();
    }

    private void helpButton_actionPerformed(ActionEvent actionEvent) {
        AbleEditorFrame.displayHelp(this, "AbleImportRemoteAgentHelp.html");
    }

    public boolean userCancelled() {
        return this.cancelled;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            AbleImportRemoteAgentDialog ableImportRemoteAgentDialog = new AbleImportRemoteAgentDialog();
            ableImportRemoteAgentDialog.setVisible(true);
            System.exit(0);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getLocalizedMessage(), "AbleImportRemoteAgentDialog()", 0);
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

