/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.Able;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.UIManager;

public class AbleGuiPreferences {
    static final long serialVersionUID = 2001083100000000001L;
    private String myPropertiesFile = "";
    Properties myProperties = null;
    private String myAbleJarFiles = "";
    private String myPlugInJarDirectory = Able.ProductDirectory + "lib" + File.separator + "plugin";
    private TreeSet myDatabaseDrivers = new TreeSet();
    private TreeSet myDatabaseProtocols = new TreeSet();
    private TreeSet myDatabaseSubprotocols = new TreeSet();
    private TreeSet myDatabaseDatabases = new TreeSet();
    private Color myEditorPanelBackground = Color.white;
    private Color myEditorPanelForeground = Color.black;
    private Font myEditorPanelFont = new Font("monospaced", 0, 12);
    private Point myEditorPanelLocation = new Point(35, 30);
    private Dimension myEditorPanelSize = new Dimension(600, 500);
    private Integer myEditorPanelDividerLocation = new Integer(200);
    private Integer myConnectionsView = new Integer(0);
    private boolean myEditorExitPrompt = true;
    private boolean myPlugInJarOn = false;
    private String myEditorBeanPaletteLabels = "Data Learning Rules Agents Samples";
    private String osType = System.getProperty("os.name").toUpperCase();
    private String myAbleLookAndFeelClassName = this.osType.equals("AIX") || this.osType.equals("UNIX") ? UIManager.getCrossPlatformLookAndFeelClassName() : UIManager.getSystemLookAndFeelClassName();
    private String myTextEditor = "";
    private Color myRuleEditorPanelBackground = Color.white;
    private Color myRuleEditorPanelForeground = Color.black;
    private Font myRuleEditorPanelFont = new Font("monospaced", 0, 12);
    private Point myRuleEditorPanelLocation = new Point(35, 30);
    private Dimension myRuleEditorPanelSize = new Dimension(600, 750);
    private Color myRuleEditorTitleBackground = Color.white;
    private Color myRuleEditorTitleForeground = Color.blue;
    private Font myRuleEditorTitleFont = new Font("Dialog", 1, 12);
    private Color myRuleEditorExceptionPanelBackground = Color.white;
    private Color myRuleEditorExceptionPanelForeground = Color.black;
    private Font myRuleEditorExceptionPanelFont = new Font("monospaced", 0, 12);
    private Point myEditorExceptionPanelLocation = new Point(70, 75);
    private Dimension myEditorExceptionPanelSize = new Dimension(550, 180);
    private Color myRuleEditorHelpPanelBackground = Color.white;
    private Color myRuleEditorHelpPanelForeground = Color.black;
    private Point myRuleEditorHelpPanelLocation = new Point(50, 50);
    private Dimension myRuleEditorHelpPanelSize = new Dimension(470, 450);
    private Color myRuleEditorOutputPanelBackground = Color.white;
    private Color myRuleEditorOutputPanelForeground = Color.black;
    private Font myRuleEditorOutputPanelFont = new Font("monospaced", 0, 12);
    private Point myRuleEditorOutputPanelLocation = new Point(90, 275);
    private Dimension myRuleEditorOutputPanelSize = new Dimension(530, 280);
    private Point myRuleEditorSetViewerPanelLocation = new Point(70, 75);
    private Dimension myRuleEditorSetViewerPanelSize = new Dimension(550, 180);
    private Color myRuleEditorXmlPanelBackground = Color.white;
    private Color myRuleEditorXmlPanelForeground = Color.black;
    private Font myRuleEditorXmlPanelFont = new Font("monospaced", 0, 12);
    private Point myRuleEditorXmlPanelLocation = new Point(70, 75);
    private Dimension myRuleEditorXmlPanelSize = new Dimension(550, 180);
    private Point myRuleDebuggerPanelLocation = new Point(35, 30);
    private Dimension myRuleDebuggerPanelSize = new Dimension(410, 360);
    private Integer myRuleDebuggerPanelDividerLocation = new Integer(200);
    private boolean myRuleDebuggerPanelHorizontal = true;
    private Point myInspectorPanelLocation = new Point(150, 150);
    private Dimension myInspectorPanelSize = new Dimension(300, 200);

    public final String getAbleJarFiles() {
        return this.myAbleJarFiles;
    }

    private final String cvtAbleJarFiles() {
        return this.myAbleJarFiles;
    }

    public final void setAbleJarFiles(String string) {
        this.myAbleJarFiles = string;
    }

    public final String getPlugInJarDirectory() {
        return Able.getLocalPathX((String)this.myPlugInJarDirectory);
    }

    private final String cvtPlugInJarDirectory() {
        try {
            return Able.getSerializablePath((String)this.myPlugInJarDirectory);
        }
        catch (IOException iOException) {
            if (Able.TraceLog != null && Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)this, "cvtPlugInJarDirectory", (Throwable)iOException);
            }
            return this.myPlugInJarDirectory;
        }
    }

    public final void setPlugInJarDirectory(String string) {
        this.myPlugInJarDirectory = string;
    }

    public final TreeSet getDatabaseDrivers() {
        return this.myDatabaseDrivers;
    }

    private final String cvtDatabaseDrivers() {
        return this.treeSetToString(this.myDatabaseDrivers);
    }

    public final void setDatabaseDrivers(Collection collection) {
        this.myDatabaseDrivers = new TreeSet(collection);
    }

    private final void setDatabaseDrivers(String string) {
        this.myDatabaseDrivers = this.treeSetFromString(string);
    }

    public final TreeSet getDatabaseProtocols() {
        return this.myDatabaseProtocols;
    }

    private final String cvtDatabaseProtocols() {
        return this.treeSetToString(this.myDatabaseProtocols);
    }

    public final void setDatabaseProtocols(Collection collection) {
        this.myDatabaseProtocols = new TreeSet(collection);
    }

    private final void setDatabaseProtocols(String string) {
        this.myDatabaseProtocols = this.treeSetFromString(string);
    }

    public final TreeSet getDatabaseSubprotocols() {
        return this.myDatabaseSubprotocols;
    }

    private final String cvtDatabaseSubprotocols() {
        return this.treeSetToString(this.myDatabaseSubprotocols);
    }

    public final void setDatabaseSubprotocols(Collection collection) {
        this.myDatabaseSubprotocols = new TreeSet(collection);
    }

    private final void setDatabaseSubprotocols(String string) {
        this.myDatabaseSubprotocols = this.treeSetFromString(string);
    }

    public final TreeSet getDatabaseDatabases() {
        return this.myDatabaseDatabases;
    }

    private final String cvtDatabaseDatabases() {
        return this.treeSetToString(this.myDatabaseDatabases);
    }

    public final void setDatabaseDatabases(Collection collection) {
        this.myDatabaseDatabases = new TreeSet(collection);
    }

    private final void setDatabaseDatabases(String string) {
        this.myDatabaseDatabases = this.treeSetFromString(string);
    }

    public Color getEditorPanelBackground() {
        return this.myEditorPanelBackground;
    }

    public String cvtEditorPanelBackground() {
        return this.colorToString(this.myEditorPanelBackground);
    }

    public void setEditorPanelBackground(Color color) {
        this.myEditorPanelBackground = color;
    }

    public void setEditorPanelBackground(String string) {
        this.myEditorPanelBackground = this.colorFromString(string);
    }

    public Color getEditorPanelForeground() {
        return this.myEditorPanelForeground;
    }

    public String cvtEditorPanelForeground() {
        return this.colorToString(this.myEditorPanelForeground);
    }

    public void setEditorPanelForeground(Color color) {
        this.myEditorPanelForeground = color;
    }

    public void setEditorPanelForeground(String string) {
        this.myEditorPanelForeground = this.colorFromString(string);
    }

    public Font getEditorPanelFont() {
        return this.myEditorPanelFont;
    }

    public String cvtEditorPanelFont() {
        return this.fontToString(this.myEditorPanelFont);
    }

    public void setEditorPanelFont(Font font) {
        this.myEditorPanelFont = font;
    }

    public void setEditorPanelFont(String string) {
        this.myEditorPanelFont = this.fontFromString(string);
    }

    public Point getEditorPanelLocation() {
        return this.myEditorPanelLocation;
    }

    public String cvtEditorPanelLocation() {
        return this.pointToString(this.myEditorPanelLocation);
    }

    public void setEditorPanelLocation(Point point) {
        this.myEditorPanelLocation = point;
    }

    public void setEditorPanelLocation(String string) {
        this.myEditorPanelLocation = this.pointFromString(string);
    }

    public Dimension getEditorPanelSize() {
        return this.myEditorPanelSize;
    }

    public String cvtEditorPanelSize() {
        return this.dimToString(this.myEditorPanelSize);
    }

    public void setEditorPanelSize(Dimension dimension) {
        this.myEditorPanelSize = dimension;
    }

    public void setEditorPanelSize(String string) {
        this.myEditorPanelSize = this.dimFromString(string);
    }

    public int getEditorPanelDividerLocation() {
        return this.myEditorPanelDividerLocation;
    }

    public String cvtEditorPanelDividerLocation() {
        return this.myEditorPanelDividerLocation.toString();
    }

    public void setEditorPanelDividerLocation(int n) {
        this.myEditorPanelDividerLocation = new Integer(n);
    }

    public void setEditorPanelDividerLocation(String string) {
        this.myEditorPanelDividerLocation = new Integer(string);
    }

    public int getConnectionsView() {
        return this.myConnectionsView;
    }

    public String cvtConnectionsView() {
        return this.myConnectionsView.toString();
    }

    public void setConnectionsView(int n) {
        this.myConnectionsView = new Integer(n);
    }

    public void setConnectionsView(String string) {
        this.myConnectionsView = new Integer(string);
    }

    public boolean getEditorExitPrompt() {
        return this.myEditorExitPrompt;
    }

    public String cvtEditorExitPrompt() {
        return this.myEditorExitPrompt ? "1" : "0";
    }

    public void setEditorExitPrompt(boolean bl) {
        this.myEditorExitPrompt = bl;
    }

    public void setEditorExitPrompt(String string) {
        this.myEditorExitPrompt = string.trim().equals("1");
    }

    public boolean getPlugInJarOn() {
        return this.myPlugInJarOn;
    }

    public String cvtPlugInJarOn() {
        return this.myPlugInJarOn ? "1" : "0";
    }

    public void setPlugInJarOn(boolean bl) {
        this.myPlugInJarOn = bl;
    }

    public void setPlugInJarOn(String string) {
        this.myPlugInJarOn = string.trim().equals("1");
    }

    public String getEditorBeanPaletteLabels() {
        return this.myEditorBeanPaletteLabels;
    }

    public void setEditorBeanPaletteLabels(String string) {
        this.myEditorBeanPaletteLabels = string;
    }

    public String getAbleLookAndFeelClassName() {
        return this.myAbleLookAndFeelClassName;
    }

    public void setAbleLookAndFeelClassName(String string) {
        this.myAbleLookAndFeelClassName = string;
    }

    public String getTextEditor() {
        return this.myTextEditor;
    }

    public void setTextEditor(String string) {
        this.myTextEditor = string;
    }

    public Color getRuleEditorPanelBackground() {
        return this.myRuleEditorPanelBackground;
    }

    public String cvtRuleEditorPanelBackground() {
        return this.colorToString(this.myRuleEditorPanelBackground);
    }

    public void setRuleEditorPanelBackground(Color color) {
        this.myRuleEditorPanelBackground = color;
    }

    public void setRuleEditorPanelBackground(String string) {
        this.myRuleEditorPanelBackground = this.colorFromString(string);
    }

    public Color getRuleEditorPanelForeground() {
        return this.myRuleEditorPanelForeground;
    }

    public String cvtRuleEditorPanelForeground() {
        return this.colorToString(this.myRuleEditorPanelForeground);
    }

    public void setRuleEditorPanelForeground(Color color) {
        this.myRuleEditorPanelForeground = color;
    }

    public void setRuleEditorPanelForeground(String string) {
        this.myRuleEditorPanelForeground = this.colorFromString(string);
    }

    public Font getRuleEditorPanelFont() {
        return this.myRuleEditorPanelFont;
    }

    public String cvtRuleEditorPanelFont() {
        return this.fontToString(this.myRuleEditorPanelFont);
    }

    public void setRuleEditorPanelFont(Font font) {
        this.myRuleEditorPanelFont = font;
    }

    public void setRuleEditorPanelFont(String string) {
        this.myRuleEditorPanelFont = this.fontFromString(string);
    }

    public Point getRuleEditorPanelLocation() {
        return this.myRuleEditorPanelLocation;
    }

    public String cvtRuleEditorPanelLocation() {
        return this.pointToString(this.myRuleEditorPanelLocation);
    }

    public void setRuleEditorPanelLocation(Point point) {
        this.myRuleEditorPanelLocation = point;
    }

    public void setRuleEditorPanelLocation(String string) {
        this.myRuleEditorPanelLocation = this.pointFromString(string);
    }

    public Dimension getRuleEditorPanelSize() {
        return this.myRuleEditorPanelSize;
    }

    public String cvtRuleEditorPanelSize() {
        return this.dimToString(this.myRuleEditorPanelSize);
    }

    public void setRuleEditorPanelSize(Dimension dimension) {
        this.myRuleEditorPanelSize = dimension;
    }

    public void setRuleEditorPanelSize(String string) {
        this.myRuleEditorPanelSize = this.dimFromString(string);
    }

    public Color getRuleEditorTitleBackground() {
        return this.myRuleEditorTitleBackground;
    }

    public String cvtRuleEditorTitleBackground() {
        return this.colorToString(this.myRuleEditorTitleBackground);
    }

    public void setRuleEditorTitleBackground(Color color) {
        this.myRuleEditorTitleBackground = color;
    }

    public void setRuleEditorTitleBackground(String string) {
        this.myRuleEditorTitleBackground = this.colorFromString(string);
    }

    public Color getRuleEditorTitleForeground() {
        return this.myRuleEditorTitleForeground;
    }

    public String cvtRuleEditorTitleForeground() {
        return this.colorToString(this.myRuleEditorTitleForeground);
    }

    public void setRuleEditorTitleForeground(Color color) {
        this.myRuleEditorTitleForeground = color;
    }

    public void setRuleEditorTitleForeground(String string) {
        this.myRuleEditorTitleForeground = this.colorFromString(string);
    }

    public Font getRuleEditorTitleFont() {
        return this.myRuleEditorTitleFont;
    }

    public String cvtRuleEditorTitleFont() {
        return this.fontToString(this.myRuleEditorTitleFont);
    }

    public void setRuleEditorTitleFont(Font font) {
        this.myRuleEditorTitleFont = font;
    }

    public void setRuleEditorTitleFont(String string) {
        this.myRuleEditorTitleFont = this.fontFromString(string);
    }

    public Color getRuleEditorExceptionPanelBackground() {
        return this.myRuleEditorExceptionPanelBackground;
    }

    public String cvtRuleEditorExceptionPanelBackground() {
        return this.colorToString(this.myRuleEditorExceptionPanelBackground);
    }

    public void setRuleEditorExceptionPanelBackground(Color color) {
        this.myRuleEditorExceptionPanelBackground = color;
    }

    public void setRuleEditorExceptionPanelBackground(String string) {
        this.myRuleEditorExceptionPanelBackground = this.colorFromString(string);
    }

    public Color getRuleEditorExceptionPanelForeground() {
        return this.myRuleEditorExceptionPanelForeground;
    }

    public String cvtRuleEditorExceptionPanelForeground() {
        return this.colorToString(this.myRuleEditorExceptionPanelForeground);
    }

    public void setRuleEditorExceptionPanelForeground(Color color) {
        this.myRuleEditorExceptionPanelForeground = color;
    }

    public void setRuleEditorExceptionPanelForeground(String string) {
        this.myRuleEditorExceptionPanelForeground = this.colorFromString(string);
    }

    public Font getRuleEditorExceptionPanelFont() {
        return this.myRuleEditorExceptionPanelFont;
    }

    public String cvtRuleEditorExceptionPanelFont() {
        return this.fontToString(this.myRuleEditorExceptionPanelFont);
    }

    public void setRuleEditorExceptionPanelFont(Font font) {
        this.myRuleEditorExceptionPanelFont = font;
    }

    public void setRuleEditorExceptionPanelFont(String string) {
        this.myRuleEditorExceptionPanelFont = this.fontFromString(string);
    }

    public Point getEditorExceptionPanelLocation() {
        return this.myEditorExceptionPanelLocation;
    }

    public String cvtEditorExceptionPanelLocation() {
        return this.pointToString(this.myEditorExceptionPanelLocation);
    }

    public void setEditorExceptionPanelLocation(Point point) {
        this.myEditorExceptionPanelLocation = point;
    }

    public void setEditorExceptionPanelLocation(String string) {
        this.myEditorExceptionPanelLocation = this.pointFromString(string);
    }

    public Dimension getEditorExceptionPanelSize() {
        return this.myEditorExceptionPanelSize;
    }

    public String cvtEditorExceptionPanelSize() {
        return this.dimToString(this.myEditorExceptionPanelSize);
    }

    public void setEditorExceptionPanelSize(Dimension dimension) {
        this.myEditorExceptionPanelSize = dimension;
    }

    public void setEditorExceptionPanelSize(String string) {
        this.myEditorExceptionPanelSize = this.dimFromString(string);
    }

    public Color getRuleEditorHelpPanelBackground() {
        return this.myRuleEditorHelpPanelBackground;
    }

    public String cvtRuleEditorHelpPanelBackground() {
        return this.colorToString(this.myRuleEditorHelpPanelBackground);
    }

    public void setRuleEditorHelpPanelBackground(Color color) {
        this.myRuleEditorHelpPanelBackground = color;
    }

    public void setRuleEditorHelpPanelBackground(String string) {
        this.myRuleEditorHelpPanelBackground = this.colorFromString(string);
    }

    public Color getRuleEditorHelpPanelForeground() {
        return this.myRuleEditorHelpPanelForeground;
    }

    public String cvtRuleEditorHelpPanelForeground() {
        return this.colorToString(this.myRuleEditorHelpPanelForeground);
    }

    public void setRuleEditorHelpPanelForeground(Color color) {
        this.myRuleEditorHelpPanelForeground = color;
    }

    public void setRuleEditorHelpPanelForeground(String string) {
        this.myRuleEditorHelpPanelForeground = this.colorFromString(string);
    }

    public Point getRuleEditorHelpPanelLocation() {
        return this.myRuleEditorHelpPanelLocation;
    }

    public String cvtRuleEditorHelpPanelLocation() {
        return this.pointToString(this.myRuleEditorHelpPanelLocation);
    }

    public void setRuleEditorHelpPanelLocation(Point point) {
        this.myRuleEditorHelpPanelLocation = point;
    }

    public void setRuleEditorHelpPanelLocation(String string) {
        this.myRuleEditorHelpPanelLocation = this.pointFromString(string);
    }

    public Dimension getRuleEditorHelpPanelSize() {
        return this.myRuleEditorHelpPanelSize;
    }

    public String cvtRuleEditorHelpPanelSize() {
        return this.dimToString(this.myRuleEditorHelpPanelSize);
    }

    public void setRuleEditorHelpPanelSize(Dimension dimension) {
        this.myRuleEditorHelpPanelSize = dimension;
    }

    public void setRuleEditorHelpPanelSize(String string) {
        this.myRuleEditorHelpPanelSize = this.dimFromString(string);
    }

    public Color getRuleEditorOutputPanelBackground() {
        return this.myRuleEditorOutputPanelBackground;
    }

    public String cvtRuleEditorOutputPanelBackground() {
        return this.colorToString(this.myRuleEditorOutputPanelBackground);
    }

    public void setRuleEditorOutputPanelBackground(Color color) {
        this.myRuleEditorOutputPanelBackground = color;
    }

    public void setRuleEditorOutputPanelBackground(String string) {
        this.myRuleEditorOutputPanelBackground = this.colorFromString(string);
    }

    public Color getRuleEditorOutputPanelForeground() {
        return this.myRuleEditorOutputPanelForeground;
    }

    public String cvtRuleEditorOutputPanelForeground() {
        return this.colorToString(this.myRuleEditorOutputPanelForeground);
    }

    public void setRuleEditorOutputPanelForeground(Color color) {
        this.myRuleEditorOutputPanelForeground = color;
    }

    public void setRuleEditorOutputPanelForeground(String string) {
        this.myRuleEditorOutputPanelForeground = this.colorFromString(string);
    }

    public Font getRuleEditorOutputPanelFont() {
        return this.myRuleEditorOutputPanelFont;
    }

    public String cvtRuleEditorOutputPanelFont() {
        return this.fontToString(this.myRuleEditorOutputPanelFont);
    }

    public void setRuleEditorOutputPanelFont(Font font) {
        this.myRuleEditorOutputPanelFont = font;
    }

    public void setRuleEditorOutputPanelFont(String string) {
        this.myRuleEditorOutputPanelFont = this.fontFromString(string);
    }

    public Point getRuleEditorOutputPanelLocation() {
        return this.myRuleEditorOutputPanelLocation;
    }

    public String cvtRuleEditorOutputPanelLocation() {
        return this.pointToString(this.myRuleEditorOutputPanelLocation);
    }

    public void setRuleEditorOutputPanelLocation(Point point) {
        this.myRuleEditorOutputPanelLocation = point;
    }

    public void setRuleEditorOutputPanelLocation(String string) {
        this.myRuleEditorOutputPanelLocation = this.pointFromString(string);
    }

    public Dimension getRuleEditorOutputPanelSize() {
        return this.myRuleEditorOutputPanelSize;
    }

    public String cvtRuleEditorOutputPanelSize() {
        return this.dimToString(this.myRuleEditorOutputPanelSize);
    }

    public void setRuleEditorOutputPanelSize(Dimension dimension) {
        this.myRuleEditorOutputPanelSize = dimension;
    }

    public void setRuleEditorOutputPanelSize(String string) {
        this.myRuleEditorOutputPanelSize = this.dimFromString(string);
    }

    public Point getRuleEditorSetViewerPanelLocation() {
        return this.myRuleEditorSetViewerPanelLocation;
    }

    public String cvtRuleEditorSetViewerPanelLocation() {
        return this.pointToString(this.myRuleEditorSetViewerPanelLocation);
    }

    public void setRuleEditorSetViewerPanelLocation(Point point) {
        this.myRuleEditorSetViewerPanelLocation = point;
    }

    public void setRuleEditorSetViewerPanelLocation(String string) {
        this.myRuleEditorSetViewerPanelLocation = this.pointFromString(string);
    }

    public Dimension getRuleEditorSetViewerPanelSize() {
        return this.myRuleEditorSetViewerPanelSize;
    }

    public String cvtRuleEditorSetViewerPanelSize() {
        return this.dimToString(this.myRuleEditorSetViewerPanelSize);
    }

    public void setRuleEditorSetViewerPanelSize(Dimension dimension) {
        this.myRuleEditorSetViewerPanelSize = dimension;
    }

    public void setRuleEditorSetViewerPanelSize(String string) {
        this.myRuleEditorSetViewerPanelSize = this.dimFromString(string);
    }

    public Color getRuleEditorXmlPanelBackground() {
        return this.myRuleEditorXmlPanelBackground;
    }

    public String cvtRuleEditorXmlPanelBackground() {
        return this.colorToString(this.myRuleEditorXmlPanelBackground);
    }

    public void setRuleEditorXmlPanelBackground(Color color) {
        this.myRuleEditorXmlPanelBackground = color;
    }

    public void setRuleEditorXmlPanelBackground(String string) {
        this.myRuleEditorXmlPanelBackground = this.colorFromString(string);
    }

    public Color getRuleEditorXmlPanelForeground() {
        return this.myRuleEditorXmlPanelForeground;
    }

    public String cvtRuleEditorXmlPanelForeground() {
        return this.colorToString(this.myRuleEditorXmlPanelForeground);
    }

    public void setRuleEditorXmlPanelForeground(Color color) {
        this.myRuleEditorXmlPanelForeground = color;
    }

    public void setRuleEditorXmlPanelForeground(String string) {
        this.myRuleEditorXmlPanelForeground = this.colorFromString(string);
    }

    public Font getRuleEditorXmlPanelFont() {
        return this.myRuleEditorXmlPanelFont;
    }

    public String cvtRuleEditorXmlPanelFont() {
        return this.fontToString(this.myRuleEditorXmlPanelFont);
    }

    public void setRuleEditorXmlPanelFont(Font font) {
        this.myRuleEditorXmlPanelFont = font;
    }

    public void setRuleEditorXmlPanelFont(String string) {
        this.myRuleEditorXmlPanelFont = this.fontFromString(string);
    }

    public Point getRuleEditorXmlPanelLocation() {
        return this.myRuleEditorXmlPanelLocation;
    }

    public String cvtRuleEditorXmlPanelLocation() {
        return this.pointToString(this.myRuleEditorXmlPanelLocation);
    }

    public void setRuleEditorXmlPanelLocation(Point point) {
        this.myRuleEditorXmlPanelLocation = point;
    }

    public void setRuleEditorXmlPanelLocation(String string) {
        this.myRuleEditorXmlPanelLocation = this.pointFromString(string);
    }

    public Dimension getRuleEditorXmlPanelSize() {
        return this.myRuleEditorXmlPanelSize;
    }

    public String cvtRuleEditorXmlPanelSize() {
        return this.dimToString(this.myRuleEditorXmlPanelSize);
    }

    public void setRuleEditorXmlPanelSize(Dimension dimension) {
        this.myRuleEditorXmlPanelSize = dimension;
    }

    public void setRuleEditorXmlPanelSize(String string) {
        this.myRuleEditorXmlPanelSize = this.dimFromString(string);
    }

    public Point getRuleDebuggerPanelLocation() {
        return this.myRuleDebuggerPanelLocation;
    }

    public String cvtRuleDebuggerPanelLocation() {
        return this.pointToString(this.myRuleDebuggerPanelLocation);
    }

    public void setRuleDebuggerPanelLocation(Point point) {
        this.myRuleDebuggerPanelLocation = point;
    }

    public void setRuleDebuggerPanelLocation(String string) {
        this.myRuleDebuggerPanelLocation = this.pointFromString(string);
    }

    public Dimension getRuleDebuggerPanelSize() {
        return this.myRuleDebuggerPanelSize;
    }

    public String cvtRuleDebuggerPanelSize() {
        return this.dimToString(this.myRuleDebuggerPanelSize);
    }

    public void setRuleDebuggerPanelSize(Dimension dimension) {
        this.myRuleDebuggerPanelSize = dimension;
    }

    public void setRuleDebuggerPanelSize(String string) {
        this.myRuleDebuggerPanelSize = this.dimFromString(string);
    }

    public int getRuleDebuggerPanelDividerLocation() {
        return this.myRuleDebuggerPanelDividerLocation;
    }

    public String cvtRuleDebuggerPanelDividerLocation() {
        return this.myRuleDebuggerPanelDividerLocation.toString();
    }

    public void setRuleDebuggerPanelDividerLocation(int n) {
        this.myRuleDebuggerPanelDividerLocation = new Integer(n);
    }

    public void setRuleDebuggerPanelDividerLocation(String string) {
        this.myRuleDebuggerPanelDividerLocation = new Integer(string);
    }

    public boolean getRuleDebuggerPanelHorizontal() {
        return this.myRuleDebuggerPanelHorizontal;
    }

    public String cvtRuleDebuggerPanelHorizontal() {
        return this.myRuleDebuggerPanelHorizontal ? "1" : "0";
    }

    public void setRuleDebuggerPanelHorizontal(boolean bl) {
        this.myRuleDebuggerPanelHorizontal = bl;
    }

    public void setRuleDebuggerPanelHorizontal(String string) {
        this.myRuleDebuggerPanelHorizontal = string.trim().equals("1");
    }

    public Point getInspectorPanelLocation() {
        return this.myInspectorPanelLocation;
    }

    public String cvtInspectorPanelLocation() {
        return this.pointToString(this.myInspectorPanelLocation);
    }

    public void setInspectorPanelLocation(Point point) {
        this.myInspectorPanelLocation = point;
    }

    public void setInspectorPanelLocation(String string) {
        this.myInspectorPanelLocation = this.pointFromString(string);
    }

    public Dimension getInspectorPanelSize() {
        return this.myInspectorPanelSize;
    }

    public String cvtInspectorPanelSize() {
        return this.dimToString(this.myInspectorPanelSize);
    }

    public void setInspectorPanelSize(Dimension dimension) {
        this.myInspectorPanelSize = dimension;
    }

    public void setInspectorPanelSize(String string) {
        this.myInspectorPanelSize = this.dimFromString(string);
    }

    public AbleGuiPreferences() {
        String string = System.getProperty("able.prefdir", "");
        String string2 = System.getProperty("user.home");
        this.myPropertiesFile = string.trim().length() == 0 ? string2 + File.separator + "ablegui.preferences" : string + File.separator + "ablegui.preferences";
        this.readPropertiesFile();
    }

    public void readPropertiesFile() {
        this.myProperties = new Properties();
        try {
            this.myProperties.load(new BufferedInputStream(new FileInputStream(this.myPropertiesFile)));
            this.movePropertiesToPreferenceVariables(this.myProperties);
        }
        catch (Exception exception) {
            this.movePreferenceVariablesToProperties(this.myProperties);
            this.writePropertiesFile();
        }
    }

    public void writePropertiesFile() {
        if (this.myProperties == null) {
            this.myProperties = new Properties();
        }
        try {
            this.movePreferenceVariablesToProperties(this.myProperties);
            this.myProperties.store(new FileOutputStream(this.myPropertiesFile), "IBM Agent Building and Learning Environment Preferences File");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updatePreferenceVariablesAndWritePropertiesFile(AbleGuiPreferences ableGuiPreferences) {
        this.setAbleJarFiles(ableGuiPreferences.getAbleJarFiles());
        this.setPlugInJarDirectory(ableGuiPreferences.getPlugInJarDirectory());
        this.setDatabaseDrivers(ableGuiPreferences.getDatabaseDrivers());
        this.setDatabaseProtocols(ableGuiPreferences.getDatabaseProtocols());
        this.setDatabaseSubprotocols(ableGuiPreferences.getDatabaseSubprotocols());
        this.setDatabaseDatabases(ableGuiPreferences.getDatabaseDatabases());
        this.setEditorPanelBackground(ableGuiPreferences.getEditorPanelBackground());
        this.setEditorPanelForeground(ableGuiPreferences.getEditorPanelForeground());
        this.setEditorPanelFont(ableGuiPreferences.getEditorPanelFont());
        this.setEditorPanelLocation(ableGuiPreferences.getEditorPanelLocation());
        this.setEditorPanelSize(ableGuiPreferences.getEditorPanelSize());
        this.setEditorPanelDividerLocation(ableGuiPreferences.getEditorPanelDividerLocation());
        this.setConnectionsView(ableGuiPreferences.getConnectionsView());
        this.setEditorExitPrompt(ableGuiPreferences.getEditorExitPrompt());
        this.setPlugInJarOn(ableGuiPreferences.getPlugInJarOn());
        this.setEditorBeanPaletteLabels(ableGuiPreferences.getEditorBeanPaletteLabels());
        this.setAbleLookAndFeelClassName(ableGuiPreferences.getAbleLookAndFeelClassName());
        this.setTextEditor(ableGuiPreferences.getTextEditor());
        this.setRuleEditorPanelBackground(ableGuiPreferences.getRuleEditorPanelBackground());
        this.setRuleEditorPanelForeground(ableGuiPreferences.getRuleEditorPanelForeground());
        this.setRuleEditorPanelFont(ableGuiPreferences.getRuleEditorPanelFont());
        this.setRuleEditorPanelLocation(ableGuiPreferences.getRuleEditorPanelLocation());
        this.setRuleEditorPanelSize(ableGuiPreferences.getRuleEditorPanelSize());
        this.setRuleEditorTitleBackground(ableGuiPreferences.getRuleEditorTitleBackground());
        this.setRuleEditorTitleForeground(ableGuiPreferences.getRuleEditorTitleForeground());
        this.setRuleEditorTitleFont(ableGuiPreferences.getRuleEditorTitleFont());
        this.setRuleEditorExceptionPanelBackground(ableGuiPreferences.getRuleEditorExceptionPanelBackground());
        this.setRuleEditorExceptionPanelForeground(ableGuiPreferences.getRuleEditorExceptionPanelForeground());
        this.setRuleEditorExceptionPanelFont(ableGuiPreferences.getRuleEditorExceptionPanelFont());
        this.setEditorExceptionPanelLocation(ableGuiPreferences.getEditorExceptionPanelLocation());
        this.setEditorExceptionPanelSize(ableGuiPreferences.getEditorExceptionPanelSize());
        this.setRuleEditorHelpPanelBackground(ableGuiPreferences.getRuleEditorHelpPanelBackground());
        this.setRuleEditorHelpPanelForeground(ableGuiPreferences.getRuleEditorHelpPanelForeground());
        this.setRuleEditorHelpPanelLocation(ableGuiPreferences.getRuleEditorHelpPanelLocation());
        this.setRuleEditorHelpPanelSize(ableGuiPreferences.getRuleEditorHelpPanelSize());
        this.setRuleEditorOutputPanelBackground(ableGuiPreferences.getRuleEditorOutputPanelBackground());
        this.setRuleEditorOutputPanelForeground(ableGuiPreferences.getRuleEditorOutputPanelForeground());
        this.setRuleEditorOutputPanelFont(ableGuiPreferences.getRuleEditorOutputPanelFont());
        this.setRuleEditorOutputPanelLocation(ableGuiPreferences.getRuleEditorOutputPanelLocation());
        this.setRuleEditorOutputPanelSize(ableGuiPreferences.getRuleEditorOutputPanelSize());
        this.setRuleEditorSetViewerPanelLocation(ableGuiPreferences.getRuleEditorSetViewerPanelLocation());
        this.setRuleEditorSetViewerPanelSize(ableGuiPreferences.getRuleEditorSetViewerPanelSize());
        this.setRuleEditorXmlPanelBackground(ableGuiPreferences.getRuleEditorXmlPanelBackground());
        this.setRuleEditorXmlPanelForeground(ableGuiPreferences.getRuleEditorXmlPanelForeground());
        this.setRuleEditorXmlPanelFont(ableGuiPreferences.getRuleEditorXmlPanelFont());
        this.setRuleEditorXmlPanelLocation(ableGuiPreferences.getRuleEditorXmlPanelLocation());
        this.setRuleEditorXmlPanelSize(ableGuiPreferences.getRuleEditorXmlPanelSize());
        this.setRuleDebuggerPanelLocation(ableGuiPreferences.getRuleDebuggerPanelLocation());
        this.setRuleDebuggerPanelSize(ableGuiPreferences.getRuleDebuggerPanelSize());
        this.setRuleDebuggerPanelDividerLocation(ableGuiPreferences.getRuleDebuggerPanelDividerLocation());
        this.setRuleDebuggerPanelHorizontal(ableGuiPreferences.getRuleDebuggerPanelHorizontal());
        this.setInspectorPanelLocation(ableGuiPreferences.getInspectorPanelLocation());
        this.setInspectorPanelSize(ableGuiPreferences.getInspectorPanelSize());
        this.writePropertiesFile();
    }

    private void movePropertiesToPreferenceVariables(Properties properties) {
        String string = "";
        try {
            string = properties.getProperty("AbleJarFiles");
            if (string != null) {
                this.setAbleJarFiles(string);
            }
            if ((string = properties.getProperty("PlugInJarDirectory")) != null) {
                this.setPlugInJarDirectory(string);
            }
            if ((string = properties.getProperty("DatabaseDrivers")) != null) {
                this.setDatabaseDrivers(string);
            }
            if ((string = properties.getProperty("DatabaseProtocols")) != null) {
                this.setDatabaseProtocols(string);
            }
            if ((string = properties.getProperty("DatabaseSubprotocols")) != null) {
                this.setDatabaseSubprotocols(string);
            }
            if ((string = properties.getProperty("DatabaseDatabases")) != null) {
                this.setDatabaseDatabases(string);
            }
            if ((string = properties.getProperty("EditorPanelBackground")) != null) {
                this.setEditorPanelBackground(string);
            }
            if ((string = properties.getProperty("EditorPanelForeground")) != null) {
                this.setEditorPanelForeground(string);
            }
            if ((string = properties.getProperty("EditorPanelFont")) != null) {
                this.setEditorPanelFont(string);
            }
            if ((string = properties.getProperty("EditorPanelLocation")) != null) {
                this.setEditorPanelLocation(string);
            }
            if ((string = properties.getProperty("EditorPanelSize")) != null) {
                this.setEditorPanelSize(string);
            }
            if ((string = properties.getProperty("EditorPanelDividerLocation")) != null) {
                this.setEditorPanelDividerLocation(string);
            }
            if ((string = properties.getProperty("ConnectionsView")) != null) {
                this.setConnectionsView(string);
            }
            if ((string = properties.getProperty("EditorExitPrompt")) != null) {
                this.setEditorExitPrompt(string);
            }
            if ((string = properties.getProperty("PlugInJarOn")) != null) {
                this.setPlugInJarOn(string);
            }
            if ((string = properties.getProperty("EditorBeanPaletteLabels")) != null) {
                this.setEditorBeanPaletteLabels(string);
            }
            if ((string = properties.getProperty("AbleLookAndFeelClassName")) != null) {
                this.setAbleLookAndFeelClassName(string);
            }
            if ((string = properties.getProperty("TextEditor")) != null) {
                this.setTextEditor(string);
            }
            if ((string = properties.getProperty("RuleEditorPanelBackground")) != null) {
                this.setRuleEditorPanelBackground(string);
            }
            if ((string = properties.getProperty("RuleEditorPanelForeground")) != null) {
                this.setRuleEditorPanelForeground(string);
            }
            if ((string = properties.getProperty("RuleEditorPanelFont")) != null) {
                this.setRuleEditorPanelFont(string);
            }
            if ((string = properties.getProperty("RuleEditorPanelLocation")) != null) {
                this.setRuleEditorPanelLocation(string);
            }
            if ((string = properties.getProperty("RuleEditorPanelSize")) != null) {
                this.setRuleEditorPanelSize(string);
            }
            if ((string = properties.getProperty("RuleEditorTitleBackground")) != null) {
                this.setRuleEditorTitleBackground(string);
            }
            if ((string = properties.getProperty("RuleEditorTitleForeground")) != null) {
                this.setRuleEditorTitleForeground(string);
            }
            if ((string = properties.getProperty("RuleEditorTitleFont")) != null) {
                this.setRuleEditorTitleFont(string);
            }
            if ((string = properties.getProperty("RuleEditorExceptionPanelBackground")) != null) {
                this.setRuleEditorExceptionPanelBackground(string);
            }
            if ((string = properties.getProperty("RuleEditorExceptionPanelForeground")) != null) {
                this.setRuleEditorExceptionPanelForeground(string);
            }
            if ((string = properties.getProperty("RuleEditorExceptionPanelFont")) != null) {
                this.setRuleEditorExceptionPanelFont(string);
            }
            if ((string = properties.getProperty("RuleEditorExceptionPanelLocation")) != null) {
                this.setEditorExceptionPanelLocation(string);
            }
            if ((string = properties.getProperty("RuleEditorExceptionPanelSize")) != null) {
                this.setEditorExceptionPanelSize(string);
            }
            if ((string = properties.getProperty("RuleEditorHelpPanelBackground")) != null) {
                this.setRuleEditorHelpPanelBackground(string);
            }
            if ((string = properties.getProperty("RuleEditorHelpPanelForeground")) != null) {
                this.setRuleEditorHelpPanelForeground(string);
            }
            if ((string = properties.getProperty("RuleEditorHelpPanelLocation")) != null) {
                this.setRuleEditorHelpPanelLocation(string);
            }
            if ((string = properties.getProperty("RuleEditorHelpPanelSize")) != null) {
                this.setRuleEditorHelpPanelSize(string);
            }
            if ((string = properties.getProperty("RuleEditorOutputPanelBackground")) != null) {
                this.setRuleEditorOutputPanelBackground(string);
            }
            if ((string = properties.getProperty("RuleEditorOutputPanelForeground")) != null) {
                this.setRuleEditorOutputPanelForeground(string);
            }
            if ((string = properties.getProperty("RuleEditorOutputPanelFont")) != null) {
                this.setRuleEditorOutputPanelFont(string);
            }
            if ((string = properties.getProperty("RuleEditorOutputPanelLocation")) != null) {
                this.setRuleEditorOutputPanelLocation(string);
            }
            if ((string = properties.getProperty("RuleEditorOutputPanelSize")) != null) {
                this.setRuleEditorOutputPanelSize(string);
            }
            if ((string = properties.getProperty("RuleEditorSetViewerPanelLocation")) != null) {
                this.setRuleEditorSetViewerPanelLocation(string);
            }
            if ((string = properties.getProperty("RuleEditorSetViewerPanelSize")) != null) {
                this.setRuleEditorSetViewerPanelSize(string);
            }
            if ((string = properties.getProperty("RuleEditorXmlPanelBackground")) != null) {
                this.setRuleEditorXmlPanelBackground(string);
            }
            if ((string = properties.getProperty("RuleEditorXmlPanelForeground")) != null) {
                this.setRuleEditorXmlPanelForeground(string);
            }
            if ((string = properties.getProperty("RuleEditorXmlPanelFont")) != null) {
                this.setRuleEditorXmlPanelFont(string);
            }
            if ((string = properties.getProperty("RuleEditorXmlPanelLocation")) != null) {
                this.setRuleEditorXmlPanelLocation(string);
            }
            if ((string = properties.getProperty("RuleEditorXmlPanelSize")) != null) {
                this.setRuleEditorXmlPanelSize(string);
            }
            if ((string = properties.getProperty("RuleDebuggerPanelLocation")) != null) {
                this.setRuleDebuggerPanelLocation(string);
            }
            if ((string = properties.getProperty("RuleDebuggerPanelSize")) != null) {
                this.setRuleDebuggerPanelSize(string);
            }
            if ((string = properties.getProperty("RuleDebuggerPanelDividerLocation")) != null) {
                this.setRuleDebuggerPanelDividerLocation(string);
            }
            if ((string = properties.getProperty("RuleDebuggerPanelHorizontal")) != null) {
                this.setRuleDebuggerPanelHorizontal(string);
            }
            if ((string = properties.getProperty("InspectorPanelLocation")) != null) {
                this.setInspectorPanelLocation(string);
            }
            if ((string = properties.getProperty("InspectorPanelSize")) != null) {
                this.setInspectorPanelSize(string);
            }
        }
        catch (Exception exception) {
            this.debugTrace("Cannot load GUI preferences. Exception is " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void movePreferenceVariablesToProperties(Properties properties) {
        properties.put("AbleJarFiles", this.cvtAbleJarFiles());
        properties.put("PlugInJarDirectory", this.cvtPlugInJarDirectory());
        properties.put("DatabaseDrivers", this.cvtDatabaseDrivers());
        properties.put("DatabaseProtocols", this.cvtDatabaseProtocols());
        properties.put("DatabaseSubprotocols", this.cvtDatabaseSubprotocols());
        properties.put("DatabaseDatabases", this.cvtDatabaseDatabases());
        properties.put("EditorPanelBackground", this.cvtEditorPanelBackground());
        properties.put("EditorPanelForeground", this.cvtEditorPanelForeground());
        properties.put("EditorPanelFont", this.cvtEditorPanelFont());
        properties.put("EditorPanelLocation", this.cvtEditorPanelLocation());
        properties.put("EditorPanelSize", this.cvtEditorPanelSize());
        properties.put("EditorPanelDividerLocation", this.cvtEditorPanelDividerLocation());
        properties.put("ConnectionsView", this.cvtConnectionsView());
        properties.put("EditorExitPrompt", this.cvtEditorExitPrompt());
        properties.put("PlugInJarOn", this.cvtPlugInJarOn());
        properties.put("EditorBeanPaletteLabels", this.getEditorBeanPaletteLabels());
        properties.put("AbleLookAndFeelClassName", this.getAbleLookAndFeelClassName());
        properties.put("TextEditor", this.getTextEditor());
        properties.put("RuleEditorPanelBackground", this.cvtRuleEditorPanelBackground());
        properties.put("RuleEditorPanelForeground", this.cvtRuleEditorPanelForeground());
        properties.put("RuleEditorPanelFont", this.cvtRuleEditorPanelFont());
        properties.put("RuleEditorPanelLocation", this.cvtRuleEditorPanelLocation());
        properties.put("RuleEditorPanelSize", this.cvtRuleEditorPanelSize());
        properties.put("RuleEditorTitleBackground", this.cvtRuleEditorTitleBackground());
        properties.put("RuleEditorTitleForeground", this.cvtRuleEditorTitleForeground());
        properties.put("RuleEditorTitleFont", this.cvtRuleEditorTitleFont());
        properties.put("RuleEditorExceptionPanelBackground", this.cvtRuleEditorExceptionPanelBackground());
        properties.put("RuleEditorExceptionPanelForeground", this.cvtRuleEditorExceptionPanelForeground());
        properties.put("RuleEditorExceptionPanelFont", this.cvtRuleEditorExceptionPanelFont());
        properties.put("RuleEditorExceptionPanelLocation", this.cvtEditorExceptionPanelLocation());
        properties.put("RuleEditorExceptionPanelSize", this.cvtEditorExceptionPanelSize());
        properties.put("RuleEditorHelpPanelBackground", this.cvtRuleEditorHelpPanelBackground());
        properties.put("RuleEditorHelpPanelForeground", this.cvtRuleEditorHelpPanelForeground());
        properties.put("RuleEditorHelpPanelLocation", this.cvtRuleEditorHelpPanelLocation());
        properties.put("RuleEditorHelpPanelSize", this.cvtRuleEditorHelpPanelSize());
        properties.put("RuleEditorOutputPanelBackground", this.cvtRuleEditorOutputPanelBackground());
        properties.put("RuleEditorOutputPanelForeground", this.cvtRuleEditorOutputPanelForeground());
        properties.put("RuleEditorOutputPanelFont", this.cvtRuleEditorOutputPanelFont());
        properties.put("RuleEditorOutputPanelLocation", this.cvtRuleEditorOutputPanelLocation());
        properties.put("RuleEditorOutputPanelSize", this.cvtRuleEditorOutputPanelSize());
        properties.put("RuleEditorSetViewerPanelLocation", this.cvtRuleEditorSetViewerPanelLocation());
        properties.put("RuleEditorSetViewerPanelSize", this.cvtRuleEditorSetViewerPanelSize());
        properties.put("RuleEditorXmlPanelBackground", this.cvtRuleEditorXmlPanelBackground());
        properties.put("RuleEditorXmlPanelForeground", this.cvtRuleEditorXmlPanelForeground());
        properties.put("RuleEditorXmlPanelFont", this.cvtRuleEditorXmlPanelFont());
        properties.put("RuleEditorXmlPanelLocation", this.cvtRuleEditorXmlPanelLocation());
        properties.put("RuleEditorXmlPanelSize", this.cvtRuleEditorXmlPanelSize());
        properties.put("RuleDebuggerPanelLocation", this.cvtRuleDebuggerPanelLocation());
        properties.put("RuleDebuggerPanelSize", this.cvtRuleDebuggerPanelSize());
        properties.put("RuleDebuggerPanelDividerLocation", this.cvtRuleDebuggerPanelDividerLocation());
        properties.put("RuleDebuggerPanelHorizontal", this.cvtRuleDebuggerPanelHorizontal());
        properties.put("InspectorPanelLocation", this.cvtInspectorPanelLocation());
        properties.put("InspectorPanelSize", this.cvtInspectorPanelSize());
    }

    private TreeSet treeSetFromString(String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            treeSet.add(stringTokenizer.nextToken());
        }
        return treeSet;
    }

    private String treeSetToString(TreeSet treeSet) {
        StringBuffer stringBuffer = new StringBuffer("");
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" " + iterator.next());
        }
        return stringBuffer.toString().trim();
    }

    private String colorToString(Color color) {
        return String.valueOf(color.getRed() + "," + color.getGreen() + "," + color.getBlue());
    }

    private Color colorFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(string3);
        int n3 = Integer.parseInt(string4);
        if (n < 0 || n > 255) {
            n = 100;
        }
        if (n2 < 0 || n2 > 255) {
            n2 = 100;
        }
        if (n3 < 0 || n3 > 255) {
            n3 = 100;
        }
        return new Color(n, n2, n3);
    }

    private String dimToString(Dimension dimension) {
        return String.valueOf(dimension.width + "," + dimension.height);
    }

    private Dimension dimFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(string3);
        if (n < 50) {
            n = 100;
        }
        if (n2 < 50) {
            n2 = 100;
        }
        return new Dimension(n, n2);
    }

    private String fontToString(Font font) {
        String string = "Plain";
        int n = font.getStyle();
        if (n == 0) {
            string = "Plain";
        }
        if (n == 1) {
            string = "Bold";
        }
        if (n == 3) {
            string = "BoldItalic";
        }
        if (n == 2) {
            string = "Italic";
        }
        return String.valueOf(font.getName() + "," + string + "," + font.getSize());
    }

    private Font fontFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        int n = Integer.parseInt(string4);
        int n2 = 0;
        if (string3.equalsIgnoreCase("Plain")) {
            n2 = 0;
        }
        if (string3.equalsIgnoreCase("Bold")) {
            n2 = 1;
        }
        if (string3.equalsIgnoreCase("BoldItalic")) {
            n2 = 3;
        }
        if (string3.equalsIgnoreCase("Italic")) {
            n2 = 2;
        }
        return new Font(string2, n2, n);
    }

    private String pointToString(Point point) {
        return String.valueOf(point.x + "," + point.y);
    }

    private Point pointFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(string3);
        return new Point(n, n2);
    }

    protected void debugTrace(String string) {
        try {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(262144L, (Object)this, "", string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

