/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.Able;
import com.ibm.able.editor.AbleInspector;
import com.ibm.able.editor.AbleInspectorContext;
import com.ibm.able.editor.AbleViewObject;
import java.awt.Point;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class AbleEnvironment
implements Serializable {
    protected static final long serialVersionUID = 2000100100000000001L;
    transient Vector inspectors = new Vector();
    AbleInspectorContext[] contexts;
    Vector pointList = new Vector();
    HashMap pointMap = new HashMap();
    private static Point nextPoint = new Point();

    public AbleEnvironment() {
        nextPoint = new Point();
    }

    public void addInspector(AbleInspector ableInspector) {
        this.inspectors.addElement(ableInspector);
    }

    public void removeInspector(AbleInspector ableInspector) {
        this.inspectors.removeElement(ableInspector);
    }

    public Vector getInspectors() {
        return this.inspectors;
    }

    public void setViewObjectLocations(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.pointMap.clear();
        this.findViewObjectLocations(defaultMutableTreeNode, this.pointMap);
    }

    protected void findViewObjectLocations(DefaultMutableTreeNode defaultMutableTreeNode, HashMap hashMap) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        AbleViewObject ableViewObject = (AbleViewObject)defaultMutableTreeNode.getUserObject();
        Point point = new Point(ableViewObject.getLocation());
        hashMap.put(ableViewObject.getKey(), point);
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(524288L, (Object)this, "findViewObjectLocations", "Found " + ableViewObject.getName() + "@ x=" + point.getX() + ", y=" + point.getY());
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            ableViewObject = (AbleViewObject)defaultMutableTreeNode2.getUserObject();
            this.findViewObjectLocations(defaultMutableTreeNode2, hashMap);
        }
    }

    public void restoreViewObjectLocations(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.restoreViewObjectLocations(defaultMutableTreeNode, this.pointMap);
    }

    protected void restoreViewObjectLocations(DefaultMutableTreeNode defaultMutableTreeNode, HashMap hashMap) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        AbleViewObject ableViewObject = (AbleViewObject)defaultMutableTreeNode.getUserObject();
        Point point = (Point)hashMap.get(ableViewObject.getKey());
        if (point == null) {
            point = this.pointList != null && this.pointList.size() > 0 ? (Point)this.pointList.remove(0) : this.getNextPoint();
        }
        ableViewObject.setLocation(point);
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            ableViewObject = (AbleViewObject)defaultMutableTreeNode2.getUserObject();
            this.restoreViewObjectLocations(defaultMutableTreeNode2, hashMap);
        }
    }

    public void saveToFile(String string) throws IOException {
        Object object;
        this.contexts = new AbleInspectorContext[this.inspectors.size()];
        for (int i = 0; i < this.inspectors.size(); ++i) {
            object = (AbleInspector)this.inspectors.elementAt(i);
            this.contexts[i] = ((AbleInspector)object).getContext();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        object = new ObjectOutputStream(fileOutputStream);
        ((ObjectOutputStream)object).writeObject(this);
    }

    public static AbleEnvironment restoreFromFile(String string) throws IOException, ClassNotFoundException {
        AbleEnvironment ableEnvironment = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        ableEnvironment = (AbleEnvironment)objectInputStream.readObject();
        return ableEnvironment;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.inspectors = new Vector();
        if (this.pointMap == null) {
            this.pointMap = new HashMap();
        }
    }

    public AbleInspectorContext[] getInspectorContexts() {
        return this.contexts;
    }

    private Point getNextPoint() {
        AbleEnvironment.nextPoint.x += 50;
        AbleEnvironment.nextPoint.y += 50;
        return new Point(nextPoint);
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

