/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.Able;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.AbleTraceLogger;
import com.ibm.able.editor.AbleEditor;
import com.ibm.able.editor.AbleEditorFrame;
import com.ibm.able.editor.AbleGridBagConstraints;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class AbleEditorPreferences
extends JDialog {
    private AbleEditorFrame target;
    private JTextField myTextEditorTextField = new JTextField();
    private JTextField myBeanJarTextField = new JTextField();
    private JCheckBox myPlugInJarOnCheckBox = null;
    private JCheckBox myMessageLogDailyFileCheckBox = null;
    private JCheckBox myTraceLogDailyFileCheckBox = null;
    private JTextField myPlugInDirectoryTextField = new JTextField();
    private JButton myPlugInDirectoryButton = null;
    private String myWorkingDirectory = ".";
    private JComboBox myLookAndFeelComboBox = null;
    private JCheckBox myExitPromptCheckBox = null;
    private static Vector myLookAndFeelInfoVector = new Vector();
    private static Vector myLookAndFeelNameVector = new Vector();
    private JComboBox myTraceLogConsoleLevelComboBox = null;
    private JComboBox myTraceLogFileLevelComboBox = null;
    private JComboBox myMessageLogConsoleSeverityComboBox = null;
    private JComboBox myMessageLogFileSeverityComboBox = null;
    private boolean cancelled = false;

    private AbleEditorPreferences() {
        this((AbleEditorFrame)null, "Able Editor Preferences");
    }

    public AbleEditorPreferences(AbleEditorFrame ableEditorFrame, String string) {
        super(ableEditorFrame, string, true);
        this.target = ableEditorFrame;
        this.initializePanel();
        this.setObject(ableEditorFrame);
    }

    public void setObject(Object object) {
        int n;
        this.target = (AbleEditorFrame)object;
        this.myTextEditorTextField.setText(this.target.getTextEditor());
        this.myBeanJarTextField.setText(AbleEditor.Preferences.getAbleJarFiles());
        this.myPlugInDirectoryTextField.setText(AbleEditor.Preferences.getPlugInJarDirectory());
        String string = AbleEditor.Preferences.getAbleLookAndFeelClassName();
        for (n = 0; n < myLookAndFeelNameVector.size(); ++n) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = (UIManager.LookAndFeelInfo)myLookAndFeelInfoVector.elementAt(n);
            if (!string.equals(lookAndFeelInfo.getClassName())) continue;
            this.myLookAndFeelComboBox.setSelectedIndex(n);
            break;
        }
        this.myPlugInJarOnCheckBox.setSelected(AbleEditor.Preferences.getPlugInJarOn());
        this.myExitPromptCheckBox.setSelected(AbleEditor.Preferences.getEditorExitPrompt());
        this.myTraceLogDailyFileCheckBox.setSelected(Able.Preferences.getTraceLogDailyFile());
        this.myMessageLogDailyFileCheckBox.setSelected(Able.Preferences.getMessageLogDailyFile());
        n = AbleTraceLogger.TraceLogLevelValuesVector.indexOf(new Long(Able.Preferences.getTraceLogConsoleLevel()));
        if (n >= 0) {
            this.myTraceLogConsoleLevelComboBox.setSelectedIndex(n);
        }
        if ((n = AbleTraceLogger.MessageLogSeverityValuesVector.indexOf(new Long(Able.Preferences.getMessageLogConsoleSeverity()))) >= 0) {
            this.myMessageLogConsoleSeverityComboBox.setSelectedIndex(n);
        }
        if ((n = AbleTraceLogger.TraceLogLevelValuesVector.indexOf(new Long(Able.Preferences.getTraceLogFileLevel()))) >= 0) {
            this.myTraceLogFileLevelComboBox.setSelectedIndex(n);
        }
        if ((n = AbleTraceLogger.MessageLogSeverityValuesVector.indexOf(new Long(Able.Preferences.getMessageLogFileSeverity()))) >= 0) {
            this.myMessageLogFileSeverityComboBox.setSelectedIndex(n);
        }
    }

    public void updateObject() throws RemoteException {
        String string;
        int n = this.myLookAndFeelComboBox.getSelectedIndex();
        String string2 = ((UIManager.LookAndFeelInfo)myLookAndFeelInfoVector.elementAt(n)).getClassName();
        if (!AbleEditor.Preferences.getAbleLookAndFeelClassName().equals(string2)) {
            AbleEditor.Preferences.setAbleLookAndFeelClassName(string2);
            try {
                UIManager.setLookAndFeel(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string3 = this.myTextEditorTextField.getText().trim();
        this.target.setTextEditor(string3);
        AbleEditor.Preferences.setTextEditor(string3);
        String string4 = this.myBeanJarTextField.getText().trim();
        String string5 = AbleEditor.Preferences.getAbleJarFiles().trim();
        if (!string5.equals(string4)) {
            AbleEditor.Preferences.setAbleJarFiles(string4);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ";");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (string5.indexOf(string) != -1) continue;
                this.target.loadJars(string);
            }
        }
        boolean bl = this.myPlugInJarOnCheckBox.isSelected();
        AbleEditor.Preferences.setPlugInJarOn(bl);
        string = this.myPlugInDirectoryTextField.getText().trim();
        String string6 = AbleEditor.Preferences.getPlugInJarDirectory().trim();
        if (bl && !string6.equals(string)) {
            AbleEditor.Preferences.setPlugInJarDirectory(string);
            JOptionPane.showMessageDialog(this, "Leave the Agent Editor and restart for the new Jar Directory to be read.", "PlugInJarDirectory value changed", 1);
        }
        AbleEditor.Preferences.setEditorExitPrompt(this.myExitPromptCheckBox.isSelected());
        long l = (Long)AbleTraceLogger.TraceLogLevelValuesVector.elementAt(this.myTraceLogConsoleLevelComboBox.getSelectedIndex());
        Able.Preferences.setTraceLogConsoleLevel(l);
        Able.Preferences.setTraceLogDailyFile(this.myTraceLogDailyFileCheckBox.isSelected());
        Able.Preferences.setMessageLogDailyFile(this.myMessageLogDailyFileCheckBox.isSelected());
        long l2 = (Long)AbleTraceLogger.TraceLogLevelValuesVector.elementAt(this.myTraceLogFileLevelComboBox.getSelectedIndex());
        Able.Preferences.setTraceLogFileLevel(l2);
        Able.setTraceConsoleHandlerLevel((long)l);
        Able.setTraceFileHandlerLevel((long)l2);
        l = (Long)AbleTraceLogger.MessageLogSeverityValuesVector.elementAt(this.myMessageLogConsoleSeverityComboBox.getSelectedIndex());
        Able.Preferences.setMessageLogConsoleSeverity(l);
        l2 = (Long)AbleTraceLogger.MessageLogSeverityValuesVector.elementAt(this.myMessageLogFileSeverityComboBox.getSelectedIndex());
        Able.Preferences.setMessageLogFileSeverity(l2);
        Able.setMessageConsoleHandlerLevel((long)l);
        Able.setMessageFileHandlerLevel((long)l2);
    }

    private void initializePanel() {
        this.setResizable(false);
        this.setSize(640, 420);
        if (this.target != null) {
            this.setLocation(this.target.getLocation());
        }
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(600, 400));
        jPanel.setMinimumSize(new Dimension(460, 313));
        container.add(jPanel);
        jPanel.add((Component)this.newEditorPanel(), "North");
        jPanel.add((Component)this.newLoggingPanel(), "Center");
        jPanel.add((Component)this.newButtonsPanel(), "South");
        this.validate();
    }

    private JPanel newEditorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = -1;
        jPanel.add((Component)new JLabel("Look and Feel:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.myLookAndFeelComboBox = new JComboBox(myLookAndFeelNameVector);
        this.myLookAndFeelComboBox.setToolTipText("Preferred look and feel name");
        jPanel.add((Component)this.myLookAndFeelComboBox, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        jPanel.add((Component)new JLabel("Text Editor:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.myTextEditorTextField = new JTextField();
        this.myTextEditorTextField.setToolTipText("Path and executable name for your preferred text editor");
        jPanel.add((Component)this.myTextEditorTextField, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        JButton jButton = new JButton("Browse...");
        jButton.setSize(90, 24);
        jButton.setToolTipText("Find the text editor executable name and path");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorPreferences.this.BrowseButton_actionPerformed(actionEvent);
            }
        });
        jPanel.add((Component)jButton, new AbleGridBagConstraints(5, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 10), 0, 0));
        jPanel.add((Component)new JLabel("Bean Jars:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.myBeanJarTextField = new JTextField();
        this.myBeanJarTextField.setToolTipText("Enter the path and jar name to autoload beans");
        jPanel.add((Component)this.myBeanJarTextField, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        JButton jButton2 = new JButton("Browse...");
        jButton2.setSize(90, 24);
        jButton2.setToolTipText("Find and append a bean jar name and path");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorPreferences.this.BrowseJarButton_actionPerformed(actionEvent);
            }
        });
        jPanel.add((Component)jButton2, new AbleGridBagConstraints(5, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 10), 0, 0));
        this.myPlugInJarOnCheckBox = new JCheckBox("PlugIn Jar Directory:");
        this.myPlugInJarOnCheckBox.setMnemonic(80);
        jPanel.add((Component)this.myPlugInJarOnCheckBox, new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.myPlugInJarOnCheckBox.setToolTipText("Check to load plug-ins on editor startup");
        this.myPlugInJarOnCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AbleEditorPreferences.this.setPlugInDirectoryStates();
            }
        });
        this.myPlugInDirectoryTextField = new JTextField();
        this.myPlugInDirectoryTextField.setToolTipText("Enter the directory containing jars to autoload beans");
        jPanel.add((Component)this.myPlugInDirectoryTextField, new AbleGridBagConstraints(1, n, 4, 1, 0.5, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.myPlugInDirectoryButton = new JButton("Browse...");
        this.myPlugInDirectoryButton.setSize(90, 24);
        this.myPlugInDirectoryButton.setToolTipText("Find a directory");
        this.myPlugInDirectoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorPreferences.this.myPlugInDirectoryButton_actionPerformed(actionEvent);
            }
        });
        jPanel.add((Component)this.myPlugInDirectoryButton, new AbleGridBagConstraints(5, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 10), 0, 0));
        this.myExitPromptCheckBox = new JCheckBox("Prompt to save on exit");
        this.myExitPromptCheckBox.setMnemonic(83);
        jPanel.add((Component)this.myExitPromptCheckBox, new AbleGridBagConstraints(1, ++n, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        jPanel.setBorder(new TitledBorder("Agent editor options"));
        return jPanel;
    }

    private JPanel newLoggingPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = -1;
        jPanel.add((Component)new JLabel("Message file log severity:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.myMessageLogFileSeverityComboBox = new JComboBox(AbleTraceLogger.MessageLogSeverityLabelsVector);
        this.myMessageLogFileSeverityComboBox.setToolTipText("Message log file severity");
        jPanel.add((Component)this.myMessageLogFileSeverityComboBox, new AbleGridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.myMessageLogDailyFileCheckBox = new JCheckBox("daily");
        jPanel.add((Component)this.myMessageLogDailyFileCheckBox, new AbleGridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        String string = Able.Preferences.getMessageLogFileName();
        JLabel jLabel = new JLabel(string);
        jPanel.add((Component)jLabel, new AbleGridBagConstraints(3, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 0, 0, 10), 0, 0));
        jLabel.setToolTipText(string);
        jPanel.add((Component)new JLabel("Message console log severity:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.myMessageLogConsoleSeverityComboBox = new JComboBox(AbleTraceLogger.MessageLogSeverityLabelsVector);
        this.myMessageLogConsoleSeverityComboBox.setToolTipText("Message log console severity");
        jPanel.add((Component)this.myMessageLogConsoleSeverityComboBox, new AbleGridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        jPanel.add((Component)new JLabel("Trace file log level:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.myTraceLogFileLevelComboBox = new JComboBox(AbleTraceLogger.TraceLogLevelLabelsVector);
        this.myTraceLogFileLevelComboBox.setToolTipText("Trace file log level");
        jPanel.add((Component)this.myTraceLogFileLevelComboBox, new AbleGridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.myTraceLogDailyFileCheckBox = new JCheckBox("daily");
        jPanel.add((Component)this.myTraceLogDailyFileCheckBox, new AbleGridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        String string2 = Able.Preferences.getTraceLogFileName();
        JLabel jLabel2 = new JLabel(string2);
        jPanel.add((Component)jLabel2, new AbleGridBagConstraints(3, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 0, 0, 10), 0, 0));
        jLabel2.setToolTipText(string2);
        jPanel.add((Component)new JLabel("Trace console log level:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 0), 0, 0));
        this.myTraceLogConsoleLevelComboBox = new JComboBox(AbleTraceLogger.TraceLogLevelLabelsVector);
        this.myTraceLogConsoleLevelComboBox.setToolTipText("Trace console log level");
        jPanel.add((Component)this.myTraceLogConsoleLevelComboBox, new AbleGridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 10, 10), 0, 0));
        jPanel.setBorder(new TitledBorder("Logging options"));
        return jPanel;
    }

    private JPanel newButtonsPanel() {
        JPanel jPanel = new JPanel();
        AblePanelHelper.addButton(jPanel, "OK", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorPreferences.this.okButton_actionPerformed(actionEvent);
            }
        }, "Save changes and close");
        AblePanelHelper.addButton(jPanel, "Cancel", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorPreferences.this.cancelButton_actionPerformed(actionEvent);
            }
        }, "Cancel changes and close");
        AblePanelHelper.addButton(jPanel, "Help", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorPreferences.this.helpButton_actionPerformed(actionEvent);
            }
        }, "Display help");
        return jPanel;
    }

    private void BrowseButton_actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2 = this.myTextEditorTextField.getText().trim();
        String string3 = string2;
        if (string3 == "") {
            string3 = this.myWorkingDirectory;
        }
        if ((string = AblePanelHelper.setTextFieldFromFileDialog(this.myTextEditorTextField, "Executable File (*.exe)", "exe", string3)) != null) {
            this.myWorkingDirectory = string;
        }
    }

    private void BrowseJarButton_actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2 = this.myBeanJarTextField.getText().trim();
        String string3 = string2;
        if (string3 == "") {
            string3 = this.myWorkingDirectory;
        }
        if ((string = AblePanelHelper.setTextFieldFromFileDialog(this.myBeanJarTextField, "Bean Jar (*.jar)", "jar", string3)) != null) {
            this.myWorkingDirectory = string;
        }
        String string4 = this.myBeanJarTextField.getText().trim();
        if (string2.length() != 0) {
            this.myBeanJarTextField.setText(string2 + ";" + string4);
        }
    }

    private void myPlugInDirectoryButton_actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2 = this.myPlugInDirectoryTextField.getText().trim();
        if (string2 == "") {
            string2 = this.myWorkingDirectory;
        }
        if ((string = AblePanelHelper.setTextFieldFromFileDialog(this.myPlugInDirectoryTextField, "Bean Jar (*.jar)", "jar", string2)) != null) {
            this.myWorkingDirectory = string;
            this.myPlugInDirectoryTextField.setText(string);
        }
    }

    private void okButton_actionPerformed(ActionEvent actionEvent) {
        this.cancelled = false;
        try {
            this.updateObject();
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this, remoteException.toString(), "Editor Error: AbleEditorPreferences()", 0);
        }
        this.dispose();
    }

    private void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.cancelled = true;
        this.dispose();
    }

    private void helpButton_actionPerformed(ActionEvent actionEvent) {
        AbleEditorFrame.displayHelp(this, "AbleEditorPreferencesHelp.html");
    }

    private void defaultButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.updateObject();
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this, remoteException.toString(), "Editor Error: AbleEditorPreferences()", 0);
        }
    }

    private void setPlugInDirectoryStates() {
        boolean bl = this.myPlugInJarOnCheckBox.isSelected();
        this.myPlugInDirectoryTextField.setEnabled(bl);
        this.myPlugInDirectoryButton.setEnabled(bl);
    }

    public boolean userCancelled() {
        return this.cancelled;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            myLookAndFeelInfoVector.addElement(lookAndFeelInfoArray[i]);
            String string = lookAndFeelInfoArray[i].toString();
            int n = string.indexOf("[");
            if (n >= 0 && (n = (string = string.substring(n + 1)).indexOf(" ")) >= 0) {
                string = string.substring(0, n);
            }
            myLookAndFeelNameVector.addElement(string);
        }
    }
}

