/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.Able;
import com.ibm.able.AbleAgent;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBeanContainer;
import com.ibm.able.AbleBufferConnection;
import com.ibm.able.AbleDataSource;
import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObject;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.filter.AbleTranslateEditor;
import com.ibm.able.editor.AbleAboutDialog;
import com.ibm.able.editor.AbleDoOnBean;
import com.ibm.able.editor.AbleEditor;
import com.ibm.able.editor.AbleEditorCanvas;
import com.ibm.able.editor.AbleEditorPreferences;
import com.ibm.able.editor.AbleEnvironment;
import com.ibm.able.editor.AbleImportRemoteAgentDialog;
import com.ibm.able.editor.AbleInspector;
import com.ibm.able.editor.AbleInspectorContext;
import com.ibm.able.editor.AbleInspectorWindow;
import com.ibm.able.editor.AbleJarInfo;
import com.ibm.able.editor.AbleJarLoader;
import com.ibm.able.editor.AbleUserDefinedFunctionDialog;
import com.ibm.able.editor.AbleViewObject;
import com.ibm.able.editor.BeanTreeCellRenderer;
import com.ibm.able.rules.AbleRuleSetEditorLauncher;
import com.ibm.archiveaccessor.jarfileaccessor.JarFileAccessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.PlainDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AbleEditorFrame
extends JFrame
implements Runnable,
PropertyChangeListener {
    static String helpFilesPath = "editor/doc-files/";
    private boolean myModifiedFlag = false;
    private boolean jarsLoaded = false;
    JPanel TopPanel = new JPanel();
    JSplitPane jSplitPane1 = new JSplitPane();
    JScrollPane LeftScrollPane = new JScrollPane();
    JScrollPane RightScrollPane = new JScrollPane();
    DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("AbleAgent");
    DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    JTree beanTree = new JTree(this.treeModel);
    JPanel BottomPanel = new JPanel();
    JToolBar MainToolBar = new JToolBar();
    JTabbedPane ToolBarPaletteTabbedPane = new JTabbedPane();
    JLabel StatusTextField = new JLabel();
    JLabel ContentsTextField = new JLabel();
    Hashtable ToolBarPaletteHash = null;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu FileMenu = new JMenu();
    JMenu EditMenu = new JMenu();
    JMenu ViewMenu = new JMenu();
    JMenu WindowsMenu = new JMenu();
    JMenu ToolsMenu = new JMenu();
    JMenu HelpMenu = new JMenu();
    JMenuItem SaveAsMenuItem = new JMenuItem();
    JMenuItem SaveMenuItem = new JMenuItem();
    JMenuItem OpenMenuItem = new JMenuItem();
    JMenu NewMenu = new JMenu();
    JMenuItem ExportMenuItem = new JMenuItem();
    JMenuItem ImportMenuItem = new JMenuItem();
    JMenuItem ImportRemoteMenuItem = new JMenuItem();
    JMenuItem PrinterSetupMenuItem = new JMenuItem();
    JMenuItem PreferencesMenuItem = new JMenuItem();
    JMenuItem PrintMenuItem = new JMenuItem();
    JMenuItem ExitMenuItem = new JMenuItem();
    JMenuItem PasteMenuItem = new JMenuItem();
    JMenuItem CopyMenuItem = new JMenuItem();
    JMenuItem CutMenuItem = new JMenuItem();
    JMenuItem DeleteMenuItem = new JMenuItem();
    JCheckBoxMenuItem EventViewMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem BufferViewMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem PropertyViewMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem AllViewMenuItem = new JCheckBoxMenuItem();
    JMenuItem AddToJarMenuItem = new JMenuItem();
    JMenuItem RuleSetEditorMenuItem = new JMenuItem();
    JMenuItem TextEditorMenuItem = new JMenuItem();
    JMenuItem RemoveFromJarMenuItem = new JMenuItem();
    JMenuItem AddToPaletteMenuItem = new JMenuItem();
    JPopupMenu jPopupMenu1 = new JPopupMenu();
    Class thisClass = this.getClass();
    ImageIcon stepIcon = new ImageIcon(this.thisClass.getResource("resources/step32.gif"));
    ImageIcon cycleIcon = new ImageIcon(this.thisClass.getResource("resources/cycle32.gif"));
    ImageIcon runIcon = new ImageIcon(this.thisClass.getResource("resources/run32.gif"));
    ImageIcon haltIcon = new ImageIcon(this.thisClass.getResource("resources/halt32.gif"));
    ImageIcon agentIcon = new ImageIcon(this.thisClass.getResource("resources/module32.gif"));
    ImageIcon frameIcon = new ImageIcon(this.thisClass.getResource("resources/nnu16.gif"));
    ImageIcon unknownIcon = new ImageIcon(this.thisClass.getResource("resources/unknown32.gif"));
    JButton HaltButton = new JButton(this.haltIcon);
    JButton RunButton = new JButton(this.runIcon);
    JButton CycleButton = new JButton(this.cycleIcon);
    JButton StepButton = new JButton(this.stepIcon);
    JMenuItem HelpTopicsMenuItem = new JMenuItem();
    JMenuItem AgentEditorHelpMenuItem = new JMenuItem();
    JMenuItem RulesetEditorHelpMenuItem = new JMenuItem();
    JMenuItem UserReferenceMenuItem = new JMenuItem();
    JMenuItem RulesReferenceMenuItem = new JMenuItem();
    JMenuItem TutorialHelpMenuItem = new JMenuItem();
    JMenuItem ExamplesHelpMenuItem = new JMenuItem();
    JMenuItem APIReferenceMenuItem = new JMenuItem();
    JMenuItem ExtendingAbleHelpMenuItem = new JMenuItem();
    JMenuItem ReadmeHelpMenuItem = new JMenuItem();
    JMenuItem AboutMenuItem = new JMenuItem();
    AbleEditorCanvas mainCanvas = new AbleEditorCanvas();
    JDialog exceptionDialog = null;
    static int num = 1;
    AbleAgent agent = null;
    AbleViewObject agentView = null;
    AbleAgent currentAgent = null;
    String currentAgentName = null;
    AbleViewObject currentAgentView = null;
    AbleEnvironment environment = null;
    AbleEditorPreferences editorPreferences = null;
    public static final DataFlavor dataFlavor = new DataFlavor(class$com$ibm$able$AbleBean == null ? (class$com$ibm$able$AbleBean = AbleEditorFrame.class$("com.ibm.able.AbleBean")) : class$com$ibm$able$AbleBean, "AbleBean");
    boolean halt = false;
    long numStepsPerCycle = 4L;
    transient Thread runnit = null;
    transient Hashtable windowList = new Hashtable();
    String workingDir = Able.Preferences.getWorkingDirectory();
    String workingFileName = null;
    public static final int HALT = 0;
    public static final int STEP = 1;
    public static final int CYCLE = 2;
    public static final int RUN = 3;
    public static final String[] processLabels = new String[]{"halted", "stepping", "cycling", "running"};
    int processMode = 0;
    private static final String untitledAgent = "untitled.ser";
    private String textEditorName = AbleEditor.Preferences.getTextEditor();
    private DateFormat timeFormatter = DateFormat.getTimeInstance(2);
    protected static Clipboard clipboard = new Clipboard("Able clipboard");
    private static String tmpDir = "tmp";
    private Helper helper = new Helper();
    private Vector beanLabels = new Vector();
    private Vector beanNames = new Vector();
    private Vector beanIcons = new Vector();
    private Vector beanJars = new Vector();
    static /* synthetic */ Class class$com$ibm$able$AbleBean;
    static /* synthetic */ Class class$com$ibm$able$AbleAgent;
    static /* synthetic */ Class class$com$ibm$able$AbleObject;

    public AbleEditorFrame() {
        String string;
        this.enableEvents(64L);
        try {
            JarFilter jarFilter;
            File file;
            String[] stringArray;
            String string2;
            this.jbInit();
            this.agent = new AbleDefaultAgent("Untitled");
            this.workingFileName = this.agent.getFileName();
            this.agent.addPropertyChangeListener((PropertyChangeListener)this);
            this.environment = new AbleEnvironment();
            this.agentView = new AbleViewObject(this.agent, this);
            this.currentAgent = this.agent;
            this.currentAgentView = this.agentView;
            this.currentAgentName = this.currentAgent.getName();
            this.mainCanvas.setAgentViewObject(this.agentView);
            this.mainCanvas.setFrame(this);
            this.rootNode.setUserObject(this.agentView);
            this.mainCanvas.setTreeView(this.beanTree);
            this.beanTree.setCellRenderer(new BeanTreeCellRenderer());
            this.beanTree.setSelectionPath(new TreePath(this.rootNode.getPath()));
            this.setToolBarPalette();
            string = Able.ProductDirectory + "lib" + File.separator + "able.jar";
            System.out.print("Loading ABLE core from jar ");
            this.loadJars(string);
            string = Able.ProductDirectory + "lib" + File.separator + "ablerules.jar";
            System.out.print("Loading ABLE rules from jar ");
            this.loadJars(string);
            string = Able.ProductDirectory + "lib" + File.separator + "ablebeans.jar";
            System.out.print("Loading ABLE beans from jar ");
            this.loadJars(string);
            string = Able.ProductDirectory + "lib" + File.separator + "ablex.jar";
            System.out.print("Loading ABLE extensions from jar ");
            this.loadJars(string);
            string = Able.ProductDirectory + "lib" + File.separator + "ableplatform.jar";
            System.out.print("Loading ABLE platform agents from jar ");
            this.loadJars(string);
            string = Able.ProductDirectory + "lib" + File.separator + "ablegui.jar";
            System.out.print(Able.LS + "Loading ABLE gui beans from jar ");
            this.loadJars(string);
            string = Able.ProductDirectory + "lib" + File.separator + "ableexamples.jar";
            System.out.print(Able.LS + "Loading ABLE example beans from jar ");
            this.loadJars(string);
            string = AbleEditor.Preferences.getAbleJarFiles();
            if (string.length() > 0) {
                System.out.println(Able.LS + "Loading custom beans from jars listed in able.preferences.AbleJarFiles: ");
                this.loadJars(string);
            }
            if (AbleEditor.Preferences.getPlugInJarOn() && (string2 = AbleEditor.Preferences.getPlugInJarDirectory()).length() > 0 && (stringArray = (file = new File(string2)).list(jarFilter = new JarFilter())) != null && stringArray.length > 0) {
                System.out.println(Able.LS + "Loading custom beans from jars in able.preferences.PlugInJarDirectory '" + string2 + "':");
                this.loadJars(stringArray, string2);
            }
            this.setTitle();
            this.setStatus(" ");
            this.setFrameIcon();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showMessageDialog(null, exception.getLocalizedMessage(), "Editor Error: AbleEditorFrame()", 0);
        }
        this.jarsLoaded = true;
        this.setBackground(AbleEditor.Preferences.getEditorPanelBackground());
        this.setForeground(AbleEditor.Preferences.getEditorPanelForeground());
        this.setSize(AbleEditor.Preferences.getEditorPanelSize());
        this.setLocation(AbleEditor.Preferences.getEditorPanelLocation());
        this.setFont(AbleEditor.Preferences.getEditorPanelFont());
        this.setTextEditor(AbleEditor.Preferences.getTextEditor());
        string = Able.Preferences.getWorkingDirectory();
        if (string.length() > 0 && !string.equals(System.getProperty("user.home"))) {
            this.setWorkingDirectory(string);
        } else {
            this.setWorkingDirectory(Able.ProductDirectory + "examples");
        }
        this.getGlassPane().addMouseListener(new MouseAdapter(){});
    }

    private void setToolBarPalette() {
        this.ToolBarPaletteHash = new Hashtable();
        String string = AbleEditor.Preferences.getEditorBeanPaletteLabels();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            this.addToolBarPalette((String)stringTokenizer.nextElement());
        }
    }

    private void addToolBarPalette(String string) {
        if (!this.ToolBarPaletteHash.containsKey(string)) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            this.ToolBarPaletteTabbedPane.addTab(string, jPanel);
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            jToolBar.setLayout(flowLayout);
            jPanel.add((Component)jToolBar, "Center");
            this.ToolBarPaletteHash.put(string, jToolBar);
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(new Dimension(511, 343));
        this.TopPanel.setPreferredSize(new Dimension(10, 90));
        this.TopPanel.setLayout(new BorderLayout());
        this.LeftScrollPane.setPreferredSize(new Dimension(200, 100));
        this.LeftScrollPane.setBackground(AbleEditor.Preferences.getEditorPanelBackground());
        this.LeftScrollPane.setForeground(AbleEditor.Preferences.getEditorPanelForeground());
        this.RightScrollPane.setPreferredSize(new Dimension(200, 400));
        this.RightScrollPane.setBackground(AbleEditor.Preferences.getEditorPanelBackground());
        this.RightScrollPane.setForeground(AbleEditor.Preferences.getEditorPanelForeground());
        this.BottomPanel.setPreferredSize(new Dimension(10, 20));
        this.BottomPanel.setMinimumSize(new Dimension(10, 20));
        this.MainToolBar.setFloatable(false);
        this.MainToolBar.setPreferredSize(new Dimension(160, 20));
        this.MainToolBar.setLayout(new FlowLayout());
        this.ToolBarPaletteTabbedPane.setPreferredSize(new Dimension(340, 20));
        this.ToolBarPaletteTabbedPane.setMinimumSize(new Dimension(200, 20));
        this.StatusTextField.setText(" ");
        this.HaltButton.setMaximumSize(new Dimension(32, 32));
        this.HaltButton.setPreferredSize(new Dimension(32, 32));
        this.HaltButton.setMinimumSize(new Dimension(32, 32));
        this.HaltButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.HaltButton_actionPerformed(actionEvent);
            }
        });
        this.RunButton.setMaximumSize(new Dimension(32, 32));
        this.RunButton.setPreferredSize(new Dimension(32, 32));
        this.RunButton.setMinimumSize(new Dimension(32, 32));
        this.RunButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.RunButton_actionPerformed(actionEvent);
            }
        });
        this.CycleButton.setMaximumSize(new Dimension(32, 32));
        this.CycleButton.setPreferredSize(new Dimension(32, 32));
        this.CycleButton.setMinimumSize(new Dimension(32, 32));
        this.CycleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.CycleButton_actionPerformed(actionEvent);
            }
        });
        this.StepButton.setMaximumSize(new Dimension(32, 32));
        this.StepButton.setPreferredSize(new Dimension(32, 32));
        this.StepButton.setMinimumSize(new Dimension(32, 32));
        this.HelpTopicsMenuItem.setText("Help topics...");
        this.HelpTopicsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.HelpMenuItem_actionPerformed(actionEvent, "editor/doc-files/HelpTopics.html");
            }
        });
        this.AgentEditorHelpMenuItem.setText("Agent Editor Reference...");
        this.AgentEditorHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.HelpMenuItem_actionPerformed(actionEvent, "editor/doc-files/AgentEditor.html");
            }
        });
        this.RulesetEditorHelpMenuItem.setText("Ruleset Editor Reference...");
        this.RulesetEditorHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.HelpMenuItem_actionPerformed(actionEvent, "rules/doc-files/edIndex.html");
            }
        });
        this.UserReferenceMenuItem.setText("Beans and Agents...");
        this.UserReferenceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.HelpMenuItem_actionPerformed(actionEvent, "doc-files/index.html");
            }
        });
        this.RulesReferenceMenuItem.setText("Rules...");
        this.RulesReferenceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.HelpMenuItem_actionPerformed(actionEvent, "rules/doc-files/ABLERuleLanguage.pdf");
            }
        });
        this.TutorialHelpMenuItem.setText("Tutorial...");
        this.TutorialHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.HelpMenuItem_actionPerformed(actionEvent, "editor/doc-files/Tutorial.html");
            }
        });
        this.ExamplesHelpMenuItem.setText("Examples...");
        this.ExamplesHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.HelpMenuItem_actionPerformed(actionEvent, "examples/doc-files/Examples.html");
            }
        });
        this.APIReferenceMenuItem.setText("JavaDoc Reference...");
        this.APIReferenceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object var2_2 = null;
                try {
                    AbleEditorFrame.displayHelpURL(this, new URL(Able.HomeUrl, "reference/index.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), " Error: displayHelp() ", 0);
                    return;
                }
            }
        });
        this.ExtendingAbleHelpMenuItem.setText("Extending Able...");
        this.ExtendingAbleHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.HelpMenuItem_actionPerformed(actionEvent, "doc-files/extIndex.html");
            }
        });
        this.ReadmeHelpMenuItem.setText("Readme...");
        this.ReadmeHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object var2_2 = null;
                try {
                    AbleEditorFrame.displayHelpURL(this, new URL(Able.HomeUrl, "index.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), " Error: displayHelp() ", 0);
                    return;
                }
            }
        });
        this.AboutMenuItem.setText("About...");
        this.AboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.AboutMenuItem_actionPerformed(actionEvent);
            }
        });
        this.StepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.StepButton_actionPerformed(actionEvent);
            }
        });
        this.FileMenu.setText("File");
        this.EditMenu.setText("Edit");
        this.ViewMenu.setText("View");
        this.WindowsMenu.setText("Windows");
        this.ToolsMenu.setText("Tools");
        this.HelpMenu.setText("Help");
        this.SaveAsMenuItem.setText("Save agent as...");
        this.SaveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.SaveAsMenuItem_actionPerformed(actionEvent);
            }
        });
        this.SaveMenuItem.setText("Save agent");
        this.SaveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.SaveMenuItem_actionPerformed(actionEvent);
            }
        });
        this.OpenMenuItem.setText("Open agent...");
        this.OpenMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.OpenMenuItem_actionPerformed(actionEvent);
            }
        });
        this.NewMenu.setText("New agent");
        JMenuItem jMenuItem = new JMenuItem("Default (com.ibm.able.AbleDefaultAgent)");
        jMenuItem.setActionCommand("AbleDefaultAgent");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.NewMenu_actionPerformed(actionEvent);
            }
        });
        this.NewMenu.add(jMenuItem);
        this.ExportMenuItem.setText("Export bean...");
        this.ExportMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.ExportMenuItem_actionPerformed(actionEvent);
            }
        });
        this.ImportMenuItem.setText("Import bean...");
        this.ImportMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.ImportMenuItem_actionPerformed(actionEvent);
            }
        });
        this.ImportRemoteMenuItem.setText("Import remote agent...");
        this.ImportRemoteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.ImportRemoteMenuItem_actionPerformed(actionEvent);
            }
        });
        this.PrinterSetupMenuItem.setText("Printer setup...");
        this.PrinterSetupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.PrinterSetupMenuItem_actionPerformed(actionEvent);
            }
        });
        this.PrinterSetupMenuItem.setEnabled(false);
        this.PreferencesMenuItem.setText("Preferences...");
        this.PreferencesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.PreferencesMenuItem_actionPerformed(actionEvent);
            }
        });
        this.PrintMenuItem.setText("Print...");
        this.PrintMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.PrintMenuItem_actionPerformed(actionEvent);
            }
        });
        this.PrintMenuItem.setEnabled(false);
        this.ExitMenuItem.setText("Exit");
        this.ExitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.ExitMenuItem_actionPerformed(actionEvent);
            }
        });
        this.PasteMenuItem.setText("Paste");
        this.PasteMenuItem.setActionCommand("paste");
        this.PasteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.PasteMenuItem_actionPerformed(actionEvent);
            }
        });
        this.PasteMenuItem.setEnabled(false);
        this.CopyMenuItem.setText("Copy");
        this.CopyMenuItem.setActionCommand("copy");
        this.CopyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.CopyMenuItem_actionPerformed(actionEvent);
            }
        });
        this.CutMenuItem.setText("Cut");
        this.CutMenuItem.setActionCommand("cut");
        this.CutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.CutMenuItem_actionPerformed(actionEvent);
            }
        });
        this.DeleteMenuItem.setText("Delete");
        this.DeleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.DeleteMenuItem_actionPerformed(actionEvent);
            }
        });
        this.DeleteMenuItem.setActionCommand("delete");
        int n = AbleEditor.Preferences.getConnectionsView();
        this.BufferViewMenuItem.setText("Data flow");
        this.BufferViewMenuItem.setIcon(new ImageIcon(this.thisClass.getResource("resources/cncbuf16.gif")));
        this.BufferViewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.BufferViewMenuItem_actionPerformed(actionEvent);
            }
        });
        if (n == 0) {
            this.BufferViewMenuItem.setSelected(true);
        }
        this.EventViewMenuItem.setText("Event listeners");
        this.EventViewMenuItem.setIcon(new ImageIcon(this.thisClass.getResource("resources/cncevt16.gif")));
        this.EventViewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.EventViewMenuItem_actionPerformed(actionEvent);
            }
        });
        if (n == 2) {
            this.EventViewMenuItem.setSelected(true);
        }
        this.PropertyViewMenuItem.setText("Property connections");
        this.PropertyViewMenuItem.setIcon(new ImageIcon(this.thisClass.getResource("resources/cncprp16.gif")));
        this.PropertyViewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.PropertyViewMenuItem_actionPerformed(actionEvent);
            }
        });
        if (n == 1) {
            this.PropertyViewMenuItem.setSelected(true);
        }
        this.AllViewMenuItem.setText("All connections");
        this.AllViewMenuItem.setIcon(new ImageIcon(this.thisClass.getResource("resources/cncall16.gif")));
        this.AllViewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.AllViewMenuItem_actionPerformed(actionEvent);
            }
        });
        if (n == 3) {
            this.AllViewMenuItem.setSelected(true);
        }
        this.AddToJarMenuItem.setText("Add agent to Jar...");
        this.AddToJarMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.AddToJarMenuItem_actionPerformed(actionEvent);
            }
        });
        this.RuleSetEditorMenuItem.setText("RuleSet Editor...");
        this.RuleSetEditorMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.RuleSetEditorMenuItem_actionPerformed(actionEvent);
            }
        });
        this.TextEditorMenuItem.setText("Text Editor...");
        this.TextEditorMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.TextEditorMenuItem_actionPerformed(actionEvent);
            }
        });
        this.RemoveFromJarMenuItem.setText("Remove agent from Jar...");
        this.RemoveFromJarMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.RemoveFromJarMenuItem_actionPerformed(actionEvent);
            }
        });
        this.AddToPaletteMenuItem.setText("Add beans to palette...");
        this.AddToPaletteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.AddToPaletteMenuItem_actionPerformed(actionEvent);
            }
        });
        this.mainCanvas.setPreferredSize(new Dimension(480, 200));
        this.mainCanvas.setBackground(AbleEditor.Preferences.getEditorPanelBackground());
        this.mainCanvas.setMinimumSize(new Dimension(200, 100));
        this.mainCanvas.setLayout(null);
        this.getContentPane().add((Component)this.TopPanel, "North");
        this.TopPanel.add((Component)this.MainToolBar, "West");
        this.MainToolBar.add((Component)this.StepButton, null);
        this.MainToolBar.add((Component)this.CycleButton, null);
        this.MainToolBar.add((Component)this.RunButton, null);
        this.MainToolBar.add((Component)this.HaltButton, null);
        this.TopPanel.add((Component)this.ToolBarPaletteTabbedPane, "Center");
        this.ToolBarPaletteTabbedPane.setTabPlacement(3);
        this.TopPanel.add((Component)this.ContentsTextField, "South");
        this.BottomPanel.setLayout(new FlowLayout(0));
        this.BottomPanel.add(this.StatusTextField);
        this.beanTree.getSelectionModel().setSelectionMode(1);
        this.beanTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)AbleEditorFrame.this.beanTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode2 == null && treeSelectionEvent.getNewLeadSelectionPath() == null) {
                    AbleEditorFrame.this.beanTree.setSelectionPath(treeSelectionEvent.getOldLeadSelectionPath());
                    return;
                }
                AbleViewObject ableViewObject = (AbleViewObject)defaultMutableTreeNode2.getUserObject();
                if (ableViewObject.getBean() instanceof AbleAgent) {
                    if (ableViewObject != AbleEditorFrame.this.currentAgentView) {
                        AbleEditorFrame.this.currentAgentView = ableViewObject;
                        AbleEditorFrame.this.switchEditContext(defaultMutableTreeNode2);
                    }
                } else if (defaultMutableTreeNode2.getParent() != null && (ableViewObject = (AbleViewObject)(defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()).getUserObject()) != AbleEditorFrame.this.currentAgentView) {
                    AbleEditorFrame.this.currentAgentView = ableViewObject;
                    AbleEditorFrame.this.switchEditContext(defaultMutableTreeNode);
                }
                AbleEditorFrame.this.mainCanvas.setSelectedViewObject((AbleViewObject)defaultMutableTreeNode2.getUserObject(), false);
            }
        });
        this.beanTree.addMouseListener(this.mainCanvas);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.LeftScrollPane.getViewport().add((Component)this.beanTree, null);
        this.RightScrollPane.getViewport().add((Component)this.mainCanvas, null);
        this.jSplitPane1.setLeftComponent(this.LeftScrollPane);
        this.jSplitPane1.setRightComponent(this.RightScrollPane);
        this.jSplitPane1.setDividerLocation(AbleEditor.Preferences.getEditorPanelDividerLocation());
        this.getContentPane().add((Component)this.BottomPanel, "South");
        this.jMenuBar1.add(this.FileMenu);
        this.jMenuBar1.add(this.EditMenu);
        this.jMenuBar1.add(this.ViewMenu);
        this.jMenuBar1.add(this.ToolsMenu);
        this.jMenuBar1.add(this.WindowsMenu);
        this.jMenuBar1.add(this.HelpMenu);
        this.FileMenu.add(this.NewMenu);
        this.FileMenu.add(this.OpenMenuItem);
        this.FileMenu.add(this.SaveMenuItem);
        this.FileMenu.add(this.SaveAsMenuItem);
        this.FileMenu.addSeparator();
        this.FileMenu.add(this.ImportMenuItem);
        this.FileMenu.add(this.ImportRemoteMenuItem);
        this.FileMenu.add(this.ExportMenuItem);
        this.FileMenu.addSeparator();
        this.FileMenu.add(this.PreferencesMenuItem);
        this.FileMenu.addSeparator();
        this.FileMenu.add(this.PrinterSetupMenuItem);
        this.FileMenu.add(this.PrintMenuItem);
        this.FileMenu.addSeparator();
        this.FileMenu.add(this.ExitMenuItem);
        this.EditMenu.add(this.CutMenuItem);
        this.EditMenu.add(this.CopyMenuItem);
        this.EditMenu.add(this.PasteMenuItem);
        this.EditMenu.add(this.DeleteMenuItem);
        this.ViewMenu.add(this.BufferViewMenuItem);
        this.ViewMenu.add(this.EventViewMenuItem);
        this.ViewMenu.add(this.PropertyViewMenuItem);
        this.ViewMenu.add(this.AllViewMenuItem);
        this.ToolsMenu.add(this.RuleSetEditorMenuItem);
        this.ToolsMenu.add(this.TextEditorMenuItem);
        this.ToolsMenu.addSeparator();
        this.ToolsMenu.add(this.AddToJarMenuItem);
        this.ToolsMenu.add(this.RemoveFromJarMenuItem);
        this.ToolsMenu.addSeparator();
        this.ToolsMenu.add(this.AddToPaletteMenuItem);
        this.HelpMenu.add(this.HelpTopicsMenuItem);
        this.HelpMenu.add(this.AgentEditorHelpMenuItem);
        this.HelpMenu.add(this.RulesetEditorHelpMenuItem);
        this.HelpMenu.addSeparator();
        this.HelpMenu.add(this.UserReferenceMenuItem);
        this.HelpMenu.add(this.RulesReferenceMenuItem);
        this.HelpMenu.add(this.TutorialHelpMenuItem);
        this.HelpMenu.add(this.ExamplesHelpMenuItem);
        this.HelpMenu.addSeparator();
        this.HelpMenu.add(this.APIReferenceMenuItem);
        this.HelpMenu.add(this.ExtendingAbleHelpMenuItem);
        this.HelpMenu.addSeparator();
        this.HelpMenu.add(this.ReadmeHelpMenuItem);
        this.HelpMenu.addSeparator();
        this.HelpMenu.add(this.AboutMenuItem);
        this.setJMenuBar(this.jMenuBar1);
    }

    protected void setTitle() {
        this.setTitle("Able Editor: " + this.agent.getFileName());
        this.setContentsTextField();
    }

    protected void setFrameIcon() {
        this.setIconImage(this.frameIcon.getImage());
    }

    protected void setProcessMode(int n) {
        this.processMode = n;
        if (this.processMode < processLabels.length) {
            this.setStatus(this.currentAgentName + " is " + processLabels[this.processMode] + " as of " + this.timeFormatter.format(new Date()) + ".");
        }
    }

    private void setProcessToolTips() {
        this.StepButton.setToolTipText("Step " + this.currentAgentName);
        this.CycleButton.setToolTipText("Cycle " + this.currentAgentName);
        this.RunButton.setToolTipText("Run " + this.currentAgentName);
        this.HaltButton.setToolTipText("Halt " + this.currentAgentName);
    }

    public void setTextEditor(String string) {
        this.textEditorName = string;
    }

    public String getTextEditor() {
        return this.textEditorName;
    }

    public AbleViewObject getCurrentAgentView() {
        return this.currentAgentView;
    }

    public void setCurrentAgent(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeNode(this.rootNode, object);
        if (defaultMutableTreeNode != null) {
            this.beanTree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    private int askAboutSaving() {
        int n = 1;
        if (this.agent != null && AbleEditor.Preferences.getEditorExitPrompt() && (this.agent.isChanged() || this.myModifiedFlag)) {
            n = JOptionPane.showConfirmDialog(this, "The agent has been changed but not saved.    \nDo you want to save the agent?", "Editor Warning: Save Changes?", 1);
            if (n == 0) {
                this.SaveMenuItem_actionPerformed(null);
            } else if (n == 1) {
                this.myModifiedFlag = false;
                this.agent.setChanged(false);
            }
        }
        return n;
    }

    public void copy(AbleBean ableBean) {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            object = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)object).writeObject(ableBean);
        }
        catch (IOException iOException) {
            this.showMessageDialog(this, iOException.toString(), "Editor Warning: copy(bean)", 0);
            return;
        }
        object = byteArrayOutputStream.toByteArray();
        ViewSelection viewSelection = new ViewSelection(object, dataFlavor);
        clipboard.setContents(viewSelection, viewSelection);
        this.PasteMenuItem.setEnabled(true);
    }

    public boolean canPaste() {
        AbleBean ableBean = this.getClipboardViewObject();
        return ableBean != null;
    }

    public void clearClipboard() {
        AbleBean ableBean = this.getClipboardViewObject();
        if (ableBean == null) {
            return;
        }
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            ((ViewSelection)transferable).lostOwnership(null, null);
            this.PasteMenuItem.setEnabled(false);
        }
    }

    public AbleBean getClipboardViewObject() {
        AbleBean ableBean = null;
        Transferable transferable = clipboard.getContents(this);
        if (transferable == null) {
            return ableBean;
        }
        try {
            byte[] byArray = (byte[])transferable.getTransferData(dataFlavor);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            ableBean = AbleObject.restoreFromStream((ObjectInputStream)objectInputStream);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException.toString(), "Editor Warning: getClipboardViewObject() paste", 2);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            this.getToolkit().beep();
            JOptionPane.showMessageDialog(this, unsupportedFlavorException.toString(), "Editor Warning: getClipboardViewObject() data flavor", 2);
        }
        catch (Exception exception) {
            this.getToolkit().beep();
            JOptionPane.showMessageDialog(this, exception.toString(), "Editor Warning: getClipboardViewObject() paste", 2);
        }
        return ableBean;
    }

    public void paste() {
        AbleBean ableBean = this.getClipboardViewObject();
        if (ableBean == null) {
            return;
        }
        try {
            this.currentAgent.addBean(ableBean);
        }
        catch (AbleException ableException) {
            JOptionPane.showMessageDialog(this, ableException.toString(), "Editor Warning: paste()", 2);
        }
    }

    private void addToNewAgentMenu(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.NewMenu_actionPerformed(actionEvent);
            }
        });
        this.NewMenu.add(jMenuItem);
    }

    void StatusTextField_actionPerformed(ActionEvent actionEvent) {
    }

    void StepButton_actionPerformed(ActionEvent actionEvent) {
        this.halt = false;
        this.setProcessMode(1);
        if (this.runnit == null) {
            this.runnit = new Thread(this);
            this.runnit.start();
        }
    }

    void CycleButton_actionPerformed(ActionEvent actionEvent) {
        this.halt = false;
        this.setProcessMode(2);
        try {
            AbleDataSource ableDataSource = this.currentAgent.getDataSource();
            this.numStepsPerCycle = ableDataSource == null ? 1L : ableDataSource.getStepsPerCycle();
        }
        catch (AbleException ableException) {
            System.out.println("Error retrieving cycle size; set to 1");
            this.numStepsPerCycle = 1L;
            ableException.printStackTrace();
            JOptionPane.showMessageDialog(this, ableException.getMessage(), "Editor Warning: CycleButton_actionPerformed()", 2);
        }
        if (this.runnit == null) {
            this.runnit = new Thread(this);
            this.runnit.start();
        }
    }

    void RunButton_actionPerformed(ActionEvent actionEvent) {
        this.halt = false;
        this.setProcessMode(3);
        if (this.runnit == null) {
            this.runnit = new Thread(this);
            this.runnit.start();
        }
    }

    void HaltButton_actionPerformed(ActionEvent actionEvent) {
        this.halt = true;
    }

    private void performCycle() throws AbleException {
        AbleDataSource ableDataSource = null;
        ableDataSource = this.currentAgent.getDataSource();
        this.numStepsPerCycle = ableDataSource == null ? 1L : ableDataSource.getStepsPerCycle();
        try {
            int n = 0;
            while ((long)n < this.numStepsPerCycle && !this.halt) {
                this.currentAgent.process();
                if (n % 10 == 0) {
                    Thread.sleep(100L);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new AbleException("Error: performCycle() " + exception.toString());
        }
        if (ableDataSource != null) {
            this.setStatus(this.currentAgentName + " epoch count = " + ableDataSource.getNumEpochs());
        }
    }

    public void run() {
        while (true) {
            switch (this.processMode) {
                case 1: {
                    try {
                        this.currentAgent.process();
                    }
                    catch (AbleException ableException) {
                        this.showMessageDialog(this, ableException.toString(), "Editor Error: StepButton_actionPerformed()", 0);
                    }
                    this.setProcessMode(0);
                    break;
                }
                case 2: {
                    try {
                        this.performCycle();
                    }
                    catch (AbleException ableException) {
                        this.showMessageDialog(this, ableException.toString(), "Editor Error: CycleButton_actionPerformed()", 0);
                    }
                    this.setProcessMode(0);
                    break;
                }
                case 3: {
                    while (!this.halt) {
                        try {
                            this.performCycle();
                            Thread.sleep(100L);
                        }
                        catch (AbleException ableException) {
                            this.showMessageDialog(this, ableException.toString(), "Editor Error: RunButton_actionPerformed()", 0);
                        }
                        catch (InterruptedException interruptedException) {
                            this.showMessageDialog(this, interruptedException.toString(), "Run interrupted", 0);
                        }
                    }
                    this.setProcessMode(0);
                    break;
                }
                case 0: {
                    try {
                        Thread.sleep(100L);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static void createConnection(AbleViewObject ableViewObject, AbleViewObject ableViewObject2) throws AbleException {
        new AbleBufferConnection((AbleBean)((AbleObject)ableViewObject.getBean()), (AbleBean)((AbleObject)ableViewObject2.getBean()));
    }

    void NewMenu_actionPerformed(ActionEvent actionEvent) {
        AbleViewObject ableViewObject;
        int n = this.askAboutSaving();
        if (n == 2) {
            return;
        }
        this.closeAllOpenWindows();
        this.removeAllFromCanvas();
        this.rootNode.removeAllChildren();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.agent = this.createAgentInstance(actionEvent);
        this.agentView = ableViewObject = new AbleViewObject(this.agent, this);
        this.environment = new AbleEnvironment();
        this.currentAgentView = this.agentView;
        this.currentAgent = this.agent;
        this.currentAgentName = this.currentAgent.getName();
        this.mainCanvas.setAgentViewObject(ableViewObject);
        this.rootNode.setUserObject(ableViewObject);
        this.createNodes(this.agent, this.rootNode);
        this.beanTree.setSelectionPath(new TreePath(this.rootNode.getPath()));
        this.agent.addPropertyChangeListener((PropertyChangeListener)this);
        this.myModifiedFlag = false;
        this.workingFileName = untitledAgent;
        this.treeModel.reload();
        this.beanTree.repaint();
        this.mainCanvas.repaint();
        this.setTitle();
        this.setStatus(" ");
        this.setProcessToolTips();
        this.cleanup();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private AbleAgent createAgentInstance(ActionEvent actionEvent) {
        Object object = null;
        String string = actionEvent.getActionCommand();
        int n = this.beanNames.indexOf(string);
        if (n == -1) {
            try {
                object = new AbleDefaultAgent("Untitled");
            }
            catch (AbleException ableException) {
                this.showMessageDialog(this, ableException.toString(), "Editor Error: createAgentInstance() ", 0);
            }
        } else {
            try {
                Class<?> clazz = Class.forName(string);
                object = clazz.newInstance();
            }
            catch (Exception exception) {
                this.showMessageDialog(this, exception.toString(), "Editor Error: createAgentInstance() ", 0);
            }
        }
        return (AbleAgent)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void OpenMenuItem_actionPerformed(ActionEvent actionEvent) {
        int n = this.askAboutSaving();
        if (n == 2) {
            return;
        }
        String[] stringArray = AblePanelHelper.getFileDialog((Window)this, "Open Agent", "Serialized Agent (*.ser)", "ser", this.workingDir, 0);
        String string = stringArray[2];
        String string2 = stringArray[0];
        if (string != null) {
            try {
                block13: {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    AbleAgent ableAgent = (AbleAgent)AbleObject.restoreFromSerializedFile((String)(string2 + File.separator + string + ".ser"));
                    this.workingDir = string2;
                    this.workingFileName = string + ".ser";
                    this.closeAllOpenWindows();
                    this.removeAllFromCanvas();
                    this.rootNode.removeAllChildren();
                    this.environment = new AbleEnvironment();
                    if (this.currentAgent != null) {
                        this.currentAgent.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    this.currentAgent = this.agent = ableAgent;
                    this.currentAgentName = this.currentAgent.getName();
                    this.agent.addPropertyChangeListener((PropertyChangeListener)this);
                    this.currentAgentView = this.agentView = new AbleViewObject(this.agent, this);
                    this.rootNode.setUserObject(this.agentView);
                    this.createNodes(this.agent, this.rootNode);
                    this.beanTree.setSelectionPath(new TreePath(this.rootNode.getPath()));
                    this.mainCanvas.setAgentViewObject(this.agentView);
                    this.mainCanvas.repaint();
                    this.treeModel.reload();
                    this.beanTree.repaint();
                    this.setStatus(" ");
                    try {
                        this.environment = AbleEnvironment.restoreFromFile(string2 + File.separator + stringArray[1] + ".env");
                        this.environment.restoreViewObjectLocations(this.rootNode);
                        this.reopenInspectors(this.environment.getInspectorContexts());
                    }
                    catch (Exception exception) {
                        if (this.agent.getTraceLogger().isLogging()) {
                            this.agent.getTraceLogger().exception(262144L, (Object)this, "OpenMenuItem_actionPerformed", (Throwable)exception);
                        }
                        String string3 = "Warning: inspectors and bean positions could not be read from '" + string + "';  caught " + exception.getClass().getName() + " exception.";
                        if (null != exception.getLocalizedMessage()) {
                            string3 = string3 + Able.LS + exception.getLocalizedMessage();
                        }
                        if ((Able.Preferences.getMessageLogConsoleSeverity() & 3L) == 0L) break block13;
                        JOptionPane.showMessageDialog(this, string3, "Editor Warning: OpenMenuItem_actionPerformed() ", 2);
                    }
                }
                this.requestFocus();
                this.myModifiedFlag = false;
                this.agent.setChanged(false);
                this.setTitle();
                this.setProcessToolTips();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                String string4 = "Error: unable to read '" + string + "';  caught " + throwable.getClass().getName() + " exception.";
                if (null != throwable.getLocalizedMessage()) {
                    string4 = string4 + Able.LS + throwable.getLocalizedMessage();
                }
                this.showMessageDialog(this, string4, "Editor Error: OpenMenuItem_actionPerformed() ", 0);
            }
            finally {
                this.cleanup();
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void SaveMenuItem_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.workingFileName.equals(untitledAgent)) {
                this.SaveAsMenuItem_actionPerformed(null);
            } else {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.agent.saveToFile();
                String string = this.agent.getFileName();
                this.environment.setViewObjectLocations(this.rootNode);
                this.environment.saveToFile(string + ".env");
                this.myModifiedFlag = false;
                this.setContentsTextField();
            }
        }
        catch (AbleException ableException) {
            this.showMessageDialog(this, ableException.toString(), "Editor Error: SaveMenuItem_actionPerformed() ", 0);
        }
        catch (IOException iOException) {
            this.showMessageDialog(this, iOException.toString(), "Editor Error: SaveMenuItem_actionPerformed() ", 0);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void SaveAsMenuItem_actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = AblePanelHelper.getFileDialog((Window)this, "Save Agent", "Serialized Agent (*.ser)", "ser", this.workingDir, 1);
        String string = stringArray[2];
        String string2 = stringArray[0];
        if (string != null) {
            this.workingDir = string2;
            this.workingFileName = string.endsWith(".ser") ? string : string + ".ser";
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.agent.saveToFile(this.workingDir + File.separator + this.workingFileName);
                this.environment.setViewObjectLocations(this.rootNode);
                this.environment.saveToFile(this.workingDir + File.separator + this.workingFileName + ".env");
                this.myModifiedFlag = false;
                this.setTitle();
                this.setProcessToolTips();
            }
            catch (AbleException ableException) {
                if (Able.TraceLog.isLogging()) {
                    Able.TraceLog.exception(262144L, (Object)"com.ibm.able.editor.AbleEditorFrame", "SaveAsMenuItem_actionPerformed", (Throwable)ableException);
                }
                this.showMessageDialog(this, ableException.toString(), "Editor Error: SaveAsMenuItem_actionPerformed() ", 0);
            }
            catch (IOException iOException) {
                this.showMessageDialog(this, iOException.toString(), "Editor Error: SaveAsMenuItem_actionPerformed() ", 0);
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ImportMenuItem_actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = new String[]{"ser"};
        String[] stringArray2 = AblePanelHelper.getFileDialog((Window)this, "Import Bean", "Beans (.ser)", stringArray, this.workingDir, 0);
        String string = stringArray2[1];
        String string2 = stringArray2[0];
        if (string != null) {
            try {
                this.workingDir = string2;
                AbleObject ableObject = new AbleObject();
                this.setCursor(Cursor.getPredefinedCursor(3));
                ableObject = ableObject.restoreFromFile(string2 + File.separator + string);
                this.currentAgent.addBean((AbleBean)ableObject);
                this.myModifiedFlag = true;
            }
            catch (Exception exception) {
                this.showMessageDialog(this, exception.toString(), "Editor Error: ImportMenuItem_actionPerformed() ", 0);
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.setContentsTextField();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ImportRemoteMenuItem_actionPerformed(ActionEvent actionEvent) {
        try {
            AbleImportRemoteAgentDialog ableImportRemoteAgentDialog = new AbleImportRemoteAgentDialog(this);
            ableImportRemoteAgentDialog.setVisible(true);
            if (!ableImportRemoteAgentDialog.userCancelled()) {
                this.myModifiedFlag = true;
            }
        }
        catch (Exception exception) {
            this.showMessageDialog(this, exception.toString(), "Editor Error: ImportRemoteMenuItem_actionPerformed() ", 0);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setContentsTextField();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ExportMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleBean ableBean = this.mainCanvas.getSelectedObject();
        if (ableBean != null) {
            String[] stringArray = new String[]{"ser"};
            String[] stringArray2 = AblePanelHelper.getFileDialog((Window)this, "Export Bean", "Beans (.ser)", stringArray, this.workingDir, 1);
            String string = stringArray2[1];
            String string2 = stringArray2[0];
            if (string != null) {
                if (!string.endsWith(".ser")) {
                    string = string + ".ser";
                }
                this.workingDir = string2;
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    ableBean.saveToFile(string2 + File.separator + string);
                }
                catch (AbleException ableException) {
                    this.showMessageDialog(this, ableException.toString(), "Editor Error: ExportMenuItem_actionPerformed() ", 0);
                }
                catch (IOException iOException) {
                    this.showMessageDialog(this, iOException.toString(), "Editor Error: ExportMenuItem_actionPerformed() ", 0);
                }
                finally {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "No bean selected.", "Editor Error: ExportMenuItem_actionPerformed() ", 0);
        }
    }

    void PreferencesMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (this.editorPreferences == null) {
            this.editorPreferences = new AbleEditorPreferences(this, "Able Editor Preferences");
            this.editorPreferences.setLocationRelativeTo(this);
        }
        String string = AbleEditor.Preferences.getAbleLookAndFeelClassName();
        this.editorPreferences.setVisible(true);
        if (!AbleEditor.Preferences.getAbleLookAndFeelClassName().equals(string)) {
            SwingUtilities.updateComponentTreeUI(this.getContentPane());
        }
    }

    void PrinterSetupMenuItem_actionPerformed(ActionEvent actionEvent) {
    }

    void PrintMenuItem_actionPerformed(ActionEvent actionEvent) {
    }

    void ExitMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    public void dispose() {
        this.saveFramePreferences();
        if (this.mainCanvas != null) {
            int n = this.askAboutSaving();
            try {
                if (n == 2) {
                    return;
                }
                if (n == 0) {
                    this.agent.saveToFile();
                }
            }
            catch (AbleException ableException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setVisible(false);
            this.removeAllFromCanvas();
            this.beanTree.removeMouseListener(this.mainCanvas);
            this.beanTree = null;
            this.mainCanvas.removeListeners();
            this.mainCanvas = null;
            Able.stopMessageAndTraceLogging();
        }
        if (this.exceptionDialog != null) {
            this.exceptionDialog.dispose();
        }
        super.dispose();
    }

    void BufferViewMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.BufferViewMenuItem.setSelected(true);
        this.EventViewMenuItem.setSelected(false);
        this.PropertyViewMenuItem.setSelected(false);
        this.AllViewMenuItem.setSelected(false);
        this.mainCanvas.setViewType(0);
    }

    void EventViewMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.BufferViewMenuItem.setSelected(false);
        this.EventViewMenuItem.setSelected(true);
        this.PropertyViewMenuItem.setSelected(false);
        this.AllViewMenuItem.setSelected(false);
        this.mainCanvas.setViewType(2);
    }

    void PropertyViewMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.BufferViewMenuItem.setSelected(false);
        this.EventViewMenuItem.setSelected(false);
        this.PropertyViewMenuItem.setSelected(true);
        this.AllViewMenuItem.setSelected(false);
        this.mainCanvas.setViewType(1);
    }

    void AllViewMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.BufferViewMenuItem.setSelected(false);
        this.EventViewMenuItem.setSelected(false);
        this.PropertyViewMenuItem.setSelected(false);
        this.AllViewMenuItem.setSelected(true);
        this.mainCanvas.setViewType(3);
    }

    private void cleanup() {
        long l = Runtime.getRuntime().totalMemory();
        System.out.println("Total memory = " + l);
        long l2 = Runtime.getRuntime().freeMemory();
        System.out.println("Free memory before gc = " + l2);
        System.gc();
        long l3 = Runtime.getRuntime().freeMemory();
        System.out.println("Free memory after gc  = " + l3);
        System.out.println("Memory freed by gc = " + (l3 - l2));
    }

    void CutMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleViewObject ableViewObject = this.mainCanvas.getSelectedViewObject();
        if (ableViewObject != null) {
            ableViewObject.actionPerformed(actionEvent);
        }
    }

    void CopyMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (this.mainCanvas.getSelectedViewObject() != null) {
            AbleBean ableBean = this.mainCanvas.getSelectedViewObject().getBean();
            this.copy(ableBean);
        }
    }

    void PasteMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.paste();
    }

    void DeleteMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (this.mainCanvas.getSelectedViewObject() != null) {
            this.mainCanvas.getSelectedViewObject().actionPerformed(actionEvent);
        }
    }

    void HelpMenuItem_actionPerformed(ActionEvent actionEvent, String string) {
        AbleEditorFrame.displayHelp(this, string);
    }

    void AboutMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleAboutDialog ableAboutDialog = new AbleAboutDialog(this, "About Able", true);
        ableAboutDialog.setLocationRelativeTo(this);
        ableAboutDialog.setVisible(true);
    }

    public static void displayHelp(Object object, String string) {
        AbleHelp.displayHelp(object, string);
    }

    public static void displayHelpURL(Object object, URL uRL) {
        if (uRL != null) {
            AbleHelp.displayHelpURL(object, uRL);
        }
    }

    void TranslateEditorMenuItem_actionPerformed(ActionEvent actionEvent) {
        try {
            new AbleTranslateEditor();
        }
        catch (AbleException ableException) {
            this.showMessageDialog(this, ableException.toString(), "Editor Error: TranslateEditorMenuItem_actionPerformed() ", 0);
        }
    }

    void RuleSetEditorMenuItem_actionPerformed(ActionEvent actionEvent) {
        try {
            new AbleRuleSetEditorLauncher();
        }
        catch (Exception exception) {
            this.showMessageDialog(this, exception.toString(), "Editor Error: RuleSetEditorMenuItem_actionPerformed() ", 0);
        }
    }

    void TextEditorMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (this.textEditorName.trim().equals("")) {
            JOptionPane.showMessageDialog(this, "No Text Editor is specified.\nPlease provide one in editor preferences.", "Text Editor not specified", 1);
            this.PreferencesMenuItem_actionPerformed(null);
        }
        try {
            Able.run((String)this.textEditorName);
        }
        catch (Exception exception) {
            this.showMessageDialog(this, exception.toString(), "Editor Error: TextEditorMenuItem_actionPerformed() ", 0);
        }
    }

    void AddToJarMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (this.askAboutSaving() == 2) {
            return;
        }
        String[] stringArray = AblePanelHelper.getFileDialog((Window)this, "Add " + this.workingDir + File.separator + this.workingFileName + " to Jar", "Bean Jar (*.jar)", "jar", this.workingDir, 0);
        String string = stringArray[1];
        String string2 = stringArray[0];
        if (string != null) {
            try {
                JarFileAccessor jarFileAccessor = new JarFileAccessor(string2 + File.separator + string);
                String string3 = jarFileAccessor.getDefaultDirectory();
                jarFileAccessor.setDefaultDirectory(this.workingDir);
                if (jarFileAccessor.exists(this.workingFileName)) {
                    jarFileAccessor.remove(this.workingFileName);
                }
                jarFileAccessor.add(this.workingFileName);
                jarFileAccessor.setDefaultDirectory(string3);
            }
            catch (Exception exception) {
                this.showMessageDialog(this, "Must save '" + this.workingFileName + "' before adding to jar.\n" + exception.getMessage(), "Editor Error: AddToJarMenuItem_actionPerformed() ", 0);
            }
        }
    }

    void RemoveFromJarMenuItem_actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = AblePanelHelper.getFileDialog((Window)this, "Remove " + this.workingFileName + " from Jar", "Bean Jar (*.jar)", "jar", this.workingDir, 0);
        String string = stringArray[1];
        String string2 = stringArray[0];
        if (string != null) {
            try {
                JarFileAccessor jarFileAccessor = new JarFileAccessor(string2 + File.separator + string);
                if (jarFileAccessor.exists(this.workingFileName)) {
                    jarFileAccessor.remove(this.workingFileName);
                }
            }
            catch (Exception exception) {
                this.showMessageDialog(this, "Unable to remove '" + this.workingFileName + "' from '" + string + "'.\n" + exception.getMessage(), "Editor Error: RemoveFromJarMenuItem_actionPerformed() ", 0);
            }
        }
    }

    void AddToPaletteMenuItem_actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = AblePanelHelper.getFileDialog((Window)this, "Add Beans to Palette", "Bean Jar (*.jar)", "jar", this.workingDir, 0);
        String string = stringArray[1];
        String string2 = stringArray[0];
        if (string != null) {
            this.workingDir = string2;
            this.loadJars(string2 + File.separator + string);
        }
        int n = this.ToolBarPaletteTabbedPane.getSelectedIndex();
        this.ToolBarPaletteTabbedPane.setSelectedIndex(0);
        this.ToolBarPaletteTabbedPane.setSelectedIndex(n);
    }

    void AddUserDefinedFunctionMenuItem_actionPerformed(ActionEvent actionEvent) {
        AbleUserDefinedFunctionDialog ableUserDefinedFunctionDialog = new AbleUserDefinedFunctionDialog(this, "Edit user-defined functions");
        try {
            ableUserDefinedFunctionDialog.setObject(this.agent);
            ableUserDefinedFunctionDialog.setVisible(true);
        }
        catch (Exception exception) {
            this.showMessageDialog(this, exception.toString(), "Editor Error: AddUserDefinedFunctionMenuItem_actionPerformed() ", 0);
        }
    }

    public String getWorkingDirectory() {
        return this.workingDir;
    }

    public void setWorkingDirectory(String string) {
        this.workingDir = string;
        this.mainCanvas.setWorkingDirectory(this.workingDir);
    }

    public void setStatus(String string) {
        this.StatusTextField.setText(string);
    }

    private void setContentsTextField() {
        this.myModifiedFlag = this.agent.isChanged() || this.myModifiedFlag;
        this.ContentsTextField.setText(this.agent.getName() + (this.myModifiedFlag ? " (modified)" : "           ") + "           Selected Agent: " + this.currentAgentName);
    }

    void WindowSelect_actionPerformed(ActionEvent actionEvent) {
        String string = ((JMenuItem)actionEvent.getSource()).getText();
        if (this.windowList.containsKey(string)) {
            Object v = this.windowList.get(string);
            if (v instanceof AbleInspectorWindow) {
                AbleInspectorWindow ableInspectorWindow = (AbleInspectorWindow)v;
                ableInspectorWindow.setVisible(true);
                ableInspectorWindow.deiconifyFrame();
                ableInspectorWindow.requestFocus();
                return;
            }
            if (v instanceof Window) {
                Window window = (Window)v;
                if (!window.isVisible()) {
                    window.setVisible(true);
                }
                window.requestFocus();
                return;
            }
        }
    }

    void addToWindowList(AbleInspectorWindow ableInspectorWindow, String string) {
        JMenuItem jMenuItem = this.addToWindowList((Object)ableInspectorWindow, string + " inspector");
        ableInspectorWindow.setFrameTitle(jMenuItem.getText());
        this.environment.addInspector(ableInspectorWindow.getInspector());
        try {
            AbleBean ableBean = ableInspectorWindow.getInspector().getBean();
            BeanInfo beanInfo = AbleJarInfo.getBeanInfo(ableBean.getClass());
            Image image = beanInfo.getIcon(1);
            ImageIcon imageIcon = new ImageIcon(image);
            jMenuItem.setIcon(imageIcon);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ableInspectorWindow.setVisible(true);
    }

    JMenuItem addToWindowList(Object object, String string) {
        String string2 = string;
        int n = 1;
        while (this.windowList.containsKey(string2)) {
            string2 = string + ":" + n++;
        }
        JMenuItem jMenuItem = new JMenuItem(string2);
        jMenuItem.setActionCommand("windowSelect");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleEditorFrame.this.WindowSelect_actionPerformed(actionEvent);
            }
        });
        this.WindowsMenu.add(jMenuItem);
        this.windowList.put(string2, object);
        return jMenuItem;
    }

    void removeFromWindowList(Object object) {
        Component[] componentArray = this.WindowsMenu.getMenuComponents();
        String string = null;
        for (int i = componentArray.length - 1; i >= 0; --i) {
            Object v;
            string = ((JMenuItem)componentArray[i]).getText();
            if (!this.windowList.containsKey(string) || (v = this.windowList.get(string)) != object) continue;
            this.windowList.remove(string);
            this.WindowsMenu.remove(i);
            if (!(object instanceof AbleInspectorWindow)) break;
            AbleInspectorWindow ableInspectorWindow = (AbleInspectorWindow)object;
            this.environment.removeInspector(ableInspectorWindow.getInspector());
            break;
        }
    }

    void closeAllOpenWindows() {
        Enumeration enumeration = this.windowList.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            this.removeFromWindowList(v);
            if (v instanceof AbleInspectorWindow) {
                ((AbleInspectorWindow)v).dispose();
                continue;
            }
            if (!(v instanceof Window)) continue;
            ((Window)v).dispose();
        }
        try {
            this.agent.quitAll();
        }
        catch (AbleException ableException) {
            this.showMessageDialog(this, ableException.toString(), "Editor Warning: closeAllOpenWindows() ", 0);
        }
    }

    void closeOpenInspectors(AbleBean ableBean) {
        Enumeration enumeration = this.windowList.elements();
        while (enumeration.hasMoreElements()) {
            AbleInspectorWindow ableInspectorWindow;
            Object v = enumeration.nextElement();
            AbleBean ableBean2 = null;
            if (!(v instanceof AbleInspectorWindow) || ableBean != (ableBean2 = (ableInspectorWindow = (AbleInspectorWindow)v).getInspector().getBean())) continue;
            this.removeFromWindowList(ableInspectorWindow);
            ableInspectorWindow.dispose();
        }
    }

    private void reopenInspectors(AbleInspectorContext[] ableInspectorContextArray) {
        AbleBean ableBean = null;
        int n = ableInspectorContextArray.length;
        for (int i = 0; i < n; ++i) {
            AbleInspectorContext ableInspectorContext = ableInspectorContextArray[i];
            String string = ableInspectorContext.beanId;
            ableBean = this.findBean(string);
            if (ableBean == null) {
                System.out.println("Error: cannot restore Inspector on " + string);
                continue;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeNode(this.rootNode, ableBean);
            AbleViewObject ableViewObject = (AbleViewObject)defaultMutableTreeNode.getUserObject();
            AbleInspectorWindow ableInspectorWindow = new AbleInspectorWindow((JFrame)this, ableViewObject);
            ableInspectorWindow.setInspectorContext(ableInspectorContext);
            this.addToWindowList(ableInspectorWindow, ableViewObject.getName());
            ableInspectorWindow.refresh();
        }
    }

    private AbleBean findBean(String string) {
        AbleAgent ableAgent = null;
        AbleAgent ableAgent2 = this.agent;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = (String)stringTokenizer.nextElement();
        if (string.equals(string2)) {
            ableAgent = this.agent;
        } else {
            String string3;
            while (stringTokenizer.hasMoreElements() && (ableAgent = ableAgent2.getBean(string3 = (String)stringTokenizer.nextElement())) != null && ableAgent instanceof AbleBeanContainer) {
                ableAgent2 = (AbleBeanContainer)ableAgent;
            }
        }
        return ableAgent;
    }

    void restoreInspectorWindow(AbleInspector ableInspector) {
        AbleInspectorWindow ableInspectorWindow = new AbleInspectorWindow((JFrame)this, ableInspector);
        String string = ableInspector.getObjectName();
        this.addToWindowList(ableInspectorWindow, string);
    }

    void createInspectorWindow(AbleViewObject ableViewObject, String string) {
        AbleInspectorWindow ableInspectorWindow = new AbleInspectorWindow((JFrame)this, ableViewObject);
        this.addToWindowList(ableInspectorWindow, string);
    }

    void addInspectorWindow(AbleInspectorWindow ableInspectorWindow, String string) {
        this.addToWindowList(ableInspectorWindow, string);
    }

    private String getTmpDir() {
        String string = new File(tmpDir).getAbsolutePath();
        File file = new File(string);
        try {
            file.mkdirs();
        }
        catch (Exception exception) {
            this.showMessageDialog(this, exception.toString(), "Editor Error: getTmpDir() ", 0);
        }
        if (!file.isDirectory()) {
            this.showMessageDialog(this, "Couldn't create temporary directory\n\"" + file + "\"", "Editor Error: getTmpDir() ", 0);
        }
        if (!file.canWrite()) {
            this.showMessageDialog(this, "No write access to temporary directory\n\"" + file + "\"", "Editor Error: getTmpDir() ", 0);
        }
        return tmpDir;
    }

    void loadJars(String string) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            System.out.println(string3);
            try {
                this.addBeansInJar(string3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.showMessageDialog(this, fileNotFoundException.getLocalizedMessage(), "Editor Error: loadJars(" + string + ") ", 0);
                fileNotFoundException.printStackTrace();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                string2 = "Unable to load beans in jar '" + string3 + "'; " + Able.LS + "caught '" + noClassDefFoundError + "'." + Able.LS + "Update classpath if beans in jar '" + string3 + "' are to be loaded, " + Able.LS + "remove it from the plugin directory or bean jar list, " + Able.LS + "or ignore this warning.";
                if (this.jarsLoaded) {
                    this.showMessageDialog(this, string2 + Able.LS + noClassDefFoundError.getLocalizedMessage(), "Editor Error: loadJars(" + string + ") ", 0);
                    noClassDefFoundError.printStackTrace();
                    continue;
                }
                if (!Able.TraceLog.isLogging()) continue;
                Able.TraceLog.text(262144L, (Object)"com.ibm.able.editor.AbleEditorFrame", "loadJars", string2 + Able.LS + noClassDefFoundError.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                string2 = "Unable to load beans in jar '" + string3 + "'; " + Able.LS + "caught '" + throwable + "'." + Able.LS + "Update classpath if beans in jar '" + string3 + "' are to be loaded, " + Able.LS + "remove it from the plugin directory or bean jar list, " + Able.LS + "or ignore this warning.";
                if (this.jarsLoaded) {
                    this.showMessageDialog(this, string2 + Able.LS + throwable.getLocalizedMessage(), "Editor Error: loadJars(" + string + ") ", 0);
                    throwable.printStackTrace();
                    continue;
                }
                if (!Able.TraceLog.isLogging()) continue;
                Able.TraceLog.text(262144L, (Object)"com.ibm.able.editor.AbleEditorFrame", "loadJars", string2 + Able.LS + throwable.getLocalizedMessage());
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void loadJars(String[] stringArray, String string) {
        if (stringArray.length > 0) {
            String string2 = string + File.separator + stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string2 = string2 + ";" + string + File.separator + stringArray[i];
            }
            this.loadJars(string2);
        }
    }

    synchronized void addBeansInJar(String string) throws IOException, NoClassDefFoundError {
        AbleJarLoader.loadJarDoOnBean(string, this.helper);
    }

    void addWithUniqueName(Vector vector, String string) {
        if (!vector.contains(string)) {
            System.out.println("adding " + string);
            vector.addElement(string);
            return;
        }
        int n = 2;
        while (vector.contains(string + "<" + n + ">")) {
            ++n;
        }
        System.out.println("adding " + string + "<" + n + ">");
        vector.addElement(string + "<" + n + ">");
    }

    private void createInstance_actionPerformed(ActionEvent actionEvent) {
        Object obj;
        String string = actionEvent.getActionCommand();
        try {
            Class<?> clazz = Class.forName(string);
            obj = clazz.newInstance();
        }
        catch (Exception exception) {
            this.showMessageDialog(this, exception.toString(), "Editor Error: createInstance_actionPerformed() ", 0);
            return;
        }
        try {
            this.currentAgent.addBean((AbleBean)obj);
            this.setContentsTextField();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showMessageDialog(this, exception.toString(), "Editor Error: createInstance_actionPerformed() ", 0);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("processingState")) {
            this.repaintNode(this.findTreeNode(this.rootNode, propertyChangeEvent.getSource()));
        } else if (string.equals("timerEventProcessingEnabled")) {
            this.repaintNode(this.findTreeNode(this.rootNode, propertyChangeEvent.getSource()));
        } else if (!string.equals("dataFlowEnabled")) {
            if (string.equals("name")) {
                this.myModifiedFlag = true;
                if (propertyChangeEvent.getSource() == this.currentAgent) {
                    this.currentAgentName = (String)propertyChangeEvent.getNewValue();
                }
                this.setTitle();
                this.setStatus("Bean name changed from '" + (String)propertyChangeEvent.getOldValue() + "' to '" + (String)propertyChangeEvent.getNewValue() + "' at " + this.timeFormatter.format(new Date()) + ".");
                this.setProcessToolTips();
                this.treeModel.reload();
                this.beanTree.repaint();
            } else if (string.endsWith("updateProperties")) {
                this.myModifiedFlag = true;
                this.setTitle();
                this.setProcessToolTips();
            } else if (string.equals("beans")) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                AbleViewObject ableViewObject = null;
                DefaultMutableTreeNode defaultMutableTreeNode2 = this.findTreeNode(this.rootNode, propertyChangeEvent.getSource());
                if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
                    if (defaultMutableTreeNode2 != null) {
                        ableViewObject = this.createNode((AbleBean)propertyChangeEvent.getNewValue(), defaultMutableTreeNode2);
                        if (defaultMutableTreeNode2.getUserObject() == this.currentAgentView) {
                            this.addToCanvas(ableViewObject);
                        }
                    }
                } else if (propertyChangeEvent.getOldValue() != null && propertyChangeEvent.getNewValue() == null && (defaultMutableTreeNode = this.findTreeNode(this.rootNode, propertyChangeEvent.getOldValue())) != null) {
                    AbleBean ableBean = (AbleBean)propertyChangeEvent.getOldValue();
                    defaultMutableTreeNode2.remove(defaultMutableTreeNode);
                    this.treeModel.reload();
                    this.beanTree.repaint();
                    this.closeOpenInspectors(ableBean);
                    if (defaultMutableTreeNode2.getUserObject() == this.currentAgentView) {
                        this.removeFromCanvas((AbleViewObject)defaultMutableTreeNode.getUserObject());
                    }
                }
                this.myModifiedFlag = true;
            }
        }
    }

    private DefaultMutableTreeNode findTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        AbleViewObject ableViewObject = (AbleViewObject)defaultMutableTreeNode.getUserObject();
        AbleBean ableBean = ableViewObject.getBean();
        if (ableBean == object) {
            return defaultMutableTreeNode;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements() && (ableBean = (ableViewObject = (AbleViewObject)(defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement()).getUserObject()).getBean()) != object && (defaultMutableTreeNode2 = this.findTreeNode(defaultMutableTreeNode2, object)) == null) {
        }
        return defaultMutableTreeNode2;
    }

    private void createNodes(AbleAgent ableAgent, DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            Vector vector = ableAgent.getBeans();
            for (int i = 0; i < vector.size(); ++i) {
                AbleBean ableBean = (AbleBean)vector.elementAt(i);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(ableBean.getName());
                AbleViewObject ableViewObject = new AbleViewObject(ableBean, this);
                defaultMutableTreeNode2.setUserObject(ableViewObject);
                if (ableAgent == this.agent) {
                    this.addToCanvas(ableViewObject);
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                if (ableBean instanceof AbleAgent) {
                    this.createNodes((AbleAgent)ableBean, defaultMutableTreeNode2);
                }
                if (!(ableBean instanceof AbleObject)) continue;
                ((AbleObject)ableBean).addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
        catch (Exception exception) {
            this.showMessageDialog(this, exception.toString(), "Editor Error: createNodes() ", 0);
        }
    }

    private AbleViewObject createNode(AbleBean ableBean, DefaultMutableTreeNode defaultMutableTreeNode) {
        AbleViewObject ableViewObject = null;
        try {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(ableBean.getName());
            ableViewObject = new AbleViewObject(ableBean, this);
            defaultMutableTreeNode2.setUserObject(ableViewObject);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.treeModel.reload();
            this.beanTree.repaint();
            if (ableBean instanceof AbleAgent) {
                this.createNodes((AbleAgent)ableBean, defaultMutableTreeNode2);
            }
            if (ableBean instanceof AbleObject) {
                ((AbleObject)ableBean).addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.beanTree.scrollPathToVisible(new TreePath(defaultMutableTreeNode2.getPath()));
        }
        catch (Exception exception) {
            this.showMessageDialog(this, exception.toString(), "Editor Error: createNode() ", 0);
        }
        return ableViewObject;
    }

    private DefaultMutableTreeNode getParentNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        TreePath treePath = this.beanTree.getSelectionPath();
        if (treePath == null) {
            defaultMutableTreeNode = this.rootNode;
        } else {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode.getParent() != null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            }
        }
        return defaultMutableTreeNode;
    }

    private void repaintNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreePath treePath;
        Rectangle rectangle;
        if (defaultMutableTreeNode != null && (rectangle = this.beanTree.getPathBounds(treePath = new TreePath(this.treeModel.getPathToRoot(defaultMutableTreeNode)))) != null) {
            this.beanTree.repaint(rectangle);
        }
    }

    private void addToCanvas(AbleViewObject ableViewObject) {
        ableViewObject.addMouseListener(this.mainCanvas);
        ableViewObject.addMouseMotionListener(this.mainCanvas);
        this.mainCanvas.add(ableViewObject);
    }

    private void removeFromCanvas(AbleViewObject ableViewObject) {
        ableViewObject.removeMouseListener(this.mainCanvas);
        ableViewObject.removeMouseMotionListener(this.mainCanvas);
        this.mainCanvas.remove(ableViewObject);
    }

    private void removeAllFromCanvas() {
        Component[] componentArray = this.mainCanvas.getComponents();
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            if (componentArray[i] instanceof AbleViewObject) {
                this.removeFromCanvas((AbleViewObject)componentArray[i]);
                continue;
            }
            this.mainCanvas.remove(componentArray[i]);
        }
    }

    private void switchEditContext(DefaultMutableTreeNode defaultMutableTreeNode) {
        Serializable serializable;
        this.removeAllFromCanvas();
        this.mainCanvas.setAgentViewObject(this.currentAgentView);
        this.currentAgent = (AbleAgent)this.currentAgentView.getBean();
        this.currentAgentName = this.currentAgent.getName();
        this.setProcessToolTips();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            serializable = (DefaultMutableTreeNode)enumeration.nextElement();
            AbleViewObject ableViewObject = (AbleViewObject)((DefaultMutableTreeNode)serializable).getUserObject();
            this.addToCanvas(ableViewObject);
        }
        serializable = this.beanTree.getSelectionPath();
        this.treeModel.reload();
        this.beanTree.expandRow(this.beanTree.getRowForPath((TreePath)serializable));
        this.beanTree.repaint();
        this.setContentsTextField();
    }

    protected void saveFramePreferences() {
        this.saveEditorFramePreferences();
        AbleEditor.Preferences.writePropertiesFile();
        Able.Preferences.writePropertiesFile();
    }

    protected void saveEditorFramePreferences() {
        AbleEditor.Preferences.setEditorPanelBackground(this.getBackground());
        AbleEditor.Preferences.setEditorPanelForeground(this.getForeground());
        AbleEditor.Preferences.setEditorPanelSize(this.getSize());
        AbleEditor.Preferences.setEditorPanelLocation(this.getLocation());
        AbleEditor.Preferences.setEditorPanelFont(this.getFont());
        AbleEditor.Preferences.setEditorPanelDividerLocation(this.jSplitPane1.getDividerLocation());
        AbleEditor.Preferences.setTextEditor(this.getTextEditor());
        Able.Preferences.setWorkingDirectory(this.getWorkingDirectory());
    }

    public void setCursor(Cursor cursor) {
        if (cursor.equals(Cursor.getPredefinedCursor(3))) {
            this.getGlassPane().setCursor(cursor);
            this.getGlassPane().setVisible(true);
        } else {
            this.getGlassPane().setVisible(false);
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public void importRemoteAgent(AbleBean ableBean) {
        try {
            this.currentAgent.addBean(ableBean);
            this.setContentsTextField();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showMessageDialog(this, exception.toString(), "Editor Error: createInstance_actionPerformed() ", 0);
        }
    }

    private void showMessageDialog(AbleEditorFrame ableEditorFrame, String string, String string2, int n) {
        if (this.exceptionDialog != null) {
            this.exceptionDialog.dispose();
        }
        this.exceptionDialog = new JDialog((Frame)null, string2, false);
        this.exceptionDialog.setSize(AbleEditor.Preferences.getEditorExceptionPanelSize());
        this.exceptionDialog.setLocation(AbleEditor.Preferences.getEditorExceptionPanelLocation());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBackground(this.exceptionDialog.getContentPane().getBackground());
        jTextArea.setMargin(new Insets(0, 2, 0, 2));
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane();
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setScrollMode(1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(true);
        JButton jButton = (JButton)jPanel2.add(new JButton("OK"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AbleEditorFrame.this.exceptionDialog != null) {
                    AbleEditor.Preferences.setEditorExceptionPanelLocation(AbleEditorFrame.this.exceptionDialog.getLocation());
                    AbleEditor.Preferences.setEditorExceptionPanelSize(AbleEditorFrame.this.exceptionDialog.getSize());
                }
                AbleEditorFrame.this.exceptionDialog.dispose();
                AbleEditorFrame.this.exceptionDialog = null;
            }
        });
        jViewport.add(jTextArea);
        this.exceptionDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (AbleEditorFrame.this.exceptionDialog != null) {
                    AbleEditor.Preferences.setEditorExceptionPanelLocation(AbleEditorFrame.this.exceptionDialog.getLocation());
                    AbleEditor.Preferences.setEditorExceptionPanelSize(AbleEditorFrame.this.exceptionDialog.getSize());
                }
                AbleEditorFrame.this.exceptionDialog.dispose();
                AbleEditorFrame.this.exceptionDialog = null;
            }
        });
        this.exceptionDialog.getContentPane().add((Component)jPanel, "Center");
        this.exceptionDialog.getContentPane().add((Component)jPanel2, "South");
        jTextArea.setDocument(new PlainDocument());
        jTextArea.insert(string, jTextArea.getCaretPosition());
        Toolkit.getDefaultToolkit().beep();
        this.exceptionDialog.show();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$900(AbleEditorFrame ableEditorFrame, ActionEvent actionEvent) {
        ableEditorFrame.createInstance_actionPerformed(actionEvent);
    }

    private class Helper
    implements AbleDoOnBean {
        private Helper() {
        }

        public void action(AbleJarInfo ableJarInfo, BeanInfo beanInfo, String string) {
            block21: {
                Object object;
                String string2;
                String string3 = null;
                Image image = null;
                BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
                String string4 = null;
                string4 = beanDescriptor.getValue("able-category") instanceof Integer ? ((Integer)beanDescriptor.getValue("able-category")).toString() : (String)beanDescriptor.getValue("able-category");
                if (string4 == "") {
                    return;
                }
                if (string4 == null) {
                    string2 = "Warning: Unable to read 'able-category' from bean '" + string + "BeanInfo'.";
                    if (Able.TraceLog.isLogging()) {
                        Able.TraceLog.text(262144L, (Object)"com.ibm.able.editor.AbleEditorFrame$Helper", "action", Able.LS + string2);
                    } else {
                        Able.MessageLog.text(2L, (Object)"com.ibm.able.editor.AbleEditorFrame$Helper", "action", Able.LS + string2);
                    }
                    string4 = "Unknown";
                }
                if ((string2 = (String)beanDescriptor.getValue("able-slot")) == null) {
                    object = "Warning: Unable to read 'able-slot' from bean '" + string + "BeanInfo'.";
                    if (Able.TraceLog.isLogging()) {
                        Able.TraceLog.text(262144L, (Object)"com.ibm.able.editor.AbleEditorFrame$Helper", "action", Able.LS + (String)object);
                    } else {
                        Able.MessageLog.text(2L, (Object)"com.ibm.able.editor.AbleEditorFrame$Helper", "action", Able.LS + (String)object);
                    }
                    string2 = "0";
                }
                if (string.equals(((Class)(object = beanDescriptor.getBeanClass())).getName())) {
                    string3 = beanInfo.getBeanDescriptor().getDisplayName();
                    image = beanInfo.getIcon(2);
                } else {
                    string3 = string;
                    int n = string.lastIndexOf(46);
                    if (n >= 0) {
                        string3 = string.substring(n + 1);
                    }
                    image = null;
                }
                try {
                    Serializable serializable;
                    Class<?> clazz = Class.forName(string);
                    if (Modifier.isAbstract(clazz.getModifiers())) {
                        return;
                    }
                    Object obj = clazz.newInstance();
                    AbleEditorFrame.this.addWithUniqueName(AbleEditorFrame.this.beanLabels, string3);
                    AbleEditorFrame.this.beanNames.addElement(string);
                    if (image == null) {
                        System.out.println("Warning: '" + string + "' image icon was not loaded.");
                        if (Able.TraceLog.isLogging()) {
                            Able.TraceLog.text(262144L, (Object)this, "", "Warning: Cannot load image for '" + string + "'; classpath needs updating.  Using default image.");
                        } else {
                            Able.MessageLog.text(2L, (Object)this, "", "Warning: Cannot load image for '" + string + "'; classpath needs updating.  Using default image.");
                        }
                    }
                    AbleEditorFrame.this.beanIcons.addElement(image);
                    AbleEditorFrame.this.beanJars.addElement(ableJarInfo);
                    if (Beans.isInstanceOf(obj, class$com$ibm$able$AbleAgent == null ? (class$com$ibm$able$AbleAgent = AbleEditorFrame.class$("com.ibm.able.AbleAgent")) : class$com$ibm$able$AbleAgent) && ((serializable = (Boolean)beanDescriptor.getValue("able-listInNewAgentMenu")) == null || ((Boolean)serializable).booleanValue())) {
                        AbleEditorFrame.this.addToNewAgentMenu(string);
                    }
                    if (Beans.isInstanceOf(obj, class$com$ibm$able$AbleObject == null ? (class$com$ibm$able$AbleObject = AbleEditorFrame.class$("com.ibm.able.AbleObject")) : class$com$ibm$able$AbleObject)) {
                        ((AbleObject)obj).quitAll();
                    }
                    obj = null;
                    serializable = null;
                    if (string4 != null) {
                        serializable = image == null ? new JButton(AbleEditorFrame.this.unknownIcon) : new JButton(new ImageIcon(image));
                        ((JComponent)serializable).setMaximumSize(new Dimension(32, 32));
                        ((JComponent)serializable).setPreferredSize(new Dimension(32, 32));
                        AbleEditorFrame.this.addToolBarPalette(string4);
                        JToolBar jToolBar = (JToolBar)AbleEditorFrame.this.ToolBarPaletteHash.get(string4);
                        jToolBar.add((Component)serializable, null);
                        ((JComponent)serializable).setToolTipText(string.substring(string.lastIndexOf(46) + 1));
                        ((AbstractButton)serializable).setActionCommand(string);
                        ((AbstractButton)serializable).addActionListener(new ActionListener(this){
                            private final /* synthetic */ Helper this$1;
                            {
                                this.this$1 = helper;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                AbleEditorFrame.access$900(Helper.access$800(this.this$1), actionEvent);
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    String string5 = "Unable to load bean '" + string + "'; caught '" + exception + "'." + Able.LS + "Update classpath if bean '" + string + "' is to be used, " + Able.LS + "or remove its container jar '" + ableJarInfo.getJarName() + "' from the plugin directory or bean jar list, " + Able.LS + "or ignore this warning.";
                    if (Able.TraceLog.isLogging()) {
                        Able.TraceLog.text(262144L, (Object)this, "", Able.LS + string5);
                        Able.TraceLog.exception(524288L, (Object)this, "AbleJarInfo", (Throwable)exception);
                    } else {
                        Able.MessageLog.text(2L, (Object)this, "", Able.LS + string5);
                    }
                    if (!AbleEditorFrame.this.jarsLoaded) break block21;
                    AbleEditorFrame.this.showMessageDialog(null, string5, "Editor Helper Error: action() ", 0);
                }
            }
        }

        public void error(String string) {
            System.out.println(string);
        }

        public void error(String string, Exception exception) {
            System.out.println(string + " " + exception.toString());
        }

        static /* synthetic */ AbleEditorFrame access$800(Helper helper) {
            return helper.AbleEditorFrame.this;
        }
    }

    static class ViewSelection
    implements Transferable,
    ClipboardOwner {
        protected Object selection;
        protected DataFlavor flavor;

        public ViewSelection(Object object, DataFlavor dataFlavor) {
            this.selection = object;
            this.flavor = dataFlavor;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.flavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(this.flavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (dataFlavor.equals(this.flavor)) {
                return this.selection;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            this.selection = null;
        }
    }

    private static class JarFilter
    implements FilenameFilter {
        private JarFilter() {
        }

        public boolean accept(File file, String string) {
            boolean bl = true;
            if (!string.toUpperCase().endsWith(".JAR")) {
                bl = false;
            } else {
                File file2 = new File(file, string);
                if (file2.length() == 0L) {
                    bl = false;
                }
            }
            return bl;
        }
    }
}

