/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.Able;
import com.ibm.able.AbleAgent;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBeanContainer;
import com.ibm.able.AbleBufferConnection;
import com.ibm.able.AbleEventConnection;
import com.ibm.able.AbleEventListener;
import com.ibm.able.AbleException;
import com.ibm.able.AblePropertyConnection;
import com.ibm.able.AblePropertyConnectionManager;
import com.ibm.able.editor.AbleEditor;
import com.ibm.able.editor.AbleEditorFrame;
import com.ibm.able.editor.AbleSelectPropertyDialog;
import com.ibm.able.editor.AbleViewObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AbleEditorCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
PopupMenuListener {
    public boolean connectionInProgress = false;
    public JFrame frame = null;
    private AbleAgent myAgent = null;
    private AbleViewObject myAgentView = null;
    private AbleViewObject myFocusObj = null;
    private AbleViewObject mySelectedObj = null;
    private JTree myTreeView = null;
    private int myConnectionMode = 0;
    private boolean myDragInProgressFlag = false;
    private Point myStartDragPoint;
    private transient Point myOldAgentPoint;
    private String mySourceProperty;
    private String myDestProperty;
    private String mySourceEvent;
    private String myDestEvent;
    private int myViewType = AbleEditor.Preferences.getConnectionsView();
    private String workingDirectory = Able.ProductDirectory + "examples";
    transient AbleViewObject connectionSource = null;
    transient int oldX1 = -1;
    transient int oldX2;
    transient int oldY1;
    transient int oldY2;

    public AbleEditorCanvas() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 127) {
                    if (AbleEditorCanvas.this.mySelectedObj != null && keyEvent != null) {
                        AbleEditorCanvas.this.mySelectedObj.actionPerformed(new ActionEvent(AbleEditorCanvas.this.mySelectedObj, 1001, "delete"));
                    }
                } else if (n == 27 && AbleEditorCanvas.this.connectionSource != null && AbleEditorCanvas.this.connectionInProgress) {
                    try {
                        AbleEditorCanvas.this.endConnection(null);
                    }
                    catch (AbleException ableException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void setAgentViewObject(AbleViewObject ableViewObject) {
        if (this.myAgentView != null) {
            this.myAgentView.setVisible(true);
            this.myAgentView.setLocation(this.myOldAgentPoint);
        }
        this.myAgentView = ableViewObject;
        this.myAgent = (AbleAgent)ableViewObject.getBean();
        this.myAgentView.setVisible(false);
        this.add(this.myAgentView);
        this.myOldAgentPoint = this.myAgentView.getLocation();
        this.myAgentView.setLocation(0, 0);
    }

    public Object getAgent() {
        return this.myAgent;
    }

    public void setFrame(JFrame jFrame) {
        this.frame = jFrame;
    }

    public int getViewType() {
        return this.myViewType;
    }

    public void setViewType(int n) {
        this.myViewType = n;
        AbleEditor.Preferences.setConnectionsView(n);
        this.invalidate();
        this.repaint();
    }

    public void setTreeView(JTree jTree) {
        this.myTreeView = jTree;
    }

    public static void removeBean(Object object) throws AbleException {
        if (object instanceof AbleBean) {
            AbleBean ableBean = (AbleBean)object;
            ableBean.removeAllConnections();
            AbleBeanContainer ableBeanContainer = ableBean.getParent();
            ableBeanContainer.removeBean(ableBean);
        }
    }

    public AbleBean getSelectedObject() {
        if (this.mySelectedObj == null) {
            return this.myAgent;
        }
        return this.mySelectedObj.getBean();
    }

    public Component add(Component component) {
        this.reposition(component);
        super.add(component);
        this.invalidate();
        this.repaint();
        return component;
    }

    public void remove(Component component) {
        super.remove(component);
        this.invalidate();
        this.repaint();
    }

    private void reposition(Component component) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = component.getLocation();
            if (!point.equals(componentArray[i].getLocation())) continue;
            component.setLocation(point.x + 15, point.y + 60);
        }
    }

    public AbleViewObject getSelectedViewObject() {
        return this.mySelectedObj;
    }

    public void setSelectedViewObject(AbleViewObject ableViewObject, boolean bl) {
        if (this.mySelectedObj != null) {
            this.mySelectedObj.setSelected(false);
        }
        this.mySelectedObj = ableViewObject;
        this.mySelectedObj.setSelected(true);
        if (this.mySelectedObj != null && bl) {
            this.selectTreeNode();
        }
        this.repaint();
    }

    public void setNoSelectedViewObject() {
        if (this.mySelectedObj != null) {
            this.mySelectedObj.setSelected(false);
        }
        this.mySelectedObj = null;
        this.requestFocus();
        this.repaint();
    }

    private void selectTreeNode() {
        if (this.myTreeView == null) {
            return;
        }
        TreeModel treeModel = this.myTreeView.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getRoot();
        this.findTreeNode(defaultMutableTreeNode);
    }

    private void findTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        AbleViewObject ableViewObject = (AbleViewObject)defaultMutableTreeNode.getUserObject();
        if (ableViewObject == this.mySelectedObj) {
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.myTreeView.setSelectionPath(treePath);
            this.myTreeView.scrollPathToVisible(treePath);
            return;
        }
        while (enumeration.hasMoreElements()) {
            this.findTreeNode((DefaultMutableTreeNode)enumeration.nextElement());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        AbleViewObject ableViewObject = this.myAgentView;
        this.requestFocus();
        Component component = (Component)mouseEvent.getSource();
        if (component instanceof AbleViewObject) {
            ableViewObject = (AbleViewObject)component;
        } else if (component instanceof JTree) {
            TreePath treePath = ((JTree)component).getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ableViewObject = (AbleViewObject)defaultMutableTreeNode.getUserObject();
            if (ableViewObject == null) {
                return;
            }
        }
        if (this.connectionSource != null && this.connectionInProgress) {
            try {
                if (component instanceof AbleViewObject) {
                    this.endConnection(ableViewObject);
                } else {
                    this.endConnection(null);
                }
            }
            catch (AbleException ableException) {
                JOptionPane.showMessageDialog(this, ableException.toString(), "Editor Canvas Error: endConnection()", 0);
            }
            return;
        }
        if (mouseEvent.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (ableViewObject == null) {
                this.setNoSelectedViewObject();
            } else {
                this.setSelectedViewObject(ableViewObject, !(mouseEvent.getSource() instanceof JTree));
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        AbleViewObject ableViewObject = null;
        this.myStartDragPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
        Component component = (Component)mouseEvent.getSource();
        if (component instanceof AbleViewObject) {
            ableViewObject = (AbleViewObject)component;
        } else if (component instanceof AbleEditorCanvas) {
            ableViewObject = this.myAgentView;
        } else if (component instanceof JTree) {
            TreePath treePath = ((JTree)component).getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ableViewObject = (AbleViewObject)defaultMutableTreeNode.getUserObject();
            if (ableViewObject == null) {
                return;
            }
        } else {
            return;
        }
        if (mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 1 && !this.connectionInProgress) {
            this.showPopup(mouseEvent, ableViewObject);
            return;
        }
        if (mouseEvent.getClickCount() == 2 && ableViewObject instanceof AbleViewObject) {
            ableViewObject.actionPerformed(new ActionEvent(ableViewObject, 1001, "open"));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Serializable serializable;
        AbleViewObject ableViewObject = null;
        Component component = (Component)mouseEvent.getSource();
        if (component instanceof AbleViewObject) {
            ableViewObject = (AbleViewObject)component;
        } else if (component instanceof AbleEditorCanvas) {
            ableViewObject = this.myAgentView;
        } else if (component instanceof JTree) {
            serializable = ((JTree)component).getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (serializable == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)serializable.getLastPathComponent();
            ableViewObject = (AbleViewObject)defaultMutableTreeNode.getUserObject();
            if (ableViewObject == null) {
                return;
            }
        } else {
            return;
        }
        if (mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 1 && !this.connectionInProgress) {
            this.showPopup(mouseEvent, ableViewObject);
            return;
        }
        if (this.myDragInProgressFlag) {
            this.myDragInProgressFlag = false;
            serializable = new Point(mouseEvent.getX(), mouseEvent.getY());
            if ((Math.abs(((Point)serializable).x - this.myStartDragPoint.x) > 1 || Math.abs(((Point)serializable).y - this.myStartDragPoint.y) > 1) && ableViewObject != null) {
                ableViewObject.setLocation(ableViewObject.getX() + ((Point)serializable).x - this.myStartDragPoint.x, ableViewObject.getY() + ((Point)serializable).y - this.myStartDragPoint.y);
                this.repaint();
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.connectionInProgress) {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        AbleViewObject ableViewObject = null;
        if (this.connectionInProgress) {
            return;
        }
        Component component = (Component)mouseEvent.getSource();
        if (!(component instanceof AbleEditorCanvas)) {
            ableViewObject = (AbleViewObject)component;
        }
        if (ableViewObject != null) {
            if (!this.myDragInProgressFlag) {
                this.myDragInProgressFlag = true;
            }
            if (!this.contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(13));
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = 0;
        int n2 = 0;
        if (this.connectionSource != null) {
            Component component = mouseEvent.getComponent();
            if (!(component instanceof AbleEditorCanvas)) {
                AbleViewObject ableViewObject = (AbleViewObject)component;
                Point point = ableViewObject.getInputPos();
                n = point.x;
                n2 = point.y;
            } else {
                n = mouseEvent.getX();
                n2 = mouseEvent.getY();
            }
            if (component != null) {
                this.paintConnection(n, n2);
                this.connectionInProgress = true;
            }
        }
    }

    public void removeListeners() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    public void showPopup(MouseEvent mouseEvent, AbleViewObject ableViewObject) {
        JPopupMenu jPopupMenu = ableViewObject.getPopupMenu(mouseEvent, ableViewObject);
        if (jPopupMenu != null) {
            jPopupMenu.addPopupMenuListener(this);
            jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.repaint();
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String string) {
        this.workingDirectory = string;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        switch (this.myViewType) {
            case 0: {
                this.drawBufferConnections(graphics);
                break;
            }
            case 2: {
                this.drawEventConnections(graphics);
                break;
            }
            case 1: {
                this.drawPropertyConnections(graphics);
                break;
            }
            case 3: {
                this.drawBufferConnections(graphics);
                this.drawEventConnections(graphics);
                this.drawPropertyConnections(graphics);
            }
        }
    }

    void drawBufferConnections(Graphics graphics) {
        Serializable serializable;
        Component component;
        int n;
        graphics.setColor(Color.black);
        Hashtable<Integer, AbleViewObject> hashtable = new Hashtable<Integer, AbleViewObject>();
        Component[] componentArray = this.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            component = componentArray[n];
            serializable = (AbleViewObject)componentArray[n];
            hashtable.put(new Integer(serializable.getObject().hashCode()), (AbleViewObject)serializable);
        }
        for (n = 0; n < componentArray.length; ++n) {
            component = (AbleViewObject)componentArray[n];
            serializable = ((AbleViewObject)component).getInputPos();
            Vector vector = ((AbleViewObject)component).getBufferConnections();
            for (int i = 0; i < vector.size(); ++i) {
                AbleBufferConnection ableBufferConnection = (AbleBufferConnection)vector.elementAt(i);
                AbleBean ableBean = ableBufferConnection.getSource();
                AbleBean ableBean2 = ableBufferConnection.getDest();
                Integer n2 = new Integer(ableBean.hashCode());
                if (ableBean.isDataFlowEnabled() && ableBean2.isDataFlowEnabled()) {
                    graphics.setColor(Color.green);
                } else {
                    graphics.setColor(Color.black);
                }
                AbleViewObject ableViewObject = (AbleViewObject)hashtable.get(n2);
                Point point = new Point(25, 25);
                if (ableViewObject == null) continue;
                point = ableViewObject.getOutputPos();
                graphics.drawLine(point.x, point.y, ((Point)serializable).x, ((Point)serializable).y);
            }
        }
    }

    void drawEventConnections(Graphics graphics) {
        Serializable serializable;
        Component component;
        int n;
        graphics.setColor(Color.blue);
        Hashtable<Integer, AbleViewObject> hashtable = new Hashtable<Integer, AbleViewObject>();
        Component[] componentArray = this.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            component = componentArray[n];
            serializable = (AbleViewObject)componentArray[n];
            hashtable.put(new Integer(serializable.getObject().hashCode()), (AbleViewObject)serializable);
        }
        for (n = 0; n < componentArray.length; ++n) {
            component = (AbleViewObject)componentArray[n];
            serializable = ((AbleViewObject)component).getInputPos();
            Vector vector = new Vector();
            vector = ((AbleViewObject)component).getBean().getAbleEventListeners();
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                if (!(e instanceof AbleBean)) continue;
                AbleBean ableBean = (AbleBean)e;
                Integer n2 = new Integer(ableBean.hashCode());
                AbleViewObject ableViewObject = (AbleViewObject)hashtable.get(n2);
                Point point = new Point(25, 25);
                if (ableViewObject == null) continue;
                point = ableViewObject.getOutputPos();
                graphics.drawLine(point.x, point.y, ((Point)serializable).x, ((Point)serializable).y);
            }
        }
    }

    void drawPropertyConnections(Graphics graphics) {
        Serializable serializable;
        Component component;
        int n;
        graphics.setColor(Color.red);
        Hashtable<Integer, AbleViewObject> hashtable = new Hashtable<Integer, AbleViewObject>();
        Component[] componentArray = this.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            component = componentArray[n];
            serializable = (AbleViewObject)componentArray[n];
            hashtable.put(new Integer(serializable.getObject().hashCode()), (AbleViewObject)serializable);
        }
        for (n = 0; n < componentArray.length; ++n) {
            component = (AbleViewObject)componentArray[n];
            serializable = ((AbleViewObject)component).getOutputPos();
            Enumeration enumeration = null;
            AblePropertyConnectionManager ablePropertyConnectionManager = ((AbleViewObject)component).getBean().getPropertyConnectionManager();
            Hashtable hashtable2 = ablePropertyConnectionManager.getConnectionsByPropertyName();
            enumeration = hashtable2.elements();
            while (enumeration.hasMoreElements()) {
                Vector vector = (Vector)enumeration.nextElement();
                for (int i = 0; i < vector.size(); ++i) {
                    AblePropertyConnection ablePropertyConnection = (AblePropertyConnection)vector.elementAt(i);
                    AbleBean ableBean = ablePropertyConnection.getDest();
                    if (!(ableBean instanceof AbleBean)) continue;
                    AbleBean ableBean2 = ableBean;
                    Integer n2 = new Integer(ableBean2.hashCode());
                    AbleViewObject ableViewObject = (AbleViewObject)hashtable.get(n2);
                    Point point = new Point(25, 25);
                    if (ableViewObject == null) continue;
                    point = ableViewObject.getOutputPos();
                    graphics.drawLine(point.x, point.y, ((Point)serializable).x, ((Point)serializable).y);
                }
            }
        }
    }

    void startConnection(AbleViewObject ableViewObject, int n) {
        boolean bl = false;
        this.myConnectionMode = n;
        if (this.myConnectionMode == 1) {
            AbleSelectPropertyDialog ableSelectPropertyDialog = new AbleSelectPropertyDialog(this.frame, "Select Source Property", true);
            ableSelectPropertyDialog.setData(ableViewObject.getProperties());
            Point point = this.frame.getLocation();
            ableSelectPropertyDialog.setLocation(point.x + 50, point.y + 50);
            ableSelectPropertyDialog.setVisible(true);
            if (ableSelectPropertyDialog.userCancelled()) {
                bl = true;
            } else {
                this.mySourceProperty = ableSelectPropertyDialog.getData();
            }
        } else if (this.myConnectionMode == 2) {
            this.mySourceEvent = ableViewObject.getEventType();
        }
        if (!bl) {
            this.connectionSource = ableViewObject;
            this.connectionInProgress = false;
            this.setStatus("Select destination object...");
            this.setCursor(Cursor.getPredefinedCursor(1));
        } else {
            this.setStatus("Connection aborted");
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void endConnection(AbleViewObject ableViewObject) throws AbleException {
        if (ableViewObject == null) {
            this.setStatus("Connection aborted");
            this.connectionSource = null;
            this.unpaintConnection();
        } else if (this.connectionSource == ableViewObject) {
            this.setStatus("Connection aborted: Can't connect an object to itself");
            this.connectionSource = null;
            this.unpaintConnection();
        } else {
            switch (this.myConnectionMode) {
                case 0: {
                    this.setStatus("Connection created");
                    AbleEditorFrame.createConnection(this.connectionSource, ableViewObject);
                    this.connectionSource = null;
                    break;
                }
                case 1: {
                    AbleSelectPropertyDialog ableSelectPropertyDialog = new AbleSelectPropertyDialog(this.frame, "Select Target Property", true);
                    ableSelectPropertyDialog.setData(ableViewObject.getProperties());
                    Point point = this.frame.getLocation();
                    ableSelectPropertyDialog.setLocation(point.x + 50, point.y + 50);
                    ableSelectPropertyDialog.setVisible(true);
                    if (!ableSelectPropertyDialog.userCancelled()) {
                        this.myDestProperty = ableSelectPropertyDialog.getData();
                        String string = this.connectionSource.getName();
                        String string2 = ableViewObject.getName();
                        try {
                            AblePropertyConnection ablePropertyConnection = new AblePropertyConnection(this.connectionSource.getBean(), this.mySourceProperty, ableViewObject.getBean(), this.myDestProperty);
                            this.connectionSource.getBean().addPropertyConnection(ablePropertyConnection);
                            this.setStatus("Bound property " + string + "." + this.mySourceProperty + " to " + string2 + "." + this.myDestProperty);
                        }
                        catch (Exception exception) {
                            this.setStatus("Error -- couldn't create property connection");
                            System.out.println("Property Connection Exception: " + exception.toString());
                        }
                    } else {
                        this.setStatus("Connection aborted");
                    }
                    this.connectionSource = null;
                    break;
                }
                case 2: {
                    String string = this.connectionSource.getName();
                    String string3 = ableViewObject.getName();
                    this.setStatus("Bound event " + string + "." + this.mySourceEvent + " to " + string3 + "." + this.myDestEvent);
                    try {
                        AbleEventConnection ableEventConnection = new AbleEventConnection(this.connectionSource.getBean(), (AbleEventListener)ableViewObject.getBean());
                        this.myAgent.addEventConnection(ableEventConnection);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.connectionSource = null;
                }
            }
        }
        this.invalidate();
        this.repaint();
        this.connectionInProgress = false;
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private synchronized void paintConnection(int n, int n2) {
        this.unpaintConnection();
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setColor(Color.black);
        AbleViewObject ableViewObject = this.connectionSource;
        if (ableViewObject == null) {
            return;
        }
        Point point = this.connectionSource.getOutputPos();
        int n3 = point.x;
        int n4 = point.y;
        graphics.drawLine(n, n2, n3, n4);
        graphics.drawLine(n + 1, n2 + 1, n3 + 1, n4 + 1);
        this.oldX1 = n;
        this.oldX2 = n3;
        this.oldY1 = n2;
        this.oldY2 = n4;
    }

    private void unpaintConnection() {
        Graphics graphics = this.getGraphics();
        if (graphics == null || this.oldX1 < 0) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.drawLine(this.oldX1, this.oldY1, this.oldX2, this.oldY2);
        graphics.drawLine(this.oldX1 + 1, this.oldY1 + 1, this.oldX2 + 1, this.oldY2 + 1);
        this.oldX1 = -1;
    }

    public void setStatus(String string) {
        ((AbleEditorFrame)this.frame).setStatus(string);
    }
}

