/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.Able;
import com.ibm.able.editor.AbleEditorFrame;
import com.ibm.able.editor.AbleGuiPreferences;
import com.ibm.logging.TextAreaHandler;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.UIManager;

public class AbleEditor {
    protected transient TextAreaHandler traceTextAreaHandler;
    protected transient TextAreaHandler messageTextAreaHandler;
    public static final AbleGuiPreferences Preferences = new AbleGuiPreferences();
    public static final String CAT_NONE = "";
    public static final String CAT_DATA = "Data";
    public static final String CAT_LEARNING = "Learning";
    public static final String CAT_RULES = "Rules";
    public static final String CAT_AGENTS = "Agents";
    public static final Object CAT_PETRI = "PetriNet";
    public static final String CAT_PLATFORM = "Platform";
    public static final String CAT_SAMPLES = "Samples";
    public static final String CAT_CONVERSATION = "Conversation";
    public static final String CAT_AUTOTUNE = "Autotune";
    public static final int LEFT = 0;
    public static final int LEFTCENTER = 1;
    public static final int CENTER = 2;
    public static final int RIGHTCENTER = 3;
    public static final int RIGHT = 4;
    public static final int BUFFER_CONNECTION = 0;
    public static final int PROPERTY_CONNECTION = 1;
    public static final int EVENT_CONNECTION = 2;
    public static final int ALL_CONNECTIONS = 3;
    private static boolean packFrame = false;
    private AbleEditorFrame myFrame = new AbleEditorFrame();

    public AbleEditor() throws Exception {
        this.myFrame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                AbleEditor.this.myFrame.dispose();
                System.exit(0);
            }
        });
        AbleEditor.launch(this.myFrame);
    }

    public static void launch(AbleEditorFrame ableEditorFrame) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ableEditorFrame.setDefaultCloseOperation(2);
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(262144L, (Object)"AbleEditor", "main", "Editor session started.");
        }
        if (packFrame) {
            ableEditorFrame.pack();
        } else {
            ableEditorFrame.validate();
        }
        ableEditorFrame.setVisible(true);
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(0x100000L, (Object)"com.ibm.able.editor.AbleEditor", "AbleEditor", "Agent editor constructed.");
        }
    }

    public static void main(String[] stringArray) {
        try {
            Able.startMessageAndTraceLogging();
            System.out.println("\nABLE Version 2.3.0 July 14, 2005");
            System.out.println("\n" + Able.NlsMsg((String)"LICENSED_MATERIALS", (Object[])new String[]{"(C) Copyright IBM Corporation 1999, 2005."}) + "\n");
            UIManager.setLookAndFeel(Preferences.getAbleLookAndFeelClassName());
            new AbleEditor();
        }
        catch (Exception exception) {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)"AbleEditor", "main", (Throwable)exception);
            }
            Able.MessageLog.exception(4L, (Object)"AbleEditor", "main", (Throwable)exception);
            System.exit(-1);
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

