/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.editor;

import com.ibm.able.Able;
import com.ibm.able.AbleHelp;
import com.ibm.able.beans.AbleClusterDiagramView;
import com.ibm.able.editor.AbleGridBagConstraints;
import com.ibm.able.editor.AbleInspectorContext;
import com.ibm.able.editor.AbleInspectorPanel;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AbleClusterDiagramPanel
extends JPanel
implements AbleInspectorPanel {
    AbleInspectorContext myContext = null;
    AbleClusterDiagramView myView = null;
    private static Vector Colors = new Vector();
    Hashtable categoryToColorMap = new Hashtable();
    JLabel jLabel3 = new JLabel();
    JTextField userThresholdTextField = new JTextField();
    JRadioButton circlesRadioButton = new JRadioButton();
    JRadioButton squaresRadioButton = new JRadioButton();
    JCheckBox showGridCheckBox = new JCheckBox();
    ButtonGroup shapeButtonGroup = new ButtonGroup();
    JCheckBox showLabelsCheckBox = new JCheckBox();
    JCheckBox showClusterIDsCheckBox = new JCheckBox();
    JComboBox categoryComboBox = new JComboBox();
    JLabel jLabel4 = new JLabel();
    JComboBox colorComboBox = new JComboBox();
    JButton colorButton = new JButton();
    JLabel jLabel5 = new JLabel();
    JCheckBox invertCheckBox = new JCheckBox();
    JLabel jLabel6 = new JLabel();
    ButtonGroup colorButtonGroup = new ButtonGroup();
    JRadioButton meanRadioButton = new JRadioButton();
    JRadioButton userThresholdRadioButton = new JRadioButton();
    JRadioButton colorMapRadioButton = new JRadioButton();

    public AbleClusterDiagramPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setPanel(Object object) {
        this.myView = (AbleClusterDiagramView)object;
        this.setObject(this.myContext);
    }

    private void initializePanel() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("No base customizable properties yet defined."), new AbleGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 0), 0, 0));
    }

    public void setObject(Object object) {
        String string;
        int n;
        this.myContext = (AbleInspectorContext)object;
        this.userThresholdTextField.setText(String.valueOf(this.myView.getUserThreshold()));
        this.showGridCheckBox.setSelected(this.myView.isShowGrid());
        int n2 = this.myView.getNodeShape();
        if (n2 == 0) {
            this.circlesRadioButton.setSelected(true);
        } else {
            this.squaresRadioButton.setSelected(true);
        }
        Vector vector = this.myView.getClusterCategoryValues();
        this.categoryToColorMap = this.myView.getColorMap();
        for (n = 0; n < vector.size(); ++n) {
            string = (String)vector.get(n);
            this.categoryComboBox.addItem(string);
            if (this.categoryToColorMap.containsKey(string)) continue;
            this.categoryToColorMap.put(string, Colors.get(n % vector.size()));
        }
        this.showLabelsCheckBox.setSelected(this.myView.isShowLabels());
        this.showClusterIDsCheckBox.setSelected(this.myView.isShowClusterIDs());
        this.invertCheckBox.setSelected(this.myView.isInvertActivations());
        n = this.myView.getColorMode();
        if (n == 0) {
            this.meanRadioButton.setSelected(true);
        }
        if (n == 1) {
            this.userThresholdRadioButton.setSelected(true);
            this.userThresholdTextField.setEnabled(true);
        }
        if (n == 2) {
            this.colorMapRadioButton.setSelected(true);
            this.categoryComboBox.setEnabled(true);
            this.colorComboBox.setEnabled(true);
            this.colorButton.setEnabled(true);
        }
        string = (String)this.categoryComboBox.getSelectedItem();
        String string2 = (String)this.categoryToColorMap.get(string);
        this.colorComboBox.setSelectedItem(string2);
    }

    public void updateObject() throws Exception {
        this.myView.setUserThreshold(Double.valueOf(this.userThresholdTextField.getText()));
        this.myView.setShowGrid(this.showGridCheckBox.isSelected());
        if (this.circlesRadioButton.isSelected()) {
            this.myView.setNodeShape(0);
        } else {
            this.myView.setNodeShape(1);
        }
        if (this.meanRadioButton.isSelected()) {
            this.myView.setColorMode(0);
        }
        if (this.userThresholdRadioButton.isSelected()) {
            this.myView.setColorMode(1);
        }
        if (this.colorMapRadioButton.isSelected()) {
            this.myView.setColorMode(2);
        }
        this.myView.setColorMap(this.categoryToColorMap);
        this.myView.setShowLabels(this.showLabelsCheckBox.isSelected());
        this.myView.setShowClusterIDs(this.showClusterIDsCheckBox.isSelected());
        this.myView.setInvertActivations(this.invertCheckBox.isSelected());
    }

    public String getName() {
        return "Cluster Diagram";
    }

    public void setView() {
        try {
            this.updateObject();
            this.myView.invalidate();
            this.myView.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "editor/doc-files/AbleInspectorClusterDiagramHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.jLabel3.setText("Draw cluster nodes as ");
        this.jLabel3.setBounds(new Rectangle(18, 171, 152, 17));
        this.userThresholdTextField.setText("0.6");
        this.userThresholdTextField.setBounds(new Rectangle(168, 59, 63, 21));
        this.circlesRadioButton.setText("Circles");
        this.circlesRadioButton.setBounds(new Rectangle(173, 169, 103, 25));
        this.squaresRadioButton.setText("Squares");
        this.squaresRadioButton.setBounds(new Rectangle(282, 169, 103, 25));
        this.showLabelsCheckBox.setSelected(true);
        this.showLabelsCheckBox.setText("Show cluster labels");
        this.showLabelsCheckBox.setToolTipText("Display the cluster labels");
        this.showLabelsCheckBox.setBounds(new Rectangle(20, 240, 139, 25));
        this.showClusterIDsCheckBox.setSelected(true);
        this.showClusterIDsCheckBox.setText("Show cluster IDs");
        this.showClusterIDsCheckBox.setToolTipText("Display the cluster numbers ");
        this.showClusterIDsCheckBox.setBounds(new Rectangle(20, 214, 143, 25));
        this.showGridCheckBox.setSelected(true);
        this.showGridCheckBox.setToolTipText("Display grid between units");
        this.categoryComboBox.setToolTipText("Select category and associated color ");
        this.categoryComboBox.setBounds(new Rectangle(39, 128, 114, 21));
        this.categoryComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleClusterDiagramPanel.this.categoryComboBox_actionPerformed(actionEvent);
            }
        });
        this.jLabel4.setText("Categories");
        this.jLabel4.setBounds(new Rectangle(39, 109, 114, 17));
        this.colorComboBox.setToolTipText("Select color value for category");
        this.colorComboBox.setBounds(new Rectangle(162, 128, 114, 21));
        this.colorComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleClusterDiagramPanel.this.colorComboBox_actionPerformed(actionEvent);
            }
        });
        for (int i = 0; i < Colors.size(); ++i) {
            this.colorComboBox.addItem(Colors.get(i));
        }
        this.colorButton.setToolTipText("Associate the selected Color with selected Category");
        this.colorButton.setText("Set Color");
        this.colorButton.setBounds(new Rectangle(288, 123, 95, 27));
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleClusterDiagramPanel.this.colorButton_actionPerformed(actionEvent);
            }
        });
        this.jLabel5.setText("Colors");
        this.jLabel5.setBounds(new Rectangle(163, 109, 107, 17));
        this.invertCheckBox.setText("Invert activations");
        this.invertCheckBox.setToolTipText("Check to display winner as largest unit");
        this.invertCheckBox.setBounds(new Rectangle(20, 263, 124, 25));
        this.jLabel6.setText("Color processing");
        this.jLabel6.setBounds(new Rectangle(15, 12, 129, 17));
        this.meanRadioButton.setText("Use mean threshold");
        this.meanRadioButton.setToolTipText("Use mean activation to separate hot from cold units ");
        this.meanRadioButton.setBounds(new Rectangle(20, 31, 368, 25));
        this.meanRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleClusterDiagramPanel.this.meanRadioButton_actionPerformed(actionEvent);
            }
        });
        this.userThresholdRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleClusterDiagramPanel.this.userThresholdRadioButton_actionPerformed(actionEvent);
            }
        });
        this.colorMapRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleClusterDiagramPanel.this.colorMapRadioButton_actionPerformed(actionEvent);
            }
        });
        this.colorButtonGroup.add(this.meanRadioButton);
        this.userThresholdRadioButton.setText("Use user threshold");
        this.userThresholdRadioButton.setToolTipText("Use threshold value to separate hot from cold units");
        this.userThresholdRadioButton.setBounds(new Rectangle(20, 57, 146, 25));
        this.colorButtonGroup.add(this.userThresholdRadioButton);
        this.colorMapRadioButton.setText("Use color map");
        this.colorMapRadioButton.setToolTipText("Explictly map colors based on cluster categories");
        this.colorMapRadioButton.setBounds(new Rectangle(20, 80, 103, 25));
        this.colorButtonGroup.add(this.colorMapRadioButton);
        this.meanRadioButton.setSelected(true);
        this.categoryComboBox.setEnabled(false);
        this.colorComboBox.setEnabled(false);
        this.colorButton.setEnabled(false);
        this.userThresholdTextField.setEnabled(false);
        this.shapeButtonGroup.add(this.circlesRadioButton);
        this.shapeButtonGroup.add(this.squaresRadioButton);
        this.circlesRadioButton.setSelected(true);
        this.showGridCheckBox.setText("Show grid");
        this.showGridCheckBox.setBounds(new Rectangle(20, 190, 226, 25));
        this.add((Component)this.jLabel6, null);
        this.add((Component)this.userThresholdRadioButton, null);
        this.add((Component)this.colorMapRadioButton, null);
        this.add((Component)this.invertCheckBox, null);
        this.add((Component)this.showGridCheckBox, null);
        this.add((Component)this.showClusterIDsCheckBox, null);
        this.add((Component)this.categoryComboBox, null);
        this.add((Component)this.jLabel4, null);
        this.add((Component)this.colorComboBox, null);
        this.add((Component)this.jLabel5, null);
        this.add((Component)this.colorButton, null);
        this.add((Component)this.jLabel3, null);
        this.add((Component)this.circlesRadioButton, null);
        this.add((Component)this.squaresRadioButton, null);
        this.add((Component)this.showLabelsCheckBox, null);
        this.add((Component)this.meanRadioButton, null);
        this.add((Component)this.userThresholdTextField, null);
    }

    void colorButton_actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.categoryComboBox.getSelectedItem();
        String string2 = (String)this.colorComboBox.getSelectedItem();
        this.categoryToColorMap.put(string, string2);
    }

    void categoryComboBox_actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.categoryComboBox.getSelectedItem();
        String string2 = (String)this.categoryToColorMap.get(string);
        this.colorComboBox.setSelectedItem(string2);
    }

    void colorComboBox_actionPerformed(ActionEvent actionEvent) {
    }

    void meanRadioButton_actionPerformed(ActionEvent actionEvent) {
        if (this.meanRadioButton.isSelected()) {
            this.categoryComboBox.setEnabled(false);
            this.colorComboBox.setEnabled(false);
            this.colorButton.setEnabled(false);
            this.userThresholdTextField.setEnabled(false);
        }
    }

    void userThresholdRadioButton_actionPerformed(ActionEvent actionEvent) {
        if (this.userThresholdRadioButton.isSelected()) {
            this.categoryComboBox.setEnabled(false);
            this.colorComboBox.setEnabled(false);
            this.colorButton.setEnabled(false);
            this.userThresholdTextField.setEnabled(true);
        }
    }

    void colorMapRadioButton_actionPerformed(ActionEvent actionEvent) {
        if (this.colorMapRadioButton.isSelected()) {
            this.categoryComboBox.setEnabled(true);
            this.colorComboBox.setEnabled(true);
            this.colorButton.setEnabled(true);
            this.userThresholdTextField.setEnabled(false);
        }
    }

    static {
        Colors.addElement("red");
        Colors.addElement("blue");
        Colors.addElement("black");
        Colors.addElement("yellow");
        Colors.addElement("green");
        Colors.addElement("gray");
        Colors.addElement("darkGray");
        Colors.addElement("lightGray");
        Colors.addElement("cyan");
        Colors.addElement("magenta");
        Colors.addElement("pink");
        Colors.addElement("orange");
    }
}

