/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.conversation;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.conversation.AblePlatformConversationAgent;
import com.ibm.able.conversation.AblePlatformConversationAgentCustomizer;
import com.ibm.conversation.ConversationPolicyHandlerFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AblePlatformStartConversationPanel
extends JPanel
implements ActionListener,
AbleCustomizerPanel {
    private static final String START_CONVERSATION = "start";
    private static final String LOOKUP_AGENT = "lookup";
    private static final String NONE_SELECTED = "<none selected>";
    AblePlatformConversationAgent myAgent = null;
    private AblePlatformConversationAgentCustomizer myCustomizer = null;
    JComboBox rootPolicyBox = null;
    JComboBox selfRoleBox = null;
    JLabel partnerRoleLabel = null;
    JTextField partnerDisplayNameField = null;

    public AblePlatformStartConversationPanel() {
        this.loadPanel();
        this.initPanelValues();
    }

    public AblePlatformStartConversationPanel(AblePlatformConversationAgent ablePlatformConversationAgent) {
        this.myAgent = ablePlatformConversationAgent;
        this.loadPanel();
        this.initPanelValues();
    }

    public AblePlatformStartConversationPanel(AblePlatformConversationAgentCustomizer ablePlatformConversationAgentCustomizer) {
        this.myCustomizer = ablePlatformConversationAgentCustomizer;
        this.loadPanel();
        this.initPanelValues();
    }

    private final void loadPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 8, 8), 0, 0);
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)new JLabel("Partner's display name:"), gridBagConstraints);
        this.partnerDisplayNameField = new JTextField(32);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.partnerDisplayNameField, gridBagConstraints);
        JButton jButton = new JButton("Lookup partner");
        jButton.setActionCommand(LOOKUP_AGENT);
        jButton.addActionListener(this);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)new JLabel("Root policy:"), gridBagConstraints);
        this.rootPolicyBox = new JComboBox();
        this.rootPolicyBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AblePlatformStartConversationPanel.this.rootPolicyBox_itemStateChanged(itemEvent);
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.rootPolicyBox, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)new JLabel("My role:"), gridBagConstraints);
        this.selfRoleBox = new JComboBox();
        this.selfRoleBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AblePlatformStartConversationPanel.this.selfRoleBox_itemStateChanged(itemEvent);
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.selfRoleBox, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)new JLabel("Partner's role:"), gridBagConstraints);
        this.partnerRoleLabel = new JLabel("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.partnerRoleLabel, gridBagConstraints);
        JButton jButton2 = new JButton("Start");
        jButton2.setActionCommand(START_CONVERSATION);
        jButton2.addActionListener(this);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        this.add((Component)jButton2, gridBagConstraints);
    }

    public void setAgent(AblePlatformConversationAgent ablePlatformConversationAgent) {
        this.myAgent = ablePlatformConversationAgent;
        this.initPanelValues();
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "conversation/doc-files/AblePlatformDefaultAgentHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public void getDataFromBean(Object object) throws RemoteException {
        try {
            this.setAgent((AblePlatformConversationAgent)object);
        }
        catch (ClassCastException classCastException) {
            throw new RemoteException(classCastException.getLocalizedMessage());
        }
    }

    public void setDataOnBean() throws RemoteException {
    }

    public void initPanelValues() {
        this.partnerDisplayNameField.setText(NONE_SELECTED);
        this.initRootPolicyBox();
        this.initSelfRoleBox();
        this.partnerRoleLabel.setText(NONE_SELECTED);
    }

    protected void initRootPolicyBox() {
        this.rootPolicyBox.removeAllItems();
        this.rootPolicyBox.addItem(NONE_SELECTED);
        if (this.myAgent != null) {
            ConversationPolicyHandlerFactory conversationPolicyHandlerFactory = this.myAgent.getConversationManager().getConversationPolicyHandlerFactory();
            Set set = conversationPolicyHandlerFactory.getPolicyNames();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.rootPolicyBox.addItem(iterator.next());
            }
        }
        this.rootPolicyBox.setSelectedItem(NONE_SELECTED);
    }

    protected void initSelfRoleBox() {
        String string;
        this.selfRoleBox.removeAllItems();
        this.selfRoleBox.addItem(NONE_SELECTED);
        if (this.myAgent != null && (string = (String)this.rootPolicyBox.getSelectedItem()) != null && !string.equals(NONE_SELECTED)) {
            ConversationPolicyHandlerFactory conversationPolicyHandlerFactory = this.myAgent.getConversationManager().getConversationPolicyHandlerFactory();
            Collection collection = conversationPolicyHandlerFactory.getRoles(string);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.selfRoleBox.addItem(iterator.next());
            }
        }
        this.selfRoleBox.setSelectedItem(NONE_SELECTED);
    }

    protected void rootPolicyBox_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.initSelfRoleBox();
        }
    }

    protected void selfRoleBox_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            String string;
            ConversationPolicyHandlerFactory conversationPolicyHandlerFactory;
            Collection collection;
            String string2 = (String)this.selfRoleBox.getSelectedItem();
            String string3 = null;
            if (this.myAgent != null && (collection = (conversationPolicyHandlerFactory = this.myAgent.getConversationManager().getConversationPolicyHandlerFactory()).getRoles(string = (String)this.rootPolicyBox.getSelectedItem())) != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (string2.equals(string4)) continue;
                    string3 = string4;
                    break;
                }
            }
            if (string3 == null) {
                this.partnerRoleLabel.setText(NONE_SELECTED);
            } else {
                this.partnerRoleLabel.setText(string3);
            }
        }
    }

    public void refreshPanel(PropertyChangeEvent propertyChangeEvent) {
        this.initPanelValues();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null) {
            if (string.equals(START_CONVERSATION)) {
                this.startConversation();
            } else if (string.equals(LOOKUP_AGENT)) {
                this.lookupPartner();
            }
        }
    }

    public void startConversation() {
        this.printDebug("startConversation");
        if (this.myAgent == null) {
            this.printDebug("startConversation: not bound to an agent");
            return;
        }
        String string = this.partnerDisplayNameField.getText().trim();
        String string2 = (String)this.rootPolicyBox.getSelectedItem();
        String string3 = (String)this.selfRoleBox.getSelectedItem();
        if (string == null || string.equals("")) {
            this.printDebug("startConversation: no partner specified");
            return;
        }
        if (string2 == null || string2.equals(NONE_SELECTED)) {
            this.printDebug("startConversation: no root policy specified");
            return;
        }
        if (string3 == null || string3.equals(NONE_SELECTED)) {
            this.printDebug("startConversation: no self role specified");
            return;
        }
        this.myAgent.startConversation(string, string2, string3);
    }

    public void lookupPartner() {
        this.printDebug("lookupPartner");
    }

    public static void main(String[] stringArray) {
        AblePlatformConversationAgent ablePlatformConversationAgent = null;
        AblePlatformStartConversationPanel ablePlatformStartConversationPanel = new AblePlatformStartConversationPanel(ablePlatformConversationAgent);
        JFrame jFrame = new JFrame("AbleConversationSetupPanel");
        jFrame.getContentPane().add(ablePlatformStartConversationPanel);
        class ExitListener
        extends WindowAdapter {
            ExitListener() {
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("Bye!");
                System.exit(0);
            }
        }
        jFrame.addWindowListener(new ExitListener());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void printDebug(String string) {
        System.out.println(string);
    }
}

