/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.conversation;

import com.ibm.able.Able;
import com.ibm.able.conversation.AbleCpGraphLoader;
import com.ibm.conversation.CpStateMachine;
import com.ibm.conversation.base.BasicCpStateMachine;
import com.ibm.conversation.base.CpXmlParser;
import com.ibm.graph.Edge;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.awt.event.GraphCanvasEvent;
import com.ibm.graph.awt.event.GraphCanvasEventListener;
import com.ibm.graph.ext.visual.VisualVertex;
import com.ibm.graph.swing.JGraphCanvas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class AbleCpGraphViewer
implements PropertyChangeListener {
    private JGraphCanvas graphCanvas;
    private JScrollPane scrollPane;
    private Net graph;
    private AbleCpGraphLoader loader;
    private JFrame frame;
    private JTextArea detailText = null;
    private JFrame detailFrame = null;
    private String viewerName = null;
    private boolean isLoaded = false;
    private boolean isSizeSet = false;
    private Point location = null;

    public AbleCpGraphViewer(String string) {
        this.frame = new JFrame(string);
        this.viewerName = string;
        this.initializeParameters();
    }

    public AbleCpGraphViewer(String string, String string2) {
        this.frame = new JFrame(string);
        this.viewerName = new String(string2);
        this.initializeParameters();
    }

    private void initializeParameters() {
        this.isLoaded = false;
        this.isSizeSet = false;
        this.graph = new Net();
        this.graph.setName("graph");
        this.graphCanvas = new JGraphCanvas(this.graph);
        this.graphCanvas.setBackground(Color.lightGray);
        this.scrollPane = new JScrollPane((Component)this.graphCanvas);
        Dragging dragging = new Dragging();
        this.graphCanvas.addGraphCanvasEventMouseDraggedListener((GraphCanvasEventListener)new DraggedListener(this, dragging));
        this.graphCanvas.addGraphCanvasEventMouseReleasedListener((GraphCanvasEventListener)new ReleasedListener(this, dragging));
        this.loader = null;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public Graphics getGraphics() {
        return this.graphCanvas.getGraphics();
    }

    public String getName() {
        return this.viewerName;
    }

    void _sizeGraphCanvas() throws NotDrawableException {
        Dimension dimension = this.graphCanvas.getGraph().getSize();
        dimension.width += 250;
        dimension.height += 200;
        this.graphCanvas.setPreferredSize(dimension);
    }

    private void _translate(Net net, int n, int n2) throws NotDrawableException {
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            Point point = vertex.getLocation();
            point.translate(n, n2);
            vertex.setLocation(point);
        }
    }

    private void _validate() {
        block3: {
            try {
                Rectangle rectangle = this.graph.getBounds();
                if (rectangle.x < 0 || rectangle.x > 100 || rectangle.y < 0 || rectangle.y > 100) {
                    this._translate(this.graph, 50 - rectangle.x, 50 - rectangle.y);
                }
                this.graphCanvas.setSize(rectangle.width + 290, rectangle.height);
                this.graphCanvas.validate();
                this.scrollPane.validate();
            }
            catch (NotDrawableException notDrawableException) {
                Able.MessageLog.text(2L, (Object)this, "_validate", notDrawableException.getLocalizedMessage());
                if (!Able.TraceLog.isLogging()) break block3;
                Able.TraceLog.exception(262144L, (Object)this, "_validate", (Throwable)notDrawableException);
            }
        }
    }

    public void fixDisplay() {
        block4: {
            try {
                this._translate(this.graph, 100, 30);
            }
            catch (NotDrawableException notDrawableException) {
                Able.MessageLog.text(2L, (Object)this, "fixDisplay", notDrawableException.getLocalizedMessage());
                if (!Able.TraceLog.isLogging()) break block4;
                Able.TraceLog.exception(262144L, (Object)this, "fixDisplay", (Throwable)notDrawableException);
            }
        }
        try {
            this._sizeGraphCanvas();
        }
        catch (NotDrawableException notDrawableException) {
            this.graphCanvas.setPreferredSize(new Dimension(700, 300));
        }
        this._validate();
    }

    private JTextArea getDetailPane() {
        if (this.detailText == null) {
            this.detailText = new JTextArea();
            this.detailText.setPreferredSize(new Dimension(400, 100));
        }
        return this.detailText;
    }

    public JComponent getGraphPane() {
        return this.scrollPane;
    }

    public void loadGraph(AbleCpGraphLoader ableCpGraphLoader) {
        this.loader = ableCpGraphLoader;
        this.loader.loadGraph(this.graph);
        this.fixDisplay();
    }

    public AbleCpGraphLoader getCPGraphLoader() {
        return this.loader;
    }

    public void saveCurrentLayout(File file) {
        this.loader.saveCurrentLayout(file, this.frame.getSize(), this.viewerName);
    }

    public void loadFromLayout(File file) {
        Dimension dimension = this.loader.loadFromLayout(file);
        this.scrollPane.setSize(dimension);
        this.frame.setSize(dimension);
        this.isSizeSet = true;
        this.frame.validate();
        this.frame.repaint();
        this.scrollPane.setSize(dimension);
        this.scrollPane.repaint();
        this.graphCanvas.setSize(dimension);
        this.graphCanvas.repaint();
    }

    public void loadFrame() {
        if (!this.isLoaded) {
            JMenuBar jMenuBar = new JMenuBar();
            this.frame.setJMenuBar(jMenuBar);
            JMenu jMenu = new JMenu("File");
            jMenu.setMnemonic(70);
            jMenu.getAccessibleContext().setAccessibleDescription("Menu for saving and loading graph layouts");
            jMenuBar.add(jMenu);
            MenuActionListener menuActionListener = new MenuActionListener(this);
            JMenuItem jMenuItem = new JMenuItem("Save Layout", 83);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(49, 8));
            jMenuItem.getAccessibleContext().setAccessibleDescription("Save the Current Layout");
            jMenuItem.setActionCommand("Save");
            jMenuItem.addActionListener(menuActionListener);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Load Layout", 76);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(50, 8));
            jMenuItem.getAccessibleContext().setAccessibleDescription("Load From Saved Layout");
            jMenuItem.setActionCommand("Load");
            jMenuItem.addActionListener(menuActionListener);
            jMenu.add(jMenuItem);
            this.frame.getContentPane().setLayout(new GridLayout(1, 1));
            this.frame.getContentPane().add(this.getGraphPane());
            if (!this.isSizeSet) {
                this.frame.setSize(new Dimension(500, 400));
            }
            this.frame.validate();
            this.isLoaded = true;
        }
        if (this.location != null) {
            this.frame.setLocation(this.location);
        }
        this.frame.setVisible(true);
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public void setLocation(Point point) {
        if (this.frame != null) {
            this.frame.setLocation(point);
        } else {
            this.location = point;
        }
    }

    public Point getLocation() {
        if (this.frame != null) {
            return this.frame.getLocation();
        }
        return null;
    }

    void showDetail(Edge edge) {
        JTextArea jTextArea = this.getDetailPane();
        if (jTextArea != null) {
            jTextArea.setText(edge.userdict.toString());
        }
        this.showDetailFrame("Edge detail: " + edge.getName());
    }

    void showDetail(Vertex vertex) {
        JTextArea jTextArea = this.getDetailPane();
        if (jTextArea != null) {
            jTextArea.setText(vertex.userdict.toString());
        }
        this.showDetailFrame("Vertex detail: " + vertex.getName());
    }

    private void showDetailFrame(String string) {
        if (this.detailFrame == null) {
            this.detailFrame = new JFrame(string);
            this.detailFrame.getContentPane().setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(this.getDetailPane());
            this.detailFrame.getContentPane().add((Component)jScrollPane, "Center");
            this.detailFrame.pack();
        } else {
            this.detailFrame.setTitle(string);
        }
        this.detailFrame.setVisible(true);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null && string.equals("CurrentState")) {
            String string2 = (String)propertyChangeEvent.getOldValue();
            String string3 = (String)propertyChangeEvent.getNewValue();
            this.changeCurrentState(string2, string3);
        }
    }

    protected void changeCurrentState(String string, String string2) {
        Hashtable hashtable = this.getCPGraphLoader().getVertexTable();
        VisualVertex visualVertex = (VisualVertex)hashtable.get(string);
        if (visualVertex != null) {
            try {
                visualVertex.setColorFill(Color.yellow);
                visualVertex.setName(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((visualVertex = (VisualVertex)hashtable.get(string2)) != null) {
            try {
                visualVertex.setColorFill(Color.blue);
                visualVertex.setName(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.getFrame().repaint();
    }

    public static void main(String[] stringArray) {
        String string = null;
        string = stringArray.length > 0 ? stringArray[0] : "testCP.xml";
        CpXmlParser cpXmlParser = new CpXmlParser();
        try {
            cpXmlParser.loadDocument(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BasicCpStateMachine basicCpStateMachine = new BasicCpStateMachine();
        cpXmlParser.initCpStateMachine((CpStateMachine)basicCpStateMachine);
        System.out.println(basicCpStateMachine.toString());
        System.out.println("Creating viewer");
        AbleCpGraphLoader ableCpGraphLoader = new AbleCpGraphLoader((CpStateMachine)basicCpStateMachine);
        AbleCpGraphViewer ableCpGraphViewer = new AbleCpGraphViewer(string);
        ableCpGraphViewer.loadGraph(ableCpGraphLoader);
        ableCpGraphViewer.loadFrame();
    }

    class ReleasedListener
    implements GraphCanvasEventListener {
        private Dragging _dragging;
        private AbleCpGraphViewer _app;

        public ReleasedListener(AbleCpGraphViewer ableCpGraphViewer2, Dragging dragging) {
            this._app = ableCpGraphViewer2;
            this._dragging = dragging;
        }

        public void graphobjectSelected(GraphCanvasEvent graphCanvasEvent) {
            if (this._dragging.zDragging) {
                MouseEvent mouseEvent;
                block7: {
                    mouseEvent = (MouseEvent)graphCanvasEvent.getAWTEvent();
                    try {
                        this._app._sizeGraphCanvas();
                    }
                    catch (NotDrawableException notDrawableException) {
                        Able.MessageLog.text(2L, (Object)this, "graphobjectSelected", notDrawableException.getLocalizedMessage());
                        if (!Able.TraceLog.isLogging()) break block7;
                        Able.TraceLog.exception(262144L, (Object)this, "graphobjectSelected", (Throwable)notDrawableException);
                    }
                }
                Component component = mouseEvent.getComponent();
                component.repaint();
                this._dragging.zDragging = false;
            } else if (graphCanvasEvent.getGraphObject() instanceof Vertex) {
                Vertex vertex = (Vertex)graphCanvasEvent.getGraphObject();
                this._app.showDetail(vertex);
            } else if (graphCanvasEvent.getGraphObject() instanceof Edge) {
                Edge edge = (Edge)graphCanvasEvent.getGraphObject();
                this._app.showDetail(edge);
            }
        }
    }

    class DraggedListener
    implements GraphCanvasEventListener {
        private AbleCpGraphViewer _app;
        private Dragging _dragging;

        public DraggedListener(AbleCpGraphViewer ableCpGraphViewer2, Dragging dragging) {
            this._app = ableCpGraphViewer2;
            this._dragging = dragging;
        }

        public void graphobjectSelected(GraphCanvasEvent graphCanvasEvent) {
            if (graphCanvasEvent.getGraphObject() instanceof Vertex) {
                Point point;
                MouseEvent mouseEvent;
                Vertex vertex;
                block6: {
                    vertex = (Vertex)graphCanvasEvent.getGraphObject();
                    mouseEvent = (MouseEvent)graphCanvasEvent.getAWTEvent();
                    point = mouseEvent.getPoint();
                    if (!this._dragging.zDragging) {
                        this._dragging.zDragging = true;
                        try {
                            this._dragging.iXDelta = -point.x + vertex.getLocation().x;
                            this._dragging.iYDelta = -point.y + vertex.getLocation().y;
                        }
                        catch (NotDrawableException notDrawableException) {
                            Able.MessageLog.text(2L, (Object)this, "graphobjectSelected", notDrawableException.getLocalizedMessage());
                            if (!Able.TraceLog.isLogging()) break block6;
                            Able.TraceLog.exception(262144L, (Object)this, "graphobjectSelected", (Throwable)notDrawableException);
                        }
                    }
                }
                point.translate(this._dragging.iXDelta, this._dragging.iYDelta);
                Component component = mouseEvent.getComponent();
                Graphics graphics = component.getGraphics();
                graphics.setXORMode(component.getBackground());
                vertex.draw(graphics);
                vertex.setLocation(point);
                vertex.draw(graphics);
            } else if (graphCanvasEvent.getGraphObject() instanceof Edge) {
                // empty if block
            }
        }
    }

    class Dragging {
        public boolean zDragging = false;
        public int iXDelta = 0;
        public int iYDelta = 0;

        Dragging() {
        }
    }

    class MenuActionListener
    implements ActionListener {
        private AbleCpGraphViewer app;

        public MenuActionListener(AbleCpGraphViewer ableCpGraphViewer2) {
            this.app = ableCpGraphViewer2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Load") || string.equals("Save")) {
                JFileChooser jFileChooser = new JFileChooser();
                GLFFilter gLFFilter = new GLFFilter();
                jFileChooser.setFileFilter(gLFFilter);
                jFileChooser.setAcceptAllFileFilterUsed(false);
                int n = jFileChooser.showDialog(this.app.getFrame(), string);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    boolean bl = false;
                    String string2 = gLFFilter.getExtension(file);
                    if (string2 != null && string2.equals("glf")) {
                        bl = true;
                    }
                    if (!bl) {
                        file = new File(file.getAbsolutePath() + ".glf");
                    }
                    if (string.equals("Load")) {
                        this.app.loadFromLayout(file);
                    }
                    if (string.equals("Save")) {
                        this.app.saveCurrentLayout(file);
                    }
                }
            } else {
                Able.MessageLog.text(2L, (Object)this, "actionPerformed", "Invalid command string");
            }
        }

        public class GLFFilter
        extends FileFilter {
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = this.getExtension(file);
                if (string != null) {
                    return string.equals("glf");
                }
                return false;
            }

            public String getExtension(File file) {
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string;
            }

            public String getDescription() {
                return "Graph Layout Format (*.glf)";
            }
        }
    }
}

