/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.conversation;

import com.ibm.able.Able;
import com.ibm.conversation.CpState;
import com.ibm.conversation.CpStateMachine;
import com.ibm.conversation.CpStateTransition;
import com.ibm.graph.Drawable;
import com.ibm.graph.Edge;
import com.ibm.graph.GraphLayoutManager;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw2EdgeLoopEllipse;
import com.ibm.graph.draw.Draw2EdgeParabolaDirectedArrowThenText;
import com.ibm.graph.ext.visual.VisualVertex;
import com.ibm.graph.layout.LayoutGlow;
import com.ibm.graph.layout.LayoutGlowCostFunction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class AbleCpGraphLoader {
    private boolean layoutDone = false;
    private Hashtable vertexTable = null;
    private Hashtable vertexShapes = null;
    private CpStateMachine machine = null;

    public AbleCpGraphLoader(CpStateMachine cpStateMachine) {
        this.machine = cpStateMachine;
        this.vertexTable = new Hashtable();
        this.vertexShapes = new Hashtable();
        this.vertexShapes.put("load-child", "RECTANGLE");
        this.vertexShapes.put("normal", "ELLIPSE");
        this.vertexShapes.put("terminal", "ELLIPSE");
    }

    public Vertex findVertex(String string) {
        if (this.vertexTable.containsKey(string)) {
            return (Vertex)this.vertexTable.get(string);
        }
        return null;
    }

    public Hashtable getVertexTable() {
        return this.vertexTable;
    }

    public void initDrawable(Edge edge, int n) {
        if (edge.isLoop()) {
            Draw2EdgeLoopEllipse draw2EdgeLoopEllipse = new Draw2EdgeLoopEllipse();
            edge.setDrawable((Drawable)draw2EdgeLoopEllipse);
        } else {
            Draw2EdgeParabolaDirectedArrowThenText draw2EdgeParabolaDirectedArrowThenText = new Draw2EdgeParabolaDirectedArrowThenText();
            draw2EdgeParabolaDirectedArrowThenText.setArrowHeadFill(true);
            draw2EdgeParabolaDirectedArrowThenText.setText(edge.getName());
            double d = 5.0 * (double)n + 10.0;
            draw2EdgeParabolaDirectedArrowThenText.setFlatness(d);
            edge.setDrawable((Drawable)draw2EdgeParabolaDirectedArrowThenText);
        }
    }

    public boolean isLayoutDone() {
        return this.layoutDone;
    }

    public CpStateMachine getStateMachine() {
        return this.machine;
    }

    public synchronized void loadGraph(Net net) {
        net.clear();
        this.vertexTable.clear();
        Iterator iterator = this.machine.getStates().iterator();
        CpState cpState = null;
        Vertex vertex = null;
        while (iterator.hasNext()) {
            cpState = (CpState)iterator.next();
            vertex = this.createVertex(cpState.getName());
            if (vertex != null) {
                this.vertexTable.put(vertex.getName(), vertex);
                net.add(vertex);
                continue;
            }
            Able.MessageLog.text(2L, (Object)this, "loadGraph", "Vertex creation failed..." + vertex);
        }
        iterator = this.machine.getStates().iterator();
        Iterator iterator2 = null;
        CpStateTransition cpStateTransition = null;
        Edge edge = null;
        int n = 0;
        while (iterator.hasNext()) {
            cpState = (CpState)iterator.next();
            if (cpState.getNumTransitions() <= 0) continue;
            iterator2 = cpState.getTransitions().iterator();
            n = 0;
            while (iterator2.hasNext()) {
                cpStateTransition = (CpStateTransition)iterator2.next();
                edge = this.createEdge(cpState.getName(), cpStateTransition.getName());
                if (edge != null) {
                    net.add(edge);
                    this.initDrawable(edge, n);
                } else {
                    Able.MessageLog.text(2L, (Object)this, "loadGraph", "Edge creation failed");
                }
                ++n;
            }
        }
        if (!this.layoutDone) {
            this.doLayout(net);
        }
        this.tuneEdgeLayout(net);
    }

    private Edge createEdge(String string, String string2) {
        CpStateTransition cpStateTransition = this.machine.getTransition(string, string2);
        Vertex vertex = this.findVertex(string);
        Vertex vertex2 = this.findVertex(cpStateTransition.getTargetName());
        if (vertex == null || vertex2 == null) {
            if (vertex == null && vertex2 == null) {
                Able.MessageLog.text(2L, (Object)this, "createEdge", "source & target are null.");
            } else if (vertex == null) {
                Able.MessageLog.text(2L, (Object)this, "createEdge", "source is null.");
            } else {
                Able.MessageLog.text(2L, (Object)this, "createEdge", "target is null.");
            }
            return null;
        }
        Edge edge = new Edge(vertex, vertex2, true);
        String string3 = new String(string2);
        edge.setName(string3);
        return edge;
    }

    private Vertex createVertex(String string) {
        VisualVertex visualVertex;
        block5: {
            CpState cpState = this.machine.getState(string);
            if (cpState == null) {
                return null;
            }
            String string2 = null;
            string2 = cpState.getType() == 3 ? "terminal" : (cpState.getType() == 2 ? "load-child" : "normal");
            String string3 = (String)this.vertexShapes.get(string2);
            if (string3 == null) {
                string3 = new String("CIRCLE");
            }
            visualVertex = null;
            visualVertex = string3.equals("RECTANGLE") ? new VisualVertex(1, Color.yellow, Color.blue, true, GraphObject.strKeyName, Color.black, "Times", 1, 12) : (string3.equals("ELLIPSE") ? new VisualVertex(3, Color.yellow, Color.blue, true, GraphObject.strKeyName, Color.black, "Times", 1, 12) : new VisualVertex(2, Color.yellow, Color.blue, true, GraphObject.strKeyName, Color.black, "Times", 1, 12));
            visualVertex.setName(string);
            visualVertex.userdict.def((Object)"type", (Object)string2);
            if (string2.equals("terminal")) {
                try {
                    visualVertex.setColorFill(Color.white);
                }
                catch (Exception exception) {
                    Able.MessageLog.text(2L, (Object)this, "createVertex", exception.getLocalizedMessage());
                    if (!Able.TraceLog.isLogging()) break block5;
                    Able.TraceLog.exception(262144L, (Object)this, "createVertex", (Throwable)exception);
                }
            }
        }
        return visualVertex;
    }

    private void doLayout(Net net) {
        net.setGraphLayoutManager((GraphLayoutManager)new LayoutGlow(new LayoutGlowCostFunction()));
        net.layout();
    }

    public void tuneEdgeLayout(Net net) {
        Enumeration enumeration = net.enumerateEdges();
        Edge edge = null;
        while (enumeration.hasMoreElements()) {
            int n;
            int n2;
            edge = (Edge)enumeration.nextElement();
            Drawable drawable = edge.getDrawable();
            if (!(drawable instanceof Draw2EdgeParabolaDirectedArrowThenText)) continue;
            Draw2EdgeParabolaDirectedArrowThenText draw2EdgeParabolaDirectedArrowThenText = (Draw2EdgeParabolaDirectedArrowThenText)drawable;
            try {
                Point point = edge.getFromVertex().getLocation();
                Point point2 = edge.getToVertex().getLocation();
                n2 = point.getX() < point2.getX() ? 1 : -1;
                n = point.getY() < point2.getY() ? 1 : -1;
            }
            catch (Exception exception) {
                Able.MessageLog.text(2L, (Object)this, "tuneEdgeLayout", exception.getLocalizedMessage());
                if (Able.TraceLog.isLogging()) {
                    Able.TraceLog.exception(262144L, (Object)this, "tuneEdgeLayout", (Throwable)exception);
                }
                n2 = 1;
                n = 1;
            }
            draw2EdgeParabolaDirectedArrowThenText.getDrawText().setAlignmentX(n2);
            draw2EdgeParabolaDirectedArrowThenText.getDrawText().setAlignmentY(n);
        }
    }

    public Dimension loadFromLayout(File file) {
        Dimension dimension;
        block4: {
            dimension = null;
            try {
                Properties properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    Point point = new Point();
                    String string = (String)enumeration.nextElement();
                    if (string.equals("POLICYNAME")) continue;
                    String string2 = properties.getProperty(string);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    double d = Double.parseDouble(stringTokenizer.nextToken());
                    double d2 = Double.parseDouble(stringTokenizer.nextToken());
                    point.setLocation(d, d2);
                    if (this.vertexTable.containsKey(string)) {
                        VisualVertex visualVertex = (VisualVertex)this.vertexTable.get(string);
                        visualVertex.setLocation(point);
                        continue;
                    }
                    if (!string.equals("FRAMESIZE")) continue;
                    dimension = new Dimension();
                    dimension.setSize((int)d, (int)d2);
                }
            }
            catch (Exception exception) {
                Able.MessageLog.text(2L, (Object)this, "loadFromLayout", exception.getLocalizedMessage());
                if (!Able.TraceLog.isLogging()) break block4;
                Able.TraceLog.exception(262144L, (Object)this, "loadFromLayout", (Throwable)exception);
            }
        }
        return dimension;
    }

    public void saveCurrentLayout(File file, Dimension dimension, String string) {
        block8: {
            PrintWriter printWriter;
            Iterator iterator;
            block7: {
                iterator = this.vertexTable.values().iterator();
                FileWriter fileWriter = null;
                printWriter = null;
                try {
                    fileWriter = new FileWriter(file);
                    printWriter = new PrintWriter(new BufferedWriter(fileWriter));
                }
                catch (Exception exception) {
                    Able.MessageLog.text(2L, (Object)this, "saveCurrentLayout", exception.getLocalizedMessage());
                    if (!Able.TraceLog.isLogging()) break block7;
                    Able.TraceLog.exception(262144L, (Object)this, "saveCurrentLayout", (Throwable)exception);
                }
            }
            printWriter.println("POLICYNAME " + string);
            printWriter.println("FRAMESIZE " + dimension.getWidth() + "," + dimension.getHeight());
            while (iterator.hasNext()) {
                VisualVertex visualVertex = (VisualVertex)iterator.next();
                printWriter.print(visualVertex.getName() + " ");
                try {
                    Point point = visualVertex.getLocation();
                    String string2 = new String(point.getX() + "," + point.getY());
                    printWriter.println(string2);
                }
                catch (Exception exception) {
                    Able.MessageLog.text(2L, (Object)this, "saveCurrentLayout", exception.getLocalizedMessage());
                    if (!Able.TraceLog.isLogging()) continue;
                    Able.TraceLog.exception(262144L, (Object)this, "saveCurrentLayout", (Throwable)exception);
                }
            }
            try {
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                Able.MessageLog.text(2L, (Object)this, "saveCurrentLayout", exception.getLocalizedMessage());
                if (!Able.TraceLog.isLogging()) break block8;
                Able.TraceLog.exception(262144L, (Object)this, "saveCurrentLayout", (Throwable)exception);
            }
        }
    }
}

