/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.conversation;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.conversation.AbleConversationManager;
import com.ibm.able.conversation.AbleConversationManagerCustomizer;
import com.ibm.able.conversation.AbleCpGraphLoader;
import com.ibm.able.conversation.AbleCpGraphViewer;
import com.ibm.conversation.ConversationPolicyHandler;
import com.ibm.conversation.ConversationPolicyHandlerFactory;
import com.ibm.conversation.CpStateMachine;
import com.ibm.conversation.CpStateMachineHandler;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class AbleConversationManagerPanel
extends JPanel
implements ActionListener,
AbleCustomizerPanel {
    private static final String BROWSE_REPOSITORY = "browse";
    private static final String SET_REPOSITORY = "set";
    private static final String VIEW_POLICY = "view";
    private static final String RELOAD_POLICIES = "reload";
    AbleConversationManager conversationManager = null;
    private AbleConversationManagerCustomizer myCustomizer = null;
    JTextField repositoryField = null;
    PolicyTableModel policyTableModel = null;
    JTable policyTable = null;
    JLabel initialPolicyLabel = null;
    JLabel initiatorRoleLabel = null;
    JLabel responderRoleLabel = null;

    public AbleConversationManagerPanel() {
        this.loadPanel();
        this.initPanelValues();
    }

    public AbleConversationManagerPanel(AbleConversationManager ableConversationManager) {
        this.conversationManager = ableConversationManager;
        this.loadPanel();
        this.initPanelValues();
    }

    public AbleConversationManagerPanel(AbleConversationManagerCustomizer ableConversationManagerCustomizer) {
        this.myCustomizer = ableConversationManagerCustomizer;
        this.loadPanel();
        this.initPanelValues();
    }

    private final void loadPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 8, 8), 0, 0);
        JLabel jLabel = new JLabel("Repository path:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)jLabel, gridBagConstraints);
        this.repositoryField = new JTextField(24);
        this.repositoryField.setActionCommand(SET_REPOSITORY);
        this.repositoryField.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.repositoryField, gridBagConstraints);
        JButton jButton = new JButton("Browse");
        jButton.setActionCommand(BROWSE_REPOSITORY);
        jButton.addActionListener(this);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton("Reload");
        jButton2.setActionCommand(RELOAD_POLICIES);
        jButton2.addActionListener(this);
        gridBagConstraints.gridx = 7;
        this.add((Component)jButton2, gridBagConstraints);
        this.policyTableModel = new PolicyTableModel();
        this.policyTable = new JTable(this.policyTableModel);
        JScrollPane jScrollPane = new JScrollPane(this.policyTable);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        this.add((Component)jScrollPane, gridBagConstraints);
        JButton jButton3 = new JButton("View");
        jButton3.setActionCommand(VIEW_POLICY);
        jButton3.addActionListener(this);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)jButton3, gridBagConstraints);
        JLabel jLabel2 = new JLabel("Initial policy:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)jLabel2, gridBagConstraints);
        this.initialPolicyLabel = new JLabel("");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        this.add((Component)this.initialPolicyLabel, gridBagConstraints);
        jLabel2 = new JLabel("Initiator role:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.add((Component)jLabel2, gridBagConstraints);
        this.initiatorRoleLabel = new JLabel("");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        this.add((Component)this.initiatorRoleLabel, gridBagConstraints);
        jLabel2 = new JLabel("Responder role:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        this.add((Component)jLabel2, gridBagConstraints);
        this.responderRoleLabel = new JLabel("");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        this.add((Component)this.responderRoleLabel, gridBagConstraints);
    }

    public void setConversationManager(AbleConversationManager ableConversationManager) {
        this.conversationManager = ableConversationManager;
        this.initPanelValues();
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "jas/doc-files/AbleJasDefaultAgentHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public void getDataFromBean(Object object) throws RemoteException {
        try {
            this.setConversationManager((AbleConversationManager)object);
        }
        catch (ClassCastException classCastException) {
            throw new RemoteException(classCastException.getLocalizedMessage());
        }
    }

    public void setDataOnBean() throws RemoteException {
        this.applyPanelValues();
    }

    public void initPanelValues() {
        if (this.conversationManager == null) {
            this.repositoryField.setText("");
            this.policyTable.removeAll();
            this.initialPolicyLabel.setText("");
            this.initiatorRoleLabel.setText("");
            this.responderRoleLabel.setText("");
        } else {
            this.repositoryField.setText(this.conversationManager.getConversationPolicyRepositoryPath());
            this.initPolicyTable();
            this.initialPolicyLabel.setText(this.conversationManager.getInitialPolicyName());
            this.initiatorRoleLabel.setText(this.conversationManager.getInitiatorRole());
            this.responderRoleLabel.setText(this.conversationManager.getResponderRole());
        }
    }

    public void applyPanelValues() {
        if (this.conversationManager == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        String string = this.repositoryField.getText().trim();
        this.conversationManager.setConversationPolicyRepositoryPath(string);
        this.initPanelValues();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void initPolicyTable() {
        ConversationPolicyHandlerFactory conversationPolicyHandlerFactory = this.conversationManager.getConversationPolicyHandlerFactory();
        Set set = conversationPolicyHandlerFactory.getPolicyNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Collection collection = conversationPolicyHandlerFactory.getRoles(string);
            this.policyTableModel.addEntry(string, collection);
        }
    }

    protected void browseRepositoryPath() {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(1);
        if (this.conversationManager != null) {
            jFileChooser.setCurrentDirectory(new File(this.conversationManager.getConversationPolicyRepositoryPath()));
        }
        if ((n = jFileChooser.showDialog(this, "Select")) == 0) {
            File file = jFileChooser.getSelectedFile();
            this.repositoryField.setText(file.getAbsolutePath());
        }
        this.applyPanelValues();
    }

    public void refreshPanel(PropertyChangeEvent propertyChangeEvent) {
        this.initPanelValues();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null) {
            if (string.equals(BROWSE_REPOSITORY)) {
                this.browseRepositoryPath();
            } else if (string.equals(SET_REPOSITORY)) {
                this.applyPanelValues();
            } else if (string.equals(VIEW_POLICY)) {
                this.displaySelectedPolicy();
            } else if (string.equals(RELOAD_POLICIES)) {
                this.reloadPolicies();
            }
        }
    }

    public void displaySelectedPolicy() {
        int n = this.policyTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        if (this.conversationManager == null) {
            return;
        }
        String string = this.policyTableModel.getPolicyName(n);
        ConversationPolicyHandlerFactory conversationPolicyHandlerFactory = this.conversationManager.getConversationPolicyHandlerFactory();
        ConversationPolicyHandler conversationPolicyHandler = conversationPolicyHandlerFactory.getPolicyHandler(string, null);
        if (conversationPolicyHandler != null && conversationPolicyHandler instanceof CpStateMachineHandler) {
            CpStateMachine cpStateMachine = ((CpStateMachineHandler)conversationPolicyHandler).getStateMachine();
            AbleCpGraphLoader ableCpGraphLoader = new AbleCpGraphLoader(cpStateMachine);
            AbleCpGraphViewer ableCpGraphViewer = new AbleCpGraphViewer(string);
            ableCpGraphViewer.loadGraph(ableCpGraphLoader);
            ableCpGraphViewer.loadFrame();
        }
    }

    public void reloadPolicies() {
    }

    public static void main(String[] stringArray) {
        AbleConversationManager ableConversationManager = null;
        try {
            ableConversationManager = new AbleConversationManager();
            ableConversationManager.setInitialPolicy("ConversationSetup", "Caller", "Responder");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        AbleConversationManagerPanel ableConversationManagerPanel = new AbleConversationManagerPanel(ableConversationManager);
        JFrame jFrame = new JFrame("AbleConversationManagerPanel");
        jFrame.getContentPane().add(ableConversationManagerPanel);
        class ExitListener
        extends WindowAdapter {
            ExitListener() {
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("Bye!");
                System.exit(0);
            }
        }
        jFrame.addWindowListener(new ExitListener());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class PolicyTableModel
    extends DefaultTableModel {
        PolicyTableModel() {
            this.setNumRows(0);
            this.addColumn("PolicyName");
            this.addColumn("Roles");
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void addEntry(String string, Collection collection) {
            String string2 = this.formRoleString(collection);
            Object[] objectArray = new String[]{string, string2};
            this.addRow(objectArray);
        }

        public String formRoleString(Collection collection) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString().trim());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            return stringBuffer.toString();
        }

        public String getPolicyName(int n) {
            return (String)this.getValueAt(n, 0);
        }

        public int findRow(String string) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string2 = (String)this.getValueAt(i, 0);
                if (string2 == null || !string2.equals(string)) continue;
                return i;
            }
            return -1;
        }
    }
}

